//   GreKo chess engine
//   (c) 2002-2021 Vladimir Medvedev <vrm@bk.ru>
//   http://greko.su

#ifndef EVAL_PARAMS_H
#define EVAL_PARAMS_H

#include "types.h"

// #define PSQ_5
// #define PSQ_12
// #define PSQ_16
#define PSQ_64

#ifdef PSQ_5
#define PSQ_SIZE 5
#endif

#ifdef PSQ_12
#define PSQ_SIZE 12
#endif

#ifdef PSQ_16
#define PSQ_SIZE 16
#endif

#ifdef PSQ_64
#define PSQ_SIZE 64
#endif

extern size_t Mid_Pawn;
extern size_t Mid_Knight;
extern size_t Mid_Bishop;
extern size_t Mid_Rook;
extern size_t Mid_Queen;
extern size_t Mid_King;

extern size_t End_Pawn;
extern size_t End_Knight;
extern size_t End_Bishop;
extern size_t End_Rook;
extern size_t End_Queen;
extern size_t End_King;

extern size_t NUMBER_OF_FEATURES;
extern vector<double> g_w;

template<typename W, typename F>
double DotProduct(const W weights, const F features)
{
	assert(weights.size() == features.size());

	double e = 0;
	for (size_t i = 0; i < weights.size(); ++i)
		e += weights[i] * features[i];
	return e;
}
////////////////////////////////////////////////////////////////////////////////

void InitFeatures();
string FeatureName(size_t index);
bool ReadWeights(vector<double>& x, const string& file);
void SetDefaultWeights(vector<double>& x);
void WriteWeights(const vector<double>& x, const string& file);

#endif
