//  GREKO Chess Engine
//  (c) 2002-2012 Vladimir Medvedev <vrm@bk.ru>
//  http://greko.110mb.com

//  moves.h: bitboard moves generator
//  modified: 12-June-2012

#pragma once

#include "position.h"

struct MoveEntry
{
  MoveEntry() {}
  MoveEntry(Move mv) : _mv(mv) {}
  Move _mv;
  EVAL _value;
};

class MoveList
{
public:

  MoveList() : _size(0) {}

  MoveEntry& operator[] (int n) { return _data[n]; }
  const MoveEntry& operator[] (int n) const { return _data[n]; }

  void Clear() { _size = 0; }
  void GenAllMoves(const Position& pos);
  void GenCaptures(const Position& pos, bool genChecks);
  void GenCheckEvasions(const Position& pos);
  Move GetNthBest(int n);
  int  Size() const { return _size; }
  
private:

  void Add(FLD from, FLD to, PIECE piece)
  {
    _data[_size++]._mv = Move(from, to, piece);
  }

  void Add(FLD from, FLD to, PIECE piece, PIECE captured)
  {
    _data[_size++]._mv = Move(from, to, piece, captured);
  }

  void Add(FLD from, FLD to, PIECE piece, PIECE captured, PIECE promotion)
  {
    _data[_size++]._mv = Move(from, to, piece, captured, promotion);
  }

  enum { MAX_SIZE = 256 };
  MoveEntry _data[MAX_SIZE];
  int _size;
};
