//  GREKO Chess Engine
//  (c) 2002-2012 Vladimir Medvedev <vrm@bk.ru>
//  http://greko.110mb.com

//  book.h: opening book
//  modified: 05-Aug-2012

#pragma once

#include <map>
#include <vector>
#include "moves.h"

class Book
{
public:
  void Clean() 
  { 
    _data.clear();
    _pos.SetInitial();
    ++_data[_pos.Hash()];
  }

  Move GetMove(const Position& pos, std::string& comment);
  bool Import(const std::string& strPath, const std::string& strMaxPly, const std::string& strColor);
  void Init();
  bool Load(const std::string& path);
  bool Save(const std::string& path);

private:
  void ProcessLine(const std::string& str);

  std::map<U64, int> _data;
  Position _pos;
};
