//   GreKo chess engine
//   (c) 2002-2021 Vladimir Medvedev <vrm@bk.ru>
//   http://greko.su

#ifndef LEARN_H
#define LEARN_H

#include "types.h"

enum
{
	STOCHASTIC_GRADIENT_DESCENT = 0x01,
	COORDINATE_DESCENT = 0x02,
};

int    CountGames(const string& file);
bool   PgnToFen(const string& pgnFile, const string& fenFile, int minPly, int maxPly, int fensPerGame);
FP_TYPE Predict(const string& fenFile, const vector<FP_TYPE>& weights);
void   CoordinateDescent(const string& fenFile, vector<FP_TYPE>& x0, int numIters, const vector<FP_TYPE>& learnParams, U64 startTime);
void   Sgd(const string& fenFile, vector<FP_TYPE>& x0, const vector<FP_TYPE>& learnParams, U64 startTime);
FP_TYPE ScoreToProbability(FP_TYPE score);

#endif
