//  GREKO Chess Engine
//  (c) 2002-2016 Vladimir Medvedev <vrm@bk.ru>
//  http://greko.su

//  bitboards.h: 64-bit position representation
//  modified: 30-Dec-2016

#ifndef BITBOARDS_H
#define BITBOARDS_H

#include "types.h"
#define MAGIC

extern U64 BB_SINGLE[64];
extern U64 BB_DIR[64][8];
extern U64 BB_BETWEEN[64][64];

extern U64 BB_PAWN_ATTACKS[64][2];
extern U64 BB_KNIGHT_ATTACKS[64];
extern U64 BB_BISHOP_ATTACKS[64];
extern U64 BB_ROOK_ATTACKS[64];
extern U64 BB_QUEEN_ATTACKS[64];
extern U64 BB_KING_ATTACKS[64];

extern U64 BB_PAWN_SQUARE[64][2];

extern U8 MSB_16[65536];

inline U64 Up(const U64& b) { return b << 8; }
inline U64 Down(const U64& b) { return b >> 8; }
inline U64 Right(const U64& b) { return (b & LL(0xfefefefefefefefe)) >> 1; }
inline U64 Left(const U64& b) { return (b & LL(0x7f7f7f7f7f7f7f7f)) << 1; }
inline U64 UpRight(const U64& b) { return (b & LL(0x00fefefefefefefe)) << 7; }
inline U64 UpLeft(const U64& b) { return (b & LL(0x007f7f7f7f7f7f7f)) << 9; }
inline U64 DownRight(const U64& b) { return (b & LL(0xfefefefefefefe00)) >> 9; }
inline U64 DownLeft(const U64& b) { return (b & LL(0x7f7f7f7f7f7f7f00)) >> 7; }

int Delta(int dir);
U64 Shift(const U64& b, int dir);

int CountBits(U64 b);
FLD LSB(const U64& bb);
FLD PopLSB(U64& bb);
int MSB(const U64& b);
int PopMSB(U64& b);

extern int B_OFFSET[64];
extern U64* B_DATA;
extern int R_OFFSET[64];
extern U64* R_DATA;

U64 BishopAttacksTrace(int f, const U64& occ);
U64 EnumBits(U64 mask, U64 n);
void InitBitboards();
void Print(U64 b);
U64 RookAttacksTrace(int f, const U64& occ);

U64 BishopAttacks(int f, const U64& occ);
U64 RookAttacks(int f, const U64& occ);
U64 QueenAttacks(int f, const U64& occ);

#endif
