/*_____________________________________________________________
     xmem.c -- extendede Dynamic memory Control Module.
_______________________________________________________________*/
/* **************** INCLUDE FILES ************************ */
#include <stdio.h>
#include "facelib.h"

/****************** EXTERNAL FUNCTIONS *********************/
/*extern char *malloc(unsigned int);
extern char *calloc(unsigned int, unsigned int);
extern void free( char *);
*/
/* **************** GLOBAL FUNCTIONS *********************** */
/*char *x_malloc(unsigned int);
char *x_calloc(unsigned int, unsigned int);
void x_free(char far *);
void x_chkfree(void);*/
/* **************** Functions Prototypes ******************* */
static char far *sto_ptr(char far *p,unsigned long b);
static void del_ptr(char far *p);
/***************** GLOBAL VARIABLES *************************** */
/* memtrace usage:
     = 0 => simple calls to malloc & free
     = 1 => tracking of all allocations using hash table
     = 2 => checking for changes to previously freed blocks
*/
int memtrace=0;		/* memory tracing control variable */
unsigned long tot_memory=0L;	/* total amount of allocated memory */
long tot_alloc=0L;	/* total # of allocations  */
int hashsize=47;	/* size of hash table - should be odd prime */
int bucketsize=10;	/* number of entries per hash bucket */

/*************** LOCAL VARIABLES **************************** */
/* memory allocation tracking table */

/* amount of extra allocation for overhead */
#define OVHDSIZE 2

/* fill character for overhead gap */
#define FILLCHAR '\377'

/* allocated entry information */
typedef struct alloc_entry {
	unsigned long size;	/* size of allocated area */
	char far *ptr;		/* pointer to allocated area */
	char far *freed;	/* pointer to copy of allocated area */
} ALLOCATION;

typedef struct bucket {
	struct bucket far *next;	/* pointer to next bucked when filled */
	int entries;			/* number of used entries */
	ALLOCATION far *alloc;		/* allocated entry array */
} BUCKET;

#define NUL_BUCKET ((BUCKET far *)0)

/* dynamic pointer hash table */
static BUCKET far *far *ptrhash = (BUCKET far * far *)0;

/* =============================================================
   Store pointer to hash table
*/
static char far *sto_ptr(p,b)
char far *p;		/* pointer to be stored */
unsigned long b;		/* size of area */
{
   register BUCKET far *bp, far *bq;  	/* bucket pointers */
   register int bno,i;                	/* bucket/entry number */

   if ( !ptrhash ) {
      /* allocate pointer hash table */
      ptrhash = (BUCKET far * far *)mycalloc(hashsize,sizeof(BUCKET far *));
      if (!ptrhash)
	return(NULL);
      tot_memory = hashsize * sizeof(BUCKET far *);
      /* to initialize hash buckets */
      for (i=0; i< hashsize; i++)
	ptrhash[i] = NUL_BUCKET;
   }
   /* compute hash table index */
   bno = (int) ( (unsigned long)p % hashsize);

   /* find first bucket with available entries */
   for (bq=bp=ptrhash[bno]; bp && bp->entries == bucketsize;
		bp=bp->next)
	bq=bp;

   /* allocate new bucket if necessary */
   if ( bp == NUL_BUCKET ) {
       if ( ! (bp = (BUCKET far *) myfarmalloc(sizeof (BUCKET))) )
	   return (NULL);
       bp->next = NUL_BUCKET;
       bp->entries = 0;
       if (bq)
	  /* connect to end of bucket chain */
	  bq->next = bp;
       else
	  /* initial bucket for this hash entry */
	  ptrhash[bno] = bp;

       /* allocate bucket's allocation entry array */
       bp->alloc = (ALLOCATION far *) mycalloc (bucketsize ,
			 sizeof(ALLOCATION));

       /* memory total includes space used for hash table */
       tot_memory += sizeof(BUCKET) +
			bucketsize * sizeof(ALLOCATION);
   }
   /* store pointer to allocated block */
   bno = bp->entries++;
   bp->alloc[bno].ptr = p;
   bp->alloc[bno].freed = NULL;
   bp->alloc[bno].size = b;

   /* update total allocation */
   tot_memory += b;

   /* increment total number of allocations */
   ++tot_alloc;

   return(p);
}

/* =========================================================
   Delete pointer from hash table
*/
static void del_ptr(p)
char far *p;		/* pointer to be freed */
{
   unsigned long gap;			/* index into overhead space */
   register BUCKET far *bp, far *bq;    /* bucket pointers */
   register int bno, i;			/* bucket/entry number */

   /* compute hash table index */
   bno = (int) ((unsigned long)p % hashsize);

   /* search bucket(s) for pointer */
   for (bq = NUL_BUCKET, bp=ptrhash[bno]; bp; bp = bp->next) {
      for (i = 0; i < bp->entries; ++i ) {
	if (bp->alloc[i].ptr == p) {
	   /* check integrity of gap */
	   for (gap = bp->alloc[i].size - OVHDSIZE;
		gap < bp->alloc[i].size; ++gap) {
	      if (p[gap] != FILLCHAR ) {
		 printf ("WARNING overwrite, addr: %lx\n",
			 (long) p);
		 break;
	      }
	   }
	   if (memtrace == 1) {
	      /* remove entry from bucket */
	      if ( --bp->entries == 0 ) {
		 /* free this bucket */
		 if ( bq )
		     bq->next = bp->next;
		 else
		     ptrhash[bno] = bp->next;
		 tot_memory -= bp->alloc[i].size;
		 myfree (( char far *) bp->alloc);
		 myfree ((char far *) bp);
		 tot_memory -= (sizeof(BUCKET) +
				bucketsize*sizeof(ALLOCATION));
		 return;
		 }
		 else if ( i < bp->entries ) {
		    /* move last entry into current spot */
		    bp->alloc[i] = bp->alloc[bp->entries];
		 }
		 myfree(p);
	      }
	      else {
		 /* memtrace == 2
		    => save copy to check for bad mods */
		 if (bp->alloc[i].freed)
		    printf ("WARNING: freeing free ptr, addr: %lx\n",
			     (long)p);
		 else if (bp->alloc[i].freed = myfarmalloc(bp->alloc[i].size))
		    farmemcpy(bp->alloc[i].freed, bp->alloc[i].ptr,
			  bp->alloc[i].size);

	      }
	      /* update total allocated memory count */
	      tot_memory -= bp->alloc[i].size;
	      if (tot_memory <0)
		printf("WARNING too many frees");

	      /* normal return */
	      return;
	   }
	}
	bq = bp;
      }
      if ( ! bp)
	 printf ("WARNING: freeing bad pointer, addr = %lx\n",(long)p);
}

/* ==========================================================
   Allocate b bytes of memory
*/
CFP far x_malloc( b)
unsigned long b;		/* number of bytes to allocate */
{
   register CFP mptr;

   if (memtrace) {
	/* add gap space */
	b += OVHDSIZE;

	/* allocate memory */
	if ( mptr = myfarmalloc(b) ) {
	   /* fill gap */
	   farmemset (mptr+b-OVHDSIZE, FILLCHAR, OVHDSIZE);

	   /* store mptr to ptrhash */
	   mptr = sto_ptr(mptr, b);
	}
   }
   else
      mptr = myfarmalloc(b);

   return(mptr);
}

/* =========================================================
  Allocate and clear i*s bytes of memory
*/
CFP far x_calloc (i, s)
unsigned long i;		/* number of blocks to be allocated */
unsigned long s;		/* size (in bytes) of each block */
{
   register unsigned long amt;
   register char far *mptr;

   /* allocate requested space */
   if ( mptr = x_malloc(amt = i*s)) {
      /* clear requested space */
      farmemset(mptr, '\0' , amt);
   }
   return(mptr);
}

/* ==========================================================
    Free allocated memory
*/
void far x_free(p)
CFP p;		/* pointer to block to be freed */
{
    if ( p == NULL)
      printf ("WARNING freed a null pointer\n");
    else if (memtrace)
      del_ptr(p);
    else
      myfree ((char far *) p);
}

/* ==========================================================
   Check to ensure all blocks have been freed
*/
void far x_chkfree()
{
   ALLOCATION far *ap;		/* allocation entry pointer */
   register int bno, i;		/* bucket/entry number */
   register BUCKET far *bp, far *bq;	/* bucket pointers */

   if (memtrace) {
      /* check for unfreed variables */
      for ( bno = 0; bno < hashsize; ++bno) {
	for (bp=ptrhash[bno]; bp; bp = bq ) {
	  for (i = 0; i < bp->entries; i++) {
	    ap = &bp->alloc[i];
	    if (memtrace ==2 && ap->freed) {
	       /* check for changes to freed blocks */
	       if (farmemcmp(ap->ptr, ap->freed, ap->size) )
		 printf ("WARNING block changed after free, addr: %lx\n",
		       (long) ap->ptr);
	    }
	    /* free unfreed block */
	    printf ("WARNING freeing unfreed block, addr: %lx\n",
		   (long)ap->ptr);
	    myfree(ap->ptr);
	  }
	  bq = bp->next;

	  /* free bucket */
	  myfree ((char far *) bp->alloc);
	  myfree ((char far *) bp);
	}
      }
      /* free pointer hash pointer array */
      myfree ((char far *) ptrhash);
      ptrhash = (BUCKET far * far *)0;

      tot_memory = 0L;
   }
}

/* ================================================================
  Reallocation of memory
*/
CFP far x_realloc(p,newsize)
CFP p;			/* block to reallocate */
unsigned long newsize;   /* new size of block */
{
   x_free(p);
   return(x_malloc(newsize));
}
