#include <dos.h>
#include <stdio.h>
#include <mem.h>
#include <alloc.h>
#include "chess.h"
#include "proc.h"
#include "timer.h"

#define SIZE 10
typedef struct {
	unsigned long result;
	unsigned  start;
	unsigned  stop;
	unsigned long count;
} TIMER;

static TIMER timestack[SIZE];

static unsigned int near timer1(void)     /* current contence of the system timer */
{
  return(inp(0x40)+(inp(0x40)<<8));
}

static unsigned long near clocks( int handler )
{
	unsigned  cl_before, cl_after;
		/* clocks beetwin last get_clock_before &
						   get_clock_after  */
  cl_before=timestack[handler].start;
  cl_after=timestack[handler].stop;
  return((cl_before>cl_after)?
  (cl_before-cl_after) : ~(cl_after-cl_before));
}

int NEAR reset_all_timer( void )
{
	memset( timestack, 0, sizeof( timestack ) );
	return(0);
}

int NEAR reset_timer( int handler )
{
	if( handler>=SIZE ) return(-1);
	timestack[handler].result=0L;
	return(0);
}

int NEAR start_timer( int handler )
{
	if( handler>=SIZE ) return(-1);
	timestack[handler].start=timer1();
	return(0);
}

int NEAR stop_timer( int handler, int flag )
{
 TIMER *tp;
	if( handler>=SIZE ) return(-1);
	tp=&timestack[handler];
	tp->count++;
	tp->stop=timer1();
	if( flag ) tp->result+=clocks( handler );
	else tp->result=clocks( handler );
	return(0);
}

void NEAR print_timer( int handler, char *head )
{
SSTRING str;
unsigned long i;
	i=timestack[handler].result/5*2;
	farsprintf( str," %s used %3lu,%-6lu mks (%lu)",
	  head,i/1000000L,i%1000000L,timestack[handler].count );
	lastlinereply( str );
}