/*
	 ͻ
	               Programm for running tests at kaissa             
	 ͼ
*/
#include <stdio.h>
#include <io.h>
#include <fcntl.h>

#include "chess.h"
#include "proc.h"
#include "ks_game.h"
#include "tests.h"

#include "FACE.h"
#include "FACEkeys.h"
#include "faceproc.h"
#include "facelib.h"

#include "ksiwind.h"
#include "ksibdraw.h"
#include "helpind.h"
#include "interface.h"
#include "menu.h"
#include "menu_fun.h"
#include "message.h"

#define TESTNUM 25

int testfp;
int testenable;

void commit(int file); /* ksiprot.c */

int runtests(void)
{
int posfp;
SSTRING fname;
int testcount;
static int start_num=1;
static int stop_num=24;
static char far format[]="BK%02d.pos";
static char far testfilename[]="test.tst";
static char far err_mess[]="Can't open file to read position. ";

int top=5,left=30;
int i;

  testenable=1;
  if(infc_info[cur_infc_ptr->name].type&MENU_STATUS)
      menuposition(*menusp,&top,&left);
  i=getnumber(top,left, &start_num, startnum_mess);
  if(i==ESCAPE || i==ERROR) return 0;
  i=getnumber(top,left, &stop_num, stopnum_mess);
  if(i==ESCAPE || i==ERROR) return 0;
/*  openallwnd(); */
  testfp=MYOPEN(testfilename,O_RDWR, 0);
  if(testfp==-1){ message( err_mess,0); return 0; }
  for(testcount=start_num; testcount<=stop_num; testcount++){
    farsprintf( fname, format, testcount );
    posfp=MYOPEN( fname, O_RDONLY+O_TEXT, 0 );
    if( posfp==-1 ){
      message( err_mess ,0);
      MYCLOSE(testfp);
      testenable=0;
      return 0;
    }
    getposfromfile(posfp);
    MYCLOSE( posfp );
    setwritten(board);
    refresh(board);
    MYWRITE(testfp,fname,FARSTRLEN(fname)); MYWRITE(testfp,eol,2);
    get_move();
	if(breakflag) break;  /* Interrupt tests running due to user break */
    commit( testfp );
  }
  MYCLOSE(testfp);
  testenable=0;
  return 0;
}
