#include "lang.h"
#include "serial.h"
#include <stdio.h>
#include <dos.h>

#define      DATA_READY_STATUS        0x1
#define      OVERRUN_ERROR            0x2
#define      PARITY_ERROR             0x4
#define      FRAMING_ERROR            0x8
#define      BREAK_DETECT             0x10
#define      TRANS_HOLDING_REG_EMPTY  0x20
#define      TRANS_SHIFT_REG_EMPTY    0x40
#define      TIMEOUT                  0x80

#define SERIAL_PORT_BASE   0x3F8
#define SERIAL_PORT_DATA   (SERIAL_PORT_BASE)
#define SERIAL_PORT_STATUS (SERIAL_PORT_BASE+5)

int receive_char_ready( void )
{
  return( inportb( SERIAL_PORT_STATUS ) & DATA_READY_STATUS );
  
}

int receive_char(char *cp)
{

  while( ! ( inportb( SERIAL_PORT_STATUS ) & DATA_READY_STATUS ) );
  *cp=inportb( SERIAL_PORT_DATA );
  return( 1 );
}

int send_char(char *cp)
{
  outportb( SERIAL_PORT_DATA, *cp );
  return( 1 );
}

void init_serial_port( void )
{

}

