
                /**\
                         Header file "proc.h"          
                                                       
                        Global functions prototypes   
                \**/

#ifndef _PROC_H
#define _PROC_H

#ifndef  _LANG_H
#include "lang.h"
#endif

#ifndef  _CHESS_H
#include "chess.h"
#endif

#ifndef  __MEM_H
#include <mem.h>   /* movedata */
#endif
#ifndef  __DOS_H
#include <dos.h>   /* FP_SEG */
#endif

#if _CPU==386
#ifndef  _386_H
#include "386.h"
#endif
#endif


#define ks_farmemcpy( dest, src, size ) _fmemcpy( dest, src, size )
/*#if _CPU==386
  #define MEMCPY( dest, src, size ) memcpy1( dest, src, size )
#else*/
  #define MEMCPY( dest, src, size ) memcpy( dest, src, size )
//#endif


MOVE * NEAR generator_null(MOVE *mp);
MOVE * NEAR generator(MOVE *mp, int pass_en);
                        /* Generate moves for current pass */
                        /* Generator also defines next pass needed */
                        /* If GEN_FUNC==NULL no more avaliable passes */
MOVE * NEAR generator_i(MOVE *mp, int pass_en);
                        /* Set first pass gen function and call generator */
MOVE * generate_all(MOVE *mp);
                        /* Generate all legal moves from first pass */
                        /* for interface and fv0() and fv1() use only */

void init_pos( void );

int allocpos( void );
                                        /* Allocate position stack */


#define color_to_king_num(color) ((color)*NUM_PIECE)
#define num_to_color(num) ((num)/NUM_PIECE)
#define reverse_color(color) (1-(color))
#define reverse_dir(dir) ( (dir)^(NDIR>>1) )


int  NEAR move(void);                   /* Return check state for our king */
void NEAR move_back(void);
int  check(PIECE_COLOR color);
                /* check state for king with some color in some position */

BOOLEAN NEAR down(void);                        /* goes one level down */
BOOLEAN NEAR up (void);                 /* goes one level  up  */

extern BYTE bit_number[256];            /* Convert byte to int */
#define byte_to_int(x) (bit_number[(x)])
extern const BYTE bytes[8];             /* Convert int to byte*/
#define int_to_byte(x) bytes[(x)]


#define MOVELENGTH 8
char far * decode(char far *dest, const MOVE *movep, POSITION *posp ,int brief);
void lastlinereply( char far * str );
void lastlinesmall(char far * str);
int putinfo( int nline, int nzone, char far * str );

MAT_EVAL material_eval(POSITION *pos);
typedef enum {
  EQUAL=1,
  GREATER=2,
  LESS=4
}                               CMP;
CMP NEAR cmp_eval(register EVAL *v1,register EVAL *v2);
                                /*          GREATER if v1>v2   */
                                /* Return   EQUAL   if v1=v2   */
                                /*          LESS    if v1<v2   */
void NEAR cpy_eval(register EVAL *v1,register EVAL *v2);
                                /* Copy evaluation v2 to v1 */
EVAL * NEAR reverse_eval(register EVAL *v1,register EVAL *v2);
                                /* v1=-v2, Return pointer to v1 */
void NEAR zero_eval(register EVAL *v1);
                                /* v1=0 */

 /* File ks_mmax.c */

void NEAR searchtree( void );                   /* The main search function */
void NEAR bettermove( void );
                                
#define clear_move(movep) ( (movep)->from=DUMMY )
#define move_exist(movep) ( (movep)->from!=DUMMY )  /* Check of move clearing */

/*#if _CPU==386
  #if sizeof(MOVE)==6
    #define movecpy( dest, src )   movecpy( (dest), (src) )
  #else
    #error "Format of MOVE is changed"
  #endif
#else*/
  #define movecpy( dest, src )   (void)memcpy( (dest), (src), sizeof(MOVE) )
/*#endif*/

#define movecmp( first, second ) \
	( (first)->from == (second)->from && (first)->to == (second)->to )
void NEAR swap_moves(MOVE *move1,MOVE *move2);      /* MOVE type swap. */

void NEAR put_eval(int level, MAT_EVAL m, POS_EVAL p);

 /* File ks_trace.c */

void NEAR trace(char *message);
int NEAR trace_pos(char *prn,int killflag); /* Make current position path string. */
int NEAR cur_trace(char *prn);              /* Make current variant string. */
int make_variant_string(char *prn);    /* Make current variant string. */
int make_variant_string_with_numbers(char* prn);

void NEAR set_branchptr(void);              /* Set level branch pointers. */
void NEAR fill_betterbranch(void);          /* Fill branch of better moves. */
void NEAR hash_betterbranch(void);          /* Fill branch if hash eval */

void NEAR clear_betterbranch(void);         /* Clear betterbranch at level */
                                       /* greater than current level. */
void NEAR print_betterbranch(void);    /* Print the branch of better moves. */

int message(char far * str,int mode);
void NEAR savesearch(void);

/* File ks_timer.c */
int NEAR stoptimeafter(void);
int NEAR notime(int curr_n);

/* File killer.c */

void NEAR init_killer(void);                  /* Initialise table for killer. */
void NEAR clear_killer(int level);        /* Reset frequances in killers. */
void NEAR clear_all_killer(void);        /* Reset frequances in killers. */
void NEAR killer_heuristic(GEN_STATUS status);     /* Fill killers table. */
void NEAR set_killer0(void);
void NEAR set_killer1(void);

int word_to_bit_num(WORD mask);

void deletemask( PIECE_NAME pname, DWRD mask );
void changemask( PIECE_NAME pname, DWRD mask );

void form_nullmove(MOVE *mp);
void NEAR change_bound(SQUARE_NUM sq);
void NEAR change_king_bound(PIECE_COLOR our);
int NEAR square_bounded(SQUARE_NUM sq, PIECE_COLOR kingcolor);

void getposfromfile( int file);
void putposintofile( int file);

int setprintflag(void);

int loadfont( int fontsize );

int NEAR read_write_array(char *file_name, void (*fill_array)(),
				 char far * array, long array_size);

void NEAR clear_moves( void );                  /* Clear written moves masks */

int NEAR we_win(void);

#endif