#include <stdio.h>

#include "facelib.h"
#include "lang.h"
#include "experim.h"
#include "proc.h"

int nullstatus; /* Null move search status */

int
 nullcount,          /* Total Null move search in FV counter */
 winnullcount,       /* Win null move search counter */

 fullnullcount,      /* Null move search in FV at full null move search
			   level counter */
 winfullnullcount,       /* Win null move search counter */

 doublenullcount,    /* Null move search in FV because of double attacked */
 windoublenullcount, /* Win null move search counter */

 boundnullcount,     /* Null move search in FV because of attacked bounded */
 winboundnullcount,  /* Win null move search counter */

 cutoffnullcount,    /* Not FV Null move search counter */
 wincutoffnullcount; /* Win null move search counter */

int nullstatistic;

int
 evalcount,        /* Evaluation use counter */
 secondevalcount,   /* Evaluation use counter second in branch*/
 thirdevalcount,   /* Evaluation use counter third in branch*/
 goodevalcount,    /* Evaluation - better or killer counter */
 secondgoodevalcount,  /* Evaluation - better or killer second in branch */
 thirdgoodevalcount,  /* Evaluation - better or killer third in branch */

 selectcount,      /* Selective deepening use counter */
 winselectcount,      /* Win after deepening */
 loseselectcount,      /* Lose after deepening */
 gooddeepeningcount;    /* Deepening in the case of good eval */

int selectstatistic;

void NEAR printnullstatistic(void)  /* print null move search statistic */
{
}

void NEAR startnullstatistic(void)  /* print null move search statistic */
{
 nullcount=0;          /* Total Null move search in FV counter */
 winnullcount=0;       /* Win null move search counter */

 fullnullcount=0;      /* Null move search in FV at full null move search
			   level counter */
 winfullnullcount=0;   /* Win null move search counter */


 doublenullcount=0;    /* Null move search in FV because of double attacked */
 windoublenullcount=0; /* Win null move search counter */

 boundnullcount=0;     /* Null move search in FV because of attacked bounded */
 winboundnullcount=0;  /* Win null move search counter */

 cutoffnullcount=0;    /* Not FV Null move search counter */
 wincutoffnullcount=0; /* Win null move search counter */
}
void NEAR printselectstatistic(void)  /* print null move search statistic */
{
LSTRING prn;
static char far form1[]="Selective search statistic:";
static char far form2[]=" Evaluation used - %u ( Second in branch - %u, third - %u )";
static char far form3[]=" Evaluation good - %u ( Second in branch - %u, third - %u )";
static char far form4[]=" Selective deepening - %u ";
static char far form5[]=" Win (killer found)  - %u ";
static char far form6[]=" Decreased (better)  - %u ";
static char far form7[]=" Lose (all move bad) - %u ";

  lastlinereply( form1 );
  farsprintf(prn, form2, evalcount,secondevalcount,thirdevalcount);
  lastlinereply(prn);
  farsprintf(prn, form3, goodevalcount,secondgoodevalcount,thirdgoodevalcount);
  lastlinereply(prn);
  farsprintf(prn, form4, selectcount);
  lastlinereply(prn);
  farsprintf(prn, form5 ,winselectcount);
  lastlinereply(prn);
  farsprintf(prn, form6 ,selectcount-winselectcount-loseselectcount);
  lastlinereply(prn);
  farsprintf(prn, form7 ,loseselectcount);
  lastlinereply(prn);
}

void NEAR startselectstatistic(void)  /* print null move search statistic */
{
  evalcount=0;
  secondevalcount=0;
  thirdevalcount=0;
  goodevalcount=0;
  secondgoodevalcount=0;
  thirdgoodevalcount=0;

  selectcount=0;
  winselectcount=0;      /* Win after deepening */
  loseselectcount=0;   /* Los after deepening */
  gooddeepeningcount=0;
}