#include <mem.h>
#include <dos.h>
#include <string.h>
#include "chess.h"
#include "face.h"
#include "current.h"
#include "entime.h"   /* pos_buf */
#include "global.h"   /* pos_stk, position */
#include "proc.h"      /* ks_farmemcpy() */
#include "newutil.h"
#include "menu.h"
#include "ks_macro.h"
#include "ks_game.h"
static int near pateormate(void);

#define WHITE_KING_AT_E1 (SQUARE[e1].wood.name==KING && \
			  SQUARE[e1].wood.color==WHITE_PIECE)
#define BLACK_KING_AT_E8 (SQUARE[e8].wood.name==KING && \
			  SQUARE[e8].wood.color==BLACK_PIECE)
#define WHITE_ROOK_AT_A1 (SQUARE[a1].wood.name==ROOK && \
			  SQUARE[a1].wood.color==WHITE_PIECE)
#define WHITE_ROOK_AT_H1 (SQUARE[h1].wood.name==ROOK && \
			  SQUARE[h1].wood.color==WHITE_PIECE)
#define BLACK_ROOK_AT_A8 (SQUARE[a8].wood.name==ROOK && \
			  SQUARE[a8].wood.color==BLACK_PIECE)
#define BLACK_ROOK_AT_H8 (SQUARE[h8].wood.name==ROOK && \
			  SQUARE[h8].wood.color==BLACK_PIECE)

void setdefaultcastles(void)
{
  CASTLE[WHITE_PIECE]=0;
  CASTLE[BLACK_PIECE]=0;
  if(WHITE_KING_AT_E1){
    if(WHITE_ROOK_AT_A1) CASTLE[WHITE_PIECE]|=CASTLELEFT;
    if(WHITE_ROOK_AT_H1) CASTLE[WHITE_PIECE]|=CASTLERIGHT;
  }
  if(BLACK_KING_AT_E8){
    if(BLACK_ROOK_AT_A8) CASTLE[BLACK_PIECE]|=CASTLELEFT;
    if(BLACK_ROOK_AT_H8) CASTLE[BLACK_PIECE]|=CASTLERIGHT;
  }
  if(!CASTLE[WHITE_PIECE]) CASTLE[WHITE_PIECE]=CASTLELEFTDONE;  /* If castles not available - it */
  if(!CASTLE[BLACK_PIECE]) CASTLE[BLACK_PIECE]=CASTLELEFTDONE;  /* is done (for correct eval) */
}

int checkcastles(void) /* Check turned on castles and turn it off, if not available */
{
int item,flag=0;
static char far mess[]="This castle is impossible";

  item=getcurm( CURMENUWP );
  switch (item) {
    case 2:
	if (CASTLE[WHITE_PIECE]& CASTLELEFT)
	  if(!WHITE_KING_AT_E1 || !WHITE_ROOK_AT_A1) {
	    CASTLE[WHITE_PIECE]&=~CASTLELEFT;
	    flag=1;
	  }
	break;
    case 1:
	if (CASTLE[WHITE_PIECE]& CASTLERIGHT)
	 if(!WHITE_KING_AT_E1 || !WHITE_ROOK_AT_H1) {
	    CASTLE[WHITE_PIECE]&=~CASTLERIGHT;
	    flag=1;
	 }
	break;
    case 4:
	if (CASTLE[BLACK_PIECE]& CASTLELEFT)
	 if(!BLACK_KING_AT_E8 || !BLACK_ROOK_AT_A8) {
	    CASTLE[BLACK_PIECE]&=~CASTLELEFT;
	    flag=1;
	 }
	break;
    case 3:
	if (CASTLE[BLACK_PIECE]& CASTLERIGHT)
	  if(!BLACK_KING_AT_E8 || !BLACK_ROOK_AT_H8) {
	    CASTLE[BLACK_PIECE]&=~CASTLERIGHT;
	    flag=1;
	  }
	break;
  }
  if (flag) message(mess,0);
  if(!CASTLE[WHITE_PIECE]) CASTLE[WHITE_PIECE]=CASTLELEFTDONE;  /* If castles not available - it */
  if(!CASTLE[BLACK_PIECE]) CASTLE[BLACK_PIECE]=CASTLELEFTDONE;  /* is done (for correct eval) */
  return(0);
}

int is_white_king(void)
{
	return((PIECE_LIST[WHITE_KING].where!=DUMMY));
}

int is_black_king(void)
{
	return((PIECE_LIST[BLACK_KING].where!=DUMMY));
}

extern SQUARE_NUM en_passant_square;
int check_en_pass_status(PIECE_COLOR color)
{
SQUARE_INFO *sqp;

    if (en_passant_square==DUMMY) return(0);
    if (color==WHITE_PIECE) {
	if (GETLINE(en_passant_square)!=5) return(1); /* not right line */
	sqp=SQUAREP(en_passant_square-8); /* next square on this file */
	if (sqp->wood.name!=PAWN || sqp->wood.color!=BLACK_PIECE)
	  return(1);	/* there is no black pawn on the square */
	if (WHOONSQUARE(en_passant_square+8)->name !=0 || /* these two should*/
	    WHOONSQUARE(en_passant_square)->name !=0 )   /* empty */
	      return(1);
    } else {
	if (GETLINE(en_passant_square)!=2) return(1); /* not right line */
	sqp=SQUAREP(en_passant_square+8); /* next square on this file */
	if (sqp->wood.name!=PAWN || sqp->wood.color!=WHITE_PIECE)
	  return(1);	/* there is no white pawn on the square */
	if (WHOONSQUARE(en_passant_square-8)->name !=0 || /* these two should*/
	    WHOONSQUARE(en_passant_square)->name !=0 )   /* empty */
	      return(1);
    }
    return(0);
}

void gamefinish(void)
{
static char far mess1[]="Draw - pate on the board.";
static char far mess2[]="Game over - mate ";
static char far mess4[]="Congratulations - I lose.";
static char far mess5[]="Game over - mate. KAISSA wins.";


   if( (1<<MOVE_COLOR) & whomove) { /* KAISSA's Move */
       if( (1<<REVCOLOR(MOVE_COLOR)) & whomove) { /* Kaissa is opponent */
		if (pateormate()) message(mess1,1);
		else message(mess2,1);
       } else {    /* Man is opponent */
		if (pateormate()) message(mess1,1);
		else message(mess4,1);
       }
   } else {
       if( (1<<REVCOLOR(MOVE_COLOR)) & whomove) { /* Kaissa is opponent */
		if (pateormate()) message(mess1,1);
		else message(mess5,1);
       } else {    /* Man is opponent */
		if (pateormate()) message(mess1,1);
		else message(mess2,1);
       }
   }
   setwhomove(MAN_MAN);
}

static int near pateormate(void)
{
  if(check(MOVE_COLOR)) return(0);
  return(1);
}

char en_passant_str[20]="";
SQUARE_NUM en_passant_square=DUMMY;
int checkenpassant(void)
{
char *str;
int i,j,flag=0;

  strlwr(en_passant_str);
  for (str=en_passant_str,i=0;i<strlen(en_passant_str);i++,str++) {
     if (*str==' ' ) {
       if (!flag) continue;
       else break;
     } else {
       flag++;
       switch (flag) {
	 case 1:
		 j=*str-'a';
		 if (j<0 || j>7) flag=3;
		 en_passant_square=j;
		 break;
	 case 2:
		 j=*str-'1';
		 if (j<0 || j>7) flag=3;
		 en_passant_square=GETOFFSET(en_passant_square,j);
		 break;
       }
       if (flag >=3) break;
     }
  }
  if (flag==0) {
      en_passant_square=DUMMY;
      return(0);
  }
  j=GETLINE(en_passant_square);
  if ((j!=2 && j!=5) || (flag>=3)) {
      en_passant_str[0]='\x0';
      en_passant_square=DUMMY;
      message("Wrong en passant square given.",0);
      return(0);
  }
  if(check_en_pass_status(MOVE_COLOR)){
      en_passant_str[0]='\x0';
      en_passant_square=DUMMY;
      message("Wrong en passant square given.",0);
      return(0);
  }
  EN_PASS=en_passant_square;
  return 0;
}

