#include "lang.h" 
#include "chess.h"
#include "global.h"
#include "current.h"
#include "newpawnh.h"
#include "ks_game.h"
#include "proc.h"
#include "facelib.h"
#include <mem.h>
#include <alloc.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>

typedef struct{
  signed char far *passage[NCOLOR]; /*Packed in string passage pawns koordinates */
  signed char far *st_sq[NCOLOR];    /*Packed in string stong squares */
  char line[NLINE][NCOLOR];         /*Lines tipes(open,semiopen...) */
/*  BYTE pawns_lines[NCOLOR][NLINE][NFILE+1]; /* ??? */*/
  POS_EVAL pawneval;               /* Pawn part of position evaluation */
}	PAWN_INFO;

typedef struct{
   signed char pawn_list[NUM_PIECE];
}      PAWN_KEY;             

typedef struct{
  int link;                 
  PAWN_KEY   key;       
  PAWN_INFO  info;      
}      PAWN_IN_HASH;    

#define SEG_SIZE ((sizeof(PAWN_IN_HASH)+15)/16)

typedef PAWN_IN_HASH  far *  PAWNHASHP ;

#define PAWN_HASH_SIZE 127   
			
#define PAWN_BUF_SIZE  500

#define PAWN_STRUCTS_SIZE 5000  /* of bytes */
		     /*Size of buffer of pawn's structures in hash*/
#define PAWN_STRUCT_SIZE  (NCOLOR*(NLINE+1)+NCOLOR*(NLINE*2+1))   /*52 bytes*/

signed char far *pawn_struct_free,far *pawn_struct_buffer;

int pawn_hash_flag;
int pawn_hash_enable;
static int pawn_alloc_hash_flag=0;

/*static int pawn_hash_alloc_flag; /*Memory for pos hash allocated ?*/*/
static int far *pawn_hash_table; /*Pointer to the hash table */
static PAWNHASHP pawn_buffer,     /*Pointer to the begin of position buffer */
		pawn_free;       /*Pointer to the end of position buffer */

static int Addrinhash;
POS_EVAL Hashpawneval;

static int pawnhashsuccessnum;
static int pawnhashoverflownum;

static void near restore_pawn_struct(void);
static void near save_pawn_struct(void);

static int near pawn_calc_hash(void);/*Hash-function from pieces's disposition */

static int near put_pawn_hash(int);
static int near search_pawn_hash(int);

static PAWNHASHP near pawn_buffer_addr(unsigned);

static unsigned near pawn_index(PAWNHASHP);

static void near pawn_buffer_addr_inc(PAWNHASHP *);

static PAWNHASHP near pawn_buffer_addr(unsigned index)
{
  return(MK_FP(FP_SEG(pawn_buffer)+index*SEG_SIZE,FP_OFF(pawn_buffer)));  /**/
}

static unsigned near pawn_index( PAWNHASHP posp)
{
  return((FP_SEG(posp)-FP_SEG(pawn_buffer))/SEG_SIZE);                   /**/
}

static void near pawn_buffer_addr_inc( PAWNHASHP *posp){
  *posp=MK_FP(FP_SEG(*posp)+SEG_SIZE,FP_OFF(*posp));                  /**/
}

static int near put_pawn_hash(int hash)
{
int i,j;	
  if(pawn_index(pawn_free)<PAWN_BUF_SIZE-1 &&       /*Not overflow hash */
    (pawn_struct_free-pawn_struct_buffer)<(PAWN_STRUCTS_SIZE-PAWN_STRUCT_SIZE)){
      pawn_free->link=pawn_hash_table[hash];
      for(i=8,j=0;i<TOTAL_NUM_PIECE;i++)
	if(i&8) pawn_free->key.pawn_list[j++]=PIECE_LIST[i].where;
      pawn_hash_table[hash]=pawn_index(pawn_free);
      pawn_buffer_addr_inc(&pawn_free);
      return(pawn_hash_table[hash]);
  }
  else{              /* No memory for next position in hash */
    pawnhashoverflownum++;
    return(0);
  }
}

static int near search_pawn_hash(int hash)
{
PAWNHASHP addr1;
int i,j,index,flag;

				/* Loop by position with the same hash */
  for(index=pawn_hash_table[hash];addr1=pawn_buffer_addr(index),index;
						   index=addr1->link){
      for(i=8,j=0,flag=0;i<TOTAL_NUM_PIECE;i++){
	if(i&8){
	  if(PIECE_LIST[i].where!=(addr1->key.pawn_list[j++])){
	    flag=1; break;
	  }
	}
      }/* for */
      if(!flag){
	return(index);
      }
  }    /* End of loop by position with the same hash */
  return(0);
}

int pawn_alloc_hash()       /* farmalloc for pos hash */
{
  if( pawn_alloc_hash_flag ) return(1);
  pawn_free=pawn_buffer=( PAWNHASHP )                                    /**/
	 MYFARMALLOC( PAWN_BUF_SIZE*16L*SEG_SIZE/*( unsigned long )sizeof( PAWN_IN_HASH)*/);
	/*because of each position use whole paragraph */
  pawn_hash_table=( IFP )MYFARMALLOC( PAWN_HASH_SIZE*2 );
  pawn_struct_free=pawn_struct_buffer=(signed char far *)MYFARMALLOC(PAWN_STRUCTS_SIZE);
  if(/* farcoreleft()<20000 || */
      !pawn_struct_buffer || !pawn_hash_table || !pawn_buffer){
    pawn_free_hash();
    return(0);
  }
  pawn_alloc_hash_flag=1;
  return(1);
}

void pawn_free_hash()       /* Free memory for pos hash */
{
    if(pawn_buffer)        MYFREE ((CFP) pawn_buffer);
    if(pawn_hash_table)    MYFREE ((CFP) pawn_hash_table);
    if(pawn_struct_buffer) MYFREE (pawn_struct_buffer);
    pawn_alloc_hash_flag=0;
    pawn_hash_flag=0;
}
				/*United alloc and init hash */
void NEAR pawn_init_hash()
{                               
int i;
  if(pawn_alloc_hash_flag){     /* If memory allocated */
    for(i=0;i<PAWN_HASH_SIZE;i++)
      pawn_hash_table[ i ]=0;     /* Init hash table */
				  /* Include the root(level=0)position in hash*/
    pawn_buffer_addr_inc( &pawn_free );
    pawn_free->link=0;
    Addrinhash=pawn_hash_table[ pawn_calc_hash() ]=1;
    pawn_buffer_addr_inc( &pawn_free );

    pawn_hash_flag=1;             /* The main thing */

    pawnhashsuccessnum=0;
    pawnhashoverflownum=0;
  }
}

int NEAR pawn_hash_success(void)
{
PAWN_INFO far *infop;
int hash;

  hash=pawn_calc_hash();
  Addrinhash=search_pawn_hash(hash);        /* Into pos_sp */

  if (!Addrinhash) {                              /* Position don't found. */
    Addrinhash=put_pawn_hash(hash);
    return(0);
  }
  infop=&(pawn_buffer_addr(Addrinhash)->info);
  Hashpawneval=infop->pawneval;
  restore_pawn_struct();
  pawnhashsuccessnum++;
  return(1);    
}

void NEAR save_pawn_hash(POS_EVAL eval)   /* Put eval of position into Hash. */
{                               /* Put best move into Hash. */
PAWN_INFO far *infop;

  if(!Addrinhash) return;
  infop=&(pawn_buffer_addr(Addrinhash)->info);
  infop->pawneval=eval;
  save_pawn_struct();
}

static int near pawn_calc_hash()
{
SQUARE_NUM sq;
int i,hash=0;
    for(i=0;i<TOTAL_NUM_PIECE;i++){
      if((i&8)&& ((sq=PIECE_LIST[i].where)!=DUMMY) && (WHOONSQUARE(sq)->name==PAWN)){
	hash+=(i+1)*sq;
      }
    }
    return(hash%(PAWN_HASH_SIZE));
}

extern char line[NCOLOR][NLINE];
extern SQUARE_NUM st_sq[NCOLOR][NLINE*2+1];
extern SQUARE_NUM passage[NCOLOR][NLINE+1];
signed char far *pawn_struct_free,far *pawn_struct_buffer;

void NEAR print_deb_pawn_hash(void)
{
SSTRING prn;
  farsprintf(prn,"Pawn hash success  %d",pawnhashsuccessnum);
  lastlinereply(prn);
  farsprintf(prn,"Position in hash   %d", pawn_index(pawn_free));
  lastlinereply(prn);
  farsprintf(prn,"Pawn hash overflow %d",pawnhashoverflownum);
  lastlinereply(prn);
}

extern char line[NCOLOR][NLINE];
extern SQUARE_NUM st_sq[NCOLOR][NLINE*2+1];
extern SQUARE_NUM passage[NCOLOR][NLINE+1];
/*extern BYTE pawns_lines[NCOLOR][NLINE][NFILE+1]; /* ??? */*/

static void near restore_pawn_struct(void)
{
PAWN_INFO far *infop;
char *eval_linep;
signed char far *hash_sqp;
SQUARE_NUM *sqp;
char far *hash_linep;
PIECE_COLOR color;
int i;

  infop=&(pawn_buffer_addr(Addrinhash)->info);
  for(color=WHITE_PIECE;color<=BLACK_PIECE;color++){
	       /*pack SQUARE_NUM into char */
    for(sqp=st_sq[color],hash_sqp=(infop->st_sq[color]);
	((*sqp++)=(SQUARE_NUM)(*hash_sqp++))!=DUMMY;);
    for(sqp=passage[color],hash_sqp=infop->passage[color];
	((*sqp++)=(SQUARE_NUM)(*hash_sqp++))!=DUMMY;);
  }
  hash_linep=&(infop->line[0][0]);
  eval_linep=&(line[0][0]);
  for(i=0;i<NLINE*NCOLOR;i++){
    *eval_linep++=*hash_linep++;
  }

/*  hash_linep=&(infop->pawns_lines[0][0][0]);   /* ??? */
  eval_linep=&(pawns_lines[0][0][0]);
  for(i=0;i<NLINE*NCOLOR*(NFILE+1);i++){
    *eval_linep++=*hash_linep++;
  } */

  return;
}

static void near save_pawn_struct(void)
{
PAWN_INFO far *infop;
char *eval_linep;
SQUARE_NUM *sqp;
char far *hash_linep;
PIECE_COLOR color;
int i;
  if(Addrinhash){
    infop=&(pawn_buffer_addr(Addrinhash)->info);
    for(color=WHITE_PIECE;color<=BLACK_PIECE;color++){
	       /*unpack char into SQUARE_NUM  */
      for(sqp=st_sq[color],infop->st_sq[color]=pawn_struct_free;
	  (*pawn_struct_free++=(signed char)(*sqp++))!=DUMMY;);
      for(sqp=passage[color],infop->passage[color]=pawn_struct_free;
	  (*pawn_struct_free++=(signed char)(*sqp++))!=DUMMY;); 
	  /* check overflow*/

    }

    hash_linep=&(infop->line[0][0]);
    eval_linep=&(line[0][0]);
    for(i=0;i<NLINE*NCOLOR;i++){
      *hash_linep++=*eval_linep++;
    }

/*    hash_linep=&(infop->pawns_lines[0][0][0]);   /* ??? */
    eval_linep=&(pawns_lines[0][0][0]);
    for(i=0;i<NLINE*NCOLOR*(NFILE+1);i++){
      *hash_linep++=*eval_linep++;
    }*/

  }
}


