#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "newhash.h"
#include "ks_game.h"
#include "experim.h"
#include "proc.h"
#include "facelib.h"
#include "ems.h"
#include "newpawnh.h"
#include "ksitimer.h"  /* nmove */
#include "gener.h"

#include <values.h>
#include <mem.h>
#include <alloc.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <io.h>
#include <stdlib.h>
#include <fcntl.h>
#include <time.h>

RAND_NUM far * rand_num;

#define ZERO 0                  /* Zero eval (repeat position) */
#define LOW_LIMIT 1              /* alpha == eval         */
#define HIGH_LIMIT 2             /*          eval == beta */
#define MIDDLE 3                 /* alpha <  eval <  beta */

typedef struct{
  EVAL eval;                        /*Evaluation of position in hash */
  struct{
  signed  left_depth:8,                 /*Rest of moves before FV*/
	  left_slow :6;                 /*Rest of slow moves*/
  unsigned  limits  :2; /*Unsigned!*/   /*Eval in limits ?*/
  }eval_conditions;                 /*Conditions at moment of evaluation*/
  signed char best_from;            /*                                    */
  signed char best_to;              /*Best move from the position in hash */
  signed char best_flags;           /*                                    */
}      POS_INFO;                /*Information part of position in hash */

typedef struct{
   BYTE ply;                   /* 0 - free, else (number of party ply) % 256 */
   unsigned long hash;
}      POS_KEY;                 /*Key part of position in hash */

typedef struct{
  POS_KEY   key;                    /*Key part of position in hash */
  POS_INFO  info;                   /*Information part of position in hash */
}      POS_IN_HASH;             /*Position in hash */

#define POS_ROUND_SIZE ((sizeof(POS_IN_HASH)+0xf) & 0xFFF0)

typedef POS_IN_HASH  far *  POSHASHP ;  /*Far pointer to structure in hash */
typedef long HASH_INDEX;     /* Must be long !!!!!!!!!!!!!!!!*/

#define POS_HASH_SIZE 7561/*8192*/  /* Disighed size of conventional hash */
HASH_INDEX pos_hash_size =10000000L; /* 0 <= hash-function  < pos_hash_size */

#define HASHTOINDEX( hash )  ( ( hash ) % pos_hash_size )  /* index=HASH & 0x00001FFF; */

int hash_success;               /*Weren't  moves generated
				  because of occurience position in hash */
int hash_enable;                /*Enable(disable) alloc memory for pos hash,
				  is seting  from the window "Options" */
int pos_hash_enable=1;
int gen_hash_enable=1;
int pos_hash_clear_flag;  	/* Clear hash table flag*/
int hash_ems;                   /* Hash use Expanded memory */

/*static int pos_hash_alloc_flag; /*Memory for pos hash allocated ?*/ */
static POSHASHP pos_hash_table;     /*Pointer to the begin of position buffer */
static BYTE begin_ply;              /* Party ply at last pos_hash_init() */

				/*Pos hash statistic variables */
static HASH_INDEX hashreplacenum;          /*Hash replacements of old position */
static HASH_INDEX hashoverflownum;         /*Hash overflowing */
static HASH_INDEX hashnotinlimit;          /*Positions ih hash without eval in limits*/
static HASH_INDEX hashlowlevel;            /*Position with level lower then current */
static HASH_INDEX hashsuccessnum;          /*Positions ih hash with eval in limits*/
static HASH_INDEX hashsuccesslevel[MAXDEPTH];/*Distribution of hash successes by levels */
static HASH_INDEX hashbestnum;             /*Number of hash best move generated */
static HASH_INDEX poshashnum;              /*Number of position in hash */
static HASH_INDEX hashnarrowednum;         /*Number of limits narrowed from hash */
static HASH_INDEX chain,chain1;            /*Lenght of chains of positions in hash */

static HASH_INDEX print_hash_index;

static POSHASHP near pos_buffer_addr( HASH_INDEX );
				/*Index of position in hash -->pointer to it*/
static long near prime( long number );/* return max prime < number */
static void calc_rand_num( void );/* calculate_array of random numbers */

static POSHASHP currp;/* pointer to current position in hash */

HASH_NUMBER pos_calc_hash(PIECE_COLOR move_color)
{
HASH_NUMBER hash=0;
WOOD_PIECE  NFP *woodp;
SQUARE_NUM sq;
PIECE_COLOR color;

  for(sq=0;sq<NSQUARE;sq++){
    woodp=WHOONSQUARE(sq);
    if(woodp->name) hash^=rand_num->pieces[woodp->color][woodp->name][sq];
  }
  for(color=0;color<NCOLOR;color++){
    if(CASTLE[color]&CASTLELEFT) hash^=rand_num->castles[color][0];
    if(CASTLE[color]&CASTLERIGHT) hash^=rand_num->castles[color][1];
  }
  if(EN_PASS!=DUMMY) hash^=rand_num->enpass[EN_PASS];
  hash|=move_color*(0x80000000L);  /* 2.10.90. */
  return(hash);
}
      
static POSHASHP near pos_buffer_addr( HASH_INDEX index)
{
  return(( hash_ems )? EMS_access( (long)index * POS_ROUND_SIZE ):
  MK_FP(FP_SEG(pos_hash_table)+(unsigned/*!!!*/)index*(POS_ROUND_SIZE>>4),
	FP_OFF(pos_hash_table)));  /**/
}

int pos_alloc_hash()       /* farmalloc for pos hash */
{      
int i;
long free;

  if( hash_ems ){          /* Hash in Expanded memory */
    i=EMS_init( (long)pos_hash_size*POS_ROUND_SIZE );
    if( pos_hash_size > EMS_memory_size / POS_ROUND_SIZE )
      pos_hash_size=EMS_memory_size / POS_ROUND_SIZE;
	      /* hash size design be simple */
    pos_hash_size=prime( pos_hash_size );
    return( i==0 );
  }
  else{                       /* Hash in conventional memory */
    if( pos_hash_table) return 1; /* Hash was allocated */
    pawn_alloc_hash();        /* Preallocate memory for pawn hash */
    free=farcoreleft()-30000; /* Reserve for other needs */
    if( free < 0 ) return 0;
    if( pos_hash_size > free / POS_ROUND_SIZE )
      pos_hash_size= free / POS_ROUND_SIZE;
    if(pos_hash_size > 10 ){
	      /* hash size design be prime */
      pos_hash_size=prime( pos_hash_size );
      pos_hash_table=( POSHASHP )MYFARMALLOC( (long)pos_hash_size*POS_ROUND_SIZE );
      return( pos_hash_table !=0 );
    }
    else return 0;
  }
}
void pos_free_hash()       /* Free memory for pos hash */
{
  if( hash_ems ) EMS_reset();
  else{
    if( pos_hash_table ) MYFREE( ( CFP )pos_hash_table );
    pos_hash_table=0;
  }
}

void NEAR pos_init_hash()
{                               
int i;
  if( pos_hash_clear_flag ) {  	/* Clear hash table */
    pos_hash_clear_flag=0;
    begin_ply=nmove;
    if( hash_ems )
      EMS_clear( EMS_memory_size, begin_ply,
		 (int)((CFP)(&pos_hash_table->key.ply)-(CFP)pos_hash_table),
		 POS_ROUND_SIZE );
    else
      for(i=0;i<pos_hash_size;i++)
	pos_buffer_addr(i)->key.ply=begin_ply;
  }				/*init statistic variables*/
  hashreplacenum=0;                 /*Hash replacements of old position */
  hashoverflownum=0;                /*Hash overflowing */
  hashnotinlimit=0;                 /*Positions ih hash without eval in limits*/
  hashlowlevel=0;                   /*Position with level lower then current */
  hashsuccessnum=0;		    /*Positions ih hash with eval in limits*/
  for(i=0;i<MAXDEPTH;i++) hashsuccesslevel[ i ]=0;/*Distribution of hash successes by levels */
  hashbestnum=0;                    /*Number of hash best move generated */
  poshashnum=0;
  hashnarrowednum=0;                /*Number of limits narrowed from hash */
  chain=chain1=0;                   /*Lenght of chains of positions in hash */
}

void NEAR print_deb_pos_hash()  /* print pos hash statistics */
{
LSTRING prn;
LSTRING prn1="  ";
int j;
     lastlinereply( "Hash statistic:" );
     farsprintf(prn,"  size - %-6lu       used - %-6lu      overflows - %-6lu repalaced - %-6lu",
		 pos_hash_size, poshashnum, hashoverflownum,hashreplacenum);
     lastlinereply(prn);
     farsprintf(prn,"  out limits - %-6lu low level - %-6lu narrowed  - %-6lu success - %lu:",
		 hashnotinlimit,hashlowlevel,hashnarrowednum,hashsuccessnum);
     lastlinereply(prn);
     for (j=1;j<16;j++){
       farsprintf(prn,"%u-%lu ",j,hashsuccesslevel[j]);
       strcat(prn1,prn);
     }
     lastlinereply(prn1);
     farsprintf(prn,"  best moves from hash done - %-6lu",hashbestnum);
     lastlinereply(prn);
}

     /*return( (Are there this position in hash with real eval)? 1 : 0)  */
int NEAR pos_hash_success(void)
{
POS_INFO far *infop;
int left_depth;
int left_slow;
WORD piece_mask;
LSTRING str,str1;
char c=0;
HASH_INDEX index;
char *signs=" <>=";
POS_EVAL tmp_alfa,tmp_beta;

  index=HASHTOINDEX( HASH );
  currp=pos_buffer_addr( index ); 

  if ( currp->key.ply==begin_ply ) return(0);
  if ( currp->key.hash!=HASH ) return(0);
/*  currp->key.ply=(nmove+1);*/
  left_depth=mindepth-level; if(left_depth<0) left_depth=0;
  left_slow=minnslow-NSLOW;  if(left_slow<0)  left_slow=0;

       /* Position found. */

  infop=&(currp->info);

  hashlowlevel++;
  if (infop->eval_conditions.limits==ZERO ||
      infop->eval_conditions.left_depth>=left_depth &&  /* Position was written into */
      infop->eval_conditions.left_slow>=left_slow) {    /*  hash at higher level */
    hashlowlevel--;
    tmp_alfa=EVAL(level).position, tmp_beta=BETA(level).position;

    switch(infop->eval_conditions.limits){  /*It's eval calculated in limits ?*/
      case LOW_LIMIT :
	  if(infop->eval.material<EVAL(level).material ||
	     infop->eval.material==EVAL(level).material &&
	     infop->eval.position<=EVAL(level).position ) c='Y';
	  else if(infop->eval.material<BETA(level).material ||
		  infop->eval.material==BETA(level).material &&
		  infop->eval.position<BETA(level).position ) {
	    BETA(level).position=infop->eval.position;
	    BETA(level).material=infop->eval.material;
	    c='H';
	  }
	  break;
      case HIGH_LIMIT :
	  if(infop->eval.material>BETA(level).material ||
	     infop->eval.material==BETA(level).material &&
	     infop->eval.position>=BETA(level).position ) c='Y';
	  else if(infop->eval.material>EVAL(level).material ||
		  infop->eval.material==EVAL(level).material &&
		  infop->eval.position>EVAL(level).position ) {
	    EVAL(level).position=infop->eval.position;
	    EVAL(level).material=infop->eval.material;
	    c='L';
	  }
	  break;
      case MIDDLE : c='Y'; break;
      case ZERO :   c='R'; break;
    }
    if ( c ) {
      if( print_hash && print_hash_index==index ){ /* printing index */
	trace_pos(str,0);
	farsprintf(str1,"(%d, %d)  pos in hash: e%c( %d, %d) l=( %d,  %d):%c",
		tmp_alfa,tmp_beta,
		signs[infop->eval_conditions.limits],
		infop->eval.material,infop->eval.position,
		infop->eval_conditions.left_depth,
		infop->eval_conditions.left_slow,
		c);
	lastlinereply(strcat(str,str1));
      }
      if ( c=='Y' || c=='R' ) {    	      /* Eval in hash is real */
	put_eval(level, infop->eval.material, infop->eval.position);
	hashsuccessnum++;
	hashsuccesslevel[level]++;
	return(1);
      }
      else /* not 'Y' */ hashnarrowednum++;
    }
    else /* not c*/ hashnotinlimit++;
  } /*if at higher level*/

       /* Generate moves from hash */

  if(gen_hash_enable && infop->best_from!=DUMMY){

    /* If status - forced and move is not check(if simple check available) */
    /* check, if it is sufficient capture. */

    if( (G_STATUS & FORCED) &&
       ((G_STATUS & WITHOUT_CHECK) || !(infop->best_flags & ISCHECK)) ){
      int capturecost;
	  capturecost=WHOONSQUARE(infop->best_to)->cost;
	  if(capturecost<MAT_DEFICIT) return 0;  /* Not in material borders */
	  if(!CHECK) if(capturecost<=0) return 0;  /* Not capture or check defense */
    }

    LAST->from=(SQUARE_NUM)infop->best_from;
    LAST->to=(SQUARE_NUM)infop->best_to;
    LAST->flags=(SQUARE_NUM)infop->best_flags;
    LAST->profit=HASH_PROFIT;      /* simulating killer profit for 3-d pass */

    piece_mask=SQUAREP(LAST->from)->who_mask.word[MOVE_COLOR];
    STORE_MOVES(SQUAREP(LAST->to),piece_mask);
    LAST++;
    hashbestnum++;
  }   
  return(0);
}

void NEAR pos_hash_eval(void)   /* Put eval of position into Hash. */
{                               /* Put best move into Hash. */
POS_INFO far *infop;
int left_depth;
int left_slow;
BYTE curr_ply;

  currp=pos_buffer_addr( HASHTOINDEX( HASH ) ); 
  infop=&(currp->info);
  left_depth=mindepth-level; if(left_depth<0) left_depth=0;
  left_slow=minnslow-NSLOW;  if(left_slow<0)  left_slow=0;
  curr_ply=nmove+1;

  if ( currp->key.ply!=begin_ply ) {
    if ( currp->key.hash!=HASH ) { /* Place is occupied by another position */
      if ( currp->key.ply==curr_ply ) { /* Current party ply */
	hashoverflownum++;
	return;
      }
      else {                         /* Previous party ply */
	hashreplacenum++;
      }
    }
    if(infop->eval_conditions.left_depth > left_depth ||  /* Level was higher */
      infop->eval_conditions.left_slow > left_slow )
      if(infop->eval_conditions.limits!=ZERO) return;
  }
  else  poshashnum++;

  currp->key.hash=HASH;
  currp->key.ply=curr_ply;
  infop->best_from=DUMMY;         /* Clear best move into Hash. */

  if(EVAL(level).material>-EVAL(level-1).material ||
     EVAL(level).material==-EVAL(level-1).material &&
     EVAL(level).position>=-EVAL(level-1).position )    /* Eval > Beta */
				 infop->eval_conditions.limits=HIGH_LIMIT;
  else if(EVAL(level).material<-BETA(level-1).material ||
     EVAL(level).material==-BETA(level-1).material &&
     EVAL(level).position<=-BETA(level-1).position)        /* Eval < Alfa */
				 infop->eval_conditions.limits=LOW_LIMIT;
  else infop->eval_conditions.limits=MIDDLE;
#if (REALEVALHASH==1)
  infop->eval.material=REALEVAL(level).material;  /* !!! 20.11.90. */ 
  infop->eval.position=REALEVAL(level).position;  /* !!! 20.11.90. */
#else
  infop->eval.material=EVAL(level).material;  /* !!! 20.11.90. */ 
  infop->eval.position=EVAL(level).position;  /* !!! 20.11.90. */
#endif
  infop->eval_conditions.left_slow=left_slow;
  infop->eval_conditions.left_depth=left_depth;
/*  infop->status=G_STATUS;*/
  if(BEST.from!=DUMMY){
    infop->best_from=BEST.from;
    infop->best_to=BEST.to;
    infop->best_flags=BEST.flags;
  }
}

static void calc_rand_num( void )
{
int i;

  randomize();
  for( i=0; i<sizeof(*rand_num); i++ )
     *((CFP)rand_num+i)=random(0xff);
}

int readrandom(void)
{
  if( (rand_num=(RAND_NUM far *)MYFARMALLOC( sizeof(*rand_num) ))==0 ) {
    message("No memory for hash random numbers",0);
    return -1;
  }
  return( read_write_array("kaissa.rnd", calc_rand_num,
			   (CFP)rand_num, (unsigned)sizeof(*rand_num)));
}

int NEAR read_write_array(char *file_name, void (*fill_array)( void ),
			  CFP array, long array_size)
{
int fp;

  fp=MYOPEN(file_name,O_RDONLY+O_BINARY,0);
  if(fp==-1){
    (*fill_array)();
    fp=MYOPEN(file_name,O_CREAT+O_WRONLY+O_BINARY,S_IWRITE);
    if ( fp==-1 ){
      message(strcat("Can't create file",file_name),0);
      return -1;
    }
    for( ;array_size>MAXINT; array_size-=MAXINT, array+=MAXINT )
      MYWRITE(fp,array,MAXINT);
    MYWRITE(fp,array,(int)array_size);
  }
  else{
    for( ;array_size>MAXINT; array_size-=MAXINT, array+=MAXINT )
      MYREAD(fp,array,MAXINT);
    MYREAD(fp,array,(int)array_size);
  }
  MYCLOSE(fp);
  return 0;
}

static long near prime( long number ) /* return max prime < number */
{
long i;
unsigned j;

  if( !(number&1) ) number--;      /* prime must be odd */
  for(i=number; i>3 ; i-=2) {      /* decrement proposed prime */
    for (j=3;(long)j*j<=i; j+=2)   /* increment denom */
      if ( ! (i%j) ) break;
    if( (long)j*j>i ) break;
  }
  return i;
}
                   /* Put position into hash with zero eval */
int NEAR zeroevaltohash(HASH_NUMBER hash, int addressanavail)
{
POS_INFO far *infop;
  if( addressanavail ) { /* Address not calculated yet */
    currp=pos_buffer_addr( HASHTOINDEX( hash ) ); 
  }
  infop=&(currp->info);
  currp->key.hash=hash;
  currp->key.ply=nmove+1;
  infop->eval.material=0;
  infop->eval.position=0;
  infop->eval_conditions.limits=ZERO;
  return(0);
}

void NEAR set_print_hash_index( void )
{
int l;
extern int variant_depth;
extern MOVE variant_moves[];

  if( hash_enable ) {
    ks_farmemcpy( &pos_stk->n, &position, sizeof(NEAR_POSITION));
    CURR_N=-1; /* To avoid copy position in move() */
    for (l=0; l<variant_depth; l++){
      CURRENT=&variant_moves[l];
      if( move() )break; /* Until illegal move */
      level++;
      pos_sp++;
    }
    print_hash_index=HASH % pos_hash_size;
    ks_farmemcpy( &position, &pos_stk->n, sizeof(NEAR_POSITION));
    level=0, pos_sp=pos_stk;
  }
}
