
                /**\
                       Program file "menu_def.c"       
                                                       
                           Menu definitions            
                                                       
                \**/

#include <string.h>     /* strlen() */
#include <ctype.h>      /* isalnum() */
#include <stdlib.h>     /* itoa(),ltoa() */

#include "face.h"
#include "faceproc.h"
#include "facekeys.h"

#include "lang.h"
#include "chess.h"
#include "current.h"
#include "global.h"
#include "ks_game.h"
#include "helpind.h"
#include "menu.h"
#include "menu_func.h"
#include "infc_func.h"

#include "ks_eval.h"
#include "ksichess.h"
#include "ksiprot.h"
#include "experim.h"

#include "ksitimer.h"
#include "newutil.h"
#include "ksiwind.h"
#include "message.h"
#include "hashpos.h"
#include "hashpawn.h"

/* Internal FACE functions */
int redrawedit( WINP wp );

extern int usefontnote;
int redrawprot( void );

static char far head1[]=" Maximum printable depth ";
static char far head2[]=" Killer move number ";
static char far head3[]=" Print depper than level number ";
static char far head4[]=" Enter white time in min ";
static char far head5[]=" Enter black time in min ";
static char far head6[]=" Enter control time in min ";
static char far head7[]=" Enter control move number ";
static char far head8[]=" Output file name ";
static char far head9[]=" Square en passant ";
static char far head10[]=" Enter text to find ";
static char far head11[]=" Enter level for start search ";
static char far head12[]=" Enter level for end search ";

			/* Main menu */
NODE mainmenu;
static NODE filemenu, posmenu, optnmenu, playmenu, debugmenu, evalmenu,
whoplaymenu, searchmenu, moredebugmenu, moreoptmenu, timecontrolmenu,
environmenu, monmenu, moncolmenu,printgamemenu,localmenu,moveordermenu;
		/* for main menu */

static ITEM mainitems[]={
{ml_file, SUBMENU, &filemenu,NULL,NULL,IND_FILE,helpfilea },
{ml_set, SUBMENU, &posmenu,NULL,NULL,IND_SET,helpseta },
{ml_play, SUBMENU, &playmenu,NULL,NULL,IND_PLAY,helpplay},
{ml_eval, SUBMENU, &evalmenu,NULL,NULL,IND_EVAL,helpeval},
{ml_info, SUBMENU, &debugmenu,NULL,NULL,IND_INFO,helpinfo},
{ml_options, SUBMENU, &optnmenu,NULL,NULL,IND_OPTIONS,helpoptions},
{ NULL }};
                /* for file menu */
static ITEM fileitems[]={
{ml_loadgame, FUNCTION|CLOSE_MENU,
	/*getprotocolname,0,*/readprotocol,
	NULL,NULL,IND_LOADGAME,helploadgame},
{ml_savegame, FUNCTION|CLOSE_MENU,
	saveprotocol,NULL,NULL,IND_SAVEGAME,helpsavegame},
{ml_printgame, SUBMENU,
	&printgamemenu,NULL,NULL,IND_PRINTGAME,helpprintgame},
{ml_changedir, FUNCTION, changedir,
	NULL,NULL,IND_CHANGEDIR,helpchangedir},
{ml_osshell, FUNCTION, osshell,NULL,NULL,IND_OSSHELL,helposshell},
{ml_exit, FUNCTION, wndexit,NULL,NULL,IND_QUIT,helpexit},
{ NULL }};

static ITEM printgameitems[]={
{ml_gametofile, FUNCTION|CLOSE_MENU,
	  prottofile,NULL,NULL,IND_GAMETOFILE,helpgametofile},
{ml_gametoprinter, FUNCTION|CLOSE_MENU,
	  prottoprinter,NULL,NULL,IND_GAMETOPRINTER,helpgametoprinter},
{ NULL }};

                /* for set menu */
static ITEM setitems[]={
{ml_newgame, FUNCTION|CLOSE_MENU, newgame,NULL,NULL,IND_NEWGAME,helpnewgame },
{ml_placepieces, FUNCTION|CLOSE_MENU, goto_boardset,NULL,NULL,IND_PLCPIECE,helpplacepieces },
{ml_loadpos, FUNCTION, loadposition,NULL,NULL,IND_LOADPOS,helploadpos },
{ml_savepos, FUNCTION, saveposition,NULL,NULL,IND_SAVEPOS,helpsavepos },
{ml_beggame, FUNCTION, protkeybegin,NULL,NULL,IND_BEGGAME,helpbeggame},
{ml_endgame, FUNCTION, protkeyend,NULL,NULL,IND_ENDGAME,helpendgame},
{ NULL }};
		/* for play menu */
static ITEM playitems[  ]={
{ml_kaissaplay, LIST, &whoplaymenu, &whomove,NULL,IND_PLAY,helpkaissaplay },
{ml_analyse, FUNCTION|CLOSE_MENU, onemovesearch,NULL,NULL,IND_ANALMOVE,helpanalize  },
{ml_monitor, SUBMENU, &monmenu,NULL,NULL,IND_MONITOR,helpmonitor },
{ml_runtests, FUNCTION|CLOSE_MENU, runtests,NULL,NULL,IND_RUNTEST,helpruntests },
{ NULL }};
                /* for whoplay submenu */
static ITEM whoplayitems[  ]={
{ml_kaissaverify,OPTION,0,0,showtimer,IND_VERMOVE,helpkaissaplay },
{ml_kaissawhite,OPTION,0,0,showtimer,IND_KSPLAY,helpkaissaplay },
{ml_kaissablack,OPTION,0,0,showtimer,IND_KSPLAY,helpkaissaplay },
{ml_kaissaself,OPTION,0,0,showtimer,IND_KSPLAY,helpkaissaplay },
{ NULL }};
                /* for eval menu */
static ITEM evalitems[]={
{ml_evaluate, FUNCTION|CLOSE_MENU, evaluate,NULL,NULL,IND_EVALUATE,helpevaluate },
{ml_compare, FUNCTION|CLOSE_MENU, compareval,NULL,NULL,IND_COMPARE,helpcompare  },
{ml_saveeval, FUNCTION, save_eval,NULL,NULL,IND_SAVEEVAL,helpsaveeval },
{ NULL }};
		/* for debug menu */
static ITEM debugitems[]={
{ml_depth, INT_NO, &print_level, head1,	NULL,IND_DEPTH,helpdepth },
{ml_printline, YES_NO, &print_flag,(void far*)PRINT_VARIANT,
	setvariation,IND_LINEPRINT,helpprintline },
{ml_range, YES_NO, &print_flag,(void far*)PRINT_NUMBER,setmoverange,IND_RANGEPRINT,helprange },
{ml_fvtoo, YES_NO, &print_fv,(void far*)0x0001 ,NULL,IND_FVPRINT,helpfvtoo },
{ml_timeused, YES_NO, &print_time,(void far*)0x0001 ,NULL,IND_TIMEPRINT,helptimeused },
{ml_killer, INT_NO, &killer_print_num, head2,NULL,IND_KILLPRINT,helpkiller },
{ml_evalborder, YES_NO, &print_full_eval,(void far*)0x0001 ,NULL,IND_EVALPRINT,helpevalborder },
{ml_infomore,       SUBMENU, &moredebugmenu ,NULL,NULL,IND_MOREPRINT,helpmore },
{ NULL }};
		/* for more debug menu */
static ITEM moredebugitems[]={
{ml_deeper, INT_NO, &print_overflow, head3,NULL,IND_DEEPRINT,helpdeeper  },
{ml_hashstat, YES_NO, &print_hash,(void far*)PRINT_HASH,NULL,IND_HASHPRINT,helphashstat  },
{ml_accumulate, YES_NO, &accumflag,(void far*)0x0001,NULL,IND_ACCUMULATE,helpaccumulate },
{ NULL }};
		/* for option menu */
static ITEM optionitems[]={
{ml_level, LIST, &searchmenu,&search_status,NULL,IND_LEVEL,helplevel  },
{ml_sound, ON_OFF, &issound, (void far*)0x0001,NULL,IND_SOUND,helpsound },
{ml_openingbook, YES_NO, &usedebut, (void far*)0x0001, debutbase,IND_OPENBOOK,helpopening },
{ml_time, SUBMENU, &timecontrolmenu,NULL,NULL,IND_TIME,helptime },
{ml_reverseboard, ON_OFF, &revindex,(void far*)0x0001,mydrawboard,IND_REVBOARD,helpreverse  },
{ml_fontnote, YES_NO, &usefontnote,(void far*)0x0001,redrawprot,IND_CHESSPIECE,helpfontnote  },
{ml_environment, SUBMENU, &environmenu,NULL,NULL,IND_ENVIRON,helpenviron },
{ml_optmore, SUBMENU, &moreoptmenu,NULL,NULL,IND_MOREOPTS,helpmore  },
{ NULL }};
                /* for timecontrol menu */
static ITEM timecontrolitems[]={
{ml_whitetime, TIME, &curtime[0],head4,showtimer,IND_TIME,helpwhitetime },
{ml_blacktime, TIME, &curtime[1],head5,showtimer,IND_TIME,helpblacktime },
{ml_timecontrol, ON_OFF, &timecontrol, (void far*)0x0001,NULL,IND_TIME,helptimecontrol },
{ml_controltime, TIME, &controltime,head6,setcontroltime,IND_TIME,helpcontroltime },
{ml_controlmove, INT, &controlmove,head7,setcontrolmove,IND_TIME,helpcontrolmove },
{ NULL }};
                /* for search depth submenu */
static ITEM searchitems[]={
{ml_levelfv0,OPTION,NULL,NULL,NULL,IND_LEVEL,helplevel },
{ml_level3 ,OPTION,NULL,NULL,NULL,IND_LEVEL,helplevel },
{ml_level31,OPTION,NULL,NULL,NULL,IND_LEVEL,helplevel },
{ml_level51,OPTION,NULL,NULL,NULL,IND_LEVEL,helplevel },
{ml_level52,OPTION,NULL,NULL,NULL,IND_LEVEL,helplevel },
{ml_level72,OPTION,NULL,NULL,NULL,IND_LEVEL,helplevel },
{ml_level73,OPTION,NULL,NULL,NULL,IND_LEVEL,helplevel },
{ml_level93,OPTION,NULL,NULL,NULL,IND_LEVEL,helplevel },
{ml_level94,OPTION,NULL,NULL,NULL,IND_LEVEL,helplevel },
{ NULL }};
		/* for more option menu */
static ITEM moreoptionitems[]={
{ml_opptime, YES_NO, &enemytime,(void far*)0x0001,NULL,IND_OPPTIME,helpopptime  },
{ml_font, YES_NO, &usefont,(void far*)0x0001,mydrawboard,IND_CHESSFONT,helpfont  },
{ml_hashpos, YES_NO, &pos_hash_enable, (void far*)0x0001, setposhash,IND_HASHEVAL,helphashpos  },
{ml_hashgen, YES_NO, &gen_hash_enable, (void far*)0x0001, setposhash,IND_HASHGEN,helphashgen  },
{ml_hashpawn, YES_NO,&pawn_hash_enable,(void far*)0x0001, setpawnhash,IND_PAWNHASH,helphashpawn  },
{ NULL }};
		/* for environment submenu */
static ITEM environitems[]={
{ml_autosave, ON_OFF, &autosaveoptions, (void far*)0x0001,NULL,IND_AUTOSAVE,helpenvironauto},
{ml_saveoptions, FUNCTION, writeoptions,NULL,NULL,IND_SAVEOPTS,helpenvironsave},
{ml_loadoptions, FUNCTION, readoptions,NULL,NULL,IND_LOADOPTS,helpenvironload},
{ NULL }};
		/* for monitior submenu */
static ITEM monitems[]={
{ml_monfile, SPECSTR, &monfile, head8,setmonitorfile,IND_MONFILENAME,helpmonfile},
{ml_replyfor, LIST, &moncolmenu,&ourmonitorcolor,NULL,IND_MONCOLOR,helpmoncolor},
{ml_go, FUNCTION|CLOSE_MENU, monitor,NULL,NULL,IND_MONGO,helpmongo},
{ NULL }};
		/* for moncolor submenu */
static ITEM moncolitems[]={
{ml_white,OPTION,0,0,0,IND_MONCOLOR,helpmoncolor },
{ml_black,OPTION,0,0,0,IND_MONCOLOR,helpmoncolor  },
{ml_both,OPTION,0,0,0,IND_MONCOLOR,helpmoncolor  },
{ NULL }};

NODE    /*  window  top left roll+op/cl     curi  frstitemp  */
mainmenu={NULL,  0,   5, HROLL,           0, mainitems  ,IND_MAINMENU},
filemenu= {NULL, 0,   0, VROLL|OPENCLOSE, 0, fileitems, IND_FILE},
posmenu ={NULL,  0,   0, VROLL|OPENCLOSE, 0, setitems, IND_SET},
playmenu={NULL,  0,   0, VROLL|OPENCLOSE, 0, playitems, IND_PLAY},
evalmenu= {NULL, 0,   0, VROLL|OPENCLOSE, 0, evalitems, IND_EVAL},
debugmenu={NULL, 0,   0, VROLL|OPENCLOSE, 0, debugitems, IND_INFO},
optnmenu={NULL,  0,   0, VROLL|OPENCLOSE, 0, optionitems, IND_OPTIONS},
whoplaymenu={NULL,  0,  10, VROLL|OPENCLOSE, 0, whoplayitems, IND_PLAY},
searchmenu={NULL,  0,  16, VROLL|OPENCLOSE, 0, searchitems, IND_LEVEL},
moredebugmenu={NULL,  0,   0, VROLL|OPENCLOSE, 0, moredebugitems,IND_INFO },
moreoptmenu  ={NULL,  0,   0, VROLL|OPENCLOSE, 0, moreoptionitems,  IND_OPTIONS },
environmenu  ={NULL,  0,   0, VROLL|OPENCLOSE, 0, environitems,  IND_hot_keys },
timecontrolmenu={NULL, 0,   0, VROLL|OPENCLOSE, 0, timecontrolitems, IND_TIME },
monmenu={NULL, 0,   0, VROLL|OPENCLOSE, 0, monitems, IND_MONITOR },
moncolmenu={NULL, 0,  28, VROLL|OPENCLOSE, 0, moncolitems, IND_MONITOR },
printgamemenu={NULL, 0,  0, VROLL|OPENCLOSE, 0, printgameitems, IND_PRINTGAME }
;

extern int flPassExt;
	  /* Local menu */
static ITEM localitems[]={
{ml_narrow, YES_NO, &narrow_en,(void far*)0x0001,NULL,IND_hot_keys,helpnarrow },
{ml_moveorder, SUBMENU, &moveordermenu,NULL,NULL,IND_TIME,helptime },
/*
{ml_nullmove, YES_NO, &nullfv_en,(void far*)0x0001,NULL,IND_hot_keys,helpnullsearch },
{ml_nulllimit, YES_NO, &nullcutoff_en,(void far*)0x0001,NULL,IND_hot_keys,helpnulllimit },
{ml_nullstat, YES_NO, &nullstatistic,(void far*)0x0001,NULL,IND_hot_keys,helpnullstat },
*/
{ml_passage, YES_NO, &flPassExt,(void far*)0x0001,NULL,IND_hot_keys,helpselect },
{ml_select, YES_NO, &select_en,(void far*)0x0001,NULL,IND_hot_keys,helpselect },
{ml_fullselect, YES_NO, &fullselect_en,(void far*)0x0001,NULL,IND_hot_keys,helpselect },
{ml_selectstat, YES_NO, &selectstatistic,(void far*)0x0001,NULL,IND_hot_keys,helpselect },
{ml_selectprint, YES_NO, &print_flag,(void far*)PRINT_SELECTIVE ,NULL,IND_TIMEPRINT,helptimeused },
{NULL}};

static ITEM moveorderitems[]={
{ml_escatt, YES_NO, &escattorder_en,(void far*)0x0001,NULL,IND_hot_keys,helpnullsearch },
{ml_dinord, YES_NO, &dinamicorder_en,(void far*)0x0001,NULL,IND_hot_keys,helpnulllimit },
{NULL}};

NODE localmenu={NULL,  13,  2, VROLL|OPENCLOSE, 0, localitems,IND_hot_keys};
NODE moveordermenu={NULL,  0,   0, VROLL|OPENCLOSE, 0, moveorderitems,IND_hot_keys};



	/* Break menu */
static ITEM breakitems[]={
{ml_makecurrentbest, FUNCTION, makecurrent,NULL,NULL,IND_MAKECUR,helpmakecurrentbest },
{ml_setverify,        FUNCTION, terminate,NULL,NULL,IND_SETVER,helpsetverify },
{ml_gotoinfomenu,      SUBMENU, &debugmenu,NULL,NULL,IND_GOTOINFO,helpgotoanalize },
{ml_tracecurrent,    FUNCTION, trace_current_branch,NULL,NULL,IND_TRACECUR,helptracecurrent  },
{ml_continue,                FUNCTION, end_work,NULL,NULL,IND_CONTF4,helpcontinuesearch  },
{ NULL }};
NODE breakmenu={NULL,  4,  48, VROLL|OPENCLOSE, 0, breakitems,IND_INTERRUPT};

	/* End set menu */
NODE castlesmenu,movecolormenu;
static ITEM endsetitems[]={
{ml_continue, FUNCTION|CLOSE_MENU, nothing,NULL,NULL,IND_SETPOSCON,helpcontinuesetpiece  },
{ml_setposition,FUNCTION|CLOSE_MENU,checkcolor,NULL,NULL,IND_SETPOSSET,helpfinish},
{ml_break,FUNCTION|CLOSE_MENU,terminate_set,NULL,NULL,IND_SETPOSBR,helpterminate},
{ml_clearboard, FUNCTION, clearpos,NULL,NULL,IND_CLRBOARD,helpclearboard },
{ml_turntomove,LIST,&movecolormenu,&boardsetcolor,NULL,IND_SETPOSCL,helpturntomove},
{ml_castles, SUBMENU, &castlesmenu,NULL,NULL,IND_SETPOSCAS,helpcastles},
{ml_enpassant, STR, &en_passant_str,head9,checkenpassant,IND_SETPOSEN,helpenpassant},
{ NULL }};
NODE endsetmenu={NULL,  11,  46, VROLL|OPENCLOSE, 0, endsetitems,IND_PLCPIECE};

static ITEM movecoloritems[]={
{ml_white, OPTION ,NULL, NULL,setwhitecolor,IND_SETPOSCL,helpsetwhite},
{ml_black, OPTION ,NULL, NULL,setblackcolor,IND_SETPOSCL,helpsetblack},
{ NULL }};

NODE movecolormenu={NULL,  0,  17, VROLL|OPENCLOSE, 0, movecoloritems,0};
	  /* Castle submenu */
static ITEM castlesitems[]={
{ml_castle1, YES_NO, &pos_stack->n.castle[0],(void far*)CASTLERIGHT,checkcastles,IND_SETPOSCAS,helpcastle1},
{ml_castle2, YES_NO, &pos_stack->n.castle[0],(void far*)CASTLELEFT,checkcastles,IND_SETPOSCAS,helpcastle2},
{ml_castle3, YES_NO, &pos_stack->n.castle[1],(void far*)CASTLERIGHT,checkcastles,IND_SETPOSCAS,helpcastle3},
{ml_castle4, YES_NO, &pos_stack->n.castle[1],(void far*)CASTLELEFT,checkcastles,IND_SETPOSCAS,helpcastle4},
{NULL}};

NODE castlesmenu={NULL,  0,  8, VROLL|OPENCLOSE, 0, castlesitems,0};

	/* Find menu */
extern int findlower,finddeeper,findglob;
extern SSTRING far pattern;

static ITEM finditems[]={
{ml_findpattern,STR,&pattern,head10 ,0,IND_SSEARCH,helpfindpattern},
{ml_findoptglob,YES_NO,&findglob,(void far *)0x0001,0,IND_SSEARCH,helpfindoptglob},
{ml_findoptlevelfrom,INT_NO,&findlower, head11,0,IND_SSEARCH,helpfindoptlevelfrom},
{ml_findoptlevelto,INT_NO,&finddeeper, head12,0,IND_SSEARCH,helpfindoptlevelto},
{ml_findgo, FUNCTION, gofind,0,0,IND_SSEARCH,helpfindgo},
{ NULL }};

NODE findmenu={NULL,  9,  25, VROLL|OPENCLOSE, 0, finditems,0 };

		/* Functions to begin menu */
int beginmainmenu( void )  { return(beginmenu(&mainmenu)); }
int beginlocalmenu( void ) { return(beginmenu(&localmenu)); }
int beginbreakmenu( void ) { return(beginmenu(&breakmenu)); }
int beginendsetmenu( void ) { return(beginmenu(&endsetmenu)); }
int beginfindmenu( void ) { return(beginmenu(&findmenu)); }
