#ifndef  _MENU_H
#define  _MENU_H

#ifndef  _HELPIND_H
#include "helpind.h"
#endif

#ifndef  _FACE_H
#include "face.h"
#endif

#define CLOSE_MENU 0x8000

#define SPEC_FLAGS (CLOSE_MENU)

#define OPENCLOSE  0x04
typedef enum {
  OPTION=0,
  SUBMENU,FUNCTION,
  ON_OFF,YES_NO,
  INT,INT_NO,
  LONG,LONG_NO,
  TIME,
  STR,
  LIST,
  SPECSTR,
} ITEM_TYPE;

typedef	struct {
  char far *itemname;
  ITEM_TYPE itemtype;
  void far *object;
  void far *info;
  int (*spec_func)(void);
  HELPIND helpind;
  char far * helpline;
} far ITEM;
typedef ITEM * ITEMPTR;

typedef struct {
  WINP wp; /* pointer to menu window */
  char top, left; /* parameters of window */
  char flag;      /* VROLL|HROLL|OPENCLOSE */
  char curitem;
  ITEMPTR firstitem;
  HELPIND helpind;
} far NODE;
typedef NODE * NODEPTR;

#define MENUSTACKSIZE     7
extern NODEPTR far menustack[ MENUSTACKSIZE ];
extern NODEPTR far *menusp;
extern int menulevel;

#define MENUWP     (menup->wp)
#define MENUFLAG   (menup->flag)
#define MENUROLL   (menup->flag&(VROLL|HROLL))
#define MENUTOP    (menup->top)
#define MENULEFT   (menup->left)
#define MENUCURITEM (menup->curitem)
#define MENUFIRSTITEM (menup->firstitem)

#define CURMENUWP  ((*menusp)->wp)
#define CURMENUFLAG ((*menusp)->flag)
#define CURMENUROLL ((*menusp)->flag&(VROLL|HROLL))
#define CURMENUTOP  ((*menusp)->top)
#define CURMENULEFT ((*menusp)->left)
#define CURMENUCURITEM ((*menusp)->curitem)
#define CURMENUFIRSTITEM ((*menusp)->firstitem)

#define ITEMP      (MENUFIRSTITEM+item)/* pointer for curr item */
#define CURITEMP   (CURMENUFIRSTITEM+item)/* pointer for curr item */

#define ITEMNAME   (itemp->itemname)
#define ITEMTYPE   (itemp->itemtype)
#define OBJECT     (itemp->object)
#define INFO       (itemp->info)
#define SPEC_FUNC  (itemp->spec_func)

int makemenu( void );

int beginmenu( NODEPTR menup );
int endmenu( void );
int showmenu( void );

int menuup( void );
int menudown( void );

int mainmenukey( int key );
int menuposition(NODEPTR menup, int *top, int *left);
int keytoitem( NODEPTR menup,int key );
int gotoitem( NODEPTR  menup, int item );
int fillmenuitem( char far *name, ITEMPTR itemp );

int getcurm(WINP wp);

#define MAXROW 25			/* max row on the screen */
#define MAXCOL 80			/* max column on the screen */

#endif