
		/**\
		 	Program file "menu.c"		
		 					
		      Menu processing functions	
		 					
		 	      Public			
		 	       functions: beginmenu()	
		 		          endmenu()	
		 			  showmenu()	
		\**/

#include <string.h>     /* strlen() */
#include <ctype.h>      /* isalnum() */
#include <stdlib.h>	/* itoa(),ltoa() */
#include <stdio.h>	/* farsprintf() */
#include <conio.h>	/* enum COLORS */

#include "face.h"
#include "faceproc.h"
#include "facekeys.h"
#include "facelib.h"

#include "lang.h"

#include "helpind.h"
#include "menu.h"
#include "interface.h"
#include "ksibdraw.h"

#include "ksiwind.h"
#include "chess.h"
#include "ksitimer.h"

int  menubordline=ONELINE,
     currmenuattr=WHITE ON CYAN,
     menuattr=BLACK ON LIGHTGRAY,
     menuborder=BLACK ON LIGHTGRAY;
WINP menuground;

static int alttochar( int key );
static int getmenuwindow( NODEPTR menup, int top, int left );
static int freemenuwindow( NODEPTR menup );

NODEPTR far menustack[ MENUSTACKSIZE ];
NODEPTR far *menusp=menustack;
int menulevel=0;

int getcurm(WINP wp)
{
  int curx,cury,roll;
    curx=getcurx( wp );
    cury=getcury( wp );
    getrolling( wp, &roll );
    switch( roll ){
      case HROLL: return(curx);
      case VROLL: return(cury);
      case ROLL :;   /* don't need now */
    }
    return(-1);
}

static int alttochar( int key )
{                      /*01234567890123456 */
  static char altkeys[]="1234567890-=####qwertyuiop####asdfghjkl#####zxcvbnm";
    key=-key;
    if( key>=(-ALT_Q) && key<=(-ALT_M) ) key=altkeys[key];
    else if( key>=(-ALT_1) && key<=(-ALT_EQUAL) ) key=altkeys[key-(-ALT_1)];
    else key=0;              /* this isn't ALT-key */
    if( key=='#' ) key=0;    /* check */
    return(key);
}

int mainmenukey( int key )
{
  extern NODE mainmenu;
    if( (key=alttochar( key ))==0 ) return(ERROR);
    return( keytoitem( &mainmenu, key ) );
}
/*
int ismainmenu( WINP wp )
{
    return( menulevel==0 /*wp==mainmenu.wp*/ );
}
*/
int gotoitem( NODEPTR menup, int item )
{
    if( MENUROLL==HROLL ) gotowindow( MENUWP, 1, item+1 );
    if( MENUROLL==VROLL ) gotowindow( MENUWP, item+1, 1 );
    menup->curitem=item;
    refresh(MENUWP);
    return(0);
}

static int getmenuwindow( NODEPTR menup, int top, int left )
{
  char buff[80];
  int i, maxlen, nitem, totlen/*,x, y*/;
  ITEMPTR itemp;
    if( (MENUWP=getwindow())==NULL ){
      checkface(0);
      return(ERROR);
    }
    settype(MENUWP,MENU);
    setattr(MENUWP,menuattr);
    setcurattr(MENUWP,currmenuattr);
    setrolling(MENUWP,MENUROLL);
    nitem=maxlen=totlen=0;	             /* reset counters */
    for( i=0,itemp=MENUFIRSTITEM; ITEMNAME; i++, itemp++ ){
      fillmenuitem(buff,itemp);
      if( MENUROLL==HROLL ) checkface(putstring( MENUWP, buff ));
      else checkface(newline( MENUWP, buff ));
      i=strlen( buff );       /* get item name length */
      if( i>maxlen ) maxlen=i;       /* find max string length */
      totlen+=i;
      nitem++;                       /* increment counter */
    }
    if(!maxlen) totlen=maxlen=1;	/* Nothing in window */
    top+=MENUTOP;
    left+=MENULEFT;
    if( left<1 ) left=1;
    if( top<1 ) top=1;
    if( MENUROLL==HROLL ){
      setstrlth( MENUWP, totlen +11);
      setmenu(MENUWP, nitem, maxlen);
      if( left+totlen-1>MAXCOL ) left=MAXCOL-(totlen-1);
      if( top>MAXROW ) top=MAXROW;
      i=poswindow(MENUWP,top,left,top,left+totlen-1);
    } else {
      setstrlth( MENUWP, maxlen );
      setmenu(MENUWP, 1, maxlen );
      if( left+maxlen+1>MAXCOL ) left=MAXCOL-(maxlen+1);
      if( top+nitem+1>MAXROW ) top=MAXROW-(nitem+1);
      i=poswindow(MENUWP,top,left,top+nitem+1,left+maxlen+1);
      border(MENUWP, menubordline, menuborder );
    }
    checkface(i);
    keyfunc(MENUWP, hotkey, BEFORE|AFTER );
    setupwind(MENUWP);
    gotoitem( menup, menup->curitem );
    checkface(openwindow(MENUWP));
/*    showmenu();*/
    return(0);
}

static int freemenuwindow( NODEPTR menup )
{
    closewindow( MENUWP );
    freewindow( MENUWP );
    MENUWP=NULL;
    return(0);
}

int menuup( void )
{
    CURMENUCURITEM=getcurm(CURMENUWP)-1;
    if( menulevel==0) return(0);/* can't up */
    if( CURMENUFLAG & OPENCLOSE ) freemenuwindow( *menusp );
    *menusp=NULL; /* clear stack */
    menusp--; menulevel--;
    /* openwindow(CURMENUWP); */
    showmenu();
    return(1);/* up done */
}

int menudown( void )
{
  int top,left;

    if( *(menusp+1)==NULL ) return(1); /* can not down */
    menuposition(*menusp,&top,&left);
    menusp++; menulevel++;
    if( CURMENUFLAG & OPENCLOSE ) getmenuwindow( *menusp, top, left );
    showmenu();
    return(1);/* down done */
}

int beginmenu( NODEPTR menu )
{
   menulevel=0;
   menustack[0]=menu;
   menusp=menustack;
   if( CURMENUFLAG & OPENCLOSE ) getmenuwindow( *menusp, 1, 1 );
   setcurattr( CURMENUWP, currmenuattr );
/*   checkface(openwindow( CURMENUWP ));*/
   showmenu();
   return(0);
}
int endmenu( void )
{
   while(menuup());
   setcurattr( CURMENUWP, menuattr );
   openwindow( CURMENUWP );
   if( CURMENUFLAG & OPENCLOSE ) freemenuwindow( *menusp );
   menusp=NULL;
   return(0);
}

int showmenu( void )
{
  int item;

	refresh(CURMENUWP);
	item=getcurm(CURMENUWP)-1;
	replacehelpline((CURITEMP)->helpline); /*????*/
	return(0);
}

extern NODE mainmenu;

int makemenu( void )		/* make the menu window */
{
  extern char far *wndname[];
static char far head1[]="                                                                           ";

  int i;
    menuground=getwindow();
    checkface( readwindow( menuground, wndname[11], configfile) );

    getattr(menuground,&menuattr);
    getcurattr(menuground, &currmenuattr );
    getborder(menuground,&i,&menuborder);

    settype(menuground,PANE );
    poswindow(menuground,1,1,1,80);
    setstrlth(menuground,180);
    setattr(menuground,menuattr);
    border(menuground,0,menuborder);
    newline(menuground,head1);
    setupwind(menuground);
    checkface(openwindow(menuground));

    if(!(mainmenu.flag&OPENCLOSE)) {
      getmenuwindow( &mainmenu, 1, 1 );
      setcurattr( mainmenu.wp, menuattr );
      checkface(openwindow( mainmenu.wp ));
    }
    return(0);
}

int fillmenuitem( char far *name, ITEMPTR itemp )
{
  char buff[80];
    switch(ITEMTYPE&~SPEC_FLAGS) {
      case ON_OFF: farsprintf(name,ITEMNAME,*((int*)OBJECT)&((int)INFO)?"On":"Off"); break;
      case YES_NO: farsprintf(name,ITEMNAME,*((int*)OBJECT)&((int)INFO)?"Yes":"No"); break;
      case INT_NO: farsprintf(name,ITEMNAME,*((int*)OBJECT)?itoa(*((int*)OBJECT),buff,10):"No"); break;
      case INT:    farsprintf(name,ITEMNAME,*((int*)OBJECT)); break;
      case LONG_NO: farsprintf(name,ITEMNAME,*((long*)OBJECT)?ltoa(*((long*)OBJECT),buff,10):"No"); break;
      case LONG:   farsprintf(name,ITEMNAME,*((long*)OBJECT)); break;
      case TIME:   farsprintf(name,ITEMNAME,(int)SECTOMIN(CLOCKTOSEC(*(long*)OBJECT))); break;
	  case SPECSTR:
      case STR :   farsprintf(name,ITEMNAME,(char far *)OBJECT); break;
      case LIST :  farsprintf(name,ITEMNAME,
	( ((NODEPTR)OBJECT)->firstitem+(*(int *)INFO) )->itemname );
	break;
      default: farsprintf(name,ITEMNAME); break;
    }
    return(0);
}

int keytoitem(NODEPTR menup,int key)
{
  int item;
  ITEMPTR itemp;
  char far *c;
    key=toupper(key);
    for(item=0,itemp=MENUFIRSTITEM; ITEMNAME; item++,itemp++) {
      c=ITEMNAME;
      while(*c) {
	if(*c!=' ') {
	  if(*c==key) return(item);
	  if(*c==toupper(*c)) break;
	}
	c++;
      }
    }
    return(ERROR);
}

int menuposition(NODEPTR menup, int *top, int *left)
{
  int bottom,right;
  int ncol,colwidth;
    getposwindow(MENUWP, top, left, &bottom, &right );
    if(MENUROLL==VROLL) *top+=MENUCURITEM+2;
    else (*top)++;
    if(MENUROLL==HROLL) {
      getmenu(MENUWP,&ncol,&colwidth);
      *left+=MENUCURITEM*colwidth-1;
    }
    else (*left)++;
    return 0;
}