
		/**\
		 	   Program file "trace.c"  	
		 					
		 	       Functions: trace	
		 			trace_pos()	
		\**/

#include "facelib.h"
#include "lang.h"
#include "chess.h"
#include "global.h"
#include "ks_game.h"
#include "current.h"
#include "proc.h"
#include "experim.h"
#include "entime.h"
#include "hashpos.h"
#include <string.h>

   /* Static functions. */

static int near make_eval_string(char *prn, EVAL *evp, int flag, EVAL *alfap, EVAL *betap);
LSTRING far betterbranch[MAXBRANCHDEPTH];        /* Branchs of better moves. */

int flPrintSlow=1;
int NEAR trace_pos(char *prn,int killflag)
{
  LSTRING buf="",new="";
  SSTRING evbuf="",evbuf1="",mbuf="";
  static char far space1[]=" ....           ";
  static char far space2[]="                ";
  int i=0;
  POSITION *p;
  int flag=1;

  *prn=' ';*(prn+1)='\0';
  for (p=pos_stk; p<pos_sp; p++) {
    decode( buf,p->a.current,p,0);
    if(p->a.current->flags&M_ISCHECK) {
      if(buf[MOVELENGTH-2]!='Q') buf[MOVELENGTH-2]='+';
      else                       buf[MOVELENGTH-1]='+';
    }

 /*** Temporary for debugging passage extention V 23.11.91 ***/
   if(flPrintSlow){     /* Not slow move */
     char str[2];
       buf[MOVELENGTH-2]='$';
       itoa((p+1)->a.nslow, str, 10);
       buf[MOVELENGTH-1]=*str;
   }
 /*** V 23.11.91 ***/

    if(flag && (!strncmp( buf,&old[i], MOVELENGTH)) ) {
	  if(p-pos_stk==print_level-1 && !killflag ||
	     p-pos_stk==level-1 && killflag )
		mystrncat(prn,space1,MOVELENGTH);
	  else
		mystrncat(prn,space2,MOVELENGTH);
      mystrncat( new, buf,MOVELENGTH);
    }
    else {
      mystrncat(prn, buf,MOVELENGTH);
      mystrncat( new, buf,MOVELENGTH);
	  flag=0;  /* Begin untraced part of variant */
    }
    i+= MOVELENGTH;
    flag= flag && (i<=strlen(old));
  }
  strcpy(old, new);
  if (flag && level!=print_level && !killflag) return(0);
/*  if(killflag) return(1); */
  if(print_full_eval){
	make_eval_string(evbuf,&BETA(level-1),1,0,0);
	make_eval_string(evbuf1,&EVAL(level-1),1,0,0);
	MYSTRCAT(evbuf,evbuf1);
	make_eval_string(evbuf1,&EVAL(level),0,0,0);
	MYSTRCAT(evbuf,evbuf1);
  }
  else{
    EVAL alfa;
      reverse_eval(&alfa,&BETA(level-1));
      make_eval_string(evbuf,&EVAL(level),0,&alfa,&BETA(level));
  }
  farsprintf(buf,"%s%9ld  ",evbuf,lambda);
  MYSTRCAT(prn, buf);
  if(killflag){
	decode( mbuf,&BEST,pos_sp,0);
	farsprintf( buf,"*%2d.%s",BEST_N,mbuf);
	MYSTRCAT(prn, buf);
  }
  else if (level <MAXBRANCHDEPTH) MYSTRCAT(prn,betterbranch[level]);
  return(1);
}

void NEAR trace(char *message)
{
LSTRING prn;

  make_variant_string( prn);
  MYSTRCAT( prn,message);
  lastlinereply( prn);
}

int make_variant_string(char * prn)
{
  LSTRING buf;
  POSITION *p;

  *prn='\0';
  for (p=pos_stk; p<pos_sp; p++) {
    decode( buf,p->a.current,p,0);
    if(p->a.current->flags&M_ISCHECK) {
      if(buf[MOVELENGTH-2]!='Q') buf[MOVELENGTH-2]='+';
      else        		      buf[MOVELENGTH-1]='+';
    }
    mystrncat(prn,buf,MOVELENGTH);
  }
  return(0);
}

extern POSITION *old_pos_sp;    // In ksiwork.c -> zalyapa
int make_variant_string_with_numbers(char* prn)
{
  SSTRING mbuf,buf;
  POSITION *p;

  *prn='\0';
  for (p=pos_stk; p<old_pos_sp; p++) {
    decode( mbuf,p->a.current,p,1);
	farsprintf( buf,"%d.%s",p->a.curr_n, mbuf);
    MYSTRCAT(prn,buf);
  }
  return(0);
}

void NEAR show_current(void)
{
SSTRING prn,buf;
static char far form1[]=" Current  %2d.%s (%2d)  moves %5lu ";
  decode(buf,CURRENT,pos_sp,0);
  farsprintf(prn,form1,
	  /*CURR_N*/CURRENT-savedfirst+1, buf,LAST-/*FIRST*/savedfirst,lambda);
  putinfo(2,1, prn);
}
extern LSTRING deb_str;
void NEAR print_betterbranch(void)
{
LSTRING prn;
SSTRING mbuf,ebuf;
char far *branchptr;
static char far fmt[]="*Best     %2d.%s Eval %s%Fs";
static char far mess1[]="*No best move on round";
  if (move_exist(&BEST) /*&& !breakflag*/ ) {       /*** V 21.11.91 ***/
/*
    decode( mbuf,&BEST,pos_sp,0);
    make_eval_string(ebuf,&evals[BEST_N-1],0,0,0);
   branchptr=skipword(betterbranch[0],1);
    farsprintf( prn,fmt,BEST_N,mbuf,ebuf,branchptr);
*/
    deb_str[0]='*';
    putinfo(1,1, deb_str /*prn*/);
  } else {
/*    FARSTRCPY( prn,mess1); */
    putinfo(1,1, mess1/*prn*/);
    lastlinereply( mess1/*prn*/);
  }
}

void NEAR show_best(void)
{
LSTRING prn;
SSTRING mbuf,ebuf,branchbuf;
static char far form1[]=" Best     %2d.%s Eval %s %s";
  decode(mbuf,&BEST,pos_sp,0);
  make_eval_string(ebuf,&EVAL(1),1,0,0);
  FARSTRNCPY(branchbuf,betterbranch[1],SHORT_STR_LEN);
  farsprintf(prn,form1,CURR_N,mbuf,ebuf,branchbuf);
  putinfo(1,1, prn);
  lastlinereply(prn);
  FARSTRCPY(deb_str,prn);
}

void NEAR show_fv0best(void)
{
SSTRING prn,mbuf;
static char far form1[]=" Best FV0    %s";
  decode( mbuf,&BEST,pos_sp,0);
  farsprintf( prn,form1, mbuf);
  putinfo(1,1, prn);
}

static int near make_eval_string(char *prn, EVAL *evp, int flag, EVAL *alfap, EVAL *betap)
{
  SSTRING buf,buf1,buf2;
  MAT_EVAL mateval;
  POS_EVAL poseval;

  mateval=(flag)? -evp->material : evp->material;
  poseval=(flag)? -evp->position : evp->position;

  *prn='';*(prn+1)='\0';
  if(fvflag)
    switch( mateval){
      case MAT_INFINITY : farsprintf( buf1," MAX");
			  break;
      case -MAT_INFINITY: farsprintf( buf1,"-MAX");
			  break;
      default: farsprintf( buf1,"%4d",mateval);
    }
  switch( poseval){
    case POS_INFINITY :     farsprintf( buf2," MAX");
			    break;
    case -POS_INFINITY:     farsprintf( buf2,"-MAX");
			    break;
    case (POS_INFINITY-1) : farsprintf( buf2," M-E");
			    break;
    case -(POS_INFINITY-1): farsprintf( buf2,"-M+E");
			    break;
    default: farsprintf( buf2,"%4d",poseval);
  }
  if(fvflag) farsprintf( buf,"(%s,%s)", buf1, buf2);
  else farsprintf( buf,"(%s)", buf2);
  MYSTRCAT(prn, buf);
  return(0);
}

/*-------------All about betterbranch.----------------------*/

#define BRANCHMOVELENGTH 11


void NEAR set_branchptr( void )
{
}
	
void NEAR fill_betterbranch( void )
{
  LSTRING prn="";
  SSTRING mbuf="";

  if(fvflag) return;
  if(level>=MAXBRANCHDEPTH-1) return;
  if(CURRENT==FIRST){ 	                           /* Eval is bettermove. */
    strcpy( prn, " Eval");
  }
  else{
    decode( mbuf,(CURRENT-1),pos_sp,1);
    if(POSFLAGS & P_DEEPENING)	farsprintf( prn,"\31 %d.%s",CURR_N, mbuf);         /* 2,7 */
    else  farsprintf( prn,"%d.%s",CURR_N, mbuf);         /* 2,7 */
  }
  MYSTRCAT( prn,betterbranch[level+1]);
  FARSTRCPY(betterbranch[level], prn);
  if(level==1 && CURRENT!=FIRST) movecpy(&bestanswer1,CURRENT-1);
  if(level==0) movecpy(&bestanswer0,&bestanswer1);
}

void NEAR hash_betterbranch( void )
{
  if(fvflag) return;
  if(level>=MAXBRANCHDEPTH-1) return;
  FARSTRCPY(betterbranch[level], " Hash");
}

void NEAR deepening_betterbranch( void )
{
  if(fvflag) return;
  if(level>=MAXBRANCHDEPTH-1) return;
  FARSTRCPY(betterbranch[level], "\31");
}

void NEAR clear_betterbranch(void)
{
  if(level>=MAXBRANCHDEPTH-1) return;
  *betterbranch[level]='\0';
  *betterbranch[level+1]='\0';
  if(level<2) clear_move(&bestanswer1);
}

static char far * near skipword(char far *str, int nword)
{
int counter=0;

  while(*str && counter<nword){
    while(*str==' ') str++;
    while(*str!=' ') str++;
    counter++;
  }
  return(str);
}


