/*
	 ͻ
	                       Time algoritms.                          
	                         I.Shabalin.                            
	 ͼ
*/
#include <time.h>
#include "chess.h"
#include "global.h"
#include "current.h"
#include "ks_game.h"
#include "ksichess.h"
#include "infc_func.h"
#include "ksitimer.h"
#include "proc.h"
#include "ks_macro.h"

#define LAST_MOVE_NUM 6  /* Number of moves before control, when time can,t */
			 /* be added. */
#define PREV_CASCADE_PART 5  /* How much the previous cascade needs */
			     /* less time, than the next cascade. */
#define CALLCLOCK 60

#define MINTIMEFORMOVE SECTOCLOCK(5)  /* Minimal time for one move - 5s */

int NEAR notime( int curr_n )
{
  clock_t cursearchtime;
  static int counter=CALLCLOCK;
static char far mess1[]="Time is over.";

	if(breakflag) return(1);
	if( --counter ) return(0);
	counter=CALLCLOCK;
	if(thinktime==ENEMYTIME)return(0);
	if( !timecontrol ) return(0);
	cursearchtime=clock()-searchbegin;
	if( cursearchtime<searchtime ) return(0);     /* Time isn't over. */
	putinfo(3,2,mess1);
	if(fv0flag && addtime()) return(0);
	if( curr_n==2 && addtimetofinishbranch()){
	  return(0);  /* There is time to finish second move. */
	}
	if( (pos_stk+1)->a.curr_n > 2 && addtimetofinishbranch()){
	  return(0);  /* There is time to finish suspicious move. */
	}
	if(cascadeflag){
	  if( curr_n>1 && EVAL(0).position==-POS_INFINITY)   /* No good moves found yet. */
	    if(addtime()) return(0);
	  if(nround>1)
	    if(addtime()) return(0);  /* Time isn't over. It's added. */
	}
	breakflag=TIMEBREAK;
	putinfo(3,2,mess1);
	return(1); /* true */
}

#define ADDTIMENUM 2
int NEAR addtime(void)
{
PIECE_COLOR lcolor;
static char far mess1[]="Time added.  ";

  if(++addtimecounter==ADDTIMENUM) return(0);
  lcolor=pos_stk[0].a.move_color;
/*  if(controltime-curtime[pos_stk[0].a.move_color]>3*searchtime){ */
  if( controltime-curtime[lcolor] >
      (controlmove-curmovenum[lcolor]+1)*MINTIMEFORMOVE ){
    searchtime*=2;
    putinfo(3,2,mess1);
    return(1);
  }
  return(0);
}

int NEAR addtimetofinishbranch(void)
{
static char far mess1[]="Time added to finish branch.";

  if(addfinishflag) return(0);
  if (pos_stk[0].a.curr_n==1) return 0;
  if(controltime-curtime[pos_stk[0].a.move_color]>3*searchtime){
    addfinishflag=1;
    searchtime+=HALF(searchtime);
    putinfo(3,2,mess1);
    return(1);
  }
  return(0);
}

int NEAR enoughtime(void) /* Return "1", if it's enough time for next cascade. */
{
/*clock_t time,time1;*/
  if(!timecontrol) return(1);
/*  time=(enemy_move_done)? enemytimesearchbegin : searchbegin ; */
  if ((clock()-searchbegin) < searchtime / PREV_CASCADE_PART) return(1);
  else return(0);
}

#define TREESIZELIMIT 3
int NEAR gonextcascade(void)
{
static char far mess1[]="Not enough time.";

  if(breakflag) return(0);
  if(thinktime==ENEMYTIME)return(1);
  if(!timecontrol) return(1);
  if(enoughtime()) return(1);
  putinfo(2,2,mess1);
  return(0);
}

int NEAR stoptimeafter(void)
{
  if (addfinishflag) return 1;
  if (addtimecounter) {
      if (EVAL(0).position!=-POS_INFINITY) return 1;
      if (nround>1 && !move_exist(&BEST)) return 0;
      return 1;
  }
  return 0;
}