/*
	 ͻ
	            Functions  for  set & clear  position               
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <mem.h>		/* memset() */
#include <stdio.h>      /* fopen(), fclose() */
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <dir.h>


#include "face.h"
#include "faceproc.h"
#include "facekeys.h"
#include "facelib.h"

#include "chess.h"
#include "ksichess.h"
#include "global.h"
#include "current.h"
#include "proc.h"
#include "ks_corr.h"
#include "ksiprot.h"
#include "ksiutil.h"
#include "ksiwind.h"
#include "entime.h"
#include "ksibase.h"
#include "ksibdraw.h"
#include "ks_game.h"
#include "ksiwork.h"
#include "hashpos.h"

#include "helpind.h"
#include "interface.h"
#include "menu.h"
#include "infc_func.h"
#include "menu_func.h"
#include "message.h"

typedef struct{
  BYTE who;
  BYTE color;
  BYTE where;
} START_POS;

#define NEXTCOLOR 10
#define TOPAWN     8

static START_POS start_pos[]={
{ ROOK,   WHITE_PIECE, a1},{ ROOK,   WHITE_PIECE, h1},
{ KNIGHT, WHITE_PIECE, b1},{ KNIGHT, WHITE_PIECE, g1},
{ BISHOP, WHITE_PIECE, c1},{ BISHOP, WHITE_PIECE, f1},
{ QUEEN,  WHITE_PIECE, d1},{ KING,   WHITE_PIECE, e1},
{ PAWN,   WHITE_PIECE, a2},{ PAWN,   WHITE_PIECE, h2},

{ ROOK,   BLACK_PIECE, a8},{ ROOK,   BLACK_PIECE, h8},
{ KNIGHT, BLACK_PIECE, b8},{ KNIGHT, BLACK_PIECE, g8},
{ BISHOP, BLACK_PIECE, c8},{ BISHOP, BLACK_PIECE, f8},
{ QUEEN,  BLACK_PIECE, d8},{ KING,   BLACK_PIECE, e8},
{ PAWN,   BLACK_PIECE, a7},{ PAWN,   BLACK_PIECE, h7}};

extern int notstartposflag;

void init_pos( void )
{
  SQUARE_NUM sq;
	FARMEMSET( &(pos_stk->n), 0, sizeof( NEAR_POSITION ) );
	PREVIOUS=move_stk;
	memset(move_stk, 0, sizeof(MOVE) );
	for( sq=a1; sq<NSQUARE; sq++ ) prepare_square( sq );
	FARMEMSET( PIECE_LIST, DUMMY, sizeof( PIECE_LIST ) );
	FARMEMSET( PIECE_MASKS, 0, sizeof( PIECE_MASKS ) );
	POS_MASK.dwrd=0L;
	FARMEMSET( npiece, 0, sizeof( npiece ) );
	FIRST=move_stk+1;
	EN_PASS=DUMMY;
}

int pieceinlist( index, piece, color, square )
int index;
PIECE_NAME *piece;
PIECE_COLOR *color;
SQUARE_NUM *square;
{
  SQUARE_INFO *sqp;
	*square=PIECE_LIST[index].where;
	if( *square!=DUMMY ){
	    sqp=SQUAREP(*square);
	    *piece=sqp->wood.name;
	    *color=sqp->wood.color;
	} else {
	    *piece=NOPIECE;
	    *color=NOCOLOR;
	}
	return(0);
}

void countpieces( void )
{
  SQUARE_NUM square;
  SQUARE_INFO *sqp;
  int i;

	FARMEMSET( npiece, 0, sizeof( npiece ) ); /* clear the piece counters */
	for( i=0; i<TOTAL_NUM_PIECE; i++ ){
		square=PIECE_LIST[i].where;
		if( square==DUMMY ) continue;
		sqp=SQUAREP(square);
		npiece[sqp->wood.color][sqp->wood.name]++;
	}
}

void set_piece_list( int pieceindex, SQUARE_NUM square )
{
	PIECE_LIST[pieceindex].where=square;
}

void corr_piece_list( SQUARE_NUM from, SQUARE_NUM to, PIECE_COLOR color )
{
  PIECE_IN_LIST *pp;
  int index,i;

	index=color_to_king_num(color); /* get index of king in piece list */
	pp=PIECE_LIST+index; /* get pointer to king */
	for(i=0;i<NUM_PIECE;i++,pp++)
	  if( pp->where==from ){ pp->where=to; break;}
}

static int near getnewindex( PIECE_COLOR color )
{
  int i;
	for( i=WHITE_PAWN_A; i<NUM_PIECE; i++ ){
		if( PIECE_LIST[ i+NUM_PIECE*color ].where!=DUMMY ) continue;
/*		npiece[color][PAWN]++;*/
		break;
	}
	return(i);
}

int newpiece( SQUARE_NUM square, PIECE_NAME pname, PIECE_COLOR color )
{
  PIECE_MASK mask={0L};
  BYTE *numpp;                /* pointer to number of required piece */
  int index, colorindex;

	if( (WHOONSQUARE( square )->name)!=NOPIECE ) deloldpiece( square );
	numpp=&npiece[color][pname]; /* get pointer to number of required piece */
	colorindex=color_to_king_num(color); /* get color index in piece list */
	switch( pname ){         /* what is piece */
	  case KING: if( *numpp ) return( ERROR );
		mask.word[color]=KING_MASK; /* get king mask */
		index=WHITE_KING;    /* get number in piece list */
		break;
	  case QUEEN: if( *numpp==0 ){ /* queen already exist? */
			mask.word[color]=QUEEN_MASK; /* get default queen mask */
			index=WHITE_QUEEN; break; /* get default queen index */
		}
		index=getnewindex( color ); /* get new index */
		mask.word[color]=KING_MASK<<index; /* get new queen mask */
		break;
	  case ROOK: if( *numpp==0 ){ mask.word[color]=LEFT_ROOK_MASK;
			index=WHITE_LEFT_ROOK; break;
		}
		if( *numpp==1 ){ 
		  if( PIECE_LIST[WHITE_LEFT_ROOK+colorindex].where==DUMMY ){
			index=WHITE_LEFT_ROOK;
			mask.word[color]|=LEFT_ROOK_MASK;
		  }
		  else{
			index=WHITE_RIGHT_ROOK;
			mask.word[color]|=RIGHT_ROOK_MASK;
		  }
		 break;
        }
		index=getnewindex( color ); /* get new index */
		mask.word[color]=KING_MASK<<index; /* get new mask */
		break;
	  case BISHOP: if( *numpp==0 ){ mask.word[color]=LEFT_BISHOP_MASK;
			index=WHITE_LEFT_BISHOP; break;
      	}
		if( *numpp==1 ){ 
		  if( PIECE_LIST[WHITE_LEFT_BISHOP+colorindex].where==DUMMY ){
			index=WHITE_LEFT_BISHOP;
			mask.word[color]|=LEFT_BISHOP_MASK;
		  }
		  else{
			index=WHITE_RIGHT_BISHOP;
			mask.word[color]|=RIGHT_BISHOP_MASK;
		  }
		 break;
        }
		index=getnewindex( color ); /* get new index */
		mask.word[color]=KING_MASK<<index; /* get new mask */
		break;
	  case KNIGHT: if( *numpp==0 ){ mask.word[color]=LEFT_KNIGHT_MASK;
			index=WHITE_LEFT_KNIGHT; break;
      	}
		if( *numpp==1 ){ 
		  if( PIECE_LIST[WHITE_LEFT_KNIGHT+colorindex].where==DUMMY ){
			index=WHITE_LEFT_KNIGHT;
			mask.word[color]|=LEFT_KNIGHT_MASK;
		  }
		  else{
			index=WHITE_RIGHT_KNIGHT;
			mask.word[color]|=RIGHT_KNIGHT_MASK;
		  }
		 break;
        }
		index=getnewindex( color ); /* get new index */
		mask.word[color]=KING_MASK<<index; /* get new mask */
		break;
	  case PAWN:
		if( *numpp==8 ) return( ERROR ); /* if number more then 8 - Error */
		index=getnewindex( color ); /* get new index */
		mask.word[color]=KING_MASK<<index; /* get new mask */
		break;
	  default: return( ERROR );
	}
	if( index<0 || index>15 ) return(ERROR);
	/*if( pname!=PAWN )*/ (*numpp)++;
	index+=colorindex;
	POS_MASK.word[color]|=mask.word[color];
	PIECE_MASKS[pname].word[color]|=mask.word[color]; /* correct the group mask */
	piece_down( square, pname, color, mask.dwrd ); /* put piece on board */
	set_piece_list( index, square );
	return(OK);
}

int deloldpiece( SQUARE_NUM square )
{
	SQUARE_INFO *sqp;
	PIECE_NAME pname;
	PIECE_COLOR color;
	PIECE_MASK mask;
	int listnum,listnuminpawns;
	SQUARE_NUM ch_sq;
	PIECE_MASK ch_mask;

	sqp=SQUAREP(square);
	pname=sqp->wood.name;
	color=sqp->wood.color;
	mask.dwrd=sqp->who_mask.dwrd;
	piece_up( square );
	deletemask( pname, mask.dwrd );
/*	POS_MASK.word[color]&=~mask.word[color];
	PIECE_MASKS[pname].word[color]&=~mask.word[color]; */
	corr_piece_list( square, DUMMY, color );
	if( pname!=PAWN )
	  if((listnuminpawns=
		  word_to_bit_num(PIECE_MASKS[pname].word[color] & 0xFF00))!=ERROR){
		listnum=word_to_bit_num(mask.word[color]);
		ch_sq=PIECE_LIST[listnuminpawns+color*NUM_PIECE].where;
		ch_mask.dwrd=0;	ch_mask.word[color]=1<<listnuminpawns;
		piece_up(ch_sq);
		piece_down(ch_sq,pname,color,mask.dwrd);

		PIECE_LIST[listnum+color*NUM_PIECE].where=PIECE_LIST[listnuminpawns+color*NUM_PIECE].where;
		PIECE_LIST[listnuminpawns+color*NUM_PIECE].where=DUMMY;

		mask.word[color]|=ch_mask.word[color];
		changemask( pname, mask.dwrd );
	}
	npiece[color][pname]--; /* only in set position */
	return(OK);
}

int setposition( PIECE_COLOR move_color )
{
	MOVE_COLOR=move_color;
	if(check( move_color )) POSFLAGS |= P_CHECK;
	else POSFLAGS&= ~P_CHECK;
/*	turn_move=move_color;
	NCHECK=CHECK ? 1: 0;*/
	MATERIAL_EVAL=material_eval(pos_sp);
	HASH=pos_calc_hash(move_color); set_game_stk();
	return(0);
}

int setstartpos( void )
{
  START_POS *stpp; /* start pos pointer */
  int i;

	init_pos();
	for( i=0; i<8; i++ ){
		stpp=start_pos+i;
		newpiece( stpp->where, stpp->who, stpp->color );
		stpp=stpp+NEXTCOLOR;
		newpiece( stpp->where, stpp->who, stpp->color );
	}
	for( i=0; i<8; i++ ){
		stpp=start_pos+TOPAWN;
		newpiece( stpp->where+i, stpp->who, stpp->color );
		stpp=stpp+NEXTCOLOR;
		newpiece( stpp->where+i, stpp->who, stpp->color );
	}
/*  setcastles */
	CASTLE[ WHITE_PIECE ]= CASTLELEFT | CASTLERIGHT;
	CASTLE[ BLACK_PIECE ]= CASTLELEFT | CASTLERIGHT;

	setposition( WHITE_PIECE );
	notstartposflag=0;
	return(0);
}

int saveposition( void )
{
  int file;
  char str[MAXPATH];
  int i;
  WINP wp;
static char far mess1[]=" Save Position ";
static char far mess2[]="Can't open file to write position.";

    int top=6,left=16;
      if(infc_info[cur_infc_ptr->name].type&MENU_STATUS)
	  menuposition(*menusp,&top,&left);
      wp=getpromptwindow(top,left,mess1);
    if( wp ) {
      keyfunc(wp,tohelpprompt,BEFORE);
      FARSTRCPY(str,configfile);
      i=searchfile( wp, str, "*.pos" );
      checkface(freewindow(wp));
    } else return 0;
    if(i==ESCAPE) return 0;
    checkface(i);
    if(i) return 0;
    make_bak_file(str); /* rename old file to ".bak"*/
    file=MYOPEN( str,O_WRONLY+O_CREAT+O_TRUNC+O_TEXT,S_IREAD+S_IWRITE);
    if( file==-1){ message( mess2,0); return(0); }
    putposintofile(file);
    MYCLOSE( file );
    return(1);
}

int loadposition( void )
{
  int file;
  char str[MAXPATH];
  int i;
  WINP wp;
  int top=6,left=16;
static char far mess1[]=" Load a Position ";
static char far mess2[]="Can't open file to read position";

    if(infc_info[cur_infc_ptr->name].type&MENU_STATUS)
      menuposition(*menusp,&top,&left);
    wp=getpromptwindow(top,left,mess1);
    if( wp ) {
      keyfunc(wp,tohelpprompt,BEFORE);
      i=searchfile( wp, str, "*.pos" );
      checkface(freewindow(wp));
    } else return 0;
    if(i==ESCAPE) return 0;
	checkface(i);
    if (i) return 0;
    file=MYOPEN( str,O_RDONLY+O_TEXT,0);
    if( file==-1 ){ message( mess2,0); return(0); }
    getposfromfile(file);
    MYCLOSE( file );
    notstartposflag=1;
    closeprotocol();
	resetprotocol();
	resettime();
    closebase();
    setwritten(board);
    refresh(board);
    return(1);
}

void getposfromfile( int fp)
{
	SSTRING wstr, bstr;
	SSTRING turnstr, wcstr, bcstr ,enpstr;
	char far *cp;
	SQUARE_NUM square;
	PIECE_NAME name;
	PIECE_COLOR color;
	WOOD_PIECE *wpp;
static char far mess1[]=" This isn't position file.";

	MYREADLINE(fp,wstr,SHORT_STR_LEN);
	MYREADLINE(fp,bstr,SHORT_STR_LEN);
	MYREADLINE(fp,turnstr,SHORT_STR_LEN);
	MYREADLINE(fp,wcstr,SHORT_STR_LEN);
	MYREADLINE(fp,bcstr,SHORT_STR_LEN);
	MYREADLINE(fp,enpstr,SHORT_STR_LEN);
	init_pos();
	if( !(*wstr=='w' && *(wstr+1)==':' && *bstr=='b' && *(bstr+1)==':') ){
		message(mess1 ,0);
	}
	for( color=WHITE_PIECE; color<NCOLOR; color++ ){
		cp=( color==WHITE_PIECE )?  wstr: bstr;
		cp+=2;  /* skip color: "w:" */
		name=NOPIECE;
		while( *cp!='\0' && *cp!='\n' ){
			if( name!=PAWN ) cp=sscanpiece( cp, &name );
			cp=sscansquare( cp,&square );
			wpp=WHOONSQUARE( square );
			if( wpp->name!=NOPIECE ) deloldpiece( square );
			newpiece( square, name, color );
			cp++;  /* skip comma or point */
		}
	}
	sscanturnmove(  turnstr);
	sscancastles(  wcstr , WHITE_PIECE); 
	sscancastles(  bcstr, BLACK_PIECE);
	sscanenpass(  enpstr);

	setposition( MOVE_COLOR );
/*	CHECK=check( MOVE_COLOR );
	MATERIAL_EVAL=material_eval(pos_sp);
	set_game_stk();
	setcolor(MOVE_COLOR);*/
}

void putposintofile( int file )
{
SSTRING str;

	sprintpos( str, WHITE_PIECE);
	MYWRITE( file, str, strlen(str) );    MYWRITE(file, eol, 2);
	sprintpos( str, BLACK_PIECE);
	MYWRITE( file, str, strlen(str) );    MYWRITE(file, eol, 2);
	sprintturnmove( str );
	MYWRITE( file, str, strlen(str) );    MYWRITE(file, eol, 2);
	sprintcastles( str , WHITE_PIECE);
	MYWRITE( file, str, strlen(str) );    MYWRITE(file, eol, 2);
	sprintcastles( str, BLACK_PIECE);
	MYWRITE( file, str, strlen(str) );    MYWRITE(file, eol, 2);
	sprintenpass( str );
	MYWRITE( file, str, strlen(str) );    MYWRITE(file, eol, 2);
}

int word_to_bit_num(WORD mask)
{
int j;

  if(!mask)return(-1);
  for(j=-1;mask;mask>>=1,j++); return(j);
}
