/*
	 ͻ
	     Functions for make foreward and backward moves             
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <mem.h>
#include "chess.h"
#include "current.h"
#include "proc.h"
#include "ks_corr.h"
#include "global.h"
#include "ks_macro.h"
#include "ks_game.h"
#include "hashpos.h"
#include "experim.h"

PIECE_COLOR revcolor[NCOLOR]={ BLACK_PIECE, WHITE_PIECE };
static PIECE_COLOR M_Enemy_color;
static PIECE_COLOR M_Our_color;
static MOVE *Movep;
static MOVEFLAGS Mflags;
static MAT_EVAL Cost_captured;

static void near countnslow(void);
	/* Count number of slow moves at the branch. */
static void near countncheck( int checkstate );
	/* Count number of checks and checks in fv. */

int /*NEAR*/ check( PIECE_COLOR color ) /* test check status */
{
	SQUARE_NUM kingsq;       /* number of king square */
	SQUARE_INFO *kingsqp;    /* pointer to king square information */
	int i;

	kingsq=PIECE_LIST[color_to_king_num(color)].where; /* get square of king */
	if(kingsq==DUMMY) return(0);
	kingsqp=SQUAREP(kingsq); /* get pointer to square info */
	color= 1- color; /* enemy color */
	i=kingsqp->attackedby.word[color];
	return( i!=0 );  /* !!! must be number of checks */
}

static void near make_promotion( PIECE_NAME pname, DWRD mask )
{                                   /* correct group mask: */
	PIECE_MASKS[PAWN].dwrd&=~mask; /* clear from pawn's mask */
	PIECE_MASKS[pname].dwrd|=mask; /* set to piece's mask */
}

void deletemask( PIECE_NAME pname, DWRD mask )
{                                   /* correct group mask: */
	POS_MASK.dwrd&=~mask; /* del mask of captured piece */
	PIECE_MASKS[pname].dwrd&=~mask; /* del mask of captured piece */
}

void changemask( PIECE_NAME pname, DWRD mask )
{                                   /* correct group mask: */
	POS_MASK.dwrd^=mask; /* del mask of captured piece */
	PIECE_MASKS[pname].dwrd^=mask; /* del mask of captured piece */
}

#define LEFT_CASTLE_LEN  3
#define RIGHT_CASTLE_LEN 2

static void near make_castle( BYTE flag )
{
  SQUARE_NUM from, to, base;
  PIECE_MASK mask;
  CASTLES *castp;

	castp=&(CASTLE[M_Our_color]);
	mask.dwrd=0L;
	base=( M_Our_color==WHITE_PIECE )? a1:a8; /* get base square for castle */
	if( flag & M_CASTLE_LEFT ){ /* long or short castle */
		from=base; to=base+LEFT_CASTLE_LEN; /* get squares from and to */
/*		mask.word[M_Our_color]=LEFT_ROOK_MASK; /* get mask to rook */
*/              mask.dwrd=SQUAREP(from)->who_mask.dwrd;
		*castp |= CASTLELEFTDONE;
		TOUCH_HASH( HASH, rand_num->castles[M_Our_color][1] );
	} else {
		from=base+LINELEN-1; to=from-RIGHT_CASTLE_LEN;
/*		mask.word[M_Our_color]=RIGHT_ROOK_MASK;
*/		mask.dwrd=SQUAREP(from)->who_mask.dwrd;
		* castp |= CASTLERIGHTDONE;
		TOUCH_HASH( HASH, rand_num->castles[M_Our_color][0] );
	}
	piece_up( from );        /* raise rook from board */
	piece_down( to, ROOK, M_Our_color, mask.dwrd ); /* place rook to board */
	TOUCH_HASH( HASH, rand_num->pieces[M_Our_color][ROOK][from] );
	TOUCH_HASH( HASH, rand_num->pieces[M_Our_color][ROOK][to] );
	corr_piece_list( from, to, M_Our_color );
	*castp &= ~CASTLERIGHT;
	*castp &= ~CASTLELEFT;
}

static void near make_en_passant( SQUARE_NUM to )
{
  SQUARE_INFO *sqp;
	to=(M_Our_color==WHITE_PIECE )? to-LINELEN:to+LINELEN;
	sqp=SQUAREP(to); /* get to square pointer */
	deletemask( PAWN, sqp->who_mask.dwrd );
	corr_piece_list( to, DUMMY, M_Enemy_color );
	piece_up( to );
	TOUCH_HASH( HASH, rand_num->pieces[M_Enemy_color][PAWN][to] );
}

static void near move_pos( ADD_POSITION *dest, ADD_POSITION *src )
{
  dest->first=dest->last=dest->current=src->last;             /* set move stack pointer */
  dest->previous=src->current;       /* set previouse move pointer */
  dest->curr_n=0;
  clear_move(&dest->best);
  dest->best_n=-1;
  dest->g_status=src->g_status;          /* status for generator */
  dest->material_eval=-src->material_eval; /* set material eval */
//  dest->mat_deficit=eval_stk[level].material-src->material_eval;
  dest->move_color=M_Enemy_color;
  dest->en_pass=DUMMY;               /* clear en passant square */
  dest->nslow=src->nslow;            /* number of slow moves */
  dest->ncheck=src->ncheck;          /* number of checks */
  dest->neval=src->neval;            /* number os evaluations */
  dest->nfvcheck=src->nfvcheck;      /* number of checks in fv */
  dest->posbetamove=0;
  dest->posflags=0;
}

extern MAT_EVAL firstroundmaterial;
int NEAR move( void )
{
  SQUARE_NUM from, to;
  SQUARE_NUM enp_sq;
  SQUARE_INFO *fromp,*top;
  PIECE_MASK whomask;
  PIECE_NAME name;
  WORD whotomask;
  int i;

  M_Our_color=MOVE_COLOR;
  M_Enemy_color=reverse_color(M_Our_color);
  Movep=CURRENT;                               /* get current move pointer */
  Mflags=Movep->flags;                             /* get move status flags */
  if(POSFLAGS & P_CHECK) Mflags|=M_CHECK_DEFENCE;
  MEMCPY(pos_sp+1, pos_sp, sizeof(NEAR_POSITION) );
  move_pos( &((pos_sp+1)->a), &(pos_sp->a) );  /* moving brunch info to new position */

  pos_sp++;  // !!!

//  if(EN_PASS!=DUMMY) TOUCH_HASH( HASH, rand_num->enpass[EN_PASS] );
  if((pos_sp-1)->a.en_pass!=DUMMY) TOUCH_HASH( HASH, rand_num->enpass[(pos_sp-1)->a.en_pass] );

  if( Mflags==M_NULLMOVE ){      /* this is null move */
    NSLOW++;
  }
  else{                               /* not null muve */
    from=Movep->from;
    to=Movep->to;
    fromp=SQUAREP(from); /* get from square pointer */
    top=SQUAREP(to); /* get to square pointer */
    whomask=fromp->who_mask; /* save the piece mask */
    name=fromp->wood.name;
    Cost_captured=top->wood.cost;

	TOUCH_HASH( HASH, rand_num->pieces[M_Our_color][name][from] );
    TOUCH_HASH( HASH, rand_num->pieces[M_Our_color][name][to] );

    if( Cost_captured ){  /* this is capture */
	    whotomask=top->who_mask.word[M_Enemy_color]; /* M.D. */
	    if (whotomask & LEFT_ROOK_MASK) {
			CASTLE[M_Enemy_color] &= ~CASTLELEFT;
	    }  else if ( whotomask & RIGHT_ROOK_MASK) {
		    CASTLE[M_Enemy_color] &= ~CASTLERIGHT;
	    }
	    MATERIAL_EVAL-=Cost_captured;
	    corr_piece_list( to, DUMMY, M_Enemy_color );
	    deletemask( top->wood.name, top->who_mask.dwrd );
	    POSFLAGS|=P_CAPTURE; /* set capture flag */
	    Mflags|=M_CAPTURE; /* set move flag */
	    TOUCH_HASH( HASH, rand_num->pieces[M_Enemy_color][top->wood.name][to] );
    }
    piece_up( from ); /* raise piece from board */
    if( name==PAWN ){
	    i=to/LINELEN; /* get dest line */
		if( i==FIRSTLINE || i==LASTLINE ){ /* test promotion */
		    name=QUEEN; /* promotion only into Queen */
		    MATERIAL_EVAL-=(QUEEN_COST-PAWN_COST);
		    make_promotion( name, whomask.dwrd ); /* make new mask */
		    Mflags|=M_PROMOTION;
		    TOUCH_HASH( HASH, rand_num->pieces[M_Our_color][PAWN][to] );
			TOUCH_HASH( HASH, rand_num->pieces[M_Our_color][QUEEN][to] );
	    } else {
		    i=from-to;
		    if( i==16 || i==-16 ) /* this is pawn jump */
		      if(SQUAREP(enp_sq=from-HALF(i))->attackedby.byte[M_Enemy_color][1]){
			EN_PASS=enp_sq;            /*from-i/2*/	/* M.D. */
			TOUCH_HASH( HASH, rand_num->enpass[enp_sq] );
		      }
	    }
    }
    piece_down( to, name, M_Our_color, whomask.dwrd ); /* set piece to board */
    corr_piece_list( from, to, M_Our_color );

    if( Mflags & (M_CASTLE_LEFT|M_CASTLE_RIGHT) ){ /* Make the castle */
		make_castle( Mflags );
    } else if( name==KING ) { /* ELSEs inserted by ADubets 16 july 90 */
	    CASTLE[M_Our_color] &= ~CASTLELEFT;
	    CASTLE[M_Our_color] &= ~CASTLERIGHT;
    } else if( name==ROOK ){
	    i=GETFILE( from );
		if( i==0 ) CASTLE[M_Our_color] &= ~CASTLELEFT;
	    if( i==7 ) CASTLE[M_Our_color] &= ~CASTLERIGHT ;
    } else if( Mflags & M_EN_PASSANT ){
	    make_en_passant( to );
	    MATERIAL_EVAL-=PAWN_COST;
	    POSFLAGS|=P_CAPTURE; /* set capture flag */
	    Mflags |= M_CAPTURE;
	    Cost_captured=PAWN_COST;
    }

    if( (i=check( M_Enemy_color ))!=0 ){
	    POSFLAGS|=P_CHECK;
	    Mflags|=M_ISCHECK;
    }

	Movep->flags=Mflags;
	if(M_Enemy_color==pos_stk->a.move_color){
	  if(MATERIAL_EVAL >= firstroundmaterial) POSFLAGS|= P_INFIRSTROUNDBORDERS;
	  if(MATERIAL_EVAL <= firstroundmaterial) POSFLAGS|= P_ENINFIRSTROUNDBORDERS;
	}
	else{
	  if(MATERIAL_EVAL >= -firstroundmaterial) POSFLAGS|= P_INFIRSTROUNDBORDERS;
	  if(MATERIAL_EVAL <= -firstroundmaterial) POSFLAGS|= P_ENINFIRSTROUNDBORDERS;
	}
	countncheck(i); /* check state already known */
	countnslow();
  } /* not null move */
  COLOR_INTO_HASH( HASH, M_Enemy_color );       /* M_Our_color into hash */
  if( check( M_Our_color ) ){ pos_sp--; return(1); }     // Illegal move.
  pos_sp--;
  return(0);
}

void NEAR move_back( void )
{
}

static void near countnslow(void) /* Count number of slow moves at the branch. */
{
  BOOLEAN check_is_slow;
	if(level>MAXSLOWLEVEL){
	  NSLOW++;
	  return;
	}
	check_is_slow=( NCHECK > NCHECK_NOT_SLOW )? TRUE : FALSE;
	if(Mflags&M_CHECK_DEFENCE ||              /* Check defence */
	   (Mflags&M_ISCHECK && !check_is_slow ) ||  /* Check     */
	   Mflags&M_PASSAGE ||         /* Passage pawn move */
	   (pos_stk[level-1].a.current->flags & M_PASSAGE && !check_is_slow)
	       /* previous passage */
	  ) return; /* Not slow move */
	if((Mflags&(M_CAPTURE|M_PROMOTION)) &&
	   POSFLAGS & P_ENINFIRSTROUNDBORDERS) return;
	NSLOW++;
}

static void near countncheck( int checkstate )/* Count number of checks and checks in fv. */
{
	if(checkstate) {
	  if(cascadeflag){
	  if((Mflags&(M_CAPTURE|M_PROMOTION)) &&
	     POSFLAGS & P_INFIRSTROUNDBORDERS) return;
	  }
	  NCHECK++;
	  if(G_STATUS&G_VARIANT) NFVCHECK++;   /* Status - Forced variant */
	} else if (Mflags & M_PASSAGE) NCHECK++;
}

