		/**\
		 	  Program file "minmax.c" 	
		 	       Functions: searchtree() 
		                          clear_move	
		 			   move_exist	
		\**/

#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "forc_def.h"
#include "proc.h"
#include "ks_game.h"
#include "experim.h"
#include "ks_eval.h"
#include "hashpos.h"
#include "gener.h"
#include <mem.h>
#include <stdio.h>

extern int flPassGen;
int NEAR PassagePawn(void);
void NEAR calc_pawns_lines(void);

 /* Global variables. */

BOOLEAN check_is_slow;     /* Set TRUE, if check is counted as a slow move. */
EVAL eval_stk[EVAL_STACK_SIZE];		/* Evaluation stack */
EVAL beta_stk[EVAL_STACK_SIZE];
EVAL realeval[EVAL_STACK_SIZE];
MOVE best_move;                         /* ??? */
BOOLEAN no_moves;                       /* ??? */
int begin_level;                        /* Searchtree start level. */
int repeatflag;     /* Set, if third time repeated position found in search. */
int cutoffnum;
int cutoffflag;
int select_en=1;
int fullselect_en=1;

int nullmove_level=MAXDEPTH;          /* Level, where null move done. */
int select_level=MAXDEPTH;          /* Level, where null move done. */
int nullfv_en=0;
int nullcutoff_en=0;
POS_EVAL null_savedeval;
POS_EVAL null_savedbeta;
int escattorder_en=1;
int dinamicorder_en=1;

#define OUR_NULLMOVE     ((nullmove_level&1) == (level&1))
#define ENEMY_NULLMOVE   ((nullmove_level&1) != (level&1))

int narrow_en=0;  /* Narrow boarders enable */
int real_en=0;    /* Hash use real eval enable */
int addatt_en=0;  /* Search deeper, if attacked */

/*****************************************************/
int NEAR wy_lose(MOVE *move, MOVE *killer);  /* 1 if killer bound with move */


 /* Static functions. */
				/* Implements min&max algorythm */
int NEAR chinese(int evflag);				/* Chinese */
static int near american(void);				/* American */
static int near american_FV(void);			/* American FV */
static int near russian(void);				/* Russian */
static void near beginsearch(void);
static void near endsearch(void);
static int near null_condition(void);
static int near evalreliable(void);  /* return 0, if position not reliable */

static void near badmove(void);
static int near lose_castle_right(POSITION *pos_sp);
int NEAR we_attacked(void);
static void near setposition0(void);
int userbreak(void);

#define POS_INFINITY_EPS 0x7FFD

int deb_val=0;
void NEAR searchtree( void )	/* The main tree search function. */
{
	     beginsearch();       /* begin search */
  labelmain: if( !american() ) goto labelup;
  labeldown: if (userbreak()) goto labelbreak;
		 if(level==deb_val)
		   deb_val=deb_val;
	     if( down()) goto labelmain;
  labelup:   if ( !russian() ) goto labeldown;
	     if ( !up()     ) goto labelexit;
	     if ( chinese(0) ) goto labelup;
	     goto labeldown;
  labelexit: endsearch();       /* end search */
	     return;
  labelbreak: setposition0();
	      return;
}

static void near setposition0(void)
{
    pos_sp=pos_stk; level=0;   /* reset stacks */
}

#define EPS 1

#define CHKILL 1
#define CHBETT 2
#define CHBAD  4
				/* Implements min&max algorythm */
int NEAR chinese(int evflag)				/* Chinese */
{
  EVAL value;

    reverse_eval(&value,&EVAL(level+1));
    if(cmp_eval(&value,&BETA(level)) & (GREATER|EQUAL)) { /* eval>=beta */
      bettermove();     /* killer move was found; prune this branch */
      if(evflag) POSFLAGS|=P_EVALKILLER;
      else POSFLAGS&=~P_EVAL;
      if(!level){
	if( BETA(level/*-1*/).position==POS_INFINITY) {
	  if(!betamove){                              /* First move out of */
	    EVAL(level).position=POS_INFINITY-EPS;     /* material bounds. */
	    BETA(level).position=POS_INFINITY;
	    betamove=CURRENT-1;
	    betamovefound=1;
	    return(0);
	  }
	  else{                                     /* Second move out of */
            betastop=1;                              /* material bounds. */
            return(1);
	  }
        }
      }  /* if level==0 */
#if (NARROWBOUNDS==1)
 if (narrow_en){
      if(cascadeflag && level<mindepth-1 && POSFLAGS & P_POSNARROWBOARDS){
/*        if(REALEVAL(level).material==-BETA(level-1).material) { */
	  if(level<print_level) lastlinereply(" Positional round.");
	  BETA(level).position=-EVAL(level-1).position;  /* Restore beta */
/*	  EVAL(level).position=-BETA(level-1).position; */
	  CURRENT--; CURR_N--;              /* Repeat analysing this move */
	  POSFLAGS&=~P_POSNARROWBOARDS;
	  return(0);
/*        }
	else{
	  reverse_eval(&EVAL(level),&EVAL(level-1));  /* Eval <- Beta */
	  return(1);
	}  */
      }
 } /* If (narrow_en) */
#endif
/*      cpy_eval(&EVAL(level),&value);  /* Standart variant */ */
      cpy_eval(&EVAL(level),&BETA(level));  /* Instead of standart variant */
      return(1);
    }                     /* Eval is in bounds.  alfa < eval < beta */
    if(cmp_eval(&value,&EVAL(level)) & GREATER) {  /* eval>alfa */
      bettermove();
      cpy_eval(&EVAL(level),&value);
      if(evflag) POSFLAGS|=P_EVALBETTER;
      else POSFLAGS&=~P_EVAL;
#if (NARROWBOUNDS==1)
 if (narrow_en){
      if(cascadeflag && level < mindepth-1){   /* Better move narrow position bounds. */
/*        BETA(level).material=EVAL(level).material;  */
	if( ( level==0 && CURR_N>4 ) ||
	   (CURRENT==LAST || CURRENT->profit < KILLER_PROFIT-5 )){
	  BETA(level).position=EVAL(level).position+1;
	  POSFLAGS&=P_POSNARROWBOARDS;
	  return(0);
	}
      }
 } /* If (narrow_en) */
#endif
    }
    else{  /* eval <= alfa */	/* Eval is less, than alpha. */
      badmove();
      if(evflag) POSFLAGS|=P_EVALBAD;
//    else POSFLAGS&=~P_EVAL;              /*** V 14.11.91 ***/
    }
    return(0);      /* continue tree search */
}

				  /* Return 0 to go up, 1 to go down. */
int fv1used=0;
static int near american(void)	 /* American 30.04.90 */
{

  fv1used=0;
  if(level==MAXDEPTH-2) {                 /* Position stack is overflow. */
    EVAL(level).material=MATERIAL_EVAL;
    if(MAXDEPTH & 1)  EVAL(level).position=-POS_INFINITY_EPS; /* Our eval. */
    else            EVAL(level).position=POS_INFINITY_EPS; /* Enemy eval. */
    return(0);                    /* Possible incorrect */
  }
  if( checkrepeat(HASH) ){
    put_eval(level,0,0);
    repeatflag=1;
    return(0); /* Go up */
  }
  if (notime(pos_stk->a.curr_n)){      /* Time for search is over. */
    return(0);
  }
  reverse_eval(&EVAL(level),&BETA(level-1));
  reverse_eval(&BETA(level),&EVAL(level-1));
  MAT_DEFICIT=eval_stk[level].material-MATERIAL_EVAL;
  clear_killer(level+2);

#if FV1_USED
  fv1used=((level==begin_level+1) &&          /* If the results of fv1 used */
    cascadeflag && !searchpass && !istep
		&& (pos_sp-1)->a.current==(pos_sp-1)->a.first);
#endif

  if (!level) {
	CURRENT=FIRST;
	if (hash_enable) {    /* If position hash used */
//A.S.4.6.91	  zeroevaltohash(HASH,1); /* Put position into hash with zero eval */
	}
	return(FIRST!=LAST);
  }

  repeatflag=0;
  clear_moves();
  if(!(NULL_ENABLE && level==nullmove_level+1)){  /* If previous not Null move */
    if (hash_enable && !fv1used) {    /* If position hash used */
      if(pos_hash_success()){             /* If position is repeating    */
	hash_betterbranch();
	hash_success=1;
	return(0);                        /* Go UP  */
      }
//      if(level<mindepth) zeroevaltohash(HASH,0); /* Put position into hash with zero eval */
      gen_hash_success=(LAST!=FIRST);
    }
  }    /* If previous not Null move */

  clear_killer(level+2);
  set_profitable_attack();
  set_new_attack();
  if(flPassGen){ calc_pawns_lines(); PassagePawn(); }

  if( G_STATUS & G_VARIANT ) return(american_FV());

#if FV1_USED
  if(fv1used){                /* If the results of fv1 used */
    LAST=FIRST+fv1movenumber;
    return(FIRST!=LAST);
  }
#endif

  if (NSLOW>=minnslow && level>=mindepth){               /* The last level. */
    G_STATUS|=G_FORCED|G_VARIANT;
    return(american_FV());
  }

  if( ( level >= mindepth-1 ) &&       /* level is last normal*/
      ( NSLOW >= minnslow ||
      ( NSLOW == minnslow-1 ) && ( !CHECK || level>=MAXSLOWLEVEL ) ) ){
    if(MAT_DEFICIT>0){            /* and material deficit. */
      G_STATUS|=G_FORCED;
      return(american_FV());
    }
  }

  G_STATUS=G_NORMAL;
  LAST=generator_i(LAST,1);

  if(FIRST==LAST){                           /*No moves. */
    if(G_STATUS&G_SELECTIVE){
      G_STATUS=G_NORMAL;
      LAST=generator_i(LAST,1);
    }
    if(FIRST==LAST){
      if(CHECK){
        put_eval(level,-MAT_INFINITY,-(POS_INFINITY-level*2)); /*  Checkmate.  */
      }
      else {
        put_eval(level,0,0);			/*  Pate.  */
      }
    }
  }
  return(FIRST!=LAST); 
}

int bound_attacked_flag;

static int near american_FV(void)	/* 30.04.90 American FV */
{
 POS_EVAL pos_EV;
 int matinlimit=0;
 int i;

  if(EXHAUST_LIMIT_CHECK) G_STATUS|=G_WITHOUT_CHECK;
  if(!CHECK){
    if( matinlimit=MAT_EVAL_IN_LIMIT ) {
      bound_attacked_flag=0;
      if(NULL_ENABLE && level>nullmove_level){   /* Null move done */
	  if(OUR_NULLMOVE) pos_EV=POS_INFINITY; /* Our null move */
	  else pos_EV=-POS_INFINITY;            /* Enemy null move */
      }
      else{  /* Standart */
	if(betamovefound) pos_EV=0;
	else if(lose_castle_right(pos_sp)) pos_EV=pos_eval();
	else {
	  if(!EXHAUST_LIMIT_EVAL) {
	    if(PREV_CHECK_NO_CAPTURE &&
	       WHOONSQUARE(PREVIOUS->to)->name!=KING)                /*M.D. */
	       pos_EV=-POS_INFINITY_EPS;
	    else pos_EV=pos_eval();
	  }  else pos_EV=-POS_INFINITY_EPS; /* have no right to evaluate */
	}
      }  /* If not null move done */
    } else pos_EV=(MAT_DEFICIT>0)? POS_INFINITY-EPS : -(POS_INFINITY-EPS);
    put_eval(level+1, -MATERIAL_EVAL, -pos_EV);

    i=chinese(1);
    if(i) return(0);   /* Go up - Eval is killer */
  }  /* If not check */

  LAST=generator_i(LAST,1);
  if(CURRENT==LAST && CHECK){
    if(MAT_DEFICIT<=0)
      put_eval(level,-MAT_INFINITY,-(POS_INFINITY-level*2)); /*  Checkmate.  */
    else{ /* Lose material */
      REALEVAL(level).material=MATERIAL_EVAL;
      REALEVAL(level).position=-POS_INFINITY;
    }
  }
  return(FIRST!=LAST);
}

static int near lose_castle_right(POSITION *pos_sp)
{
  POSITION *pos_sp2;
    pos_sp2=pos_sp-2;
    if(pos_sp2<pos_stk) return(1);
    if ( ( pos_sp2->n.castle[WHITE_PIECE] & CASTLELEFT )
		!= ( CASTLE[WHITE_PIECE] & CASTLELEFT ) ||
	   ( pos_sp2->n.castle[WHITE_PIECE] & CASTLERIGHT )
		!= ( CASTLE[WHITE_PIECE] & CASTLERIGHT ) ||
	   ( pos_sp2->n.castle[BLACK_PIECE] & CASTLELEFT )
		!= ( CASTLE[BLACK_PIECE] & CASTLELEFT ) ||
	   ( pos_sp2->n.castle[BLACK_PIECE] & CASTLERIGHT )
		!= ( CASTLE[BLACK_PIECE] & CASTLERIGHT ) )
				return(1);
    return(0);
}

extern MAT_EVAL firstroundmaterial;
static int near russian(void)				/* Russian */
{
  if(select_en && cascadeflag && (level==select_level))
    select_level=MAXDEPTH;
  if(select_en && cascadeflag ){  /* Check unreliable evaluation - deepening */
	 if(POSFLAGS & P_DEEPENING){
		selectcount++;
		if(EVAL(level).position>=BETA(level).position) winselectcount++;
		if(EVAL(level).position<=-BETA(level-1).position){
	loseselectcount++;
	deepening_betterbranch();
		}
	 }         /*** V 15.11.91 ***/
	 else if( (POSFLAGS & P_EVALBEST) /* && NEVAL<=1  */  /*** V 15.11.91 ***/
		  && INFIRSTROUNDBORDERS && NSLOW<=(MAXSLOWLEVEL)){  /*** V 15.11.91 ***/
		if(!evalreliable()){ /* Position is not reliable */
	POSFLAGS|=P_DEEPENING;
	if(POSFLAGS & P_EVALBETTER){  /* Eval is better */
	  MOVE movebuf[30];
	  int copysize;
	  int forcedmovenum;
	    forcedmovenum=(LAST-FIRST);
	    copysize=forcedmovenum*sizeof(MOVE);
	    MEMCPY(movebuf,FIRST,copysize);  /* Save forced moves */
	    G_STATUS=G_NORMAL;
	    CURRENT=FIRST;
	    LAST=generator_i(FIRST,0); /* Generate all rest moves */
	    MEMCPY(LAST,movebuf,copysize); /* Add forced moves into the end */
	    LAST+=forcedmovenum;
	    BETA(level).position=EVAL(level).position; /* Set new eval, as beta */
	}
	else{   /* Eval is killer */
	    G_STATUS=G_NORMAL;
	    LAST=generator_i(FIRST,1);
	}
	EVAL(level).position=-BETA(level-1).position; /* Restore alfa */
	POSFLAGS&=~P_EVALBEST;
	return(0);   /* Go down */
      }
    }
  }
  if(CURR_N<1 && /*G_STATUS==NORMAL &&*/ !hash_success && !repeatflag && !cutoffflag){
    if(CHECK) {
      if(MAT_DEFICIT<=0 || G_STATUS==G_NORMAL)
	put_eval(level,-MAT_INFINITY,-(POS_INFINITY-level*2)); /*  Checkmate.  */
      else{
	REALEVAL(level).material=MATERIAL_EVAL;
	REALEVAL(level).position=-POS_INFINITY;
      }
    }
    else if(G_STATUS==G_NORMAL){
      put_eval(level,0,0);                /*  Pate.  */
    }
  }

  if(CURR_N>0 && move_exist(&BEST)) killer_heuristic(G_STATUS);

  if(print_flag) russian_debug();
  if( hash_success )  hash_success=0;
				    /* Weren't  moves  generated
				    because of occurience position in hash
				    but not because of pat or checmate */
  else
    if(!(NULL_ENABLE && level>nullmove_level)){ /* If not Null move done */
      if(hash_enable) {     /* If position hash is used   */
	    pos_hash_eval();      /* Put eval of position and limits into hash */
#ifdef HASH_ATT_ENABLE
	    hash_att_killer();    /* store best move in attack hash */
#endif
      }
    }
  if(BEST_N!=-1) {			/* Average best move number */
    n_best++;
    sum_best+=BEST_N;
  }

  return(1);
}


static void near beginsearch(void)
{
  repeatflag=0;
  lambdasearch=0;
  NSLOW=0;
  NCHECK=0;
  NFVCHECK=0;
  NEVAL=0;
  clear_all_killer();
  betastop=FALSE;
  betamovefound=0;
  betamove=NULL;
  check_is_slow=FALSE;
  cpy_eval(&EVAL(level-2),&alfa);		/* set up evaluation stack */
  reverse_eval(&EVAL(level-1),&beta);
  reverse_eval(&BETA(level-1),&alfa);
  pos_sp= pos_stk+level;		/* set up position stack	*/
  clear_move(&best_move);
  clear_betterbranch();
  begin_level=level;
  nullmove_level=MAXDEPTH;          /* Level, where null move done. */
  select_level=MAXDEPTH;          /* Level, where null move done. */
  sumnumber[0]=sumnumber[1]=0;
  CURR_N=0;
}
				/* Save better move */
void NEAR bettermove(void)			/* save the best found move */
{
  if(breakflag) return;
  if(NULL_ENABLE && level==nullmove_level) return;
  if(level==0 && betamove) return;
  if(CURR_N>0){
    POSFLAGS&=~P_EVALBEST;
    BEST_N=CURR_N;                          /* CURRENT-1 because */
    movecpy(&BEST,CURRENT-1);               /* "up" make CURRENT++ */
  }
  if(level==0 && !fv0flag){
    EVAL value;
    if(cmp_eval(reverse_eval(&value,&EVAL(level+1)),&EVAL(level)) & GREATER)   /* eval>alfa */
      reverse_eval(&evals[CURRENT-savedfirst-1],&EVAL(level+1));
    show_best();
  }
  fill_betterbranch();
}

static void near badmove(void)		/* dummy */
{
SQUARE_NUM kill_to;
MOVE *kill;
MOVE *mp;

  if(!dinamicorder_en) return;
  if(G_STATUS&G_FORCED) return;
  if(!level || fv1used) return;
  if(we_win() && CURR_N<5 &&    /* We win and one of first moves is killed */
     !(POSFLAGS&P_ADDMOVESORT)){  /* Additional move sorting hasn't happened yet */
    if(!move_exist(&(pos_sp+1)->a.best)) return; /* Killer not exist */
    kill=&(pos_sp+1)->a.best;
    if(!(kill->flags&M_CAPTURE)) return;  /* Killer not capture */
    kill_to=kill->to;
    if(!wy_lose((CURRENT-1),kill)){  /* Lose not becouse of our move */
      int counter=0;
      POSFLAGS|=P_ADDMOVESORT;   /* Additional move sorting has happened */
      LAST=generator(LAST,0);
      for(mp=CURRENT;mp!=LAST;mp++){    /* For all generated moves */
	if(mp->from==kill_to){           /* If escape from attack */
	  if(mp->profit>GIFT_LIMIT){
	    mp->profit=KILLER_PROFIT+20-counter++;  /* Put move before killers */
	  }
	}
      }
      move_sort(CURRENT,mp);
    }
  }
}

int NEAR we_win(void)
{
  if(MAT_DEFICIT<0) return 1;
  if(sumnumber[Our_color]<sumnumber[Enemy_color]) return 1;
  return 0;
}

int NEAR wy_lose(MOVE *move, MOVE *killer)  /* 1 if killer bound with move */
{
  if(move->to==killer->to) return 1;  /* Capture moved piece */

  if(SQUAREP(killer->to)->attackedby.word[Our_color] &
     SQUAREP(move->from)->who_mask.word[Our_color])
    return 1;     /* Capture piece who was defenced before our move */

  if(!(SQUAREP(killer->to)->attackedby.word[Enemy_color] &
       SQUAREP(killer->from)->who_mask.word[Enemy_color]))
    return 1;      /* Capture piece who wasn't attacked before our move */

  return 0; /* We lose not becouse of our last move */
}

static void near endsearch(void)
{
/*static char far mess1[]="Error. Position stack overflow.";*/
static char far mess2[]="Error. Move stack overflow.";
  if(move_exist(&BEST))
     movecpy( &best_move,&BEST );	/* save the best move found during the search */
/*  if(pos_stk[MAXDEPTH-1].curr_n) message(mess1,0);
*/  if((move_stk+MOVE_STACK_SIZE-1)->from) message(mess2,0);
}

/**/
void NEAR swap_moves(MOVE/* far*/ *move1,MOVE/* far*/ *move2)
{
  MOVE buf;
	movecpy(&buf,move1);
	movecpy(move1,move2);
	movecpy(move2,&buf);
}

void NEAR put_eval(int level, MAT_EVAL m, POS_EVAL p)
{
  EVAL(level).material=REALEVAL(level).material=m;
  EVAL(level).position=REALEVAL(level).position=p;  
}

extern WORD trans_mask[NPIECE+1];

//extern PIECE_MASK defencing_piece;  /* Piece defencing another pieces */
static int near evalreliable(void)  /* return 0, if position not reliable */
{
int our_cost=0,enemy_cost=0;
PROFIT_SQ * psqp;

  if(double_attacked(Our_color)) return 0;   /* for new profitable attacked square */
  if(fullselect_en){
	 for(psqp=NEWATTACKED[Our_color]; psqp->square!=DUMMY; psqp++){  /* for new profitable attacked square */
		if(psqp->profit >= QUEEN_COST) return 0;  /* Queen attacked */
		if((psqp->profit > 2) &&
			(SQUAREP(psqp->square)->who_mask.word[Our_color] &
	  DEFENCING_PIECE.word[Our_color])) return 0;  /* Defencing piece attacked */
	 }
	 if((psqp->square != DUMMY) && (psqp->profit > 2)) return 0;
	 if(PIECE_BOUND_MASK[Our_color ][Enemy_color ]) /* King <- enemy <- enemy */
		return 0;
  }
  return 1;


}