/*
	 ͻ
	                    Initialization of data                      
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/

#include <mem.h>           /* NULL */
#include "chess.h"
#include "global.h"
#include "ks_macro.h"
#include "proc.h"
#include "ks_corr.h"
#include "current.h"
#define MIN_XY 0
#define MAX_XY 7
#define ONBOARD(x,y) ( (x)>=MIN_XY && (x)<=MAX_XY && (y)>=MIN_XY && (y)<=MAX_XY )

BYTE square_dirmask[ NSQUARE ]; /*Available queen dir for square*/
BYTE square_kndirmask[ NSQUARE ]; /*Available knight dir for square*/
unsigned int sqnum_to_addr_shift[ NSQUARE ];

DIR direction[NSQUARE][NSQUARE];
			/* direction  between two squares */

/* direction  lup up upr r rd dn dl lf  */
int stepx[NDIR]={ -1, 0, 1, 1, 1, 0,-1,-1 };
int stepy[NDIR]={  1, 1, 1, 0,-1,-1,-1, 0 };
/*               upl upr rup rdn dnr dlf lfd lup */
int kn_stepx[NDIR]={ -2, -1,  1,  2,  2,  1, -1, -2 };
int kn_stepy[NDIR]={  1,  2,  2,  1, -1, -2, -2, -1 };

static void near prepare_dir( SQUARE_NUM square )
{
	BYTE dirmask, kndirmask;
	int file, line, x, y;
	DIR dir, i;

	dirmask=kndirmask=0;
	file=GETFILE( square ); line=GETLINE( square );
	for( dir=0, i=1; dir<NDIR; dir++, i<<=1 ){
		x=file+stepx[dir]; y=line+stepy[dir];
		if( ONBOARD(x,y) ) dirmask|=i;
		x=file+kn_stepx[dir]; y=line+kn_stepy[dir];
		if( ONBOARD(x,y) ) kndirmask|=i;
	}
	square_dirmask[ square ]=dirmask;
	square_kndirmask[ square ]=kndirmask;
}

void prepare_square( SQUARE_NUM square )
{
	int file, line, x, y;
	SQUARE_NUM edge;
	DIR dir;

	file=GETFILE( square ); line=GETLINE( square );
	for( dir=0; dir<NDIR; dir++ ){
		x=file+stepx[dir]; y=line+stepy[dir];
		while( ONBOARD(x,y) ){
			x+=stepx[dir]; y+=stepy[dir];
		}
		edge=GETOFFSET( x-stepx[dir], y-stepy[dir] );
		SQUAREP(square)->edge[dir]=edge;
	}
	SQUAREP(square)->mynum=square;
	WHOONSQUARE(square)->color=NOCOLOR;
	WHOONSQUARE(square)->name=NOPIECE;
	WHOONSQUARE(square)->cost=NOCOST;
}

static void near prepare_direct(void)
{
  SQUARE_NUM src, dest;
  DIR dir;
  int sfile, sline, dfile, dline, deltax, deltay;
					/* direction  between two squares */
    for(src=a1; src<NSQUARE; src++) {
		sfile=GETFILE(src); sline=GETLINE(src);
		for( dest=a1; dest<NSQUARE; dest++ ){
			if( src==dest ){ direction[src][dest]=NODIR; continue; }
			dfile=GETFILE(dest); dline=GETLINE(dest);
			deltax=dfile-sfile; deltay=dline-sline;
			if( deltax==0 )  /* squares is on one file */
				if( deltay>0 ) dir=_UP; else dir=_DOWN;
			else if( deltay==0 )  /* squares is on one line */
				if( deltax>0 ) dir=_RIGHT; else dir=_LEFT;
			else if( deltax==deltay ) /* squares is on a1-h8 diag. */
				if( deltax>0 ) dir=_RIGHT_UP; else dir=_LEFT_DOWN;
			else if( deltax==-deltay ) /* squares is on a8-h1 diag. */
				if( deltax>0 ) dir=_RIGHT_DOWN; else dir=_LEFT_UP;
			else dir=NODIR;  /* squares isn't on some dir */
			direction[src][dest]=dir;
		}
    }
}

BYTE bit_number[256];			/* Convert byte to bit number */
static void near ini_bit_num(void)
{
  int i;
  int n;
    for(i=0; i<256; i++) bit_number[i]=0;
    for(i=1,n=0; i<256; i*=2,n++) bit_number[i]=n;
}
static void near init_sqnum_to_addr_shift(void)
{
SQUARE_NUM i;
    for(i=a1;i<=h8;i++)
      sqnum_to_addr_shift[i]=i*sizeof(SQUARE_INFO);
}

void prepare( void )
{
	int i;

	for( i=0; i<TOTAL_NUM_PIECE; i++ ){
		PIECE_LIST[i].where=DUMMY;
	}
	init_sqnum_to_addr_shift();
	for( i=0; i<64; i++ ){
		prepare_dir( i );
		prepare_square( i );
	}
	prepare_direct();
	ini_bit_num();	/* W.K. */
}
