/*
	 ͻ
	                Header file for search and cascade              
	                 programmed  by  I.Shabalin                     
	 ͼ
*/
#ifndef _KS_GAME_H
#define _KS_GAME_H

#ifndef _CHESS_H
#include"chess.h"
#endif

typedef enum {
  NO_PRINT=0,          /* Print nothing. */
  PRINT_ALL=0x1,       /* Print all variants. */
  PRINT_VARIANT=0x2,   /* Print entered variant. */
  PRINT_NUMBER=0x4,    /* Print variants with the namber of positions */
			  /* from start number to stop number. */
  PRINT_KILLER=0x8,    /* Print variants with the nuber of killer move is */
			  /* more than defined number. */
  PRINT_LEVEL=0x10,    /* Print to defined level. */
  PRINT_OVERFLOW=0x20, /* Print variant at depth greater than defined depth. */
  PRINT_BESTBRANCH=0x40,  /* Not used. */
  PRINT_HASH=0x80,       /*Print pos hash statistics*/
  PRINT_SELECTIVE=0x100  /* Print selective deeperning position */
}   PRINT_FLAG;

typedef enum {
  FV0=0,
  C03,
  C13,
  C15,
  C25,
  C27,
  C37,
  C39,
  C49,
} SEARCH_STATUS;

typedef unsigned long SHORT_POS;

#define MAXBRANCHDEPTH 16
#define MAXPRINTLEVEL 16

#define MAXSEARCHPASS 1
#define NUM_MOVES_IN_POS 100

typedef enum {
  NOBREAK=0,
  TERMINATE=1,
  MAKECURRENT=2,
  WRONGGUESS=3,
  TIMEBREAK=4
} BREAKFLAGS;

extern BREAKFLAGS breakflag;



#define MYTIME    0          /* What time I use for think */
#define ENEMYTIME 1
extern int thinktime;

extern SEARCH_STATUS search_status;
extern begin_level;
extern SEARCH_STATUS search_status;

extern int print_level;
extern PRINT_FLAG print_flag;
extern int printsmth;

extern int print_fv;
extern long start_print_num;
extern long stop_print_num;
extern int killer_print_num;
extern LSTRING far variant_str;
extern int print_overflow;
extern int print_time;
extern int print_full_eval;
extern int print_hash;
extern LSTRING old;
extern BOOLEAN fvflag;
extern BOOLEAN fv0flag;
extern BOOLEAN fv1flag;
extern BOOLEAN cascadeflag;
extern MOVE *savedfirst;                       /* Saved first move pointer. */
extern BOOLEAN print_eval_flag;
extern long int lambda;
extern long int lambdafv;
extern long int lambdasearch;
extern int lambdamove[NUM_MOVES_IN_POS];
extern long int lambdaeval;
extern int fv1movenumber;
extern int fv0movenumber;
extern unsigned long n_best;
extern unsigned long sum_best;

  /* Some global things for search. */


extern EVAL evals[NUM_MOVES_IN_POS];
extern int minnslow;     /* Minimal quantity of slow moves at the brunch */
extern int mindepth;     /* The depth of full search */
extern int minncheck;    /* Minimal quantity of check moves at the brunch */
extern int nforcedcheck;
extern BOOLEAN check_is_slow;
extern BOOLEAN no_moves;
extern BOOLEAN repeat_flag;
extern int cutoffnum;

extern int last_to_repeat;    /* Number of last positon in game_stk. */
extern int last_repeated;     /* Number of last positon in repeat_stk. */
extern int pos_repeated;
extern int drawflag;
extern int searchpass;
extern int istep;
extern EVAL alfa,beta;
extern BOOLEAN betastop,alfaeval;
extern int posbetastop;
extern MOVE *betamove;
extern MOVE *posbetamove;
extern int betamovefound;
extern int posbetamovefound;
extern int timebreak;
extern int nround;                        /* The current number of round */


 /* File ks_debug.c */

void NEAR init_debug(void);  /* Init debug variables at the beginning of program. */
void NEAR start_debug(void);  /* Init debug variables at the beginning of search. */
void NEAR russian_debug(void);    /* Trace all needed information about position. */
BOOLEAN NEAR decodvarstr(char far *str,MOVE *mp);  /* Decode entered variant into the */
int check_variant( void );     /* Return FALSE, if entered variant is empty. */

 /* File ks_trace.c */

void NEAR show_current(void);
void NEAR show_best(void);
void NEAR show_fv0best(void);


 /* File ks_game.c */

void NEAR swap_evals(int i,int j);    /* Swap evals in evals[]. */
void NEAR swap_lambda(int i, int j);
int make_move(MOVE *movep);  /* Make move in game. */
int init_game(void);      /* Init all variables for the begining off game. */
MOVE * get_move(void);     /* Return the best Kaissa move. */
void NEAR change_repeated(void); /* Make information about repeat case. */
int NEAR checkrepeat(unsigned long hash); /* Return 1, if position repeated */
int NEAR checkrepeattree(unsigned long hash); /* Return 1, if position repeated at searchtree*/
int NEAR start_repeat(void);
void set_game_stk(void);

typedef enum {
  KAISSA=3,
  MAN_KAISSA=2,
  KAISSA_MAN=1,
  MAN_MAN=0,
  ANALYSE=4,
  MONITOR=5,
} WHOPLAY; /* players */
extern SQUARE_NUM cursquare, redsquare;
extern WHOPLAY whomove; /* current player: user/computer  */
extern int debut;         /* begin is debut */
extern int analyse;       /* search one move and not do it */
extern int enemytime;     /* think enemy time */
extern int issound;
extern int usedebut;
extern int enemy_move_done;
extern int enemy_move_exist;
extern int uselink;
extern int accumflag;  /* Accumulate replyes in Kaissa.sav */

extern int sumnumber[NCOLOR];


int setcolor( PIECE_COLOR color );

extern SQUARE_NUM en_passant_square;
extern char en_passant_str[20];
int checkenpassant(void);
int setwhomove(WHOPLAY newwhomove);
void NEAR copy_position_n( void ); /*copy near part of position */

void make_bak_file_name(char far * bakfilename, char far * path);
int make_bak_file(char far * path);

#endif