		/**\
		 	Program file "ks_game.c"	
		 					
		 	       Functions: init_game()	
		 		      get_move()	
		 		      make_move()	
		\**/
/*extern unsigned int _stklen=2000;
extern unsigned int  _heaplen=2;*/
#include <stdio.h>
#include <mem.h>
#include <string.h>
#include <conio.h>
#include <time.h>

#include "face.h"
#include "faceproc.h"
#include "facelib.h"

#include "lang.h"
#include "chess.h"
#include "global.h"
#include "ks_game.h"
#include "current.h"
#include "proc.h"
#include "ksichess.h"
#include "ksitimer.h"
#include "ksiwind.h"
#include "ks_macro.h"
#include "ks_eval.h"
#include "entime.h"
#include "hashpawn.h"
#include "hashpos.h"
#include "experim.h"
#include "ksiwind.h"
#include "interfac.h"
#include "message.h"

extern int flPassExt,flPassGen;
int NEAR PassagePawn(void);
void NEAR calc_pawns_lines(void);
int flTurnir=0;

int showchar( char c, int p, char attr );


	  /* Functions. */

static EVAL * near sortmove(void);            /* Sort moves in move_stk, according */
					/*  to there evaluation in evals[].  */
					/* Return best evaluation. */

static int near gamepostohash(void); /* Put all positions from game_stk into hash table */

/*static void near sortmovetolambda(void);*/
static void near fv0(void);                  /* Make fv0. */
static void near fv1(void);                  /* Make fv1. */
static void near cascade(void);              /* Make cascade. */
static void near inf_print(int minnslow,int mindepth,int nround,int mateval);
			  /* Print information about cascade and round. */
static void near inf_print_fv0(void);        /* Print "Fv0". */
static void near inf_print_fv1(void);        /* Print "Fv1". */
static int near make_down (void);            /* Make current move. Go down tree. */
static int near make_up(void);              /* Go up tree. */
static int near showtime(clock_t tstop,clock_t tstart,long lambda,char far *message);
		/* Show time between tstart and tstop in reply window. */
static void near set_cascade_parametrs(void);   /* Set cascade table and cascade number, */
				    /* according to search_status. */
static void near set_cascade_table(int s1,int d1,int s2,int d2,int s3,int d3,int s4,int d4);
					    /* Fill cascade table. */
static void near startsearch(void);     /* Set all variables before Kaissa */
				       /* choose her move. */

#define ALFADIR 1     /* Evals of all moves are less then alfa. */
#define BETADIR 2     /* Evals of more than one move are greater than beta. */
#define STEPNUMBER 5    /* The number of steps in changing eval in one */
				/* direction. */
#define MAXNCASCADE 4   /* Maximum  number of cascades. */
#define NCASCPARAM 2    /* Number of cascade parametrs. */
#define HALFPAWN 1      /* Half of pawn's cost. */

     /* Global variables. */

MOVE  move_stk[MOVE_STACK_SIZE];	/* Move stack. */
int level;				/* Current level. */
PIECE_COLOR turn_move=WHITE_PIECE;      /* Turn to move in root position. */
unsigned long int n_best,sum_best;      /* ??? */

int searchpass;                         /* Current cascade number. */
int nround;                             /* The current number of round */
EVAL evals[NUM_MOVES_IN_POS];           /* Array for evals of moves. */
EVAL besteval0;                         /* The eval of best move. */

MOVE bestfv0;                           /* Best move after fv0 */
MOVE bestanswerfv1;                     /* Best answer after fv1 */

int besteval1;
int fv0movenumber;			/* the number of our move */
int fv1movenumber;                      /* The number of enemy moves after */
					/*  our best move. */
EVAL alfa,beta;                         /* Alfa and beta for seachtree. */
BOOLEAN betastop;                       /* Set TRUE, if evals of more than */
					/* one move are greater than beta. */
MOVE *savedfirst;                       /* Saved first move pointer. */
MOVE *betamove;          /* The first move, which eval is greater than beta. */
/*MOVE *posbetamove;       /* The first move, which eval is greater than beta. */
*/
int betamovefound;       /* Set, when fount that move. */
/*int posbetamovefound;
*/
int minnslow;              /* Minimal quantity of slow moves at the brunch. */
int mindepth;              /* The depth of full search. */
int ncascade=1;            /* The maximum number of cascade. */
int thinktime=MYTIME;          /* Thinking: my time or enemy time */
int istep;                 /* Current step number. */
SEARCH_STATUS search_status=C13 ;  /* Current search status */
int nforcedcheck=1;    /* The number of check, which is not counted as slow. */
MOVE nullmove;       /* ??? */
int nullmovedone=0;   /* First null move done */
int accumflag;  /* Accumulate replyes in Kaissa.sav */

char  cascadetable[MAXNCASCADE][NCASCPARAM]={{1,3},{1,5},{1,7}};
						 /* Table of cascade parametrs. */
MAT_EVAL firstroundmaterial;

static MAT_EVAL steps[STEPNUMBER+1]={2,2,4,8,8,8};  /* Steps to change alfa */
				     /* and beta, if eval is out off board. */

#define put_search_stk(hash)                         \
  if(level<SEARCH_STACK_SIZE ) search_stk[level]=hash

void initmoveprofit(void);
int init_game(void)    /* Init all variables for the begining of game. */
{
  pos_stk=pos_stk;
  turn_move=WHITE_PIECE;
  init_eval();
  init_killer();
  init_debug();
  readrandom();
  initmoveprofit();
  return(0);
}

MOVE * search(void)
{
clock_t time1,time2;
static char far mess1[]="No move !\n";
static char far mess2[]="Total time.";
static char far mess3[]="No best move !\n";
static char far mess4[]="No first move !\n";

    emptystate( small ); if(thinktime==MYTIME) refresh( small );
/*  emptystate( reply );*/

  setbeginsearch();
  clear_move(&bestanswer0);
  startsearch();
  time1=clock();
  fvflag=TRUE;
  fv0flag=TRUE;
  cascadeflag=FALSE;
  fv0();
  fv0flag=FALSE;
  if (FIRST==LAST) return(NULL);
  if (breakflag) return(FIRST);
  if (besteval0.material==MAT_INFINITY) return(FIRST);
  time2=clock();
  if(print_time) showtime(time2,time1,lambda,"");
/*  if(print_fv) print_betterbranch(); */
  if(LAST==FIRST) {                          /* No moves. */
    lastlinereply(mess1);
    return(NULL);
  }
  if(LAST-FIRST==1){ /* If there is only one move, return it. */
	  movecpy( &best_move, FIRST );
	  return(&best_move);
  }
  if(search_status==FV0) return(&best_move);
#if FV1_USED
  fv1();
#endif
  fvflag=FALSE;
  cascadeflag=TRUE;
  if (breakflag) return(FIRST);
  cascade();
  checkface( windowsave( reply, kaissa_sav, 'a' ) );
  cascadeflag=FALSE;
  time2=clock();
stopsearch:   /* terminate search and make current best move */
  if(print_time) showtime(time2,time1,lambda, mess2);
  if(move_exist(&best_move)) return(&best_move);
  else {
	lastlinereply(mess3);
	movecpy( &best_move, FIRST );
	if(move_exist(&best_move))  return(&best_move);
    lastlinereply(mess4);
    return(NULL);
  }
}

MOVE * get_move(void)      /* Return the best Kaissa move. */
{
MOVE *mp;

  if( answer_ready && movecmp( pos_stk->a.previous, &bestanswer ) ){
	  answer_ready=0;
	  openwindow( small );
	  return( &kaissa_move );
  }
  answer_ready=0;
  if(thinktime==MYTIME) {
	openwindow(small);
	emptystate( reply );
	setprintflag();
	replacehelpline(interruptstr);
  }
  mp=search();
  replacehelpline(helpstr);
  return(mp);
}

int make_move( MOVE *movep )    /* Make move in game. */
{
int done;         /* 0 = OK, 1 = End of game, -1 = ERROR */
    movecpy(move_stk,movep); /* save meking move in stack */
#ifdef NEAR_POS_USED
/*  ks_farmemcpy(&(pos_stk->n),&position,sizeof(NEAR_POSITION));NEW */
#endif
    CURRENT=move_stk; LAST=move_stk+1; /* set MOVE pointers */
    turn_move=REVCOLOR( turn_move ); /* where use turn_move  */
    done=make_down();        /* make move down */
    if( done==ERROR ) return( ERROR ); /* can't down */
    PREVIOUS=move_stk;
    MEMCPY(pos_stk,pos_stk+1,sizeof(POSITION));
    level=0; pos_sp=pos_stk; /* return to 0 level */
    change_repeated();
    return(0);
}

/*------------------------------------------------------------------------*/

static void near fv0(void)
{
int done,i;

  inf_print_fv0();
  /* We need setpos here. */
  FIRST=move_stk+1;
  for(i=0;i<NUM_MOVES_IN_POS;i++){                    /* Set evals array. */
    evals[i].material=-MAT_INFINITY+NUM_MOVES_IN_POS-i;
    evals[i].position=-POS_INFINITY;
  }
  alfa.material=-MAT_INFINITY;
  alfa.position=-POS_INFINITY;
  beta.material=MAT_INFINITY;
  beta.position=POS_INFINITY;
  level=0;
  *old=' ';*(old+1)='\0';

  savedfirst=FIRST;
  CURR_N=0;
  G_STATUS=G_NORMAL;
  LAST=generate_all(FIRST);
  fv0movenumber=(int)(LAST-FIRST);
  if(fv0movenumber<=1)return;

  if(!CHECK){
	nullmovedone=1;
	CURRENT=move_stk; /*CURRENT=FIRST;*/
	/*LAST=FIRST+1;*/
	form_nullmove(CURRENT);
	make_down();
	G_STATUS|=G_FORCED;
	searchtree();
	if (breakflag==TIMEBREAK) make_up();
	if (breakflag){ nullmovedone=0; return; }
	besteval0.material=-EVAL(level).material;
        beta.material=EVAL(level).material /* May be (+2) ? */;
	make_up();
        nullmovedone=0;
  }

  CURRENT=FIRST;
 /*
  savedfirst=CURRENT;
  CURR_N=0;
  G_STATUS=G_NORMAL;
  LAST=generate_all(CURRENT);
  fv0movenumber=(int)(LAST-FIRST);
 */
  while((done=make_down())!=0){
    if(done==-1) {                   /* Skip illegal move */
      evals[CURRENT-FIRST-1].material=-MAT_INFINITY;
      evals[CURRENT-FIRST-1].position=-POS_INFINITY;
      continue;
    }
    G_STATUS|=G_FORCED;
    searchtree();
    if(breakflag){   /* If search was breaked put "-INFINITY" into evals[]. */
      if (breakflag==TIMEBREAK) make_up();
      evals[pos_stk[0].a.current-pos_stk[0].a.first].material=-MAT_INFINITY;
      evals[pos_stk[0].a.current-pos_stk[0].a.first].position=-POS_INFINITY;
      return;
    }
/*  else reverse_eval(&evals[pos_stk[0].current-pos_stk[0].first],&EVAL(level));
*/  else{         /* 1 string to 7   31.07.90. I.Sh. */
      if(EVAL(level).material<beta.material ||
	 EVAL(level).material==beta.material &&
	 EVAL(level).position<beta.position) {
         evals[pos_stk[0].a.current-pos_stk[0].a.first].material=-EVAL(level).material;
      }
      evals[pos_stk[0].a.current-pos_stk[0].a.first].position=-EVAL(level).position;
    }
            /* If search wasn't breaked, put eval of move into evals[]. */
    make_up();
    if(EVAL(level+1).material<beta.material){  /* If current move is better, */
      beta.material=EVAL(level+1).material;     /* raise the low board. */
      bettermove();
    }
  }
  cpy_eval(&besteval0,sortmove());  /* Sort our moves and copy best eval */
				    /*  into besteval0. */
  set_killer0();
  besteval1=evals[1].material; /* Save the material eval of the second move. */
  if(LAST!=FIRST){
	movecpy(&BEST,FIRST);
	movecpy(&best_move,FIRST); /* Ch. BEST to best_move AD */
	movecpy(&bestfv0,FIRST);
  }
  show_fv0best();
}

void form_nullmove(MOVE *mp)
{
 mp->flags=M_NULLMOVE;
}

static void near fv1(void)
{
int done;
  inf_print_fv1();
  *old=' ';*(old+1)='\0';
  beta.material=besteval0.material;
  CURRENT=FIRST;
  done=make_down();
  CURRENT=FIRST;
  CURR_N=0;
  G_STATUS=G_NORMAL;

  if(flPassGen){ calc_pawns_lines(); PassagePawn(); }
  LAST=generate_all(CURRENT);
  while((done=make_down())!=0){
    if(done==-1) { /* Skip illegal move */
      evals[pos_stk[1].a.curr_n-1].material=-MAT_INFINITY;
      evals[pos_stk[1].a.curr_n-1].position=-POS_INFINITY;
      continue;
    }
    G_STATUS|=G_FORCED;
    searchtree();
    if (breakflag==TIMEBREAK) { make_up(); make_up(); }
    if (breakflag) return;
    reverse_eval(&evals[pos_stk[1].a.curr_n-1],&EVAL(level));
    if(EVAL(level).material<beta.material)
      beta.material=EVAL(level).material;
    make_up();
  }
  sortmove();
  movecpy(&bestanswerfv1,FIRST);
  set_killer1();
  fv1movenumber=(int)(LAST-FIRST);
  if(print_flag) russian_debug();  /* As in russian */
  make_up();
}

void NEAR start_killer(void);

static void near startsearch(void)   /* Set all variables before Kaissa choose her move */
{
  extern int nmove;
  lambda=0; lambdafv=0; lambdaeval=0;
/*  if(timecontrol) showsearchtime();*/
  betastop=FALSE;
  betamovefound=0;
  party_status();
  MATERIAL_EVAL=material_eval(pos_sp);
/*  begin_bound();*/
  set_cascade_parametrs();
  minnslow=0;mindepth=0;
  NSLOW=0;
  NCHECK=0;
  NFVCHECK=0;
  check_is_slow=FALSE;
  pos_sp= pos_stk; level=0;		/* set up position stack	*/
  PREVIOUS=move_stk;
  clear_move(&best_move);
  if(print_flag) start_debug();
  init_killer();
  clear_betterbranch();
/*  start_killer();*/
/*  pos_reset_hash(); pawn_reset_hash(); */
/*  pos_calc_hash();  /* A.S. 11.1.91 */*/
  if(hash_enable) pos_init_hash();
  if(pawn_hash_enable) pawn_init_hash();
//A.S.4.6.91  gamepostohash();   /* Put all positions from game_stk into hash table */
  if(!accumflag) MYUNLINK(kaissa_sav);
  startnullstatistic();
  startselectstatistic();
  Our_color=MOVE_COLOR;
  Enemy_color=reverse_color(Our_color);
  if (flPassExt && (mat_without_pawns[0]+mat_without_pawns[1] < 35))
	flPassGen=1;
  else flPassGen=0;
  if(flPassGen){ calc_pawns_lines(); PassagePawn(); }
}

static void near set_cascade_parametrs(void)
{
  flTurnir=0;
  switch(search_status){
	case FV0: break;
	case C03: ncascade=1;
		  set_cascade_table(0,3,0,5,0,7,4,9);
		  break;
	case C13: ncascade=1;
		  set_cascade_table(1,3,1,7,1,7,4,9);
		  break;
	case C15: ncascade=2;
		  set_cascade_table(1,3,1,5,1,7,4,9);
		  break;
	case C25: ncascade=2;
		  set_cascade_table(1,3,2,5,2,7,4,9);  /* 3.1 -> 5.2 */
		  break;
	case C27: ncascade=3;
		  set_cascade_table(1,3,2,5,2,7,4,9);
		  break;
	case C37: ncascade=3;
		  set_cascade_table(1,3,2,5,3,7,4,9);
		  break;
	case C39: ncascade=4;
		  set_cascade_table(1,3,2,5,3,7,3,9);
		  break;
	case C49: ncascade=4;
		  flTurnir=1;
		  set_cascade_table(1,3,2,5,3,7,4,9);
		  break;
  }
}

static void near set_cascade_table(int s1,int d1,int s2,int d2,
				   int s3,int d3,int s4,int d4)
{
  cascadetable[0][0]=s1;    /* First cascade - minnslow */
  cascadetable[0][1]=d1;    /* First cascade - mindepth */
  cascadetable[1][0]=s2;    /* Second cascade - minnslow */
  cascadetable[1][1]=d2;    /* Second cascade - mindepth */
  cascadetable[2][0]=s3;    /* Third cascade - minnslow */
  cascadetable[2][1]=d3;    /* Third cascade - mindepth */
  cascadetable[3][0]=s4;    /* 4-th cascade - minnslow */
  cascadetable[3][1]=d4;    /* 4-th cascade - mindepth */
}

static void near cascade(void)
{
clock_t time1,time2;
int i,istart;
int dir_flag;       /* May be 0, ALFADIR or BETADIR. */
BOOLEAN step_flag;  /* Set FALSE, if the direction of board shifting was */
		    /* changed. */
BOOLEAN alfaeval;   /* Set TRUE, if evals of all moves are less then alfa. */
MAT_EVAL step=0;    /* Step for changing alfa and beta, if nessesary. */

/*  set_killer(); */
  if(besteval0.material>besteval1){
      alfa.material=besteval0.material-HALFPAWN;
      beta.material=besteval0.material-HALFPAWN;
  } else {
    alfa.material=besteval0.material;
    beta.material=besteval0.material;
  }
  for(searchpass=0; searchpass<ncascade && !breakflag; searchpass++){
	if(searchpass && !gonextcascade()) break;  /* Do not go to the next cascade. */
    minnslow=cascadetable[searchpass][0];
    mindepth=cascadetable[searchpass][1];
    alfa.position=-POS_INFINITY;
    beta.position=POS_INFINITY;
    firstroundmaterial=alfa.material;
/*    if(mat_without_pawns[WHITE_PIECE]+mat_without_pawns[BLACK_PIECE]<60 &&
       timecontrol) minnslow++;  /* Raise number of still moves, if few pieces at board. */
*/
    for(i=0;i<NUM_MOVES_IN_POS;i++){     /* Set evals array. */
      evals[i].material=-MAT_INFINITY+NUM_MOVES_IN_POS-i;
      evals[i].position=-POS_INFINITY;
    }
    step_flag=TRUE;
    istep=0;
    dir_flag=0;
	FIRST=move_stk+1;
	savedfirst=FIRST;
    for(nround=1;;nround++){   /*  While eval is not in border */
      inf_print(minnslow,mindepth,nround,alfa.material);
      *old=' ';*(old+1)='\0';
      level=0;
      time1=clock();
      BEST.from=DUMMY;	/* no best move on the round */
	searchtree();

      time2=clock();
      if( hash_enable && print_flag & PRINT_HASH )  print_deb_pos_hash();
      if( pawn_hash_enable && print_flag & PRINT_HASH ) print_deb_pawn_hash();
      print_betterbranch();
      if(print_time) showtime(time2,time1,lambdasearch,"");
      if(breakflag) break;

      istart=FIRST-move_stk-1;
      for(alfaeval=TRUE,i=istart;i<istart+(LAST-FIRST);i++){
	if(cmp_eval(&evals[i],&alfa)&GREATER){
	  alfaeval=FALSE;              /* Set alfaeval, if evals of */
	  break;                       /* all moves are less then alfa. */
	}
      }
													/* If mate eval or */
      if(!betastop && !alfaeval) break;  /* Eval is in border, go to the next */
						/* cascade. */							/* prune this cascade */

      if(betastop){   /* Evals of more than one move are greater than beta. */
	if(dir_flag==ALFADIR) step_flag=FALSE;
	dir_flag=BETADIR;
	step=(step_flag)? steps[istep++] : HALF(step);
	alfa.material+=step;
	beta.material+=step;
	FIRST=CURRENT-2;
	swap_moves(FIRST,betamove);
	swap_evals((int)(FIRST-move_stk-1),(int)(betamove-move_stk-1));
	swap_lambda((int)(FIRST-move_stk-1),(int)(betamove-move_stk-1));
      }
      if(alfaeval){    /* Evals of all moves are less then alfa. */
	if(dir_flag==BETADIR) step_flag=FALSE;
	dir_flag=ALFADIR;
	step=(step_flag)? steps[istep++] : HALF(step);
	alfa.material-=step;
	beta.material-=step;
      }
      if(step==0){
	putinfo(3,1,"Error in rounds. Step==0 ");
	break;
      }
      if(istep>STEPNUMBER) break;     /* Mate eval is found, go to the next */
      if(REALEVAL(level).material==MAT_INFINITY) break;   /* cascade. */
    } /* while */
/*  if (beta.material==MAT_INFINITY ||
	 (beta.material==MAT_INFINITY-HALFPAWN &&
		beta.position>POS_INFINITY-10)) break; */
    if(REALEVAL(level).material==MAT_INFINITY) break;             /* stop if mate */
    FIRST=savedfirst;
	sortmove(); /*if(!breakflag) sortmovetolambda();*/
    besteval0.material=alfa.material;
	movecpy(&BEST,FIRST);
	movecpy(&best_move,FIRST); /* AD 12 june 90 */
//    if (ncascade==2 && party_flag==ENDGAME && timecontrol) ncascade=3;
    if (flTurnir && timecontrol) {
       int mt=mat_without_pawns[WHITE_PIECE]+mat_without_pawns[BLACK_PIECE];
       if (searchpass==1 && mt >=60 ) break;
       if (searchpass==2 && mt >=10 ) break;
    }
  } /* for */
  if( print_hash ) print_deb_pos_hash();
  if( nullstatistic ) printnullstatistic();
  if( selectstatistic ) printselectstatistic();
  showusedtime();
  if(!move_exist(&bestanswer0) && movecmp(&BEST,&bestfv0))
    movecpy(&bestanswer0,&bestanswerfv1);
}

static EVAL * near sortmove(void)
{
int i,j,imax;
EVAL max;
  for (j=0;j<LAST-FIRST;j++){
    max.material=-MAT_INFINITY;
    max.position=-POS_INFINITY;
    for (imax=i=j;i<LAST-FIRST;i++)
      if ( cmp_eval( &max,&evals[i]) & LESS ){
	cpy_eval( &max,&evals[i]);
	imax=i;
      }
    swap_evals(imax,j); swap_lambda(imax,j);
    swap_moves(FIRST+imax,FIRST+j);
  }
  return(evals);
}

#define NORMALEVALLIMIT -500
/*static void near sortmovetolambda(void)
{
int i,j,imax;
int max;
  for(j=0;evals[j].material>NORMALEVALLIMIT;j++); /* Skip sorted moves. */
  for (;j<LAST-FIRST;j++){
    max=0;
    for (imax=i=j;i<LAST-FIRST;i++)
      if ( max<lambdamove[i] ){
	max=lambdamove[i];
	imax=i;
      }
    swap_evals(imax,j); swap_lambda(imax,j);
    swap_moves(FIRST+imax,FIRST+j);
  }
} */


static int near make_down (void)              /*  0 - No move to make */
{                                 /*  1 - move is OK */
				  /* -1 - illegal move */
  if(CURRENT==LAST) return(0);	  /* "down()" failed */

/*  copy_position_n(); /*copy near part of position */*/

  if(move()){    /* Move is not legal. */
	move_back();
	CURRENT++;
    return(-1);
  }
  lambda++;
  CURR_N=CURR_N+1;
  level++; pos_sp++;
  Our_color=MOVE_COLOR;
  Enemy_color=reverse_color(Our_color);
  clear_betterbranch();

  showchar( 0x11, level, RED +16*BLUE );
  return(1);	            /* down succeeded	*/
}

static int near make_up(void)
{
  showchar( '_', level,  RED +16*BLUE  );
  level--; pos_sp--;
  Our_color=MOVE_COLOR;
  Enemy_color=reverse_color(Our_color);
  move_back();
  if(breakflag) CURRENT=LAST;   /*2.04.90. Shabalin*/
  else CURRENT++;
  return (TRUE);
}

static int near showtime(clock_t tstop,clock_t tstart,long lambda, char far *message)
{
unsigned long i;
SSTRING prn;
static char far form1[]=" CPU time used = %lu.%lu [s]";
static char far form2[]=" Move number = %lu ";
static char far form3[]=" Speed = %lu [moves/s]";
static char far form4[]=" Search breaked at move number %2d.";

     if(*message) lastlinereply(message);
     i=tstop-tstart;
	 farsprintf( prn, form1,CLOCKTOSEC(i),CLOCKTOSEC(i*1000)%1000);
	 lastlinereply(prn);	 /*lastlinesmall(prn);*/
	 i=SECTOCLOCK(lambda)/((i)?i:1);
	 farsprintf(prn, form2,lambda);
	 lastlinereply(prn);	 /*lastlinesmall(prn);*/
	 farsprintf(prn, form3,i);
	 lastlinereply(prn);	 /*lastlinesmall(prn);*/
     if(breakflag){
       farsprintf(prn, form4,CURR_N);
	   lastlinereply(prn);	 /*lastlinesmall(prn);*/
     }
     return(0);
}

void NEAR swap_evals(int i,int j)
{
EVAL buf;
  cpy_eval(&buf,evals+i);
  cpy_eval(evals+i,evals+j);
  cpy_eval(evals+j,&buf);
}

void NEAR swap_lambda(int i, int j)
{
int buf;
  buf=i;i=j;j=buf;
}

/*-------------All for tree time repeated positions.------------------------*/

static void near put_game_stk(HASH_NUMBER hash);
static void near put_repeat_stk(HASH_NUMBER hash);
#define posequal(hash1, hash2) ((hash1)==(hash2))/* Return 1, if positions */

#define GAME_STACK_SIZE   50
#define REPEAT_STACK_SIZE 30
#define SEARCH_STACK_SIZE 8

HASH_NUMBER far game_stk[GAME_STACK_SIZE];      /* Game positions. */
HASH_NUMBER far repeat_stk[REPEAT_STACK_SIZE]; /* Positions, which was repeated. */
HASH_NUMBER far search_stk[SEARCH_STACK_SIZE]; /* Positions, meeted in current branch. */

int first_to_repeat=0;   /* Number of first positon in game_stk. */
int last_to_repeat;    /* Number of last positon in game_stk. */
int last_repeated;     /* Number of last positon in repeat_stk. */

int pos_repeated;      /* Set TRUE when some game position where repeated. */
int drawflag;          /* Set TRUE when some game position where repeated  */
							/* at the third time. */
void NEAR change_repeated(void)   /* In the end of make_move(). */
{
HASH_NUMBER hash;              /* Current position. */
BOOLEAN repeat_flag;           /* Set TRUE when meet repeated position. */
int i;

  if(WHOONSQUARE(PREVIOUS->to)->name==PAWN || POSFLAGS & P_CAPTURE){     /* Pawn's move or capture. */
    pos_repeated=0;
    last_repeated=0;
    last_to_repeat=0;
  }
  hash=HASH;
  repeat_flag=0;
  drawflag=0;
  for(i=0;i<last_repeated;i++)
	if(posequal(hash,repeat_stk[i])){
		/* Position repeated third time. */
	  drawflag=1;
	  return;
	}

  for(i=0;i<last_to_repeat;i++){
    if(posequal(hash,game_stk[i])){
	/* Position repeated. */
      put_repeat_stk(hash);
      repeat_flag=1;
      pos_repeated=1;
      break;
    }
  }

  if(!repeat_flag) put_game_stk(hash);
}

void set_game_stk(void)
{
  game_stk[0]=HASH;
  last_to_repeat=1;
  last_repeated=0;
  pos_repeated=0;
  drawflag=0;
}

int NEAR checkrepeat(HASH_NUMBER hash)  /* Return 1, if position repeated */
{
int i;

  if(nullmovedone) return(0);
  for(i=0;i<last_to_repeat-1;i++){
    if(posequal(hash,game_stk[i])) return(1);
  }
  return ( checkrepeattree(hash) );
}

int NEAR checkrepeattree(HASH_NUMBER hash)  /* Return 1, if position repeated */
{
int i;
  i=level-4;
  if(i >= SEARCH_STACK_SIZE){
    i=SEARCH_STACK_SIZE;
    i^=((level^i)&1);
  }
  for(;i>=0;i-=2){
    if(posequal(hash,search_stk[i])) return(1);
  }
  put_search_stk(hash);
  return(0);
}
/*
static int near gamepostohash(void) /* Put all positions from game_stk into hash table */
{
int i;

  if(!pos_hash_enable) return(0);
  for(i=0;i<last_to_repeat;i++){
    zeroevaltohash(game_stk[i],1);
  }
  return(0);
}
*/
int NEAR start_repeat(void)
{
  return(0);
}

static void near put_game_stk(HASH_NUMBER hash)
{
  game_stk[last_to_repeat]=hash;
  if(last_to_repeat!=GAME_STACK_SIZE-1) last_to_repeat++;
}

static void near put_repeat_stk(HASH_NUMBER hash)
{
  repeat_stk[last_repeated]=hash;
  if(last_repeated!=REPEAT_STACK_SIZE-1) last_repeated++;
}


/*********** End repeat position routines ******************/

static void near inf_print(int minnslow,int mindepth,int nround,int mateval)
{
  SSTRING buf;
static char far form1[]=" Iteration %1d.%1d;  round %2d (mat.eval %2d)";
  farsprintf(buf, form1, mindepth,minnslow,nround,mateval);
  putinfo(3,1,buf);
/*  if(printsmth) */ lastlinereply(buf);
}

static void near inf_print_fv0(void)
{
static char far mess1[]="Think at enemy time:";
  if(thinktime==ENEMYTIME) if(printsmth) lastlinereply(mess1);
  if(printsmth) lastlinereply("Fv0");
  putinfo(3,1," Fv0");
}

static void near inf_print_fv1(void)
{
  if(printsmth) lastlinereply("Fv1");
  putinfo(3,1," Fv1");
}
