
                /**\
                       Program file "eval_ut.c"        
                                                       
                \**/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <dir.h>
#include <sys\stat.h>
#include <mem.h>
#include <dir.h>
#include "facelib.h"

#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "proc.h"
#include "pos_eval.h"
#include "ks_eval.h"
#include "face.h"
#include "faceproc.h"
#include "facekeys.h"
#include "facemouse.h"
#include "ksiwind.h"
#include "ks_game.h"
#include "interface.h"
#include "infc_func.h"
#include "menu.h"
#include "menu_func.h"

char far EVAL_NAME[MAX_POINT][50]={
 {" Isolated pawns"},
 {" Isolated pawns on semiopen lines"},
 {" Doubled pawns"},
 {" Phalanga"},
 {" Pawns in center"},
 {" Pawn attacks"},
 {" Pawn attacks on center"},
 {" Backward pawns "},
 {" Strong squares"},
 {" Pawn attacks adjacent to enemy king"},
 {" Pawn attacks on enemy pieces"},
 {" Pawns blocked by enemy on F and C files"},
 {" Pawns blocked on D and E files"},
 {" Semipassed pawns"},
 {" Passed pawns"},
 {" Bishop/knight attacks enemy rook/queen"},
 {" Rooks on seventh line"},
 {" Rooks on seventh line in endgame"},
 {" Profitable attacks on bound pieces"},
 {" Double profitable attacks"},
 {" Bishops and knights at initial squares"},
 {" Knights on strong squares"},
 {" Bishops on strong squares"},
 {" Piece attacks on center"},
 {" Rooks on open and semiopen lines"},
 {" Two bishops exist"},
 {" Knight and queen exist"},
 {" Knights in center"},
 {" Pieces attacked by bishop"},
 {" Bound pieces"},
 {" Rooks behind passed pawn"},
/*
 {" Rook attacks on semiopen lines"},
 {" Rook attacks on open lines"},
*/
 {" Rooks attacks open and semiopen lines"},
 {" Rooks behind passed pawn"},
 {" Castles possible or made"},
 {" Bishop and rook attacks from king square"},
 {" Bishop attacks on enemy pieces"},
 {" Bishop/knight attacks adjacent to king"},
 {" Piece attacks adjacent to enemy king "},
 {" Piece attacks on strong square"},
 {" Pieces mobility"},
 {" Pieces mobility on enemy's half of board"},
 {" Passed pawn blocks"},
 {" Profitable attacks on passed pawn blocks"},
 {" Attacks on passed pawn trajectories"},
 {" King distance from passed pawns"},
 {" King distance from center "},
 {" Profitable attacked "},
 {" Bishop exist "}
};
char far EVAL_IND [MAX_IND][32]={
 {" Exchange resistance"},
 {" Distance between kings"},
 {" King distance from center"},
 {" Kings opposition"}
};

extern  POS_EVAL total_eval;
static void near print_eval_line (POS_EVAL weval,POS_EVAL beval,CFP str);
static void near print_independ_line ( POS_EVAL weval,CFP strip);
static void near fill_head_line( void);
static void near print_total_eval_line ( POS_EVAL eval);
static void near save_main_eval ( void );
static void near save_ind_eval ( void );
static void near get_party_status(PARTY_STATUS party_flag, CFP str);
static int near load_eval(void);

MAT_EVAL material_eval(POSITION *pos)
{
  MAT_EVAL value;
  LIST_NUM j;
  WOOD_PIECE far *woodp;
    value=0;
    for(j=0; j<TOTAL_NUM_PIECE; j++)
    if(pos->n.piece_list[j].where!=DUMMY) {
      woodp=&pos->n.square[pos->n.piece_list[j].where].wood;
      if(num_to_color(j)==pos->a.move_color)
        value+=woodp->cost;
      else
        value-=woodp->cost;
    }
    return(value);
}

void NEAR cpy_eval(register EVAL *v1,register EVAL *v2)
				/* Copy evaluation v2 to v1 */
{
  v1->material=v2->material;
  v1->position=v2->position;
}

EVAL * NEAR reverse_eval(register EVAL *v1,register EVAL *v2)
				/* v1=-v2, Return pointer to v1 */
{
  v1->material=-v2->material;
  v1->position=-v2->position;
  return(v1);
}

void NEAR zero_eval(register EVAL *v1)
                                /* v1=0 */
{
  *( (DWRD *)v1 )=0l;
}


int NEAR distance (SQUARE_NUM sq1, SQUARE_NUM sq2)
{
int i,j;
        i=abs(sq1&7-sq2&7);
        j=abs((sq1>>3)-(sq2>>3));
	return(max(i,j));
}
void  print_eval (struct EVAL_STRUCT *ep,struct idepend_eval *ip,POS_EVAL eval )
{
  POS_EVAL *curp,*cur_enemyp;
  POS_EVAL weval,beval;
  int i;

    fill_head_line();
    for (i=0,curp=(POS_EVAL *)ep; i<MAX_POINT;
	 i++,curp++) {
      (char *)cur_enemyp=(char *)curp+(sizeof(struct EVAL_STRUCT));
      weval=*curp;beval=*cur_enemyp;
      if (weval || beval)
      print_eval_line ( weval,beval, EVAL_NAME[i]);
    }
    for (i=0,curp=(POS_EVAL *)ip; i<MAX_IND;
	 i++,curp++) {
      weval=*curp;
      if (weval) print_independ_line (weval, EVAL_IND[i]);
    }
    print_total_eval_line(eval);
}
static void near print_eval_line ( POS_EVAL weval,POS_EVAL beval,CFP str )
{
static char far format[]=" %-41Fs%10i%13i";
  char prn[100];
	farsprintf(prn,format,str,weval,beval);
    lastlinereply(prn);
}
static void near fill_head_line ( void )
{
 char prn[100];
 static char far buf[100]="";
 static char far status_str[]="Party status";
 static char far line[]="                                               White        Black       ";

 get_party_status(party_flag,prn);
 farsprintf(buf,"%Fs%15s",status_str,prn);
 lastlinereply(buf);
 lastlinereply(line);
}

void near get_party_status(PARTY_STATUS party_flag,CFP str)
{
static char far debut_str[]= "Debut";
static char far middl_str[]= "Middlegame";
static char far end_str[]=   "Endgame";
static char far mate_str[]=  "Checkmate";

 switch (party_flag) {
   case 1: FARSTRCPY(str,debut_str);break;
   case 2: FARSTRCPY(str,middl_str);break;
   case 4: FARSTRCPY(str,end_str);break;
   case 8: FARSTRCPY(str,mate_str);break;
   default: *str='\0';
 }
}

static void near print_independ_line ( POS_EVAL weval, CFP strip)
{
char prn[100];
static char far format[]=" %-41Fs%15i";

	farsprintf(prn,format,strip,weval);
    lastlinereply(prn);
}
static void near print_total_eval_line ( POS_EVAL eval)
{
char prn[100]="";
static char far format[]="  White piece total eval%6i";

    lastlinereply(prn);
	farsprintf(prn,format,eval);
    lastlinereply(prn);
}

void print_cmp_eval ( CFP fname )
{
  int i;
  char buf[100]="";
  POS_EVAL *cur1,*enemy_cur1,*cur2,*enemy_cur2;
  char strst1[20],strst2[20];
static char far format[]=" Party status CURRENT=%s, Party_status %Fs=%s";
static char far line[]="                                                 White             Black             ";
static char far format1[]="                                           CURRENT%9Fs  CURRENT%9Fs";
static char far space1[]="         ";
static char far space2[]="                  ";
static char far format2[]="            Total                        %9i%9i";


  get_party_status(party_flag,strst1);
  get_party_status(party_flag_buf,strst2);
  farsprintf(buf,format,strst1,fname,strst2);
  lastlinereply(buf);
  lastlinereply(line);
	farsprintf(buf,format1,fname,fname);
  lastlinereply(buf);
  lastlinereply("");
  cur1=(POS_EVAL *)&all_eval[0];
  (char *)enemy_cur1=(char *)cur1+sizeof(struct EVAL_STRUCT);
  cur2=(POS_EVAL *)&eval_buf[0];
  (char *)enemy_cur2=(char *)cur2+sizeof(struct EVAL_STRUCT);

  for (i=0;i<MAX_POINT;i++,cur1++,enemy_cur1++,cur2++,enemy_cur2++)  {
	if((*cur1-*cur2) || (*enemy_cur1-*enemy_cur2)) {
	  if( *cur1-*cur2 ){
		 if(*cur1)farsprintf(strst1,"%9i",*cur1);
	     else setmem(strst1,9,' ');
		 if(*cur2)farsprintf(strst1+9,"%9i",*cur2);
	     else MYSTRCAT(strst1+9,space1);
	  }
	  else farsprintf(strst1,space2);
	  if( *enemy_cur1-*enemy_cur2 ){
		 if(*enemy_cur1)farsprintf(strst2,"%9i",*enemy_cur1);
	     else setmem(strst2,9,' ');
		 if(*enemy_cur2)farsprintf(strst2+9,"%9i",*enemy_cur2);
	     else MYSTRCAT(strst2+9,space1);
	  }
	  else farsprintf(strst2,space2);
	  farsprintf(buf,"%-41Fs%s%s",EVAL_NAME[i],strst1,strst2);
	  lastlinereply(buf);
	}
  }
  cur1=(POS_EVAL *)&color_ind_eval;
  cur2=(POS_EVAL *)&color_ind_buf;
  for (i=0;i<MAX_IND;i++,cur1++,cur2++)
	if(*cur1-*cur2) {
		 if(*cur1)farsprintf(strst1,"%9i",*cur1);
	     else MYSTRCAT(strst1,space1);
		 if(*cur2)farsprintf(strst1+9,"%9i",*cur2);
	     else MYSTRCAT(strst1,space1);
	  farsprintf(buf,"%-41Fs%s",EVAL_IND[i],strst1);
	  lastlinereply(buf);
	}
  lastlinereply("");
  farsprintf(buf,format2,total_eval,total_eval_buf);
  lastlinereply(buf);

}

CMP NEAR cmp_eval(register EVAL *v1,register EVAL *v2)
				/*          GREATER if v1>v2	*/
				/* Return   EQUAL   if v1=v2	*/
				/*          LESS    if v1<v2	*/
{
  if(v1->material>v2->material) return(GREATER);
  if(v1->material<v2->material) return(LESS);
  if(v1->position>v2->position) return(GREATER);
  if(v1->position<v2->position) return(LESS);
  return(EQUAL);
}
void putevalintofile (int file)
{
   MYWRITE(file,&party_flag,sizeof(PARTY_STATUS));
   MYWRITE(file,&total_eval,sizeof(total_eval));
   MYWRITE(file,&all_eval,sizeof(struct EVAL_STRUCT)*2);
   MYWRITE(file,&color_ind_eval,sizeof(struct idepend_eval));
}
void getevalfromfile (int file)
{
   MYREAD(file,&party_flag_buf,sizeof(PARTY_STATUS));
   MYREAD(file,&total_eval_buf,sizeof(total_eval));
   MYREAD(file,&eval_buf,sizeof(struct EVAL_STRUCT)*2);
   MYREAD(file,&color_ind_buf,sizeof(struct idepend_eval));
}
int evaluate(void)
{
  extern POS_EVAL total_eval;
    emptystate( reply );
    party_status();
    set_profitable_attack();
    pos_eval();
    print_eval  (&all_eval[0],&color_ind_eval,total_eval);
    party_flag_buf=party_flag;
    total_eval_buf=total_eval;
    save_main_eval ();
    save_ind_eval  ();
    return goto_reply();
}

SSTRING far deffname="*.evl";
SSTRING far fname="*.evl";


int compareval(void)
{
    char drive[3];
    char dir[70];
    char name[10];
    char ext[5];

    emptystate(reply);
    party_status();
    set_profitable_attack();
    pos_eval();
    if (load_eval()) {
	MYFNSPLIT(fname,drive,dir,name,ext);
	strupr(name);
	print_cmp_eval(name);
    }  else print_cmp_eval("OLD");
    return goto_reply();
}

int save_eval(void)
{
  int file;
  char str[MAXPATH];
  int i;
  WINP wp;
  int top=6,left=35;
  static char far mess[]="Can't open file to write eval";

    if(infc_info[cur_infc_ptr->name].type&MENU_STATUS)
      menuposition(*menusp,&top,&left);
    wp=getpromptwindow(top,left," Save Eval ");
    if( wp ) {
      keyfunc(wp,tohelpprompt,BEFORE);
      FARSTRCPY(str,configfile);
      i=searchfile( wp, str, deffname );
      checkface(freewindow(wp));
    } else return 0;
    if(i==ESCAPE) return 0;
    checkface(i);
    if(i) return 0;
    make_bak_file(str); /* rename old file to ".bak"*/
    file=MYOPEN( str,O_WRONLY+O_CREAT+O_BINARY,S_IREAD+S_IWRITE);
    if( file==-1){ message( mess,0); return(0); }
    party_status();
    set_profitable_attack();
    pos_eval();
    putevalintofile(file);
    MYCLOSE( file );
    FARSTRCPY(fname,str);
    return(1);
}
static int near load_eval(void)
{
  int file;
  char str[MAXPATH];
  int i;
  WINP wp;
  static char far mess[]=  "Can't open file to read eval";
    wp=getpromptwindow(6,35," Load a Eval ");
    if( wp ) {
      keyfunc(wp,tohelpprompt,BEFORE);
      i=searchfile( wp, str, deffname );
      checkface(freewindow(wp));
    } else return 0;
    if(i==ESCAPE) return 0;
    checkface(i);
    if (i) return 0;
    file=MYOPEN(str,O_RDONLY+O_BINARY,0);
    if( file==-1 ){ message( mess,0); return(0); }
    getevalfromfile(file);
    MYCLOSE( file );
    FARSTRCPY(fname,str);
    return(1);
}
static void near save_main_eval ( void )
{
	MEMCPY( &eval_buf[0],&all_eval[0],sizeof(struct EVAL_STRUCT)*2);
}
static void near save_ind_eval ( void )
{
	MEMCPY( &color_ind_buf,&color_ind_eval,sizeof(struct idepend_eval));
}
