#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "ks_corr.h"
#include "proc.h"
#include "pos_eval.h"
#include "ks_eval.h"
#include "attacks.h"
#include <stdlib.h>

extern char centr_square[NSQUARE];
extern SHORT_POS_EVAL rook_on_line[16],rook_attack_line[16],castle_eval[16];
extern SHORT_POS_EVAL pawns_attack_king_possibility[256];
extern SHORT_POS_EVAL pieces_attack_king_possibility[256];
extern SHORT_POS_EVAL pieces_attack_piece_king_possibility[256];
BYTE bit_quantity[256];			/* Quantity bits in byte */
extern SHORT_POS_EVAL   pieces_attack_centre[256], pawns_attack_centre[256];
extern SHORT_POS_EVAL   pieces_attack_st_sq_centre[256],pieces_attack_st_sq[256];
extern int bit_num[256][NLINE+1];

extern MAT_EVAL pawns_price[256],pieces_price[256];

extern SQUARE_NUM king_moves[NSQUARE][NLINE+1];
extern char normal_mask[256];
extern WORD trans_mask[NPIECE+1];

static void near calc_bit_quantity(void);
static void near calc_bit_num(void);
static void near calc_king_moves(void);
static void near calc_rook_on_line(void);
static void near calc_rook_attack_line(void);
static void near calc_castle_eval(void);
static void near calc_pieces_attack_centre(void);
static void near calc_pawns_attack_centre(void);
static void near calc_pawn_attack_king_possib(void);
static void near calc_piece_attack_king_possib(void);
static void near calc_normal_mask(void);
static void near calc_prices(void);

void NEAR init_eval(void){
  calc_bit_quantity();
  calc_bit_num();
  calc_king_moves();
  calc_rook_on_line();
  calc_rook_attack_line();
  calc_castle_eval();
  calc_pieces_attack_centre();
  calc_pawns_attack_centre();
  calc_pawn_attack_king_possib();
  calc_piece_attack_king_possib();
  calc_normal_mask();
  calc_prices();
  calc_attack_arrays();
}
static void near calc_bit_quantity(){
int i,j;
  for(i=0;i<256;i++){
    bit_quantity[i]=0;
    for(j=0;j<8;j++){
      if(i&(1<<j)){
	bit_quantity[i]++;
      }
    }
  }
}
static void near calc_bit_num(void){
int i,j,l,k;
  for(i=0;i<256;i++){
    for(j=1,k=0,l=0;j<256;j<<=1,l++){
      if(i&j){
	bit_num[i][k++]=l;
      }
    }
    bit_num[i][k]=DUMMY;
  }
}
static void near calc_king_moves(){
/*extern const int increment[NDIR];*/
SQUARE_NUM cur_square,to,*sqp;
int i;
  for(cur_square=a1;cur_square<=h8;cur_square++){
    sqp=king_moves[cur_square];
    for(i=0;i<NDIR;i++){
      to=cur_square+increment[i];
      if(to>=a1 && to<=h8 && abs((to&7)-(cur_square&7))<=1){
	*sqp++=to;
      }
    }
    *sqp=DUMMY;
  }
}
static void near calc_castle_eval(){
union{
CASTLES i1;
int     i2;
}     i;
  for(i.i2=0;i.i2<16;i.i2++){
    castle_eval[i.i2]=castle_right_lose;
    if ( ((i.i1 & CASTLERIGHT) || (i.i1 & CASTLELEFT)))
		castle_eval[i.i2]-=castle_right_lose;
    if ( (i.i1 & CASTLELEFTDONE) || (i.i1 & CASTLERIGHTDONE))
		castle_eval[i.i2]+=castle_done-castle_right_lose;  /* M.D. */
  }
}
static void near calc_piece_attack_king_possib(){
POS_EVAL cur_eval;
int i;
  for(i=0;i<256;i++){
    cur_eval=0;
    if(i & RIGHT_KNIGHT_MASK) cur_eval+=bishop_knight_attack_king_possibility;
    if(i & LEFT_KNIGHT_MASK) cur_eval+=bishop_knight_attack_king_possibility;
    if(i & RIGHT_BISHOP_MASK) cur_eval+=bishop_knight_attack_king_possibility;
    if(i & LEFT_BISHOP_MASK) cur_eval+=bishop_knight_attack_king_possibility;
    if(i & RIGHT_ROOK_MASK) cur_eval+=rook_attack_king_possibility;
    if(i & LEFT_ROOK_MASK) cur_eval+=rook_attack_king_possibility;
    if(i & QUEEN_MASK) cur_eval+=queen_attack_king_possibility;
    pieces_attack_king_possibility[i]=cur_eval;
  }
}
static void near calc_pawn_attack_king_possib(){
int i;
  for(i=0;i<256;i++){
    pawns_attack_king_possibility[i]=bit_quantity[i]*pawn_attack_king_possibility;
  }
}
static void near calc_pieces_attack_centre()  {
int i;
  for(i=0;i<256;i++){
    pieces_attack_centre[i]=bit_quantity[i&(BISHOP_KNIGHT_MASK)]*
			    bishop_knight_attack_centre;
    pieces_attack_centre[i]+=bit_quantity[i&QUEEN_ROOK_MASK]*
			    rook_attack_centre;
    pieces_attack_st_sq[i]=bit_quantity[i&BISHOP_KNIGHT_MASK]*
			    bishop_knight_attack_st_sq;
  }
}
static void near calc_pawns_attack_centre()  {
int i;
  for(i=0;i<256;i++){
    pawns_attack_centre[i]=bit_quantity[i]*pawn_attack_centre;
  }
}
/*static void near calc_piece_attack_piece_king_possibility(){
int i;
POS_EVAL cur_eval;
  for(i=0;i<256;i++){
    cur_eval=0;
    if(i & RIGHT_BISHOP_MASK) cur_eval+=bishop_attack_bishop_king_possibility;
    if(i & LEFT_BISHOP_MASK) cur_eval+=bishop_attack_bishop_king_possibility;
    if(i & RIGHT_ROOK_MASK) cur_eval+=rook_attack_rook_king_possibility;
    if(i & LEFT_ROOK_MASK) cur_eval+=rook_attack_rook_king_possibility;
    if(i & QUEEN_MASK) cur_eval+=queen_attack_queen_king_possibility;
    pieces_attack_piece_king_possibility[i]=cur_eval;
  }
} */
static void near  calc_rook_on_line()
{
int i;
  for(i=0;i<16;i++){
    rook_on_line[i]=0;
    if(i&OPEN       )rook_on_line[i]+=rook_on_open_line;
    if(i&SEMIOPEN   )rook_on_line[i]+=rook_on_semiopen_line;
  }
}
static void near  calc_rook_attack_line(){
int i;
  for(i=0;i<16;i++){
    rook_attack_line[i]=0;
    if(i&OPEN       )rook_attack_line[i]+=rook_attack_open_line;
    if(i&SEMIOPEN   )rook_attack_line[i]+=rook_attack_semiopen_line;
  }
}

static void near calc_normal_mask()
{
int i;
PIECE_NAME j;
  for(i=0;i<256;i++){
    normal_mask[i]=0;
    for(j=KING;trans_mask[j]<=RIGHT_ROOK_MASK;j++){   /*only pieces , not pawns */
      if(i>(2*trans_mask[j]-1)){   /* set all bit left trans_mask*/
	normal_mask[i]=(char)trans_mask[j+1];
      }
    }
  }
}
static void near calc_prices(void)
{
int i,j;
  for(i=0;i<256;i++){
    pawns_price[i]=bit_quantity[i]*pawn_price;
    for(j=1;j<256;j<<=1){
      if(i&j&QUEEN_MASK)pieces_price[i]+=queen_price;
      if(i&j&ROOK_MASK)pieces_price[i]+=rook_price;
      if(i&j&KNIGHT_MASK)pieces_price[i]+=knight_price;
      if(i&j&BISHOP_MASK)pieces_price[i]+=bishop_price;
    }
  }
}
