#ifndef  _CHESS_H
#include "chess.h"
#endif

POS_EVAL pos_eval( void );/*Must be called after mat_eval() for current
				 position ,because pos_eval use common
				 variable mat_wihtout_pawns and
				 MATERIAL_EVAL whith are setting by
				 mat_eval()                         */

void NEAR init_eval( void );   /* Is called in init_game("ks_game.c") */
extern int ev_deb;             /* if(ev_deb) evaluation is printing
				  can be modified throu MENU         */
extern PARTY_STATUS party_flag;
extern POS_EVAL total_eval_buf;

int NEAR distance(SQUARE_NUM sq1, SQUARE_NUM sq2);
typedef signed char SHORT_POS_EVAL;

void party_status(void);

struct EVAL_STRUCT
{
  POS_EVAL  ev_isolated_pawn ;
  POS_EVAL  ev_isolated_pawn_on_semiopen_line;
  POS_EVAL  ev_double_pawn;
  POS_EVAL  ev_phalanga;
  POS_EVAL  ev_centre_pawn;
  POS_EVAL  ev_pawn_attack;
  POS_EVAL  ev_pawn_attack_centre;
  POS_EVAL  ev_pawn_before_enemy_st_sq;
  POS_EVAL  ev_strong_square;
  POS_EVAL  ev_pawn_attack_king_possibility;
  POS_EVAL  ev_piece_attacked_by_pawn;
  POS_EVAL  ev_pawn_blockade_by_enemy_on_f_lines;
  POS_EVAL  ev_pawn_blockade_on_de_lines;
  POS_EVAL  ev_semipassage_pawn;
  POS_EVAL  ev_passage_pawn;
  POS_EVAL  ev_bishop_knight_attack_enemy_rook_queen;
  POS_EVAL  ev_rook_on_seven_line;
  POS_EVAL  ev_rook_on_seven_line_in_endgame;
  POS_EVAL  ev_profitable_attack_on_bound_piece;
  POS_EVAL  ev_double_profitable_attack;
  POS_EVAL  ev_initial_bishop_knight_state;
  POS_EVAL  ev_knight_on_st_sq;
  POS_EVAL  ev_bishop_on_st_sq;
  POS_EVAL  ev_piece_attack_centre;
  POS_EVAL  ev_rook_open_semiopen_line;
  POS_EVAL  ev_two_bishop_existance;
  POS_EVAL  ev_knight_and_queen_existance;
  POS_EVAL  ev_knight_in_centre;
  POS_EVAL  ev_piece_attacked_by_bishop;
  POS_EVAL  ev_bound_piece;
  POS_EVAL  ev_rook_behind_passage_pawn;
  POS_EVAL  ev_rook_attack_open_semiopen_line;
  POS_EVAL  ev_rook_behind_passed_pawn;
  POS_EVAL  ev_castle;
  POS_EVAL  ev_bishop_rook_king_possibility;
  POS_EVAL  ev_bishop_attack_enemy_piece;
  POS_EVAL  ev_bishop_knight_attack_king_possibility;
  POS_EVAL  ev_piece_attack_king_possibility;
  POS_EVAL  ev_piece_attack_st_sq;
  POS_EVAL  ev_pieces_possibility;
  POS_EVAL  ev_att_enemy_half;
  POS_EVAL  ev_block_passage_pawn;
  POS_EVAL  ev_profitable_attack_block_passage_pawn;
  POS_EVAL  ev_attack_passage_trace;
  POS_EVAL  ev_king_distance_to_passed_pawn;
  POS_EVAL  ev_king_in_centre;
  POS_EVAL  ev_profitable_attacked;
  POS_EVAL  ev_bishop_exist;
};
struct idepend_eval
{
  POS_EVAL  ev_change_resistens;
  POS_EVAL  ev_king_distance;
  POS_EVAL  ev_king_centre_distance;
  POS_EVAL  ev_king_opposition;
};
extern MAT_EVAL mat_without_pawns[NCOLOR];
extern struct EVAL_STRUCT eval_buf[NCOLOR];
extern struct EVAL_STRUCT all_eval[NCOLOR];
extern struct idepend_eval color_ind_eval;
extern struct idepend_eval color_ind_buf;
extern PARTY_STATUS party_flag_buf;
void  print_cmp_eval (char far * fname);
void  putevalintofile ( int file);
void  getevalfromfile (int file);

void print_eval ( struct EVAL_STRUCT *ep, struct idepend_eval *ip,POS_EVAL eval);
void NEAR cmpare_eval (struct EVAL_STRUCT *ep,struct EVAL_STRUCT *ep1, struct idepend_eval *ep3, struct idepend_eval *ep4);
POS_EVAL pos_eval( void );
void NEAR init_eval( void );

int evaluate( void );
int compareval( void );
int save_eval ( void );
/*int load_eval ( void );*/

void NEAR set_profitable_attack(void);
void NEAR set_new_attack(void);
int NEAR double_attacked(PIECE_COLOR our);
int NEAR attacked(PIECE_COLOR our);
int NEAR bounded_attacked(PIECE_COLOR our);
