#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "ks_corr.h"
#include "proc.h"
#include "pos_eval.h"
#include "ks_eval.h"
#include "hashpawn.h"
#include "ks_macro.h"
#include "ks_game.h"
#include "experim.h"
#include "attacks.h"

#include <stdio.h>
#include <mem.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

extern int flPassGen;
int NEAR PassagePawn(void);

#define BITNUM 256
#define PIECE_LIST_END(color) (color? TOTAL_NUM_PIECE : NUM_PIECE)
#define PAWN_LIST_FIRST(color) (PIECE_LIST+(color? NUM_PIECE+8 : 8))
#define PIECE_LIST_FIRST(color) (PIECE_LIST+(color? NUM_PIECE : 0))


extern int nmove;
int our_pawns[NCOLOR]={8,24};
PIECE_COLOR our,enemy;
PARTY_STATUS party_flag=DEBUT;
struct EVAL_STRUCT all_eval[NCOLOR];
PARTY_STATUS party_flag_buf;
POS_EVAL total_eval_buf;
struct EVAL_STRUCT eval_buf[NCOLOR];
struct idepend_eval    color_ind_eval,color_ind_buf;
struct EVAL_STRUCT *evalp,*evalfp;
POS_EVAL total_eval;
								  /* central squares for WHITE */
const BYTE centr_square[NSQUARE]={0,0,0,0,0,0,0,0,            /* 1 horizontal */
				  0,0,0,0,0,0,0,0,
				  0,0,0,0,0,0,0,0,
				  0,0,0,1,1,0,0,0,
				  0,0,0,1,1,0,0,0,
				  0,0,0,1,1,0,0,0,
				  0,0,0,0,0,0,0,0,
				  0,0,0,0,0,0,0,0};           /* 8 horizontal */
							      /*        a,b,c,d,e,f,g,h  */
							      /* potentially strong squares for WHITE  */
const BYTE st_square[NSQUARE]=   {0,0,0,0,0,0,0,0,
				  0,0,0,0,0,0,0,0,
				  0,0,0,0,0,0,0,0,
				  0,0,1,1,1,1,0,0,
				  0,1,1,1,1,1,1,0,
				  0,1,1,1,1,1,1,0,
				  0,1,1,1,1,1,1,0,
				  0,1,1,1,1,1,1,0};
const BYTE king_from_centre[NSQUARE]={0,0,0,0,0,0,0,0,
				      0,5,5,5,5,5,5,0,
				      0,5,10,10,10,10,5,0,
				      0,5,10,15,15,10,5,0,
				      0,5,10,15,15,10,5,0,
				      0,5,10,10,10,10,5,0,
				      0,5,5,5,5,5,5,0,
				      0,0,0,0,0,0,0,0};
SQUARE_NUM central_square[NCOLOR][7]={d4,e4,d5,e5,d6,e6,DUMMY,
				       d3,e3,d4,e4,d5,e5,DUMMY};
const POS_EVAL passage_pawn[NLINE]={0,10,10,25,40,60,100};
							      /* from sixth to seventh rank need more because
								 the pawn leaves a centre square */
const SHORT_POS_EVAL semipassage_pawn[NLINE]={0,0,0,10,25,40,0};
const SHORT_POS_EVAL king_from_pawn[]={18,15,12,9,6,3,0,0};
const SHORT_POS_EVAL pawn_from_queen[]={0,0,0,3,6,9,12,15};
SQUARE_NUM king_moves[NSQUARE][NLINE+1];
SHORT_POS_EVAL rook_on_line[16],rook_attack_line[16],castle_eval[16];
SHORT_POS_EVAL pawns_attack_king_possibility[BITNUM];
SHORT_POS_EVAL pieces_attack_king_possibility[BITNUM];
SHORT_POS_EVAL pieces_attack_centre[BITNUM], pawns_attack_centre[BITNUM];
SHORT_POS_EVAL pieces_attack_st_sq[BITNUM];
int bit_num[BITNUM][NLINE+1];

MAT_EVAL pawns_price[BITNUM],pieces_price[BITNUM];
MAT_EVAL mat_without_pawns[NCOLOR];
MAT_EVAL beg_mat_without_pawns[NCOLOR];

WORD trans_mask[NPIECE+1]={NOMASK,KING_MASK,QUEEN_MASK,RIGHT_ROOK_MASK,
			  RIGHT_KNIGHT_MASK,RIGHT_KNIGHT_MASK,H_PAWN_MASK};
BYTE normal_mask[BITNUM];

/*SQUARE_NUM prof_attacked_square[NCOLOR][NUM_PIECE+1];*/
SQUARE_NUM bound_pieces[NCOLOR][NUM_PIECE+1];


int QUEEN_FLAG[NCOLOR];
PIECE_MASK QUEEN_ALL_MASK;
int pawns_lines[NCOLOR][NLINE][NFILE+1];
BYTE line[NCOLOR][NLINE];
SQUARE_NUM st_sq[NCOLOR][NLINE*2+1];
SQUARE_NUM passage[NCOLOR][NLINE+1];
int pawn_attack_num[NCOLOR];

static void near mat_eval(void);                              /*calc materian without pawns */
void NEAR calc_pawns_lines(void);                             /*line characteristics*/
void NEAR pawn_eval(PIECE_COLOR color);                       /*pawn eval independing pieces*/
static void  near eval_phalanga(void);                        /*phalanges evals */
static void  near profitable_attack(void);                    /*profitable_attacks eval */
static void  near piece_eval(void);
static void  near king_possibility(void);
static void  near eval_central_squares(void);
static void  near eval_st_sq(void);
static void  near far_king_possibility(void);
static void  near passage_pawn_factors(void);
static void  near possibilities(void);
static void  near king_distance(void);
static void  near calc_change_resistance(void);
static void  near kings_opposition(void);
static void  near eval_bound_pieces (void);
static void  near eval_prepare (void);
static POS_EVAL near eval_sum ( void );
static POS_EVAL near eval_independ_sum ( void );

#define EVAL_STRING_LENGHT 50

#define OUR_PIECE_LIST_END(color) (color? TOTAL_NUM_PIECE : NUM_PIECE)

static void near mat_eval(void)
{
  QUEEN_ALL_MASK.dwrd=PIECE_MASKS[QUEEN].dwrd;
  QUEEN_FLAG[WHITE_PIECE]=QUEEN_ALL_MASK.byte[WHITE_PIECE][1];
  QUEEN_FLAG[BLACK_PIECE]=QUEEN_ALL_MASK.byte[BLACK_PIECE][1];

  for(our=WHITE_PIECE;our<=BLACK_PIECE;our++){
    mat_without_pawns[our]=pieces_price[POS_MASK.byte[our][0]];
    if(QUEEN_FLAG[our]){                                       /* for many queens */
      mat_without_pawns[our]+=bit_quantity[QUEEN_ALL_MASK.byte[our][1]]*queen_price;
    }
  }
}

POS_EVAL pos_eval(void)
{
     evalcount++; if(NEVAL==1) secondevalcount++; if(NEVAL>=2) thirdevalcount++;       
     NEVAL++; 
/*     set_profitable_attack(); */
     total_eval=0;
     mat_eval();
	 eval_prepare ();                                 /* prepare zerow eval */

	 if(!flPassGen) calc_pawns_lines();        /* build histogramm */
	 if (pawn_hash_flag && pawn_hash_success())       /* if pawn hash exist in hash */
	 total_eval+=Hashpawneval*((MOVE_COLOR)?-1:1);          /* ?? fill from pawnhash */
	 for(our=WHITE_PIECE,evalp=evalfp;our<NCOLOR;our++,evalp++) {
	enemy=1-our;
	 pawn_eval(our);
	 eval_phalanga();
     }
     if(pawn_hash_flag)  {
       total_eval=eval_sum();
       save_pawn_hash(total_eval*((MOVE_COLOR)?-1:1));      /*put pawn struct into hash*/
     }
     for (our=WHITE_PIECE,evalp=evalfp;our<NCOLOR;our++,evalp++)  {         /* color dependent thinghs */
       enemy=1-our;
       eval_st_sq();
       eval_central_squares();
       profitable_attack();
       piece_eval();
       possibilities();
       eval_bound_pieces(); /* Must be after profitable_attack() */
	   if ( party_flag & (MIDDLEGAME) )  {
		 far_king_possibility();
	 king_possibility();
       }
       if ( party_flag & ENDGAME ) passage_pawn_factors();
     }
     calc_change_resistance();                      /* color independent things */
     if (party_flag & ENDGAME)       kings_opposition();
     if (party_flag & (CHECKMATE) )  king_distance();
     total_eval=eval_sum();
     total_eval+=eval_independ_sum();
     return(total_eval*((MOVE_COLOR)?-1:1));
}

PIECE_COLOR checkmate_color;

void party_status()
{
MAT_EVAL mat_checkmate_color;
int i,counter=0;
		       /* How many moves have been done ? */
    mat_eval();
    beg_mat_without_pawns[WHITE_PIECE]=mat_without_pawns[WHITE_PIECE];
    beg_mat_without_pawns[BLACK_PIECE]=mat_without_pawns[BLACK_PIECE];


/*    party_flag=(nmove<=20)? DEBUT: MIDDLEGAME; /* M.D. */
		       /* How many pieces material on the board? */
*/
    for(i=0;i<16;i++)
      if(!SQUAREP(i)->who_mask.dwrd) counter++;
    for(i=48;i<64;i++)
      if(!SQUAREP(i)->who_mask.dwrd) counter++;
    party_flag=(counter<=10)? DEBUT: MIDDLEGAME; 


    if((mat_without_pawns[WHITE_PIECE]+mat_without_pawns[BLACK_PIECE])<40 /*&&
       abs(MATERIAL_EVAL)<bishop_price*/){
      party_flag=ENDGAME;
    }
		     /*Who is checkmated ?*/
    checkmate_color=(MATERIAL_EVAL<0)? MOVE_COLOR:
					 reverse_color(MOVE_COLOR);
    if(abs(mat_without_pawns[WHITE_PIECE]-mat_without_pawns[BLACK_PIECE])
		  >=rook_price) { /* may be checkmate */
      mat_checkmate_color=mat_without_pawns[checkmate_color]+
			  pawns_price[POS_MASK.byte[checkmate_color][1]];
		     /*How many material have checkmated side? */
      if(mat_checkmate_color<=4) party_flag=CHECKMATE;
    }
}

void NEAR calc_pawns_lines(){                       /*pawns histogram*/
int term,cur_gor,cur_vert,*pawnp,i;
PIECE_IN_LIST *piecep;
SQUARE_NUM cur_square;
int (*expect_pawnlp)[NFILE+1];
int *curp;

  setmem(&pawns_lines,sizeof(pawns_lines),DUMMY);   /* W.K.: DUMMY is integer */
									/* conversion -1 to char and */
									/* char to int may give 255 !!!! */
  for(our=WHITE_PIECE ;our<NCOLOR;our++){
    for(piecep=PAWN_LIST_FIRST(our),i=0,expect_pawnlp=pawns_lines[our];
	i<8; piecep++,i++,expect_pawnlp++) {
      if((cur_square=piecep->where)==DUMMY){
	continue;
	}
      if(QUEEN_FLAG[our] && WHOONSQUARE(cur_square)->name==QUEEN) continue;
	  cur_gor=cur_square>>3; 	                    /* define gor number*/
      cur_vert=cur_square&7;
	  if(i==cur_vert && *(curp=*expect_pawnlp)==DUMMY ){ /* Acceleration */
	*curp=cur_gor;
/*	*(curp+1)=DUMMY;*/
      }
      else{
	for(pawnp= pawns_lines[our][cur_vert];*pawnp!=DUMMY;pawnp++) {
	  if((our)?*pawnp<cur_gor:*pawnp>cur_gor){
	    term=*pawnp;
	    *pawnp=cur_gor;         /* *pawn <-->cur_gor  */
	    cur_gor=term;
	  }
	} 
	*pawnp=cur_gor;
      } /* else */
    } /* for by pawns */
  } /* for by colors */
}

void NEAR pawn_eval (PIECE_COLOR our)
{
int *cur_pawn,*enemy_pawn,* cur_pawn_left,* cur_pawn_right,*enemy_right,
    *enemy_left,dummy[1];
int cur_line,shift;
SQUARE_NUM cur_square,*st_sqp,*passagep;
int i,j;
SQUARE_NUM cur_st_sq;
int *next_enemy_pawn;
PIECE_COLOR enemy;

  enemy=1-our;
  *dummy=DUMMY;                                               /* special  tool for 'a'  and 'h' lines */
  st_sqp=st_sq[our];
  passagep=passage[our];
  for(i=0;i<NLINE;i++){                                       /* loop on lines */
    cur_line=0;
    cur_pawn= pawns_lines[our][i];
    enemy_pawn= pawns_lines[enemy][i];
    cur_pawn_left=(i==0)? dummy: pawns_lines[our][i-1];
    cur_pawn_right=(i==7)? dummy: pawns_lines[our][i+1];
    enemy_left=(i==0)?  dummy: pawns_lines[enemy][i-1];
    enemy_right=(i==7)? dummy: pawns_lines[enemy][i+1];
    if(cur_pawn[0]==DUMMY) {
      cur_line=SEMIOPEN;
      if (enemy_pawn[0]==DUMMY) {
	cur_line=OPEN;
      }
    } else {
      for ( j=0; cur_pawn[j]!=DUMMY; j++){          /*double pawn*/
	if ( j ){
	  evalp->ev_double_pawn+=double_pawn;
	  if(cur_pawn_left[0]==DUMMY && cur_pawn_right[0]==DUMMY){ /* just made */
	    evalp->ev_double_pawn+=double_isolated_pawn; /* isolated pawn */
	  }
	}
	cur_square = (cur_pawn[j] << 3) + i;
	shift = our ? -NLINE: NLINE;
													/* begin Strong squares */

	if (i>1) {                                      /* let us try the square attacked from the right */
	  if (WHOONSQUARE(cur_square-1+shift)->name!=PAWN
													/* no pawn on the square */
	      && !(WHOONSQUARE(cur_square-2)->name==PAWN &&
		   WHOONSQUARE(cur_square-2)->color==our) )    {
													/* no other our pawn attacks the square */
		  next_enemy_pawn=pawns_lines[enemy][i];
													/* can it be attacked from right by an enemy pawn ? */
		  while (*next_enemy_pawn!=DUMMY)
			if (our ? (*next_enemy_pawn+1)<cur_pawn[j]:
				(*next_enemy_pawn-1)>cur_pawn[j])
					break;
			else next_enemy_pawn++;
		  if (*next_enemy_pawn==DUMMY) {
													/* it cannot be attacked from right, let's check left */
		    next_enemy_pawn=pawns_lines[enemy][i-2];
													/* can it be attacked from left by an enemy pawn ? */
		    while (*next_enemy_pawn!=DUMMY)
			if (our ? (*next_enemy_pawn+1)<cur_pawn[j]:
				(*next_enemy_pawn-1)>cur_pawn[j])
					break;
			else next_enemy_pawn++;
		    if (*next_enemy_pawn==DUMMY) {
			cur_st_sq=cur_square-1+shift;
													/*Transverse with st_square array with color correction */
			if(st_square[our?(NSQUARE-cur_st_sq):cur_st_sq])
													/* is it potentially strong ? */
			    *st_sqp++=cur_st_sq;
		    }
		  }
	  }                                             /* end of if SQUARE.. */
	}
	if (i<6) {    /* let us try the square attacked from the left */
	  if (WHOONSQUARE(cur_square+1+shift)->name!=PAWN ) {
		/* no pawn on the square */
		next_enemy_pawn=pawns_lines[enemy][i];
			/* can it be attacked from left by an enemy pawn ? */
		while (*next_enemy_pawn!=DUMMY)
			if (our ? (*next_enemy_pawn+1)<cur_pawn[j]:
				(*next_enemy_pawn-1)>cur_pawn[j])
					break;
			else next_enemy_pawn++;
		if (*next_enemy_pawn==DUMMY) {
			/* it cannot be attacked from left, let's check right */
		  next_enemy_pawn=pawns_lines[enemy][i+2];
			/* can it be attacked from right by an enemy pawn ? */
		  while (*next_enemy_pawn!=DUMMY)
			if (our ? (*next_enemy_pawn+1)<cur_pawn[j]:
				(*next_enemy_pawn-1)>cur_pawn[j])
					break;
			else next_enemy_pawn++;
		  if (*next_enemy_pawn==DUMMY) {
			cur_st_sq=cur_square+1+shift;
	     /*Transverse with st_square array with color correction */
			if(st_square[our?(NSQUARE-cur_st_sq):cur_st_sq])
				/* is it potentially strong ? */
			    *st_sqp++=cur_st_sq;
		  }
		} /* end of left checking */
	  } /* end of if SQUARE.. */
	} /* end of checking the right side of pawn */
	/* end of STRONG SQUARES */


	if(enemy_pawn[0]==DUMMY)  {                     /*semiopen pawn*/
	  if((enemy_left[0]==DUMMY || (our?
		enemy_left[0]>=cur_pawn[j]:enemy_left[0]<=cur_pawn[j]))&&
	     (enemy_right[0]==DUMMY || (our?
		enemy_right[0]>=cur_pawn[j]:enemy_right[0]<=cur_pawn[j]))){
	    evalp->ev_passage_pawn+=passage_pawn[our?(NLINE-1-cur_pawn[j]):cur_pawn[j]];
	    cur_line|=PASSAGE;
	    *passagep++=cur_square;
	  }
	}
	if(cur_pawn_left[0]==DUMMY && cur_pawn_right[0]==DUMMY){
	  evalp->ev_isolated_pawn+=isolated_pawn;          /*isolated pawn*/
	  if(enemy_pawn[0]==DUMMY){                     /* Must be removed from pawn eval
													   because dependensing of pieces*/
	    if((DEFAULT_MASK)(POS_MASK.word[enemy]) &  QUEEN_ROOK_MASK){
		  evalp->ev_isolated_pawn_on_semiopen_line+=isolated_pawn_on_semiopen_line;
	    }
	  }
													 /* do we need doubled pawns on isolated lines ? */
	} else {
/*	if (enemy_pawn[0]==DUMMY && (party_flag & ENDGAME))
	evalp->ev_semipassage_pawn+=semipassage_pawn[GETLINE(cur_square)];*/
	}
      }                                              /* end of loop by pawns on the i-th line */
    }                                                /* end of else */
    line[our][i]=cur_line;
  }                                                  /* end of the loop by lines */
	*passagep=*st_sqp=DUMMY;                         /* because there is circle "while st_sqp!=DUMMY*/
}

static void near eval_phalanga(void)
{
  int i,cur_gor;
  SQUARE_NUM cur_square;
  PIECE_IN_LIST *piecep;

    for(i=0,piecep=PAWN_LIST_FIRST(our);i<8;piecep++,i++) {
      if((cur_square=piecep->where)!=DUMMY) {
	if(QUEEN_FLAG[our] && WHOONSQUARE(cur_square)->name==QUEEN) continue;
	if(SQUAREP(cur_square+1)->who_mask.word[our] & PAWN_MASK) {
	  if ((cur_square&7)<5 && (cur_square&7)>1) {
	    cur_gor=cur_square>>3;
	    if((our)?(cur_gor<5):(cur_gor>2))
	    evalp->ev_phalanga+=phalanga;
	  }
	}
      }
    }
}
/*
static void near profitable_attack()
{
  int i;
  SQUARE_NUM cur_square,*prof_sqp;
  SQUARE_INFO *sqip;
  PIECE_NAME cur_name;
  WORD our_mask,enemy_mask;
  PIECE_IN_LIST *piecep;

  prof_sqp=prof_attack_square;
  for ( i=1,piecep=PIECE_LIST_FIRST(enemy)+1; i<NUM_PIECE;piecep++,i++) {
						   /* loop on enemy pieces */
    if ( (cur_square=piecep->where ) == DUMMY ) continue;      /* no piece */
    sqip=SQUAREP(cur_square);
    our_mask=sqip->attackedby.word[our];       /* our attacks on the piece */
    if ( !our_mask ) continue;

    if(QUEEN_FLAG[our])  {          /* change our mask for promoted pawns */
      if ( our_mask & QUEEN_ALL_MASK.word[our]){   /*queen exist*/
	our_mask|=QUEEN_MASK;
      }
      our_mask &= (~QUEEN_ALL_MASK.word[our]) | 0xFF;
      if ( !our_mask ) continue;
    }
    enemy_mask=sqip->attackedby.word[enemy]; /* enemy's ataacks on the square */
    cur_name=sqip->wood.name;                /* piece name */
    if ( our_mask > trans_mask[cur_name] || !enemy_mask ) {
				/* definition of profitable attack*/
      *prof_sqp++=cur_square;
      if ( our_mask & PAWN_MASK && cur_name!=PAWN)   /*pawn attack piece*/
      evalp->ev_pawn_attack_enemy_piece+=pawn_attack_enemy_piece;
    }                                               /* if profitable */
  }                                                 /* for enemy pieces */
  *prof_sqp=DUMMY;
		  /* double profitable attacks (forks) */
  if ( *prof_attack_square!= DUMMY && *(prof_attack_square+1) != DUMMY){
    evalp->ev_double_profitable_attack+=double_profitable_attack;
    if ( WHOONSQUARE(*prof_attack_square)->name!=PAWN &&
	 WHOONSQUARE(*(prof_attack_square+1))->name!=PAWN)
      if(our==MOVE_COLOR)  /* If our turn to move */
	evalp->ev_double_profitable_attack+=our_double_profitable_attack;
      else
	evalp->ev_double_profitable_attack+=double_profitable_attack;
				/*Double profitable attack at pieces */
    }
}
*/


static void near piece_eval()
{
BYTE cur_mask;
SQUARE_NUM cur_square,*passedp;
PIECE_COLOR passcolor;
SQUARE_INFO *sqr,*cursqip;
int i,j,k,*pawn_num;
PIECE_IN_LIST *piecep;

					  /* All about king */
  cur_square=KING_SQ[our];
  if ( party_flag & ( DEBUT | MIDDLEGAME) ) {
    evalp->ev_castle+=castle_eval[CASTLE[our]&0xF];/*Castle mask */
  }
  if (party_flag & ENDGAME) {
    evalp->ev_king_in_centre+=king_from_centre[cur_square];
    k=0;
    passcolor=our;
    passedp=passage[our];		/* M.D. */
    if (*passedp==DUMMY) {
	 passedp=passage[enemy];
	 passcolor=enemy;
    }
    for ( ; *passedp!=DUMMY; passedp++) {
       j=king_from_pawn[distance(cur_square,*passedp)];
       j+=pawn_from_queen[passcolor ? 8-GETLINE(*passedp): GETLINE(*passedp)+1];
       if (j>k) k=j;
    }
    evalp->ev_king_distance_to_passed_pawn+=k;
  }      /* End of king evaluation */

  for (i=1,piecep=PIECE_LIST_FIRST(our); i<NUM_PIECE ;piecep++,i++) {
						   /* loop on our pieces */
    if( (cur_square=piecep->where ) != DUMMY ) {           /* exist piece */
      cursqip=SQUAREP(cur_square);

      if(cursqip->wood.name==PAWN){   /* If pawn */
		 if(party_flag&(MIDDLEGAME|DEBUT)) {
		   if(our?(cur_square==d7 && SQUARE[d6].wood.name!=NOPIECE ||
			   cur_square==e7 && SQUARE[e6].wood.name!=NOPIECE):
			  (cur_square==d2 && SQUARE[d3].wood.name!=NOPIECE ||
			   cur_square==e2 && SQUARE[e3].wood.name!=NOPIECE)){
		     evalp->ev_pawn_blockade_on_de_lines+=pawn_blockade_on_de_lines;
		   }
		   if(our?(cur_square==f7 && SQUARE[f6].wood.name!=NOPIECE &&
			   SQUARE[f6].wood.color==WHITE_PIECE ):
			  (cur_square==f2 && SQUARE[f6].wood.name!=NOPIECE &&
			   SQUARE[f3].wood.color==BLACK_PIECE )) {
		     evalp->ev_pawn_blockade_by_enemy_on_f_line+=pawn_blockade_by_enemy_on_f_line;
		   }
		 }
      }
      else{    /* Piece */
			    /* Equal part for every piece */
	if((j=cursqip->attackedby.word[enemy] & BISHOP_MASK)!=0){
	  evalp->ev_piece_attacked_by_bishop+=piece_attacked_by_bishop*bit_quantity[j];
	}
	if((j=((unsigned)(cursqip->attackedby.word[enemy] & PAWN_MASK) >> 8) )!=0){
	  evalp->ev_piece_attacked_by_pawn+=piece_attacked_by_pawn*bit_quantity[j];
	}
			   /* End equal part */
	switch(cursqip->wood.name)  {
	  case ROOK:
	    if (party_flag & (DEBUT|MIDDLEGAME)) {
		  while(1){ /* Count rooks line */
													    /* At open line */
		    if(line[our][GETFILE(cur_square)] & OPEN){
			  evalp->ev_rook_open_semiopen_line+=rook_on_open_line;
			  break;
		    }
													  /* Attack open line */
		    cur_mask=cursqip->who_mask.byte[our][0];
		    sqr=SQUAREP(cur_square & 0xfff8);   /* the rook's rank on "a" line */
		    for (j=0; j<8; j++,sqr+=1) {
			  if(line[our][j] & OPEN){           /* If line is open */
			    if(cur_mask & sqr->attackedby.byte[our][0]){  /* We attack line */
				  if(!sqr->who_mask.word[our] &&   /* Not our piece */
				     (sqr->wood.name==DUMMY || sqr->wood.color!=our)) { /* Not our piece */
				    evalp->ev_rook_open_semiopen_line+=rook_attack_open_line;
				    break;
				  }
				  else{  /* Can't go at line, but attack it */
				    evalp->ev_rook_open_semiopen_line+=rook_attack_open_line/2;
				    break;
				  }
			    }   /* If We attack line */
			  }   /* If line is open */
		    } /* for lines */
												     /* At semiopen line */
		    if(line[our][GETFILE(cur_square)] & SEMIOPEN){
			  evalp->ev_rook_open_semiopen_line+=rook_on_semiopen_line;
			  break;
		    }
											    /* Attack semiopen line */
		    sqr=SQUAREP(cur_square & 0xfff8);   /* the rook's rank on "a" line */
		    for (j=0; j<8; j++,sqr+=1) {
			  if(line[our][j] & SEMIOPEN){           /* If line is semiopen */
			    if(cur_mask & sqr->attackedby.byte[our][0]){  /* We attack line */
				  if(!sqr->who_mask.word[our] &&   /* Not our piece */
				     (sqr->wood.name==DUMMY || sqr->wood.color!=our)) { /* Not our piece */
				    evalp->ev_rook_open_semiopen_line+=rook_attack_semiopen_line;
				    break;
				  }
				  else{  /* Can't go at line, but attack it */
				    evalp->ev_rook_open_semiopen_line+=rook_attack_semiopen_line/2;
				    break;
				  }
			    }   /* If We attack line */
			  }   /* If line is semiopen */
		    } /* For lines */
		    break;
		  }  /* While - count rook line */
		  if(GETLINE(cur_square)==(our?1:6)){
		    evalp->ev_rook_on_seven_line+=rook_on_seven_line;
		  }
	    } /* If debut or middlegame */
	   if (party_flag & ENDGAME) {
	     k=GETFILE(cur_square);
	     if (line[WHITE_PIECE][k] & PASSAGE) {
						     /* is it on the same line as the passed pawn */
		   pawn_num=pawns_lines[WHITE_PIECE][k];
		   while ((j=*pawn_num) !=DUMMY) {
		     if (j > (cur_square>>3)) {
			   evalp->ev_rook_behind_passage_pawn+=rook_behind_passage_pawn;
			   break;
		     }
		     pawn_num++;
		   }
	     } /* If passage */
		  if (line[BLACK_PIECE][k] & PASSAGE) {
		     /* is it on the same line as the passed pawn */
		    pawn_num=pawns_lines[BLACK_PIECE][k];
		    while ((j=*pawn_num) !=DUMMY) {
			  if (j < (cur_square>>3)) {
			    evalp->ev_rook_behind_passage_pawn+=rook_behind_passage_pawn;
			    break;
			  }
			  pawn_num++;
		    }
		  }
		  if((cur_square>>3)==(our?1:6)){
		  /* to check enemy pawns on seventh or enemy king on eighth line */
		    evalp->ev_rook_on_seven_line_in_endgame+=rook_on_seven_line_in_endgame;
		  }
	    } /* If endgame */
	    break;
	  case BISHOP:
	    if (party_flag & (DEBUT|MIDDLEGAME)) {
	      if(our?(cur_square==c8 || cur_square==f8):
		 (cur_square==c1 || cur_square==f1)) {
		evalp->ev_initial_bishop_knight_state+=initial_bishop_knight_state;
	      }
	      evalp->ev_bishop_exist+=bishop_exist;  /* just made */
	    }
	    break;
	  case KNIGHT:
	    if (party_flag & (DEBUT | MIDDLEGAME)) {
		if(our?(cur_square==b8 || cur_square==g8):
		       (cur_square==b1 || cur_square==g1)) {
		   evalp->ev_initial_bishop_knight_state+=initial_bishop_knight_state;
		}
	    }
	    break;
	}  /* end of switch on piece name */
      }  /* If of not pawn */
    }  /*  end of if our piece exists */
  }  /* end of our  piece loop */
  if (party_flag & (DEBUT | MIDDLEGAME)) {
     cur_mask=POS_MASK.word[our];
    if ( (cur_mask & BISHOP_MASK) == BISHOP_MASK)
	evalp->ev_two_bishop_existance+=two_bishop_existance;
    if ( (cur_mask & QUEEN_MASK) && (cur_mask & KNIGHT_MASK))
	evalp->ev_knight_and_queen_existance+=knight_and_queen_existance;
  }
}

static void near king_possibility()
{
  SQUARE_NUM *sqp,enemy_king_sq,cur_square;
  int k,i,j;

  enemy_king_sq=PIECE_LIST[enemy*NUM_PIECE].where;
  k=0;
  for(sqp=king_moves[enemy_king_sq];(cur_square=*sqp)!=DUMMY;sqp++){
    if(party_flag & (MIDDLEGAME|DEBUT))  {
      i=SQUAREP(cur_square)->attackedby.byte[our][1];
      if (i) {
	if(QUEEN_FLAG[our])  {
	  j= QUEEN_ALL_MASK.byte[our][1];
	  if (i & j) {
	    evalp->ev_piece_attack_king_possibility+=queen_attack_king_possibility*
		   bit_quantity[i&j];
						       /* attacks of promoted pawns */
	    i &=~j;
	  }
	}
	evalp->ev_pawn_attack_king_possibility+=pawns_attack_king_possibility[i];
	k=1;
      }
      evalp->ev_piece_attack_king_possibility+=pieces_attack_king_possibility[
	     SQUAREP(cur_square)->attackedby.byte[our][0]];
    }
  }                                                     /* endfor*/
  if (k) evalp->ev_pawn_attack_king_possibility+=add_for_pawn_attack_king_possibility;
}

static void near eval_central_squares()
{
  SQUARE_NUM *sqp,cur_square;
  SQUARE_INFO *cursqip;
  int j;

    if ( !( party_flag & (DEBUT | MIDDLEGAME))) return;
    for(sqp=central_square[our];(cur_square=*sqp)!=DUMMY;sqp++) {
						               /* central_squares*/
      cursqip=SQUAREP(cur_square);
      if ( party_flag & MIDDLEGAME) {
         evalp->ev_piece_attack_centre+=pieces_attack_centre[  /* piece attacks on the centre */
	       cursqip->attackedby.byte[our][0]];
         evalp->ev_pawn_attack_centre+=pawns_attack_centre[    /* pawn attacks on the centre */
	       cursqip->attackedby.byte[our][1]];
         if(QUEEN_FLAG[our])                                   /* add for many queens */
         evalp->ev_pawn_attack_centre-=bit_quantity[cursqip->attackedby.byte[our][1] &
	                      (QUEEN_ALL_MASK.byte[our][1])]*pawn_attack_centre;
      } else {
	 evalp->ev_piece_attack_centre+=pieces_attack_centre[  /* piece attacks on the centre */
	       cursqip->attackedby.byte[our][0] & ~QUEEN_MASK];
         evalp->ev_pawn_attack_centre+=pawns_attack_centre[    /* pawn attacks on the centre */
	       cursqip->attackedby.byte[our][1]];
         if(QUEEN_FLAG[our])                                   /* add for many queens */
         evalp->ev_pawn_attack_centre-=bit_quantity[cursqip->attackedby.byte[our][1] &
	                      (QUEEN_ALL_MASK.byte[our][1])]*pawn_attack_centre;
      }
      if(cursqip->who_mask.byte[our][1]){
	  evalp->ev_centre_pawn+=centre_pawn;		     /* pawn in the centre */
	  if(QUEEN_FLAG[our] && cursqip->wood.name!=PAWN)
          evalp->ev_centre_pawn-=centre_pawn;
      }
      if((j=cursqip->who_mask.word[our] & KNIGHT_MASK)!=0)   /* knight in the centre */
      evalp->ev_knight_in_centre+=knight_in_centre*bit_quantity[j];
    }
}

static void near eval_st_sq()
{
SQUARE_NUM *sqp,cur_square,j;
SQUARE_INFO *cursqip;
int k,i;

  for ( sqp= st_sq[our]; (cur_square=*sqp)!=DUMMY; sqp++) {
							      /* loop on strong squares of "our" */
    if (party_flag & ( DEBUT | MIDDLEGAME)) {
      cursqip=SQUAREP(cur_square);
      evalp->ev_strong_square+=strong_square;	              /* the number of strong squares */
      evalp->ev_piece_attack_st_sq+= 			      /* attacks on the strong squares */
	pieces_attack_st_sq[cursqip->attackedby.byte[our][0]];
	if ( cursqip->who_mask.word[our] & BISHOP_KNIGHT_MASK) {
							      /* pieces on the strong square */
	  switch ( cursqip->wood.name ) {
	    case KNIGHT: evalp->ev_knight_on_st_sq+= knight_on_st_sq;
			 break;
	    case BISHOP: evalp->ev_bishop_on_st_sq+= bishop_on_st_sq;
			 break;
	 }
       }
		}                                                         /* end of if DEBUT or MIDDLEGAME */
	k=GETFILE(cur_square);		                              /* current line */
    i=0;			                              /* pawn on the line number */
    while ( (j=pawns_lines[enemy][k][i]) !=DUMMY) {           /* while pawns */
	   if ( (our) ? ( j < GETLINE(cur_square)) : ( j > GETLINE(cur_square) ) )
	      evalp->ev_pawn_before_enemy_st_sq-=pawn_before_enemy_st_sq;
							      /* backward pawn */
       i++;
    }
  }                                                           /* for st_sq */
}

static void near far_king_possibility()
{
  SQUARE_NUM cur_square,our_king_sq,cur_edge,begin_square;
  int cur_dir,curdirstep;

   if (!QUEEN_FLAG[enemy] && (PIECE_LIST[enemy*NUM_PIECE+WHITE_QUEEN].where==DUMMY))
	return;	                                      /* no enemy queens */
   our_king_sq=PIECE_LIST[our*NUM_PIECE].where;
   curdirstep=1;
   for(cur_dir=0;cur_dir<NDIR;cur_dir+=curdirstep)  {
	 cur_edge=SQUAREP(our_king_sq)->edge[cur_dir];
	 begin_square=our_king_sq+increment[cur_dir];
	 if(cur_edge==our_king_sq) continue;
	 if(WHOONSQUARE(cur_edge)->name==NOPIECE)
	   evalp->ev_bishop_rook_king_possibility+=bishop_rook_king_possibility;
	 for(cur_square=begin_square;cur_square!=cur_edge;
			  cur_square+=increment[cur_dir])  {
       evalp->ev_bishop_rook_king_possibility+=bishop_rook_king_possibility;
     }
   }
}

static void near passage_pawn_factors()
{
  SQUARE_NUM  cur_square,*passagep;
  SQUARE_INFO *sqi1;
  int j;

   for(passagep=passage[our];(cur_square=*passagep)!=DUMMY;passagep++)  {
     sqi1=SQUAREP(cur_square+(our?-NLINE:NLINE));
     if(sqi1->who_mask.word[enemy])  {
       evalp->ev_block_passage_pawn+=block_passage_pawn;                             /* blocked by an enemy piece */
     }
     if((j=sqi1->attackedby.byte[our][0])!=0)
       evalp->ev_attack_passage_trace+=attack_passage_trace*bit_quantity[j];
     if((j=sqi1->attackedby.byte[our][1])!=0)
       evalp->ev_attack_passage_trace+=attack_passage_trace*bit_quantity[j];
   }                                                          /* end of loop on our passed pawns squares */
   for(passagep=passage[enemy];(cur_square=*passagep)!=DUMMY;passagep++)  {
     sqi1=SQUAREP(cur_square+(our ? NLINE: -NLINE));
     if((j=sqi1->attackedby.byte[our][0])!=0)
       evalp->ev_attack_passage_trace+=attack_passage_trace*bit_quantity[j];
     if((j=sqi1->attackedby.byte[our][1])!=0)
       evalp->ev_attack_passage_trace+=attack_passage_trace*bit_quantity[j];
   }                                                          /* end of loop on enemy passed pawns squares */
}
static void near possibilities()
{
  BYTE  *attbyp, *last_attbyp;
  int k;
  SQUARE_NUM sq;

	last_attbyp=&(SQUARE[h8].attackedby.byte[our][0]);
    if (party_flag & DEBUT) {
      for(sq=0,attbyp=&(SQUARE[a1].attackedby.byte[our][0]);
	  attbyp<=last_attbyp;attbyp+=sizeof(SQUARE_INFO),sq++)  {
	if(*(WORD *)attbyp){
	  k=bit_quantity[(*attbyp) & ~(QUEEN_MASK|KING_MASK)]+(*(attbyp+1)!=0);
	  evalp->ev_pieces_possibility+=k/* *pieces_possibilityA.S.==1*/;
/*	  if(k && (sq>>5)!=our)
	    evalp->ev_att_enemy_half+=k*pieces_possibility; */
	}
      }
    }
    else {
      for(sq=0,attbyp=&(SQUARE[a1].attackedby.byte[our][0]);
	  attbyp<=last_attbyp;attbyp+=sizeof(SQUARE_INFO),sq++) {
	if(*(WORD *)attbyp){
	  k=bit_quantity[*attbyp&~KING_MASK]+(*(attbyp+1)!=0);
	  evalp->ev_pieces_possibility+=k/**pieces_possibilityA.S.==1*/;
/*	  if(k && (sq>>5)!=our)
	    evalp->ev_att_enemy_half+=k*pieces_possibility; */
	}
      }
    }
}
static void near kings_opposition()
{
  SQUARE_NUM sq1,sq2;
							     /* Only pawns*/
  if((POS_MASK.byte[WHITE_PIECE][0]|POS_MASK.byte[BLACK_PIECE][0])==KING_MASK){
    sq1=PIECE_LIST[0].where;
    sq2=PIECE_LIST[NUM_PIECE].where;
    if(abs(sq1-sq2)==2 || abs(sq1-sq2)==2*NLINE){
	  color_ind_eval.ev_king_opposition-=king_opposition;
	}
    if (MOVE_COLOR) color_ind_eval.ev_king_opposition=-color_ind_eval.ev_king_opposition;
  }
}
static void near king_distance()
{
  div_t s1,s2;
  #define CENTER(x)  ((x>3)?x-4:3-x)

    s1=div(PIECE_LIST[0].where,NLINE);                        /* white king */
    s2=div(PIECE_LIST[NUM_PIECE].where,NLINE);                /* black king */
	color_ind_eval.ev_king_distance=kings_distance*max(abs(s1.quot-s2.quot),abs(s1.rem-s2.rem));

    if(checkmate_color)s1.quot=s2.quot,s1.rem=s2.rem;
	color_ind_eval.ev_king_centre_distance=king_center_distance*(abs(s1.quot-4)+abs(s1.rem-4));
	if (checkmate_color!=WHITE_PIECE) {
	  color_ind_eval.ev_king_distance=-color_ind_eval.ev_king_distance;
	  color_ind_eval.ev_king_centre_distance=-color_ind_eval.ev_king_centre_distance;
	}
}
static void near calc_change_resistance()
{
  MAT_EVAL mat;
  PIECE_COLOR who;

	if (abs(MATERIAL_EVAL)<4) color_ind_eval.ev_change_resistens=0;
	else{
	  who=turn_move;					/*may be turn_move */
	  mat=mat_without_pawns[who];
	  if (mat)  color_ind_eval.ev_change_resistens=
		change_resistance*(beg_mat_without_pawns[who]-mat)/mat;
	  else {
	color_ind_eval.ev_change_resistens=(MATERIAL_EVAL >0)?50:-50;
      }
      color_ind_eval.ev_change_resistens*=MATERIAL_EVAL/4;
      if (MOVE_COLOR)
	color_ind_eval.ev_change_resistens=-color_ind_eval.ev_change_resistens;
    }
}


static void near eval_prepare ( void )
{
  evalfp=&all_eval[0];
  setmem (evalfp,sizeof(all_eval),NULL);
  setmem (&color_ind_eval,sizeof(struct idepend_eval),NULL);
}

static POS_EVAL near eval_sum ( void )
{
  POS_EVAL *curp,*enemy_curp;
  POS_EVAL result=0;
  int i;

  curp=(POS_EVAL *)evalfp;
  (char *)enemy_curp=(char *)curp+sizeof(struct EVAL_STRUCT);
  for (i=0;i<MAX_POINT;i++,curp++,enemy_curp++)  
	   result+=(*curp-*enemy_curp);
  return(result);
}

static POS_EVAL near eval_independ_sum ( void )
{
 POS_EVAL *curp;
 POS_EVAL result=0;
 int i;


 for (i=0,curp=(POS_EVAL *)&color_ind_eval;i<MAX_IND;i++,curp++)  
   result+=*curp;
 return(result);
}

int prof_cmp(const void *src1, const void *src2)
				/* Compare profits for sorting */
				/* This function cannot have modifier "near" */
{
  return(((PROFIT_SQ *)src2)->profit-((PROFIT_SQ *)src1)->profit);
}

//PIECE_MASK defencing_piece;  /* Piece defencing another pieces */
/*
void NEAR prof_sort(PROFIT_SQ *first,PROFIT_SQ *last )
{
PROFIT_SQ tmp;
  if( (first+1)==(last-1) ) {
	if( first->profit < (last-1)->profit ) {
	  tmp=*(last-1);*(last-1)=*first;*first=tmp;//swap_moves( first, last-1 );
	}
  }
  else
	qsort(first,last-first,sizeof(*first),prof_cmp);
}
*/

void NEAR set_profitable_attack(void)
{
  int i;
  SQUARE_NUM cur_square;
  PROFIT_SQ *prof_sqp;
  SQUARE_INFO *sqip;
  WORD our_att,enemy_att;
  PIECE_IN_LIST *piecep;
  PIECE_COLOR our,enemy;
  MAT_EVAL our_lost,our_cost;

  DEFENCING_PIECE.dwrd=0;
  for(our=0,enemy=1-our;our<NCOLOR;our++,enemy=1-our){  /* For colors */
	prof_sqp=PROFITS[our];
	for ( i=1,piecep=&PIECE_LIST[(our<<4)+1]; i<NUM_PIECE;piecep++,i++) {
							 /* loop on our pieces */
	  if ( (cur_square=piecep->where ) == DUMMY ) continue;      /* no piece */
	  sqip=SQUAREP(cur_square);
	  our_att=sqip->attackedby.word[our];       /* our attacks on the piece */
	  DEFENCING_PIECE.word[our]|=our_att;
	  enemy_att=sqip->attackedby.word[enemy]; /* enemy's attacks on the square */
	  our_cost=sqip->wood.cost;
	  if((prof_sqp->profit=LOST(our_att,enemy_att,our_cost,our_lost))!=0) {
				  /* definition of profitable attack*/
		prof_sqp++->square=cur_square;
	  }                                               /* if profitable */
	}     /* for enemy pieces */
	prof_sqp->profit=0;
	prof_sqp->square=DUMMY;  /* Set DUMMY at the end of array */
//      if(PROFITS[our]+1<prof_sqp)   // A.S. 19.11.91 PROFITS not sorted!!!!!!
//	  prof_sort( PROFITS[our], prof_sqp );
//	  qsort(PROFITS[our],prof_sqp-PROFITS[our],sizeof(*prof_sqp),prof_cmp);
  }  /* for colors */
}

void NEAR set_new_attack(void)
{
PROFIT_SQ *sqp;    /* Current attacked square */
PROFIT_SQ *attsqp;    /* New attacked square */
PROFIT_SQ *prevsqp;     /* Previous attacked square */
PROFIT_SQ *prevattsqp;  /* Previous new attacked square */
int attwasinprev;

  for(our=0,enemy=1-our;our<NCOLOR;our++,enemy=1-our){  /* For colors */
    attsqp=NEWATTACKED[our];
    for(sqp=PROFITS[our]; sqp->square!=DUMMY; sqp++){  /* For our attacked square */
      attwasinprev=0;
      for(prevsqp=(pos_sp-1)->n.profits[our]; prevsqp->square!=DUMMY; prevsqp++){  /* For our previous attacked square */
	if(sqp->square==prevsqp->square){   /* Attack was in previous position */
	  attwasinprev=1;
	  if(NSLOW==pos_sp->a.nslow){        /* Move was not slow */
	    for(prevattsqp=(pos_sp-1)->n.newattacked[our]; prevattsqp->square!=DUMMY; prevattsqp++){  /* For our previous new attacked square */
	      if(sqp->square==prevattsqp->square){   /* Attack was new */
		attsqp->square=sqp->square;  /* Attack is new */
		attsqp->profit=sqp->profit;
		attsqp++;
		break;  /* Stop searching our previous new attacked square */
	      }
	    }
	  }
	  else{}  /* Move was slow ------> Attack is not new */
	  break;  /* Test next attacked square */
	} /* If attack was in previous position */
      } /* For our previous attacked square */
      if(!attwasinprev){  /* Attack wasn't in previous position */
	attsqp->square=sqp->square;   /* Attack is new */
	attsqp->profit=sqp->profit;
	attsqp++;
      }
    }   /* For our attacked square */
    attsqp->square=DUMMY;
//  if(NEWATTACKED[our]+1<attsqp)
//    qsort(NEWATTACKED[our],attsqp-NEWATTACKED[our],sizeof(*attsqp),prof_cmp);
  }   /* For colors */
}

int NEAR double_attacked(PIECE_COLOR our)
{
  PROFIT_SQ *prof_sqp;

  prof_sqp=/*prof_attacked_square*/PROFITS[our];
  if( prof_sqp->square!= DUMMY && (prof_sqp+1)->square !=DUMMY) return(1);
  return(0);
}

int NEAR attacked(PIECE_COLOR our)
{
  return(PROFITS[our][0].square!=DUMMY);
}

static void near profitable_attack()  /* Need prof_attack_square filled */
{
  PROFIT_SQ *prof_sqp;

  for(prof_sqp=PROFITS[our]; prof_sqp->square!=DUMMY ; prof_sqp++)
	evalp->ev_profitable_attacked+=profitable_attacked;

  if(double_attacked(enemy))
	if(our==MOVE_COLOR){  /* We attack enemy */
/*	  evalp->ev_double_profitable_attack+=our_double_profitable_attack; */
	}
	else{      /* We attacked */
	  if(!select_en)
	evalp->ev_double_profitable_attack+=double_profitable_attack;
   }
}

extern int bound_attacked_flag;

static void near eval_bound_pieces( void )  /* Need prof_attack_square filled */
{
PROFIT_SQ *sqp;   /* Enemy profitable attacked square pointer */

  evalp->ev_bound_piece+=bit_quantity[PIECE_BOUND_MASK[our][our]]*bound_piece;
  evalp->ev_bound_piece+=bit_quantity[PIECE_BOUND_MASK[our][enemy]]*enemy_bound_piece;

  for(sqp=PROFITS[enemy]; sqp->square!=DUMMY; sqp++){  /* For all profitable attacked squares */
	if(square_bounded(sqp->square,enemy)){           /* If attacked square bounded */
	  evalp->ev_profitable_attack_on_bound_piece+=our_profitable_attack_on_bound_piece;
/*
      if(our==MOVE_COLOR)  /* If our turn to move */
	evalp->ev_profitable_attack_on_bound_piece+=our_profitable_attack_on_bound_piece;
      else{  /* We attacked */
	if(!NULL_ENABLE)
	  evalp->ev_profitable_attack_on_bound_piece+=profitable_attack_on_bound_piece;
	else bound_attacked_flag=1;
	  }
*/
    }   /* If attacked square bounded */
  }    /* For all profitable attacked squares */
}

int NEAR bounded_attacked(PIECE_COLOR our)
{
PROFIT_SQ *sqp;   /* Profitable attacked square pointer */

  for(sqp=PROFITS[our]; sqp->square!=DUMMY; sqp++){  /* For all profitable attacked squares */
	if(square_bounded(sqp->square,our))        /* If attacked square bounded */
      return 1;
  }
  return 0;
}

void NEAR set_bound_pieces(void)
{
}

/**************** Passage pawn extention algorithm *********************/

int flPassExt=1,flPassGen;
int NEAR PassagePawn(void)
{
int *cur_pawn,*enemy_pawn,*enemy_right,
    *enemy_left,dummy[1];
SQUARE_NUM cur_square,*passagep;
int i,j;
int ret=0;
PIECE_COLOR our,enemy;

  *dummy=DUMMY;
/*  for(our=0;our<NCOLOR;our++)  */ our=MOVE_COLOR; {   /* loop on colors */

    enemy=1-our;
    passagep=pos_sp->n.passage;
    for(i=0;i<NLINE;i++){        /* loop on lines */
      cur_pawn= pawns_lines[our][i];
      enemy_pawn= pawns_lines[enemy][i];
      enemy_left=(i==0)?  dummy: pawns_lines[enemy][i-1];
      enemy_right=(i==7)? dummy: pawns_lines[enemy][i+1];
      for ( j=0; cur_pawn[j]!=DUMMY; j++){    /* loop on double pawn */
	cur_square = (cur_pawn[j] << 3) + i;
	if(enemy_pawn[0]==DUMMY)  {                     /*semiopen pawn*/
	  if((enemy_left[0]==DUMMY || (our?
		enemy_left[0]>=cur_pawn[j]-1:enemy_left[0]<=cur_pawn[j]+1))&&
	     (enemy_right[0]==DUMMY || (our?
		enemy_right[0]>=cur_pawn[j]-1:enemy_right[0]<=cur_pawn[j]+1))){
	    *passagep++=cur_square;
	    ret=1;
	  }
	}
      }   /* loop on double pawn */
    }  /* loop on line */
    *passagep=DUMMY;
  }   /* loop on color */
  return ret;
}