
		/**\
		 	Program file "downup.c"		
		 					
		 	       Functions: down()	
		 			   up()		
		\**/

#include <mem.h>
#include <string.h>
#include <conio.h>
#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "ks_game.h"
#include "proc.h"
#include "face.h"
#include "ksiwind.h"
#include "ksibdraw.h"
#include "ksichess.h"
#include "ksiwork.h"
#include "facelib.h"

long int lambda;		/* move counter */
long int lambdafv;
long int lambdasearch;
int lambdamove[NUM_MOVES_IN_POS];
long int lambdaeval;
extern int begin_level;
int sumnumber[NCOLOR];


static void near deletecurrent(void);  /* Delete CURRENT from move_stk */

void NEAR copy_position_n( void ) /*copy near part of position */
{
}

BOOLEAN NEAR down (void)
{
 int notdone;
 static long int oldlambda=0;

  if (level==0 && stoptimeafter()) breakflag=TIMEBREAK;
  if(breakflag) return(0);

  while(1) {  /* While not legal move. */
    if(CURRENT==LAST) {		/* Have we got some moves to move ? */
/*      if(level>1) CURRENT=FIRST;	/* Forget viewed moves */*/
      if(level) LAST=generator(CURRENT,1);		/* Call generator to generate next moves */
      if(CURRENT==LAST){         	/* It can't generate moves */
	return(FALSE);
      }
    }				  /* "down()" failed */

    notdone=move();
    if(!notdone) break;  /* Legal move found */
    move_back();
    deletecurrent();   /* CURRENT++; */
  }  /* While not legal move. */
  CURR_N=CURR_N+1;
  if(!level){
    show_current();
	if(CURR_N>1) lambdamove[CURR_N-2]=(int)(lambda-oldlambda);
	oldlambda=lambda;
  }
  lambda++;lambdasearch++;
  sumnumber[Our_color]+=CURR_N;
  level++; pos_sp++;
  Our_color=MOVE_COLOR;
  Enemy_color=reverse_color(Our_color);
  clear_betterbranch();
  if( thinktime==MYTIME || level<5 )showchar( 0x11, level, RED +16*BLUE );
  return(TRUE);	            /* down succeeded	*/
}

BOOLEAN NEAR up(void)
{
  if( thinktime==MYTIME || level<5 )showchar( '-', level, RED +16*BLUE );
  if(level==begin_level) return (FALSE);
  level--; pos_sp--;
  Our_color=MOVE_COLOR;
  Enemy_color=reverse_color(Our_color);
  sumnumber[Our_color]-=CURR_N;
  move_back();
  if(breakflag) CURRENT=LAST;   /*2.04.90. Shabalin*/
  else CURRENT++;
  return (TRUE);
}

static void near deletecurrent(void)  /* Delete CURRENT from move_stk */
{
  LAST--;
  MEMCPY(CURRENT,CURRENT+1,sizeof(MOVE)*(LAST-CURRENT));
}