
		/**\
		 	Program file "decode.c"		
		 					
		 	       Functions: decode()	
		\**/


#include "facelib.h"
#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "proc.h"
#include "ks_macro.h"
#include "gener.h" /*PROFIT_LIMIT */
#include <string.h>
/*
static char near name_to_char(PIECE_NAME piece_name)
{
  switch (piece_name) {
    case KING:  return('K');
    case QUEEN: return('Q');
    case ROOK:  return('R');
    case BISHOP:return('B');
    case KNIGHT:return('N');
    case PAWN:  return('P');
  }
  return('#');
}
*/
extern char pctoch[];

char far * decode(char far *dest, const MOVE *movep, POSITION *posp ,int brief)
{
/* p-piece, f1-first field, f2-second field, p-into p )	*/
/* output  format:  pf1-f2p				*/
  PIECE_NAME cur_name;
  int kill,semi_brief,cur_piece,i;
  WORD cur_att;
  SQUARE_NUM from,to,temp;
  BYTE flags;
  PIECE_NAME att;
  PIECE_COLOR color;
  char num_add_ch=0;
  static char far null_str[]="NULL    ";
  static char far kill_lcast_str[]="O-0-0   ";
  static char far lcast_str[]="0-0-0   ";
  static char far kill_scast_str[]="O-0     ";
  static char far scast_str[]="0-0     ";


    if ( movep ) {
      flags=movep->flags;
	  kill=movep->flags & M_KILLER;
	  if(flags & M_NULLMOVE)
		 return(FARSTPCPY(dest,null_str));
      if(flags & M_CASTLE_LEFT) {
	if(kill) dest=FARSTPCPY(dest,lcast_str);
	else     dest=FARSTPCPY(dest,kill_lcast_str);
	goto hash_mark;
      }
      if(flags & M_CASTLE_RIGHT) {
	if(kill) dest=FARSTPCPY(dest,kill_scast_str);
	else     dest=FARSTPCPY(dest,scast_str);
	goto hash_mark;
      }
      to=movep->to;
      from=movep->from;
      color=posp->a.move_color;
      cur_att=posp->n.square[to].attackedby.word[color];
      cur_name=posp->n.square[from].wood.name;
      if( !brief || cur_name!=PAWN ){            /* if pawn is moving */
		*dest++=pctoch[cur_name];
        if(kill && !brief) *(dest-1)+=-'A'+'a';	/* There was killer move */
					/* 1st pos = piece code */
      }
      if (!brief) {
        *dest++= 'a' + GETFILE(from);		/* 2nd pos = alfa field from */
        *dest++= '1' + GETLINE(from);		/* 3rd pos = num field from */
      }
      else if( !(cur_name==PAWN) ) {
	cur_att&=PIECE_MASKS[cur_name].word[color];
	if( (semi_brief=bit_quantity[(BYTE)cur_att]+
	    bit_quantity[cur_att>>8]) > 1){
	    /*if more then 1 pieces with equal name attack same square */
	  for(cur_piece=color_to_king_num(color)+1,i=0;
	      i<semi_brief-1;cur_piece++) {
	    temp=posp->n.piece_list[cur_piece].where;
	    if(posp->n.square[temp].wood.name==cur_name && temp!=from){
		     /* Unexpressible  briefy */
	      if( GETFILE(temp)==GETFILE(from) ) num_add_ch|=1;
				/* 2nd pos = alfa field from */
	      if( GETLINE(temp)==GETLINE(from) ) num_add_ch|=2;
				/* 3rd pos = num field from */
		  i++;
	    }/* if on same raw or column */
	  }/* for pieces */
	  if ( (num_add_ch & 2) || (num_add_ch==0 && (cur_name == KNIGHT ||
	      cur_name == ROOK) )  )
	      *dest++= 'a' + GETFILE(from);
	  if ( num_add_ch & 1 )  *dest++= '1' + GETLINE(from);
	}/*if */
      }
					/* 4th pos = 'x' if capture else '-'*/
      if(((att=posp->n.square[to].wood.name)!=NOPIECE) ||
	(posp->a.en_pass==to && cur_name==PAWN) )
	if( !brief || cur_name!=PAWN ) *dest++='x';
        else *dest++= 'a' + GETFILE(from);
      else if( !brief ) *dest++='-';

      if( !brief && movep->profit>PROFIT_LIMIT)
          *(dest-1)=att!=NOPIECE ? '*': '=';   /* Profitable move */
      *dest++= 'a' + (to&7);		/* 5th pos = alfa field to */
      if( !brief || cur_name!=PAWN || att==NOPIECE )
        *dest++= '1' + (to>>3);		/* 6th pos = num field to */

      if(( flags & M_PROMOTION )&&( flags & M_ISCHECK )){
	*dest++='Q'; *dest++='+';
      }
      else if( flags & M_PROMOTION){ *dest++= 'Q'; *dest++=' '; }
      else if( flags & M_ISCHECK){ *dest++='+'; *dest++=' '; }
      else if(!brief) { *dest++=' '; *dest++=' ';}                    
      else {  *dest++=' ';}                    
      *dest='\0';
      if( brief ) return ( dest );/* no hash mark */
    }
hash_mark:
    if(movep->profit==HASH_PROFIT) *(dest-2)='H';
    else if(movep->profit==HASH_ATTACK_PROFIT) *(dest-2)='h';
    return ( dest );
}
