
		/**\
		 	Program file "ks_debug.c"	
		 					
		 	       Function: init_debug() 	
		 	                 start_debug() 	
		 	                russin_debug() 	
		\**/

#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "proc.h"
#include "ks_game.h"
#include "hashpos.h"
#include "experim.h"

#include <string.h>
#include <mem.h>
#include <stdio.h>

#include "ksichess.h"
#include "ksiutil.h"
#include "ksiwork.h"

#define MAX_VARIANT_SIZE 8

    /* Global variables for programm debugging. */

int print_level;          /* Maximum printed level. */
BOOLEAN print_eval_flag;  /* Set TRUE, if eval information is to be printed. */
PRINT_FLAG print_flag;    /* Set print regime. */
int print_fv;              /* Print search in fv0 and fv1. */
BOOLEAN fvflag;           /* Set TRUE, if fv0 is active. */
BOOLEAN fv0flag;           /* Set TRUE, if fv0 is active. */
BOOLEAN fv1flag;           /* Set TRUE, if fv1 is active. */
BOOLEAN cascadeflag;      /* Set TRUE, if cascade is active. */
int print_time;           /* Set TRUE, if time information is to be printed. */
int print_hash;
int print_full_eval;
LSTRING /*far*/ deb_str="\0";      /* Used in td to see the current brunch. */

LSTRING far variant_str=  "\0";  /* Variant to be printed in the form of string. */
MOVE variant_moves[MAX_VARIANT_SIZE];
				   /* The same in the form of MOVE's array. */
int variant_depth;        /* The depth of variant to be printed. */

long start_print_num;      /* First position to be printed. */
long stop_print_num;       /* Last position to be printed. */

int killer_print_num;   /* Number of killer move to be printed. */
int print_overflow;     /* Minimum printed level. */

LSTRING far old;                       /* The old traced brunch. */


      /* Static functions. */

static int near trace_killer(void);    /* Print variants with the nuber of killer */
				  /* move more than defined number. */
static int near trace_overflow(void);  /* Print variant at depth greater than */
				  /* defined depth. */
static int near trace_all(void);       /* Print all variants. */
static int near trace_variant(void);   /* Print entered variant. */
static int near trace_number(void);    /* Print variants with the number of  */
			  /* positions from start number to stop number. */

void NEAR init_debug(void)
{
 print_level=0;     /* Init debug variables at the beginning of */
 print_flag=0;              /* program. */
 killer_print_num=0;
 print_overflow=0;
 print_fv=0;
 print_time=0;
 print_full_eval=0;
 print_hash=0;
 set_branchptr();
}

void NEAR start_debug(void)
{
 lambda=0;
 if(!decodvarstr(variant_str,variant_moves)) print_flag&=~PRINT_VARIANT;
 clear_betterbranch();
 if( print_hash ) set_print_hash_index();/* A.S. evaluate hash of variant */
}

static int near trace_all( void )
{
  LSTRING prn;
  if (!level) return(0);
  if(print_level && level<=print_level)
    if (trace_pos(prn,0)) lastlinereply(prn);
  return(0);
}

static int near trace_variant( void )
{
  LSTRING prn;
  int l;
  if(print_level && level>print_level) return(0);
  for (l=0; l<variant_depth; l++)
	if(!movecmp(pos_stk[l].a.current,&variant_moves[l]))
	  return(0);
  if (trace_pos(prn,0))	
	lastlinereply(prn);
  return(0);
}

static int near trace_number( void )
{
  LSTRING prn;
  if(print_level && level>print_level) return(0);
  if(lambda>=start_print_num && lambda<=stop_print_num)
	if (trace_pos(prn,0))	lastlinereply(prn);
  return(0);
}

static int near trace_overflow( void )
{
  LSTRING prn;
  if(level>print_overflow)
	if (trace_pos(prn,0))	lastlinereply(prn);
  return(0);
}

static int near trace_selective( void )
{
  LSTRING prn;      /* Trace position if deepening lose */
  if(POSFLAGS & P_DEEPENING /*&& (EVAL(level).position<BETA(level).position)*/)
	if (trace_pos(prn,0))	lastlinereply(prn);
  return(0);
}

static int near trace_killer( void )
{
  LSTRING prn;

  if (BEST_N >= killer_print_num)
	if(trace_pos(prn,1)) lastlinereply(prn);
  return(0);
}

int printsmth;

int setprintflag(void)
{
  if( killer_print_num ) print_flag|=PRINT_KILLER;
  else print_flag&=~PRINT_KILLER;
  if( print_overflow ) print_flag|=PRINT_OVERFLOW;
  else print_flag&=~PRINT_OVERFLOW;
  if(print_level) print_flag|=PRINT_LEVEL;
  else print_flag&=~PRINT_LEVEL;
  if(print_flag || print_time || print_hash) printsmth=1;
  else printsmth=0;
  return(0);
}

void NEAR russian_debug(void)
{
  if( level>MAXPRINTLEVEL ) return;
  if( !print_fv && !cascadeflag) return;
  if( print_flag & PRINT_SELECTIVE ) trace_selective();
  if( killer_print_num )  trace_killer();
  if( print_overflow ) trace_overflow();
  if( print_flag & PRINT_VARIANT ) { trace_variant(); return; }
  if( print_flag & PRINT_NUMBER  ) { trace_number(); return; }
  trace_all();
  return;
}

int check_variant( void )
{
	if( *variant_str ) return(1);
	else return(0);
}

BOOLEAN NEAR decodvarstr(char far *str, MOVE *mp)  /* Decode entered variant into the */
{                                        /* form of MOVE's array. */
static FULLMOVE fullmove;
int i;

  variant_depth=0;
  for(i=0; i<MAX_VARIANT_SIZE && *str; i++){
    if( !(str=sscanmove(str, &fullmove)) ) break;
    fulltomove(&fullmove,mp++);
    variant_depth++;
  }
  return(variant_depth);
}
