/*
	 ͻ
	                Correction  of  edges  and  masks               
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/

#include <mem.h>    /* NULL */
#include <time.h>   /* clock */
#include "chess.h"
#include "current.h"
#include "proc.h"
#include "ks_corr.h"
#include "global.h"

#define SQSIZE sizeof(SQUARE_INFO)  /* size of square info in bytes */
				   /* 0   1   2   3   4   5   6   7 */
DIR reverse[NDIR]=  { 4,  5,  6,  7,  0,  1,  2,  3 };
#define reverse( dir ) ( ( dir )^4 )
int increment[NDIR]={ 7,  8,  9,  1, -7, -8, -9, -1 };
int knincrement[NDIR]={ 6, 15 , 17, 10, -6, -15, -17, -10 };
int byteshift[NDIR]={ SQSIZE*7, SQSIZE*8, SQSIZE*9, SQSIZE*1,
			  SQSIZE*(-7),SQSIZE*(-8),SQSIZE*(-9),SQSIZE*(-1)};
int knbyteshift[NDIR]={ SQSIZE*6, SQSIZE*15, SQSIZE*17, SQSIZE*10,
			  SQSIZE*(-6),SQSIZE*(-15),SQSIZE*(-17),SQSIZE*(-10)};
MAT_EVAL const piece_cost[NPIECE+1]={ 0, KING_COST, QUEEN_COST, ROOK_COST, BISHOP_COST, KNIGHT_COST, PAWN_COST };
/*
PIECE_MASK piece_mask[NPIECE+1];
*/

BYTE npiece[NCOLOR][NPIECE+1]; /* current number of pieces on board */

static void near setedge( void ); /* to set edge on dir */
static void near deledge( void ); /* to clear edge on dir */
static void near setallmask( void ); /* set masks on dir */
/*static void near setonemask( void );/* set mask on first square */*/
static void near clearallmask( void );/* to clear all masks on direction */
/*static void near clearonemask( void );/* to clear one mask on first square */*/

/* Static variables for use in setedge, deledge, setmask and clearmask */
static SQUARE_NUM Newedge;  /* new edge to set */
static DIR Rdir;            /* direction from edge to main square */
static int Shift;           /* shift in bytes to next square on dir */
static SQUARE_INFO *Sqp,    /* pointer to current square */
	*Forep,                 /* pointer to foreward edge */
	*Backp;                 /* pointer to backward edge */
static DWRD Clmask, Setmask;/* masks to clear and set on current dir */

void near setedge( void )/* to set new edge on dir */
{
  SQUARE_NUM *src, *dest;

	src=Sqp->edge+Rdir;       /* get pointer for stop */
	dest=Forep->edge+Rdir;    /* get dest */
	while( dest!=src ){      /* moving from dest to source */
		*dest=Newedge;       /* set new edge on dest */
		(char *)dest-=Shift; /* shift to next square */
	}                        /* shift is from src to dest=>'-' */
}

void near deledge( void )/* to clear edge on dir */
{
  SQUARE_NUM newedge;
  SQUARE_NUM *src, *dest;

	src=Sqp->edge+Rdir;      /* get pointer for stop */
	dest=Forep->edge+Rdir;   /* get dest */
	newedge=*src;            /* get new edge */
	while( dest!=src ){      /* moving from dest to source */
		*dest=newedge;       /* set new edge on dest */
		(char *)dest-=Shift; /* shift to next square */
	}                        /* shift is from src to dest */
}
				 /* set masks on all dir */
#define SETALLMASK								\
/*	while( Forep!=Sqp ){							\
		*(DWRD *)(&Forep->attackedby)|=Setmask; /* set new mask */ \
		(char *)Forep-=Shift;					\
	}                                                                       \
*/                                                                              \
	setallmask();
void near setallmask( void )
{
  PIECE_MASK *dest, *src;

	dest=&(Forep->attackedby); /* get dest for mask setting */
	src= &(Sqp->attackedby); /* get source */
	while( dest!=src ){      /* move from dest to source */
		*(DWRD *)dest|=Setmask; /* set new mask */
		(char *)dest-=Shift; /* increment */
	}
}

				 /* set masks to first square on dir */
#define SETONEMASK *(DWRD *)((char *)(&Sqp->attackedby)+Shift)|=Setmask;
/*void near setonemask( void )
{
  PIECE_MASK *dest;

	dest=&(Sqp->attackedby); /* get pointer to square */
	(char *)dest+=Shift;     /* add shift to next square in bytes */
	*(DWRD *)dest|=Setmask;
}
*/

void near clearallmask( void )
{
  PIECE_MASK *dest,*src;

	dest=&(Forep->attackedby);
	src= &(Sqp->attackedby);
	while( dest!=src ){
		*(DWRD *)dest&=Clmask; /* clear old mask */
		(char *)dest-=Shift;
	}
}

#define CLEARALLMASK								\
/*	while( Forep!=Sqp ){							\
		*(DWRD *)(&Forep->attackedby)&=Clmask; /* clear old mask */ \
		(char *)Forep-=Shift;					\
	}                                                                       \
	*/                                                                      \
	clearallmask();
#define CLEARONEMASK *(DWRD *)((char *)(&Sqp->attackedby)+Shift)&=Clmask;
/*void near clearonemask( void )
{
  PIECE_MASK *dest;

	dest=&(Sqp->attackedby);
	(char *)dest+=Shift;     /* add shift to next square in bytes */
	*(DWRD *)dest&=Clmask;
} */

#define ALL  2               /* how many squares on direction */
#define ONE  1               /* attacked by corresp. piece */
#define NOT  0               /* All squares, only first square or none */
#define B_PAWN 7

BYTE numattack[NPIECE+1+1][NDIR]=
/*              0    1    2    3    4    5    6    7   direction */
/* dummy  */{{ NOT, NOT, NOT, NOT, NOT, NOT, NOT, NOT},
/* king   */ { ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE},
/* queen  */ { ALL, ALL, ALL, ALL, ALL, ALL, ALL, ALL},
/* rook   */ { NOT, ALL, NOT, ALL, NOT, ALL, NOT, ALL},
/* bishop */ { ALL, NOT, ALL, NOT, ALL, NOT, ALL, NOT},
/* knight */ { ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE},
/* W pawn */ { ONE, NOT, ONE, NOT, NOT, NOT, NOT, NOT},
/* B pawn */ { NOT, NOT, NOT, NOT, ONE, NOT, ONE, NOT}};

void /*NEAR */piece_down( offset, pname, color, mask )
SQUARE_NUM offset;
PIECE_NAME pname;
PIECE_COLOR color;
DWRD mask;
{
	int dmask;  /* current direction bit */
	DIR dir;    /* current direction */
	BYTE dirmask, rdirmask, kndirmask;
	PIECE_NAME oldname, newname, backname;
	SQUARE_NUM *edgep;       /* pointer to edges of square */
	WOOD_PIECE *wp;
	BYTE *oldattp, *newattp;

	Setmask=mask;            /* new mask to be set */
	Newedge=offset;          /* new edge to be set */
	Sqp=SQUAREP(offset);      /* get pointer to main square */
	edgep=Sqp->edge;         /* get pointer to edges of this square */
	oldname=Sqp->wood.name;  /* get who stay on square */
	newname=pname;
							 /* wP not equal bP for use in numattack */
	if( pname==PAWN && color==BLACK_PIECE ) newname=B_PAWN;
	if( oldname==PAWN && Sqp->wood.color==BLACK_PIECE ) oldname=B_PAWN;
	dirmask=square_dirmask[ offset ]; /* get avail dir masks */
	rdirmask=square_dirmask[ NSQUARE-1-offset ]; /* avail. rev. directions */
	kndirmask=square_kndirmask[ offset ]; /* get knight avail dir mask */
	oldattp=numattack[oldname]; /* get pointer to array of n attacked sq */
	newattp=numattack[newname]; /* for old and new pieces */

	for( dmask=1, dir=0; dmask<256; dmask<<=1, dir++, oldattp++, newattp++ ){
		if( !( dmask & dirmask ) ) continue; /* not available direction */
		Shift = byteshift[ dir ]; /* get shift to next square in bytes */
		Forep = SQUAREP(*(edgep+dir)); /* get fore edge pointer */
		if( oldname ){       /* that is capture */
			if( (*oldattp)!=NOT ){ /* capt'd piece attack this dir */
				Clmask=~Sqp->who_mask.dwrd;
				if( oldname==KNIGHT ){ /* if old piece is knight */
					if(dmask & kndirmask){  /* dir is avail for kn */
						Shift=knbyteshift[ dir ]; /* get shift for knight */
						CLEARONEMASK       /* clear king mask on dir */
						Shift=byteshift[ dir ]; /* restore shift */
					}
				} else { /* it isn't knight */
					if( *(oldattp)==ALL ) CLEARALLMASK
						else CLEARONEMASK
				}
			}
		} else {             /* that isn't capture */
			Rdir = reverse( dir ); /* get reversed dir & save in global var */
			if( dmask & rdirmask ){ /* reverse dir avail (not edge of board) */
				setedge(); /* set new if not edge of board */
				Backp = SQUAREP(*( edgep + Rdir )); /* get back edge pointer */
				backname = Backp->wood.name; /* get piece on back edge */
				if( numattack[backname][dir]==ALL ){
					/* back piece attack dir */
					Clmask=~Backp->who_mask.dwrd;
					CLEARALLMASK
				}
			}
		}
		if( newname==KNIGHT ) /* if new piece is knight */
			if(dmask & kndirmask) Shift=knbyteshift[ dir ]; /* dir is avail for kn */
				else continue;
		if( *(newattp)!=NOT ){ /* new piece attack this dir */
			if( *(newattp)==ALL ) SETALLMASK
				else SETONEMASK
		}
	} /* end of dir for */
	Sqp->bound=NOBOUND;    /* ??????? Piece not baund */
	wp=&Sqp->wood;           /* get pointer to wood piece */
	wp->name=pname;
	wp->color=color;
	wp->cost=piece_cost[pname];
	Sqp->who_mask.dwrd=mask;
        if(pname==KING){
	  KING_SQ[color]=offset;
	  change_king_bound(color);
	}
       /* else */ change_bound(offset);
}

void /*NEAR */piece_up( SQUARE_NUM offset )
{
	int dmask;      /* current direction bit */
	DIR dir;          /* current direction */
	int dirmask, rdirmask, kndirmask;  /* available dir masks */
	PIECE_NAME oldname, backname;
	SQUARE_NUM *edgep;
	BYTE *oldattp;
	WOOD_PIECE *wp;

	Sqp=SQUAREP(offset);      /* main square pointer */
	oldname=Sqp->wood.name;  /* piece name */
	if( oldname==PAWN && Sqp->wood.color==BLACK_PIECE ) oldname=B_PAWN;
	edgep=Sqp->edge;         /* edges pointer */
	dirmask=square_dirmask[ offset ]; /* avail. directions */
	rdirmask=square_dirmask[ NSQUARE-1-offset ]; /* avail. rev. directions */
	if( oldname==KNIGHT ) kndirmask=square_kndirmask[ offset ];
	oldattp=numattack[oldname]; /* pointer to attack array */
	Clmask=~Sqp->who_mask.dwrd;  /* get mask to clear */

	for( dmask=1, dir=0; dmask<256; dmask<<=1, dir++, oldattp++ ){
		if( !( dmask & dirmask ) ) continue; /* not available direction */
		Shift = byteshift[ dir ]; /* get shift to next square in bytes */
		Forep = SQUAREP(*( edgep + dir )); /* get fore edge pointer */
		if( dmask & rdirmask ){ /* isn't edge of board */
			Rdir = reverse( dir ); /* get reversed dir */
			deledge();       /* delete the old edge */
			Backp = SQUAREP(*( edgep + Rdir )); /* get back edge pointer */
			backname = Backp->wood.name; /* get piece on back edge */
			if( numattack[backname][dir]==ALL ){
				/* back piece attack dir, back knight can't attack  */
				Setmask=Backp->who_mask.dwrd;
				SETALLMASK
			}
		}
		if( oldname==KNIGHT ) /* if old piece is knight */
			if(dmask & kndirmask) Shift=knbyteshift[ dir ]; /* dir is avail for kn */
				else continue;
		if( *( oldattp )!=NOT ){        /* piece attack this dir */
			if( *( oldattp )==ALL ) CLEARALLMASK
				else CLEARONEMASK
		}
	} /* end of dir for */
	Sqp->wood.name=NOPIECE;
	wp=&Sqp->wood;           /* get pointer to wood piece */
	wp->name=NOPIECE;
	wp->color=NOCOLOR;
	wp->cost=NOCOST;
	Sqp->who_mask.dwrd=(DWRD)NOMASK;
        change_bound(offset);
}

