#include <stdlib.h>      /* abs() */
#include <stdio.h>       /* sprintf() */
#include <string.h>	/* strcpy()*/
#include <conio.h>	/* kbhit()*/

#include "face.h"
#include "faceproc.h"
#include "facekeys.h"
#include "facemous.h"
#include "facelib.h"
#include "chess.h"
#include "ksichess.h"
#include "ksiprot.h"
#include "global.h"
#include "current.h"
#include "proc.h"
#include "ksitimer.h"
#include "ksibase.h"
#include "ksiwork.h"
#include "ksiutil.h"
#include "ks_macro.h"
#include "ks_game.h"
#include "entime.h"
#include "proc.h"
#include "ksiwind.h"
#include "ksibdraw.h"
#include "ksisound.h"
#include "helpind.h"
#include "menu.h"
#include "menu_func.h"
#include "interface.h"
#include "infc_func.h"
#include "serial.h"
#include "link.h"
#include "serial.h" 
#include "hashpos.h"

BREAKFLAGS breakflag=NOBREAK;

extern char far playmove[];
extern char far playerror[];

int far mygetch(void);

POSITION *old_pos_sp;
int userbreak( void )
{
  MOVE move;
  static int kbhitcnt=0;
  int c,x,y;
  char str[20];
  int ret;

    if (kbhitcnt++ <100 && !print_flag ) return 0;
    kbhitcnt=0;
	if( !kbhit() && !mousehit()) return(0);
			/* if keyboard or mouse were not pressed */
	if( thinktime==ENEMYTIME ) {
	  old_pos_sp=pos_sp;
	  pos_sp=&pos_buf;

	  ret=proceed_user_action(BOARDBREAK_ST);
	  if (ret==-3) {   /* the global key for main state */
		breakflag=TERMINATE;
		pos_sp=old_pos_sp;
		return breakflag;
	  }
	  if (ret==-1) {
		pos_sp=old_pos_sp;
		return(0); /* move is not yet ready */
	  }
	  if (ret==-2) {
		thinktime=MYTIME;
		fulltomove( &curmove, &move );
		if (!legalmove(&curmove)) {
			music(playerror);
			setwritten(board);
			refresh(board);
			thinktime=ENEMYTIME;
			pos_sp=old_pos_sp;
			return 0; /* not legal move */
		}
		if (redsquare!=DUMMY) clearframe( redsquare );
		redsquare=DUMMY;
		enemy_move_exist=1;
		if( movecmp( &move, &bestanswer ) ){ /* guessed right */
		  enemy_move_done=1;
		  if (issound) music( playmove );
		  pos_sp=pos_stk;
		  savemove(&curmove, pos_buf.a.move_color);
		  updatetime();  /* It's better to do it with parametr color */
		  setwritten(board);
		  refresh(board);
		  showtimer();
		  setbeginsearch(); /* Our time begin */
		  openwindow( small );
		  replacehelpline(interruptstr);
		  pos_sp=old_pos_sp;
		  return(0);
		}
		breakflag=TERMINATE;
		clear_move( &bestanswer ); /* AD 15 june 90 */
		pos_sp=old_pos_sp;
		return breakflag;
	  } /* end of if ret==-2 (move done) */
	}
	else {
		if( kbhit() )         /* if keyboard key pressed */
			c=mygetch();		/* get the key from the user */
		else if( mousehit() ) {  /* mouse button pressed or mouse move */
			c=getmousekey();
			if (c==LEFTRELEAS) {
			   getmouseloc(&x,&y);
			   getmousetext( y, x, str );
			   if (!strcmp(str,"F4") || !strcmp(str,"Interrupt"))
				c=F4;
			}
		}
		if (c==F4) {
		   old_pos_sp=pos_sp;
		   pos_sp=pos_stk;
		   ret=proceed_user_action(BREAK_ST);
		   pos_sp=old_pos_sp;
		   setprintflag(); /* Need if user change Info submenu */
		   if (!breakflag) replacehelpline(interruptstr);
		   return breakflag;
		}
	}
    return(0);
}




int terminate(void)
{
    setwhomove(MAN_MAN);
    breakflag=TERMINATE;
    return -1;
}

int makecurrent(void)
{
    pos_sp=pos_stk; level=0;   /* reset stacks */
    breakflag=MAKECURRENT;
    return -1;
}

int trace_current_branch(void)
{
  LSTRING buf;
  SSTRING lambdastr;
    make_variant_string_with_numbers(buf);
    ultoa(lambda,lambdastr,10);
    strcat(buf,lambdastr);
    lastlinereply(buf);
    putinfo(2,1,buf);
    return 0;
}

#define NMOVES  75
MOVE legalmoves[NMOVES]; /* array to legal moves */

int onemovesearch( void )
{
  MOVE *mp;
  static char far str[]=" Search finished: #a1-a1    ";
  char far *cp;

	pos_hash_clear_flag=1;
	setprintflag();
	if( print_flag ){
	   ret_status((REPLY_ST<<8)|DELETE_ST);
	}
	mp=get_move();
	if (breakflag==TERMINATE) return 0;
	if(mp) {
	  cp=decode( &str[18], mp, pos_stk ,0);
	  *cp='.';
	}
	else {
	  FARSTRCPY( &str[18], "No move.");
	}
	message( str ,1);
	return( 0 );
}


int movetofull( FULLMOVE *fmp, MOVE *mp )
{
  SQUARE_INFO *sqp;
	if( mp->flags==M_NULLMOVE ){ fmp->flags=M_NULLMOVE; return(0); }
	fmp->from=mp->from;
	fmp->to=mp->to;
	sqp=SQUAREP(mp->from);
	fmp->who=sqp->wood.name;
	fmp->flags=mp->flags;
	if( mp->flags & M_PROMOTION ) fmp->prom=QUEEN;
	else fmp->prom=NOPIECE;
	sqp=SQUAREP(mp->to);
	/*if( sqp->wood.name!=NOPIECE )*/ fmp->capt=sqp->wood.name;
	return(0);
}

int fulltomove( FULLMOVE *fmp, MOVE *mp )
{
	if( fmp->flags==M_NULLMOVE ){ mp->flags=M_NULLMOVE; return(0); }
	mp->to=fmp->to;
	mp->from=fmp->from;
	mp->flags=fmp->flags;
	if( fmp->prom!=NOPIECE ) mp->flags|=M_PROMOTION;
	if( fmp->capt!=NOPIECE ) mp->flags|=M_CAPTURE;
	return(0);
}

int genlegalmoves( void )
{
		/* Generate all legal moves of */
  Our_color=MOVE_COLOR;
  Enemy_color=reverse_color(Our_color);
  FIRST=legalmoves;              /* the opponent. */
  LAST=generate_all(FIRST);
  return(LAST!=FIRST);
}

int legalmove( FULLMOVE *movep ) /* return 1 if move legal else 0 */
{
  MOVE ksimp,*mp;

    fulltomove( movep, &ksimp );
    mp=legalmoves;
    while(mp!=LAST) {
      if( movecmp( &ksimp, mp)) return(1);
      mp++;
    }
    return(0);
}

int fillmove( FULLMOVE *fmp )
{
  SQUARE_INFO *sqp;
	if( fmp->flags&M_CASTLE_RIGHT ){
	  fmp->who=KING;
	  if(MOVE_COLOR){ fmp->from=e8; fmp->to=g8; } /* Black */
		else{ fmp->from=e1; fmp->to=g1; }           /* White */
	}
	if( fmp->flags&M_CASTLE_LEFT){
	  fmp->who=KING;
	  if(MOVE_COLOR){ fmp->from=e8; fmp->to=c8; }
		else{ fmp->from=e1; fmp->to=c1; }
	}
	sqp=SQUAREP(fmp->to);
	fmp->capt=sqp->wood.name;
	if( fmp->capt!=NOPIECE ) fmp->flags|=M_CAPTURE;
	if( fmp->who==PAWN ){
		if(	(GETLINE( fmp->to )==0 || GETLINE( fmp->to )==7 )){
			fmp->prom=QUEEN;
			fmp->flags|=M_PROMOTION;
		} else fmp->prom=NOPIECE;
		if( abs(fmp->from-fmp->to)==9 || abs(fmp->from-fmp->to)==7 )
			if( fmp->capt==NOPIECE ){
				fmp->flags=(M_EN_PASSANT|M_CAPTURE); /* M.D. */
				fmp->capt=PAWN;
			}
	} else fmp->prom=NOPIECE;
	if( fmp->who==KING ){
		if( fmp->from-fmp->to==-2 ) fmp->flags=M_CASTLE_RIGHT;
		if( fmp->from-fmp->to==2 )  fmp->flags=M_CASTLE_LEFT;
	}
	return(0);
}

int getkaissamove( FULLMOVE *fmp )
{
  int done=1;
  MOVE move, *mp=&move;

	if( debut ){
		done=getbasemove( fmp );
		if( done==1 ) debut=0;
		else if( done==OK ){
			fillmove( fmp );
			genlegalmoves();
			if( !legalmove( fmp ) )
		{ done=ERROR; debut=0; }
			else
		 fulltomove( fmp, mp );
		}
	}
	if( !debut && done!=OK ){
		mp=get_move();            /* get next kaissa move */
		if (breakflag==TERMINATE) {setwhomove(MAN_MAN); return ERROR;}
		if (breakflag!=MAKECURRENT && mp==NULL) return(ERROR);
		if( mp==NULL ) mp=FIRST;   /*  */
		done=OK;
		movetofull( fmp, mp );
	}
	make_move( mp );
	return( done );
}

int putkaissamove( FULLMOVE *fmp )
{
  int done;
  MOVE move;

	if( debut ){
		done=putbasemove( fmp );
		if( done==1 ) debut=0;
		if( done==-1 ) return( done );
	}
	fulltomove( fmp, &move );
	done=make_move( &move );
	return( done );
}

int setwhomove (WHOPLAY newwhomove)
{
    whomove=newwhomove;
    showtimer();
    return(0);
}