/* 	 ͻ
	              Interface with user of chess program              
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <conio.h>      /* getch() */
#include <ctype.h>      /* tolower() */
#include <string.h>     /* strcat() */
#include <stdio.h>      /* sprintf() */
#include <stdlib.h>     /* itoa() */

#include "chess.h"
#include "global.h"     /* turn_move for sscanmove() */ 
#include "current.h"
#include "ksichess.h"
#include "ks_macro.h"
#include "ksiutil.h"
#include "ks_corr.h"
#include "facelib.h"
#include "facemous.h"
#include "facekeys.h"

extern int usefontnote;
extern char pctoch[];
#define piecetochar(p)  (pctoch[(p)+7*usefontnote])

int issquare( int c )
{
	c=tolower( c );
	if( (c>='a' && c<='h')||(c>='1' && c<='8') ) return(1);
	return(0);
}

int ispiece( int c )
{
	c=tolower( c );
	if( c=='k'||c=='q'||c=='r'||c=='n'||c=='p'||c=='b' ) return(1);
	return(0);
}

int iscolor( int c )
{
	c=tolower( c );
	if( c=='w'||c=='l') return(1);
	return(0);
}

int ischess( int c )
{
	c=tolower( c );
	if( issquare(c) ) return(1);
	if( ispiece(c) )  return(1);
	if( c=='-'||c=='x'||c=='+') return(1);
	return(0);
}

int iscastle( char far *str )
{
	if( *str=='0' && *(str+1)=='-' && *(str+2)=='0' ){
	  if( *(str+3)=='-'&& *(str+4)=='0') return(2);
	  return(1);
	}
	return(0);
}

int ismove( char far *str )  /* 1 - if Pa2-a3, 2 - if a2-a3 */
{
	if( iscastle( str ) ) return(1);
	if( ispiece(*str) && issquare(*(str+1)) && issquare(*(str+2))
		&& ischess(*(str+3)) && issquare(*(str+4)) && issquare(*(str+5)) )
			return(1);
	if( issquare(*(str)) && issquare(*(str+1))
		&& ischess(*(str+2)) && issquare(*(str+3)) && issquare(*(str+4)) )
			return(2);
	return(0);
}

int chartopiece( int c )
{
	c=toupper(c);
	switch( c ){
		case 'K': return( KING );  case 'Q': return( QUEEN );
		case 'R': return( ROOK );  case 'B': return( BISHOP );
		case 'N': return( KNIGHT );case 'P': return( PAWN );
	}
	return(0);
}

int chartocolor( int c )
{
	c=toupper(c);
	switch( c ){
		case 'W': return( WHITE_PIECE);
		case 'L': return( BLACK_PIECE);
	}
	return(0);
}

extern int ismouse;
/*
int getfacekey( void )
{
  int c=0;
	  while( !c ){
		if( MYKBHIT() )         /* if keyboard key pressed */
			c=mygetch();		/* get the key from the user */
		else if( ismouse && mousehit() )   /* mouse button pressed or mouse move */
			c=getmousekey();
	  }
	  if (ismousekey(c)) {
		/*if (c==RIGHTPRESS)*/ c=ESCAPE;
	  }
	  return( c );
}
*/

#define SKIPBLANK( str )  { while( *(str)==' ' ) (str)++; }

char far * sscanpiece( char far *str, PIECE_NAME far *name )
{
	if( !ispiece( *str ) ) return( str );
	*name=chartopiece(*str++);
	return( str );
}
char far * sscansquare( char far *str, SQUARE_NUM far *sqp )
{
	if( !( issquare( *str ) && issquare(*(str+1)) ) ) return( str );
	*sqp=GETOFFSET( *str -'a', *(str+1) -'1' );
	return( str+2 );
}

char far * sscanmove( char far *str, FULLMOVE *mp )
{
int i;
int flag;

	FARMEMSET( mp, 0, sizeof( FULLMOVE ) );
	SKIPBLANK( str )
	if( !(flag=ismove( str )) ) return( NULL );
	if( (i=iscastle( str ))!=0 ){
          mp->who=KING;
          mp->from=(turn_move)?e8:e1;
	  if( i==1 ){
	    mp->flags|=M_CASTLE_RIGHT;
	    mp->to=mp->from+2;
	    return(str+3);
	  }
	  else {
	    mp->flags|=M_CASTLE_LEFT;
	    mp->to=mp->from-2;
	    return(str+5);
	 }
/*	  return(str+MOVESTRLEN); */
	}
	if(flag==1)
	  str=sscanpiece( str, (PIECE_NAME far *) &(mp->who) );
	if(flag==2) mp->who=PAWN;
	str=sscansquare( str, (SQUARE_NUM far *)&(mp->from) );
	if( *str++=='x' ) mp->flags=M_CAPTURE;/* else mp->flags=0;*/
	str=sscansquare( str, (SQUARE_NUM far *)&(mp->to) );
	if( *str=='+' ) mp->flags|=M_ISCHECK; /* I don't know where it place */
	if( ispiece(*str) ){
		str=sscanpiece( str, (PIECE_NAME far *)(&mp->prom) );
		mp->flags|=M_PROMOTION;
	}
	if( *str=='+' ) mp->flags|=M_ISCHECK;
/* for old protocols compatibility */
	if( mp->who==KING ){  /*Added 28.03.90 Shabalin*/
	  if( mp->from-mp->to==-2 ) mp->flags|=M_CASTLE_RIGHT;
	  if( mp->from-mp->to==2 )  mp->flags|=M_CASTLE_LEFT;
	}
	if( *str ) str++; /* if not end-of-line */
	return( str );
}

int sprintpos( char far *str, PIECE_COLOR color)
{
	int i, pnum;
	PIECE_NAME name, findpiece;
	PIECE_COLOR col;
	SQUARE_NUM square;

	*str++=( color==WHITE_PIECE )? 'w':'b';
	*str++=':';
	findpiece=KING;
	while( findpiece<=PAWN ){
	  pnum=0;
	  for( i=(NUM_PIECE*color); i<(NUM_PIECE*(color+1)); i++ ){
	    pieceinlist( i,  (PIECE_NAME *)&name, 
                            (PIECE_COLOR *)&col,  (SQUARE_NUM *)&square );
	    if( name!=findpiece ) continue;
		*str++=pctoch[findpiece]; /* get piece name */
	    if( name==PAWN && pnum ) str--; /* don't need more P name */
	    str=sprintsquare( str, square ); /* make square */
	    *str++=',';
	    pnum++;
	  }
	  findpiece++;
	}
	*(str-1)='.'; *str='\0';
	return(0);
}

char far * sprintsquare( char far *str, SQUARE_NUM square )
{
	*str='a'+GETFILE(square);
	*(str+1)='1'+GETLINE(square);
	return( str+2 );
}

static char far leftcastle[MOVESTRLEN+1]= "0-0-0  ";
static char far rightcastle[MOVESTRLEN+1]="0-0    ";

char far * sprintmove( char far *str, FULLMOVE *movep )
{
	if( movep->flags & M_CASTLE_LEFT ){
		farstrcpy( str, leftcastle ); return( str+MOVESTRLEN );
	}
	if( movep->flags & M_CASTLE_RIGHT ){
		farstrcpy( str, rightcastle ); return( str+MOVESTRLEN );
	}
	if (movep->who==PAWN) /* *str++=' '*/;
	else *str++=piecetochar( movep->who );     /* 1 */
	str=sprintsquare( str, movep->from ); /* 2-3 */
	*str++=( movep->capt!=NOPIECE || movep->flags&M_CAPTURE )? 'x':'-'; /* 4 */
	str=sprintsquare( str, movep->to );   /* 5-6 */
	*str++=( movep->prom==NOPIECE )? ' ':piecetochar( movep->prom ); /* 7 */
	if (movep->who==PAWN) *str++=' ';
	*str='\0';
	return( str );
}

char far * sprintmove1( char far *str, FULLMOVE *movep )
{
	if( movep->flags & M_CASTLE_LEFT ){
		farstrcpy( str, leftcastle ); return( str+MOVESTRLEN );
	}
	if( movep->flags & M_CASTLE_RIGHT ){
		farstrcpy( str, rightcastle ); return( str+MOVESTRLEN );
	}
	*str++=pctoch[ movep->who ];     /* 1 */
	str=sprintsquare( str, movep->from ); /* 2-3 */
	*str++=( movep->capt!=NOPIECE || movep->flags&M_CAPTURE )? 'x':'-'; /* 4 */
	str=sprintsquare( str, movep->to );   /* 5-6 */
	*str++=( movep->prom==NOPIECE )? ' ':pctoch[ movep->prom ]; /* 7 */
	*str='\0';
	return( str );
}

int sprintturnmove( char far *str )
{
  str=faritoa( MOVE_COLOR, str, 10);
  return(0);
}

int sprintcastles( char far *str, PIECE_COLOR color)
{
  str=faritoa( CASTLE[color], str, 10);
  return(0);
}

int sprintenpass( char far *str )
{
  str=faritoa( EN_PASS, str, 10 );
  return(0);
}

int sscanturnmove( char far *str )
{
  MOVE_COLOR=faratoi(str);
  return(0);
}

int sscancastles( char far *str, PIECE_COLOR color )
{
  CASTLE[color]=faratoi(str);
  return(0);
}

int sscanenpass( char far *str )
{
  EN_PASS=faratoi(str);
  return(0);
}
