/*
	 ͻ
	               Working  functions  for  interface               
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "face.h"
#include "faceproc.h"
#include "facelib.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "ks_game.h"
#include "ksichess.h"
#include "ksiwind.h"
#include "ksibdraw.h"
#include "ksitimer.h"
#include "proc.h"
#include "ks_macro.h"
#include "ksiprot.h"
#include "menu_fun.h"
#include "message.h"

/*extern*/ int finishbranch;
extern int nmove;

#define MINPH   60       /* minutes per hour */
#define SECPM   60       /* second per minute */

#define NHOUR    2

#define RESERV1      SECTOCLOCK(5*SECPM) /* reserv before first control */
#define FIRSTTIME    SECTOCLOCK(1L*NHOUR*MINPH*SECPM)/*-RESERV1*/  /* Two hours. in minutes */
					/* before first control */
#define FIRSTCONTROL 40
#define NEXTCONTROL  20
#define OPERATE      SECTOCLOCK(5)

#define NTIME1   25
#define NTIME2   35
#define TIMECONST1 2
#define TIMECONST2 3/2

clock_t	gamebegin,  /* Begining of the game */
	movetime,   /* Time between moves. */
	curtime[NCOLOR],    /* Current color time. (whitetime or blacktime) */
	controltime=FIRSTTIME,  /* Control time. */
	enteredcontroltime=FIRSTTIME,  /* Control time from user. */
	searchbegin,  /* Start of search */
	enemytimesearchbegin,  /* Start of search at enemy time. */
	searchtime,   /* Time for the search */
	ltime;    /* Real searchtime. */
int timecontrol=0;    /* set if need to control time */
int addtimecounter;
int addfinishflag;

int controlmove=FIRSTCONTROL;
int enteredcontrolmove=FIRSTCONTROL;
int curmovenum[NCOLOR];

int setcontroltime(void)
{
  enteredcontroltime=controltime;
  return(0);
}

int setcontrolmove(void)
{
  enteredcontrolmove=controlmove;
  return(0);
}

int init_timer(void)
{
   enteredcontroltime=controltime;
   enteredcontrolmove=controlmove;
   return 0;
}

int resettime( void )
{
	gamebegin=clock();
	curtime[0]=0;curtime[1]=0;
	curmovenum[0]=0;curmovenum[1]=0;
	movetime=gamebegin;
	if(!controlmove) controlmove=1;
	searchtime=(controltime)/controlmove;
	if( HALF(nmove)<NTIME1 ) searchtime=searchtime*TIMECONST1;
	else if( HALF(nmove)<NTIME2 ) searchtime=searchtime*TIMECONST2;
        controltime=enteredcontroltime;
        controlmove=enteredcontrolmove;
	return(0);
}

int setbeginsearch( void )
{
PIECE_COLOR lcolor;
	lcolor=pos_stk[0].a.move_color;
	breakflag=0;
	addtimecounter=0;
	addfinishflag=0;
	if(thinktime==ENEMYTIME){
	  enemytimesearchbegin=clock(); 
	  return(0);
	}
	searchbegin=clock();
	if( curtime[lcolor]>controltime ) searchtime=0; /* no more time */
	else searchtime=(controltime-curtime[lcolor])/(controlmove-curmovenum[lcolor]+1); /* update timer */
	if( HALF(nmove)<NTIME1 ) searchtime=searchtime*TIMECONST1;
	else if( HALF(nmove)<NTIME2 ) searchtime=searchtime*TIMECONST2;
	if (enemy_move_done) {
		searchtime+=searchbegin-enemytimesearchbegin;
		searchbegin=enemytimesearchbegin;
	}
	showsearchtime();
	return(0);
}

extern clock_t curprotime;   /* Time from protocol */
extern int protocolflag;

int showtimer( void )
{
  char str[40]="";
  char far *wname;
  char far *bname;
  static char far format[]=" %14Fs - %-14Fs";
  static char far colname[][12]={"White move","Black move"};
  static char far space[]="                          ";
	if( whomove==KAISSA || whomove==KAISSA_MAN )
	 wname=kaissa_str;
	else wname=player_str;
	if( whomove==KAISSA || whomove==MAN_KAISSA )
	 bname=kaissa_str;
	else bname=player_str;
	player[0].name=wname;
	player[1].name=bname;
    farsprintf( str, format,  player[0].name, player[1].name );
    posstate( timer, 1,1 );
    checkface( putstring( timer, str ) );

    maketimestring(curtime[0],str);
    gotowindow( timer, 2, 7 );
    putstring( timer, str );
    maketimestring(curtime[1],str);
    gotowindow( timer, 2, 20 );
    checkface( putstring( timer, str ) );

    posstate( timer, 3, 1 );
    checkface( putstring( timer, space ) );
    posstate( timer, 3, 12 );
    checkface( putstring( timer, colname[MOVE_COLOR]) );

    refresh( timer ) ;
    return(0);
}

int showsearchtime( void )
{
  SSTRING str,timestr;
static char far form[]="Time for search %s";
  if(!timecontrol) return(0);
  maketimestring(searchtime,timestr);
  farsprintf(str,form,timestr);
  putinfo(3,2,str);
  return(0);
}

int showusedtime( void )
{
  SSTRING str,timestr;
  static char far form[]="Time used       %s";
  maketimestring(clock()-searchbegin,timestr);
  farsprintf(str,form,timestr);
  putinfo(3,2,str);
  lastlinereply(str);
  return(0);
}

void maketimestring(clock_t t,char *str)
{
  long h, m, s;
  static char far form[]="%02d:%02d:%02d";
	s=CLOCKTOSEC(t);
	m=s/SECPM; s=s%SECPM; h=m/MINPH; m=m%MINPH;
	farsprintf( str, form,(int)h,(int)m,(int)s);
}


int updatetime( void )
{
clock_t buf;
PIECE_COLOR lcolor;
	buf=clock();
	ltime=buf-movetime;  /* get the real search time */
	movetime=buf;
	lcolor=reverse_color(MOVE_COLOR);
	if(!protocolflag) curtime[lcolor]+=ltime;
	else              curtime[lcolor]=curprotime;
	curmovenum[lcolor]++;
	if( curmovenum[1]==controlmove ){
		controlmove+=controlmove;
		controltime+=controltime;
	}
	if(!protocolflag) showtimer();
	return(0);
}

