/*
	 ͻ
	                  Functons  for  music  play                    
	                 programmed  by  Anthon  Dubets                 
	              with using Microsoft GW Basic function            
	 ͼ
*/
#include <dos.h>             /* sound(), nosound(), delay() */
#include <ctype.h>           /* tolower() */
#include <stdlib.h>          /* atoi() */
#include "facelib.h"
#include "lang.h"
#include "ksisound.h"

#define BUFFSIZE 100     /* size of buffer for save note string */
#define NNOTE    12      /* number of notes in one octave */
#define NOCTAVE  8       /* number of octaves */
#define DEFTEMPO 120     /* default tempo */
#define NMUSIC   3       /* may be: normal, legato, stacatto */
#define DENOM    8       /* denom for divide note length */
typedef enum{
  A=0, _A=1, B=2, C=3, _C=4, D=5, _D=6, E=7, F=8, _F=9, G=10, _G=11
} NOTE;

#define ISNOTE( ch )    (( (ch)>='a'&& (ch)<='g' )||( (ch)>='A'&& (ch)<='G' ))
#define ISOCTAVE( ch )  ( (ch)=='o' || (ch)=='O' )
#define ISTEMPO( ch )   ( (ch)=='t' || (ch)=='T' )
#define ISPAUSE( ch )   ( (ch)=='p' || (ch)=='P' )
#define ISLENGTH( ch )  ( (ch)=='l' || (ch)=='L' )
#define ISPERIOD( ch )  ( (ch)=='.' )
#define ISMUSIC( ch )   ( (ch)=='m' || (ch)=='M' )

static unsigned int far notefrec[NOCTAVE][NNOTE]={
/*  A     A#    B     C     C#    D     D#    E     F     F#    G     G# */
{   10,   20,   30,   40,   50,   60,   70,   82,   87,   93,   98,  104 },
{  110,  117,  123,  130,  139,  147,  156,  165,  175,  185,  196,  208 },
{  220,  233,  247,  262,  277,  294,  311,  330,  349,  370,  392,  415 },
{  440,  466,  493,  523,  554,  587,  622,  659,  698,  740,  784,  831 },
{  880,  932,  988, 1047, 1109, 1175, 1245, 1319, 1397, 1480, 1568, 1661 },
{ 1760, 1865, 1976, 2093, 2217, 2349, 2489, 2637, 2794, 2960, 3136, 3322 },
{ 3520, 3729, 3951, 4186, 4435, 4698, 4978, 5274, 5588, 5920, 6272, 6645 },
{ 7040, 7459, 7902, 8372, 8870, 9397, 9956,10548,11175,11840,12544,13290 }
};
/*static char notebuff[BUFFSIZE]; buffer for save note string..not use */
	/* indexes of notes in array without # notes */
static unsigned char far noteindex[NNOTE-5]={ 0,2,3,5,7,8,10 };
static unsigned char far notedur[NMUSIC]={7,8,6};/* 7/8, 8/8=1, 6/8=3/4 */
	/* define duration for normal, legato & stacatto music */
static unsigned char octave=5; /* current octave, default is 5 */
static unsigned int l1len=(240/DEFTEMPO)*1000; /* lenght of whole note in ms */
static unsigned char notelen=4; /* note length in part of whole note */
	/* default is quarter note lenght */
static unsigned char mul=7; /* define current music, default is normal */

static char far * near playnote( char far *cp ); /* play one note */
static char far * near setoctave( char far *cp );/* set new octave */
static char far * near settempo( char far *cp ); /* set new tempo */
static char far * near pause( char far *cp );    /* pause */
static char far * near setlength( char far *cp );/* set note length */
static char far * near setmusic( char far *cp ); /* set music */
static char far * near setperiod( char far *cp ); /* set period */

static char far * near playnote( char far *cp )
{
  int note, len=0;
	note=noteindex[ tolower(*cp++) - 'a' ]; /* get note index in octave */
	if( *cp=='#' || *cp=='+' ){        /* is a sharp note? */
		if(note==A||note==C||note==D||note==F||note==G) note++;
		cp++;
	}
	len=notelen;                       /* save current note length */
	if( isdigit( *cp ) ) cp=setlength( cp ); /* define special length */
	if( ISPERIOD( *cp ) ) cp=setperiod( cp ); /* new play time */
	sound( notefrec[octave][note] );   /* turn sound on */
	delay( (l1len*mul)/(notelen*DENOM) ); /* wait required time */
	nosound();                         /* turn sound off */
	delay( (l1len*(DENOM-mul))/(notelen*DENOM) ); /* wait to whole note len */
	notelen=len;                       /* restore old note length */
	return(cp);
}

static char far * near setoctave( char far *cp )
{
  int i;
	i=*cp - '0';                       /* convert char to integer */
	if( i<0 || i>6 ) return( cp );     /* check new value */
	octave=i;                          /* set new octave */
	return( cp+1 );
}

static char far * near settempo( char far *cp )
{
  int i;
	i=faratoi( cp );                      /* convert string to integer */
	if( i>=32 && i<=255 ) l1len=(int)( 240000L/i ); /* make new L1 lenght */
	while( isdigit( *cp )) cp++;       /* skip this number */
	return( cp );
}

static char far * near pause( char far *cp )
{
  int i;
	i=faratoi( cp );
	if( i>=1 && i<=64 ) delay( (l1len/notelen)*i );
	while( isdigit( *cp )) cp++;
	return( cp );
}

static char far * near setlength( char far *cp )
{
  int i;
	i=faratoi( cp );
	if( i>=1 && i<=64 ) notelen=i;
	while( isdigit( *cp ) ) cp++;
	return( cp );
}

static char far * near setperiod( char far *cp )
{
	return( cp+1 );                    /* not used now */
}

static char far * near setmusic( char far *cp )
{
	switch( *cp ){
	  case 'n': case 'N': mul=notedur[0]; break;
	  case 'l': case 'L': mul=notedur[1]; break;
	  case 's': case 'S': mul=notedur[2]; break;
	  default: return(cp);
	}
	return( cp+1 );
}

int music( char far *cp )
{
	while( *cp ){            /* while not end of line */
		if( ISNOTE( *cp ) ){ cp=playnote( cp ); continue; }
		if( ISOCTAVE( *cp ) ){ cp=setoctave( cp+1 ); continue; }
		if( ISTEMPO( *cp ) ){ cp=settempo( cp+1 ); continue; }
		if( ISPAUSE( *cp ) ){ cp=pause( cp+1 ); continue; }
		if( ISLENGTH( *cp ) ){ cp=setlength( cp+1 ); continue; }
		if( ISMUSIC( *cp ) ){ cp=setmusic( cp+1 ); continue; }
		cp++;                /* this is undefined simbol */
	}
	return(0);
}
