	/**\
	                 Work  with  protocol  of  game                 
	\**/
#include <mem.h>             /* memcpy() */
#include <alloc.h>
#include <stdio.h>           /* fgets() farsprintf() */
#include <ctype.h>           /* isalpha() */
#include <time.h>            /* clock_t */
#include <dir.h>             /* fnsplit(), fnmerge() */
#include <dos.h>             /* REGS, gettime(), getdate() */
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>          /* strcpy() */

#include "face.h"
#include "faceproc.h"
#include "facelib.h"
#include "facekeys.h"
#include "facerr.h"

#include "interfac.h"
#include "menu.h"
#include "menu_fun.h"

#include "chess.h"
#include "global.h"
#include "current.h"
#include "proc.h"
#include "ks_game.h"
#include "ksichess.h"
#include "newutil.h"

#include "ks_macro.h"
#include "ks_corr.h"
#include "ksibdraw.h"
#include "ksiprot.h"
#include "ksiwind.h"
#include "ksiutil.h"
#include "ksiwork.h"
#include "ksisound.h"
#include "ksitimer.h"
#include "ksibase.h"
#include "entime.h"
#include "ks_game.h"
#include "hashpos.h"
#include "message.h"

/* Internal FACE functions */
int redraw(WINP wp);
int redrawedit (WINP wp);



#define PROSTRLEN 120
#define PLSTRLEN   20        /*  12345678 */
#define MOVESTRLEN  8        /*  Ka1-a2+0 */
#define PROSIZE   300

#define COMMENTSIZE (sizeof( SSTRING ))
#define COMMENTBUFFSIZE (100*COMMENTSIZE)

/*static CFP commentbuff,curcomment;*/
CFP far farstrcpy(CFP dest,const CFP source);

typedef struct {
  FULLMOVE move;     /* full move */
  clock_t time;      /* time used for search */
  BYTE flag;         /* move flag */
  CFP comment;       /* pointer to comment */
  long fileoffset;	 /* offset in tmp profile */
  /*...*/
} far PROMOVE;

SSTRING far maincomment="";
typedef PROMOVE  *PROMP;
static PROMP probuff=NULL;
PLAYER player[NCOLOR]={{player_str, 0l, 0}, {player_str, 0l, 0}};

static char far defpro[MAXPATH]="*.pro";
static char far protocolname[MAXPATH]="kaisspro.pro";
static char far protocoltmp[MAXPATH]="kaisspro.tmp";
static int profile=-1;		/* protocol file handle M.D. */
static long int maxprotseek=0L;	/* maximum protocol file offset M.D. */
static long int curprotseek=0L;	/* protocol file offset of current move M.D. */
int protocol=0; /* set 1 if protocol game */
static int totpromove; /* total number of moves in protocol */
static int nreaded;   /* number of moves, readed from file */
int nmove=0;        /* current move number, begining from 1 */
FULLMOVE curmove;  /* current move */
clock_t	curprotime;   /* Time from protocol */
int protocolflag;
POSITION far startprotpos={0};
int notstartposflag;
static char far lastprotname[MAXPATH]="*.mon"; /* Save protocol name */
					      /* for monitor */

int putcommentstring(char far * str);  /* Return 1, if comment exist. */
int writemaincomment( int file );
int readmaincomment( int file );
static int near showcomment(int nmove);

static int near readprostr( char far *str, PROMP mp ); /* read string of protocol */
static int near readoldprostr( char far *str, PROMP  promp ); /* read string of protocol */
static int near makeprotocol( void );
static void near clearcomment( int nmove, int mainflag);
static int near writemove( int profile, PROMP  promp, int nmove );
						/* returns written length */
static void near putheader( int profile);
static int near writemonitormove( int fp, PROMP  promp, int nmove ,FULLMOVE *newmove, PIECE_COLOR color);
static int near writemonmove( int file, PROMP  promp, int nmove );
static int near dispmove( FULLMOVE *movep, int nmove );
static char far * near sprintdt( char far *str );
static void setstartprotpos(void);
void flush(FILE *fp);
void commit(int file);
/*static PROMP near returnprot(int tomove);*/
static int near moveprot(int tomove);
static void near posstateenter(int nmove);
int copyfile(int dstfile, int srcfile);

extern char far playmove[];

int fmovecmp( FULLMOVE *mp1, FULLMOVE *mp2 )
{   /* return 0 if moves equal else 1 */
	return( !((mp1->who==mp2->who) && (mp1->from==mp2->from) &&
		(mp1->to==mp2->to) && (mp1->prom==mp2->prom)) );
}


int resetprotocol( void )
{
static char far mess1[]=" No memory for protocol ";
static char far form1[]="   1.  ... ";
static char far form2[]="   1.      ";

	if( probuff==NULL ){
		probuff=farcalloc( PROSIZE, sizeof( PROMOVE ));
		if( probuff==NULL ){
			message(mess1,0);
		}
	} else clearcomment(0,1);

/**/	ks_farmemcpy(&startprotpos, pos_stk, sizeof(POSITION));

	if(/* nmove!=0 || profp==NULL*/1 ) makeprotocol();        /* make new protocol file */
	nmove=totpromove=nreaded=0; /* reset all counters */
	protocol=0;                        /* reset protocol flag */
	checkface( emptystate(enter) );    /* clear protocol window */
	posstate( enter, 1,1 );
	if(startprotpos.a.move_color){
	   checkface( putstring( enter, form1 ) );
	   posstate( enter, 1,2 );
	}
	else{
	   checkface( putstring( enter, form2 ) );
        }
		refresh( enter );
        pos_hash_clear_flag=1;/* A.S. pos hash must be cleared */
	return(0);
}

int closeprotocol( void )
{
/*	if( profp ) fclose( profp );
	profp=NULL;*/
	if ( profile!=-1) MYCLOSE( profile);
	profile=-1;
	return(0);
}

static int near readprostr( char far *str, PROMP   mp ) /* read string of protocol */
{
  clock_t time;
	while( !ismove( str ) ) /* skip the move number */
		if( *str++=='\0' ) return(1); /* this isn't move string */
	str=sscanmove( str, &mp->move ); /* scan one move */
	time=0l;
	farsscanf( str, "%ld", &time ); /* scan move parameters */
	mp->time=time;
	while(*str!='\n' && *str!='\0' && *str!='*') str++;
        if(*str=='*'){
          mp->comment=farcalloc(1,SHORT_STR_LEN);
          farstrncpy(mp->comment,str+2,SHORT_STR_LEN);
        }
	/* more parameters */
	return(0);
}

static int near readoldprostr( char far *str, PROMP   promp ) /* read string of protocol */
{
	while( !ismove( str ) ) /* skip the move number */
		if( *str++=='\0' ) return(0); /* this isn't move string */
	str=sscanmove( str, &promp->move ); /* scan white move */
	promp++;
	while( !isalpha( *str ) && *str!='\0' ) str++; /*  28.03.90 Shabalin */
	if( !ismove( str ) ) return( 1 );  /* string not empty */
	str=sscanmove( str, &promp->move );/* scan black answer */
	return( 2 );/* return number of move readed */
}

static char far protfname[MAXPATH]="";
static namegiven=0;

int getprotocolname( void )	/* F3 key : begin */
{
static char far mess1[]=" Load a Game ";
  int i;
  WINP wp;
	namegiven=0;
	wp=getpromptwindow(4,12,mess1);
	if( wp ) {
	  keyfunc(wp,tohelpprompt,BEFORE);
	  i=searchfile( wp, protfname, defpro );
	  checkface(freewindow(wp));
	} else return 0;
	FARSTRCPY( lastprotname, protfname ); /* fname -> lastprotname */
	if( i==ERROR ){ checkface(i); return(0); }
	if( i==ESCAPE ) return(0); /* for continue menu */
	namegiven=1;
	return 1;	/* close menu */
}

int readprotocol( void )	/* F3 key : continue */
{
  int profp;
  char str[PROSTRLEN];
  PROMP  promp=probuff;
  char procode[2];
  char poscode;
  int i, j, nread,lth;
  static char far form1[]=" Read Pro: Can't read file: %Fs ";
  static char far space[]="          ";
  static char far form2[]="   ...";

     getprotocolname();
	if(!namegiven) return 0;
	clearcomment(0,1);
	emptystate( enter );
	setupwind( enter );
	checkface( refresh( enter ) );
	if( (profp=MYOPEN( protfname, O_RDONLY+O_TEXT, 0 ))==-1 ){
		farsprintf( str, form1,
				protfname );
		message( str,0 );
		return(0);
	}
	nreaded=0;
	MYREADLINE(profp,str,PROSTRLEN);
	j=farsscanf( str,"%c%c%c", procode, procode+1, &poscode );
	facefreeze(enter);            /* disable face windowes */
	if( *procode=='#' && *(procode+1)=='1' ){
		i=1;                 /* new version of protocol */
		farsscanf( str+j, "%Fs %Fs", (char far *)player[0].name,
				(char far *)player[1].name );
		nread=1;
	} else i=0;              /* old pro version */
	if(poscode!='+'){
	  notstartposflag=0;
	  setstartpos();
	}
	else{
	  notstartposflag=1;
	  getposfromfile(profp);
	}
	readmaincomment(profp);
/**/	ks_farmemcpy(&startprotpos, pos_stk, sizeof(POSITION));
	resettime();
	setcolor(MOVE_COLOR);
	setwritten(board);
	refresh(board); /* Draw initial position of protocol ?? */
	while( 	MYREADLINE(profp,str,PROSTRLEN) >0 ){
		if (!FARSTRNCMP(str,space,10)) break;
		if( i ){             /* new protocol version */
			readprostr( str, promp );
			dispmove( &promp->move, nreaded );
		} else {
			nread=readoldprostr( str, promp ); /* read one pro string */
			if( nread==0 ) break;
			dispmove( &promp->move, nreaded );
			if( nread==2 ) dispmove( &(promp+1)->move, nreaded+1 );
		}
		promp+=nread; /* moves readed */
		nreaded+=nread;
	}
	if ( ODD(nreaded) ) putstring(enter,form2);
	nmove=0;  /* reset protocol */
	MYCLOSE( profp );         /* close protocol file */
	showcomment(nmove);
	showtimer();
	setwritten(board);
	refresh(board);
	setupwind( enter );      /* goto window begining */
	faceunfreeze(enter);               /* enable face windowes */
/*	redraw( enter );     /* redraw protocol window */*/
	if( (totpromove=nreaded)!=0 ) setwhomove(MAN_MAN);
	makeprotocol();
	for (i=0,promp=probuff;i<totpromove;i++,promp++) {
		lth=writemove(profile,promp,i);
		promp->fileoffset=curprotseek;
		curprotseek+=lth;
	}
	(probuff+totpromove)->fileoffset=maxprotseek=curprotseek;
	curprotseek=probuff->fileoffset;
	commit(profile);
	if (!genlegalmoves() && whomove!=MAN_MAN) gamefinish();
	return(0);
}

/*int getpromove( void )
{
  PROMP  promp;
	if( nmove+1>totpromove ) return(ERROR);
	promp=probuff+nmove;
	fillmove( &promp->move );
	curprotime=promp->time;
	putkaissamove( &promp->move );
	protocolflag=1; updatetime(); protocolflag=0;
	refresh( timer );
	curprotseek=(promp+1)->fileoffset;
	nmove++;
	posstateenter( nmove );
	refresh( enter );
	setcolor( REVCOLOR( MOVE_COLOR ) ); /* set color */
	if( issound ) music( playmove );
	setwritten(board);
	refresh(board);
	if (!genlegalmoves() && whomove!=MAN_MAN) gamefinish();
	return(OK);
}
*/
static int near makeprotocol( void )
{
  SSTRING str;
  static char far form1[]=" Make Pro: Can't open file: %Fs ";
	closeprotocol();
	MYUNLINK( protocolname ); /* delete *.pro protocol */
	MYRENAME( protocoltmp, protocolname ); /* save *.tmp file to *.pro */
	/* use default protocol name */
	profile=MYOPEN(protocoltmp,O_RDWR+O_CREAT+O_TEXT,S_IREAD+S_IWRITE);
	if (profile==-1) {
		farsprintf( str, form1, protocoltmp );
		message( str ,0);
	}               /* to define new protocol format */
	putheader(profile);
	writemaincomment(profile);
	maxprotseek=tell(profile);
	curprotseek=maxprotseek;
	commit(profile);
	return(0);
}

static void near putheader(int file)
{
   char str[PROSTRLEN];
   char str1[PROSTRLEN];
   static char far form1[]="#1+ %Fs  %Fs  %s\r\n";
   static char far form2[]="#1  %Fs  %Fs  %s\r\n";

	sprintdt( str1 );
	if(notstartposflag){
	  farsprintf( str, form1, player[0].name, player[1].name, str1 );
	  MYWRITE(file,str,strlen(str));
	  putposintofile(file/*, &startprotpos*/);
	}
	else {
	  farsprintf( str, form2, player[0].name, player[1].name, str1 );
	  MYWRITE(file,str,strlen(str));
	}
}

int saveprotocol( void )	/* F2 key */
{
  int i;
  int  file;
  SSTRING str;
  PROMP  promp;
  char fname[MAXPATH]="";
  WINP wp;
  static char far mess1[]=" Save a Game as ";
  static char far mess2[]=" SavePro: Can't open file: %Fs ";

	wp=getpromptwindow(5,12,mess1);
	if( wp ) {
	  keyfunc(wp,tohelpprompt,BEFORE);
	  i=searchfile( wp, fname, defpro );
	  checkface(freewindow(wp));
	} else return 0;
	if (i==ESCAPE) return(0);
	if( i==ERROR ){ checkface(i); return(ERROR); }
	make_bak_file(fname); /* rename old file to ".bak"*/
	file=MYOPEN(fname,O_WRONLY+O_CREAT+O_TRUNC+O_TEXT,S_IREAD+S_IWRITE);
	if (file==-1){
		farsprintf( str, mess2, fname );
		message( str,0 );
		return(ERROR);
	}

	MEMCPY(&pos_buf,pos_stk,sizeof(POSITION));

	ks_farmemcpy(pos_stk, &startprotpos, sizeof(POSITION));
	putheader(file);
	writemaincomment(file);
	promp=probuff;
	for( i=0; i<totpromove; i++, promp++ ) writemove( file, promp, i );
	MYCLOSE(file);
	MEMCPY(pos_stk, &pos_buf, sizeof(POSITION));

	return(0);
}



static int near writemove( int file, PROMP  promp, int nmove )
{
  char str[PROSTRLEN]="    \0";
  char str1[PROSTRLEN];
  SSTRING buf="";
  int i;
  static char far form1[]="%s %6lu * %s\r\n";
  static char far form2[]="%s %6lu\r\n";

	if( EVEN(nmove) ) farsprintf( str,"%3d.", HALF(nmove)+1 );
	sprintmove1( str+4, &(promp->move) );
	if(promp->comment) farstrcpy(buf,promp->comment);
	if(*buf) farsprintf( str1, form1, str, promp->time, buf );
	else     farsprintf( str1, form2, str, promp->time );
	i=strlen(str1);
	MYWRITE(file,str1,i);
	return(i/*+1*/);
}


static int near dispmove( FULLMOVE *movep, int nmove )
{
  char str[MOVESTRLEN*2];
  char movestr[MOVESTRLEN+1];
  int nextnum,nmove1;
  static char far form1[]="    1.  ... ";
  static char far form2[]="  %3d. %s";
  static char far form3[]="   %s";
  static char far form4[]="  %3d.";

	sprintmove( movestr, movep );
	nmove1=nmove + startprotpos.a.move_color;

	if( !nmove && nmove1 ){           /* First move black */
	  farsprintf( str ,form1);
	  posstate( enter, 1,1 );
	  checkface( putstring( enter, str ) );
	}
	if( EVEN(nmove1) ) farsprintf( str,form2, HALF(nmove1)+1, movestr );
	else farsprintf( str,form3, movestr );
	posstate( enter, HALF(nmove1)+1,ODD(nmove1)+1 );
	checkface( putstring( enter, str ) );
	nextnum=nmove1+1;
	if( EVEN(nextnum) ){
		farsprintf( str,form4, HALF(nextnum)+1 );
		posstate( enter, HALF(nextnum)+1, ODD(nextnum)+1 );
		checkface( putstring( enter, str ) );
	}
	posstateenter(nmove+1);
	return(0);
}

static void near posstateenter(int nmove)
{
int nmove1;
    nmove1=nmove + startprotpos.a.move_color;
    posstate( enter, HALF(nmove1)+1,ODD(nmove1)+1 );
}

extern clock_t curtime[NCOLOR];

int savemove( FULLMOVE *movep, PIECE_COLOR color ) /* normal move into protocol */
{
  PROMP  promp;
  int i;
  long int li;
  int nmove1;

	if( profile==-1 ) makeprotocol(); /* No profile: make protocol */
	promp=probuff+nmove;          /* get move pointer */
	if( fmovecmp( movep, &promp->move ) ){ /* entered new move */
		clearcomment(nmove,0);
		totpromove=nmove;         /* now moves in protocol is not legal */
                nmove1=nmove + startprotpos.a.move_color;
	        posstate( enter, HALF(nmove1)+1,ODD(nmove1)+1 );
		truncstate(enter);
		if (!color) {	/* to erase black's move */
			posstate(enter,getnrow(enter),getcurx(enter)+1);
			deleol(enter);
			putstring(enter,"   ...");
			posstate(enter,getnrow(enter),getcurx(enter)-1);
		}
	}
	showcomment(nmove+1);
	ks_farmemcpy( &promp->move, movep, sizeof( FULLMOVE ) );
	promp->time=curtime[color];
        promp->fileoffset=curprotseek;
	MYLSEEK(profile,curprotseek,SEEK_SET);
	i=writemove( profile, promp, nmove ); /* write move to file */
	curprotseek+=i;
	(promp+1)->fileoffset=li=curprotseek;
	for (;li<maxprotseek;maxprotseek--) MYWRITE(profile," ",1);
	commit( profile );
	maxprotseek=MYLSEEK(profile,li,SEEK_SET);
	dispmove( movep, nmove );     /* display move on screen */
	refresh(enter);
	if( nmove==totpromove ) totpromove++;
	nmove++;                      /* increment move counter */
	return(0);
}

int playprotocol( void )	/* RETURN key */
{
  int tomove;

	tomove=getcurx( enter )+(getnrow( enter )-1)*2 -
		  startprotpos.a.move_color - 1;
	moveprot(tomove);
	return(0);
}

static int near moveprot(int tomove)
{
  PROMP  promp;

  protocolflag=1;
  if( tomove>=nmove ){
    if(tomove>totpromove) tomove=totpromove;
    promp=probuff+nmove;
  }
  else{
    if( tomove<0 ) tomove=0;
      resettime();
      setstartprotpos();				/* set initial position */
      if( usedebut )
	      if( initbase()==OK ) debut=1;
      nmove=0;
      controltime=enteredcontroltime;
      controlmove=enteredcontrolmove;
      promp=probuff;
  }
  while( nmove<tomove ){
	  fillmove( &promp->move );
	  curprotime=promp->time;
	  putkaissamove( &promp->move );
	  updatetime();
	  curprotseek=(promp+1)->fileoffset;
	  promp++; nmove++;
  }
  posstateenter(nmove);
  setcolor(MOVE_COLOR); /*EVEN(nmove)? WHITE_PIECE:BLACK_PIECE ); /* set color */*/
  if( issound ) music( playmove );

  showcomment(nmove);
  showtimer();
  setwritten(board);
  refresh(board);
  refresh(enter);
  if (!genlegalmoves() && whomove!=MAN_MAN) gamefinish();
  pos_hash_clear_flag=1;  /* A.S. pos hash must be cleared */
  protocolflag=0;
  return(0);
}

int protkeyminus( void )	/* - */
{
	moveprot(nmove-1);
	return(0);
}
int protkeyplus( void )        /* + */
{
	moveprot(nmove+1);
	return(0);
}
int protkeyend( void ) 	/* Ctrl+E */
{
        moveprot(totpromove);
	return(0);
}
int protkeybegin( void )       /* Ctrl+B */
{
	moveprot(0);
	return(0);
}

static char far mon[][4]=
{"NUL","jan","feb","mar","apr","may","jun","jul","aug","sep","oct","nov","dec"};

static char far * near sprintdt( char far *str )
{
  struct date d;
  struct time t;
  static char far form1[]="%2d %Fs %4d, %02d:%02d";
	getdate( &d );
	gettime( &t );
	farsprintf( str, form1,
		d.da_day, mon[d.da_mon], d.da_year, t.ti_hour, t.ti_min );
	return( str+18 ); /* return pointer to EOL */
}

void flush(FILE *stream)
{
     int duphandle;

     /* flush the stream's internal buffer */
     fflush(stream);

     /* make a duplicate file handle */
     duphandle = dup(fileno(stream));

     /* close the duplicate handle to flush\
        the DOS buffer */
     MYCLOSE(duphandle);
}

static void setstartprotpos(void)
{
  ks_farmemcpy(pos_stk, &startprotpos, sizeof(POSITION));
  setposition( MOVE_COLOR );
}

static int near writemonmove( int file, PROMP  promp, int nmove )
{
  char str[PROSTRLEN]="    \0";
  char str1[PROSTRLEN];
  char timestr[10];
  SSTRING buf="";
  int i;
  static char far form1[]="%s %s * %s\r\n";
  static char far form2[]="%s %s\r\n";

	if( EVEN(nmove) ) farsprintf( str,"%3d.", HALF(nmove)+1 );
	sprintmove1( str+4, &(promp->move) );
	if(promp->comment) farstrcpy(buf,promp->comment);
	maketimestring(promp->time,timestr);
	if(*buf) farsprintf( str1, form1, str, timestr, buf );
	else     farsprintf( str1, form2, str, timestr);
	i=strlen(str1);
	MYWRITE(file,str1,i);
	return(i/*+1*/);
}


static int near writemonitormove( int fp, PROMP  promp, int nmove, FULLMOVE *newmove, PIECE_COLOR color)
{
static char far str[PROSTRLEN]="    \0";
  char oldmovestr[10];
  char newmovestr[10];
  char timestr[10];
  char oldtimestr[10];
  static char far form1[]="%s %s New move %s Time used %s\r\n";

	if( EVEN(nmove) ) farsprintf( str,"%3d.", HALF(nmove)+1 );
	sprintmove( oldmovestr, &(promp->move) );
	sprintmove( newmovestr, newmove );
	maketimestring(curtime[color]+clock()-movetime,timestr);
	maketimestring(promp->time,oldtimestr);
	farsprintf( str+4,form1,
		  oldmovestr, oldtimestr, newmovestr, timestr);
	MYWRITE( fp, str, FARSTRLEN(str));
	return(OK);
}

int monfp=-1;
PIECE_COLOR ourmonitorcolor=0;
char far monfile[16]="*.mon";
char far defmonfile[16]="*.mon";

int setmonitorfile(void)
{
  char str[MAXPATH];
  int i;
  WINP wp;
  int top,left;
  static char far mess1[]=" Monitor output file ";

    menuposition(*menusp,&top,&left);
    wp=getpromptwindow(top,left,mess1);
    if( wp ) {
      keyfunc(wp,tohelpprompt,BEFORE);
      i=searchfile( wp, str, defmonfile );
      checkface(freewindow(wp));
    } else return 0;
    if(i==ESCAPE) return 0;
    checkface(i);
    if(i) return 0;
    FARSTRCPY(monfile,str);
    return 0;
}

int monitor(void)
{
  PROMP promp;
  static FULLMOVE newmove;
  MOVE *mp;
  char str[MAXPATH];
  char timestr[10];
  static char far mess1[]=" Can't open output file ";
  static char far form1[]=" Time at start: %s\r\n";

    if (monfp!=-1) MYCLOSE(monfp);
    monfp=MYOPEN( monfile, O_TRUNC | O_WRONLY| O_CREAT| O_TEXT, S_IREAD+S_IWRITE );
    if(monfp==-1) {
       message(mess1,0); return 0;
    }
/*    resettime();*/
/*  showtimer();*/
    promp=probuff+nmove;

    if (nmove>1) maketimestring((promp-2)->time,timestr);
    else strcpy(timestr,"00:00:00");
    farsprintf( str,form1,timestr);
    MYWRITE( monfp, str, FARSTRLEN(str));
    while( nmove<totpromove ) {
      fillmove( &promp->move );
      if((ourmonitorcolor+1) & (MOVE_COLOR+1)){
	  mp=get_move();
	  if(breakflag==TERMINATE) break;
	  movetofull(&newmove,mp);
	  fillmove(&newmove);
	  writemonitormove( monfp, promp, nmove, &newmove, MOVE_COLOR);
      }
      else writemonmove( monfp, promp, nmove );
      putkaissamove( &promp->move );
      dispmove(&promp->move,nmove);
      refresh(enter);
      updatetime();
      commit( monfp );
      refresh(board);
      promp++; nmove++;
    }
    return 0;
} 
static SSTRING commentstr="";
static PROMP curpromove;

int beginannotate(void)
{
    settype(comment,PROMPT);
    border(comment, TWOLINES, commentborder&'\xF0' + WHITE);
    setattr(comment,menuattr);
    setcurattr(comment,currmenuattr);
    setusemouse( comment );
    if(nmove){
      curpromove=probuff+nmove-1;
      if(!curpromove->comment)
	curpromove->comment=farcalloc(1,SHORT_STR_LEN);
      farstrncpy(commentstr,curpromove->comment,SHORT_STR_LEN);
    }
    else farstrncpy(commentstr, maincomment, SHORT_STR_LEN);
    putcommentstring(commentstr);
    return refresh(comment);
}
int entercomment(void)
{
    checkface(firstread( comment, commentstr, SHORT_STR_LEN ));
    if(nmove) farstrncpy(curpromove->comment,commentstr,SHORT_STR_LEN);
    else farstrncpy(maincomment, commentstr, SHORT_STR_LEN);
    return 1;
}
int gooutannotate(void)
{
    settype(comment,PANE);
    putcommentstring(commentstr);
    border(comment, ONELINE, commentborder );
    refresh(comment);
    return OK;
}


int putcommentstring(char far *str)
{
    emptystate(comment);
    newline(comment,str);
    return(1);
}

static int near showcomment(int nmove)
{
SSTRING commentstr="";
PROMP curpromove;
  if(whomove!=MAN_MAN)return(1);
  if(nmove){
    curpromove=probuff+nmove-1;
    if(curpromove->comment)
      farstrncpy(commentstr,curpromove->comment, SHORT_STR_LEN);
  }
  else farstrncpy(commentstr, maincomment, SHORT_STR_LEN);
  putcommentstring(commentstr);
/*  refresh(comment);*/
  openwindow(comment); /* V 18.03.91. */

  return(1);
}

static int writemaincomment( int file )
{
char str[PROSTRLEN]="";
static char far form1[]="* %Fs\r\n";
  farsprintf( str, form1, maincomment );
  MYWRITE(file,str,strlen(str));
  return(1);
}

static int readmaincomment( int file )
{
char str[PROSTRLEN]="";
int nb;
long point;


  nb=MYREADLINE(file,str,PROSTRLEN);
  if(*str=='*') {
	str[FARSTRLEN(str)-1]='\0';
	farstrncpy(maincomment,str+2,SHORT_STR_LEN);
  } else {
	point=tell(file);
	MYLSEEK(file,point-nb,SEEK_SET);
  }

/*
  nb=_read(file,str,2);
  lseek(file, tell(file)-nb, SEEK_SET);
  if(*str=='*'){
   MYREADLINE(file,str,PROSTRLEN);
   farstrncpy(maincomment,str+2,SHORT_STR_LEN);
  }
*/

  return(1);
}

static void near clearcomment(int nmove, int mainflag)
{
int i;

	if (mainflag) FARSTRCPY(maincomment,"");
	for (i=nmove;i<totpromove;i++)
	    if ((probuff+i)->comment) {
		 farfree((probuff+i)->comment);
		 (probuff+i)->comment=NULL;
	    }
}


extern int far freezed;
int redrawprot( void )
{
  int firstmove, i;
	firstmove=nmove-(getcurx(enter)-1)-(getcury(enter)-1)*2;
	facefreeze(enter);
	emptystate(enter);
	for( i=0; i<totpromove; i++ ){
		dispmove( &((probuff+i)->move), i );
	}
	posstateenter( firstmove );
	posstateenter( nmove );
	faceunfreeze( enter );
	return(0);
}

int printfp=-1;
char far printfile[72]="protocol.prn";
char far defprintfile[72]="*.prn";
int outdevice=0; /* 0= out to file, 1= out to printer */

int printprottofile(int printfp);

int prottofile(void)
{
  int i;
  char str[MAXPATH];
  WINP wp;
  static char far mess1[]=" Save a Game as ";
  static char far mess2[]=" Can't open output file ";

    wp=getpromptwindow(5,12,mess1);
    if( wp ) {
      keyfunc(wp,tohelpprompt,BEFORE);
      i=searchfile( wp, str,defprintfile );
      checkface(freewindow(wp));
    } else return 0;
    if (i==ESCAPE) return(0);
    if( i==ERROR ){ checkface(i); return(ERROR); }
    make_bak_file(str); /* rename old file to ".bak"*/
    printfp=MYOPEN( str, O_WRONLY+O_CREAT+O_TRUNC+O_TEXT,S_IREAD|S_IWRITE );
    if(printfp==-1) {
       message(mess2,0); return 0;
    }
    printprottofile(printfp);
    MYCLOSE(printfp);
    FARSTRCPY(printfile,str);
    return 0;
} 

int prottoprinter(void)
{
int printfp;
static char far filename[]="kaissa.prn";
static char far mess1[]=" Can't open output file ";

    printfp=MYOPEN( filename, O_RDWR+O_CREAT+O_TRUNC+O_TEXT,S_IREAD|S_IWRITE );
    if(printfp==-1) {
       message(mess1,0); return 0;
    }
    printprottofile(printfp);
    MYLSEEK(printfp,0L,SEEK_SET);
    copyfile(4,printfp);
    MYCLOSE(printfp);
    return 0;
} 

int printprottofile(int printfp)
{
  SSTRING str;
  PROMP  promp;
  int nmove;
  char movestr[10];
  char timestr[10];
  clock_t timeb,timew,prevtimeb,prevtimew;
  int commw;
  static char far form1[]=" %Fs %Fs \r\n";
  static char far form2[]="    %3d. %s ";
  static char far form3[]="          %s\r\n";
  static char far form4[]="     ";
  static char far form5[]="    %3d. . . .   ";
  static char far form6[]="        %s\r\n";
  static char far form7[]=" %s ";
  static char far form8[]=" %s\r\n";
  static char far form9[]="     ";

    if(*maincomment){
      MYWRITE( printfp, maincomment, FARSTRLEN(maincomment));
      MYWRITE(printfp,eol,2);
    }
    else{
	  farsprintf( str, form1, player[0].name, player[1].name );
      MYWRITE( printfp, str, strlen(str));
    }
    promp=probuff; nmove=0; prevtimew=0; prevtimeb=0;
    while( nmove<totpromove ) {
      commw=0;
	 sprintmove( movestr, &(promp->move) );
	 timew=promp->time-prevtimew; prevtimew=promp->time;
	 maketimestring(timew,timestr);
		farsprintf(str,form2,HALF(nmove)+1,movestr);
		MYWRITE( printfp, str, strlen(str));

	 if (promp->comment) {
		commw=1;
		farsprintf(str,form3,timestr+3);
		MYWRITE(printfp,str,strlen(str));
		MYWRITE(printfp,form4,5);
		MYWRITE( printfp, promp->comment, FARSTRLEN(promp->comment));
		MYWRITE(printfp,eol,2);
		if( nmove<=totpromove ){
		  farsprintf(str,form5,HALF(nmove)+1);
		  MYWRITE( printfp, str, strlen(str));
		}
	 } else  commw=0;
	 promp++; nmove++;
	 if( nmove>=totpromove ) break;
	 sprintmove( movestr, &(promp->move) );
	 timeb=promp->time-prevtimeb; prevtimeb=promp->time;
	 farsprintf( str,form7,movestr);
	 MYWRITE(printfp,str,strlen(str));
	 if (commw) {
		maketimestring(timeb,timestr);
		farsprintf(str,form6,timestr+3);
	 } else {
		farsprintf(str,form7,timestr+3);
		MYWRITE( printfp,str,strlen(str));
		maketimestring(timeb,timestr);
		farsprintf(str,form8,timestr+3);
	 }
	 MYWRITE( printfp, str, strlen(str));
	 if (promp->comment) {
		MYWRITE(printfp,form9,5);
		MYWRITE( printfp, promp->comment, FARSTRLEN(promp->comment));
		MYWRITE(printfp,eol,2);
	 }
	 promp++; nmove++;
    }
	MYWRITE(printfp,eol,2);
	return 0;
} 

int checkprinter( void )    /* Return 1, if printer is OK */
{
  int err;
  union REGS r;
	r.h.ah=2; /* get printer status */
	r.x.dx=0; /* lpt0: */
	int86( 0x17, &r, &r );
	err=r.h.ah;
	if( err&0x90 ) return(1);
	return(0);
}

#define BUFFSIZE 512
int copyfile(int dstfile, int srcfile)
{
int nb;
void far * buf;
static char far mess1[]=" Printer not ready. ";
static char far form1[]="             ";

  if( dstfile==4 )
	if( !checkprinter() )
		{ message(mess1,0); return(-1); }
  buf=MYFARMALLOC(BUFFSIZE);
  while((nb=MYREAD(srcfile,buf,BUFFSIZE)) > 0){
    if(!FARSTRNCMP(buf,form1,10)) break;
    if((nb=MYWRITE(dstfile,buf,nb))==-1) break;
  }
  MYFREE(buf);
  if(nb==-1) return(-1);
  return(0);
}
