#include <stdlib.h>          /* NULL */
#include <string.h>

#include "myface.h"
#include "faceproc.h"
#include "facemous.h"
#include "facekeys.h"
#include "facelib.h"

#include "menu.h"
#include "menu_fun.h"
#include "interfac.h"
#include "infc_fun.h"

#include "proc.h"
#include "entime.h"
#include "ksichess.h"
#include "helpind.h"
#include "ksibdraw.h"
#include "ks_macro.h"
#include "ksiutil.h"
#include "ksiprot.h"
#include "ksiwork.h"
#include "ksiwind.h"
#include "ksitimer.h"
#include "ks_corr.h"
#include "ks_game.h"
#include "ksisound.h"
#include "ksibase.h"
#include "newutil.h" /* setdefaultcastle() */
#include "tests.h"
#include "link.h"
#include "hashpos.h"

int posmouswindow( int x, int y );
int upedit(WINP wp);
int downedit(WINP wp);
int leftedit(WINP wp);
int rightedit(WINP wp);
int set_escape(int x,int y);
int entermove(void);

int showsquare( void );
int drawpiecemove( void );

typedef struct {
  WINP *wpp;
  int key;
  CFP str;
  int retkey;
  int (*fun)( int x, int y );
} far HOTMOUSE;

HOTMOUSE hmouse[]={
/*{ &enter,    RIGHTRELEAS, NULL, 0,rightmouseenter },*/

{ &helpline, LEFTRELEAS, "F1", F1,NULL },
{ &helpline, LEFTRELEAS, "Help", F1,NULL },

{ &helpline, LEFTRELEAS, "F2", F2,NULL },
{ &helpline, LEFTRELEAS, "Save", F2,NULL },

{ &helpline, LEFTRELEAS, "F3", F3,NULL },
{ &helpline, LEFTRELEAS, "Load", F3,NULL },

{ &helpline, LEFTRELEAS, "F4", F4,NULL },
{ &helpline, LEFTRELEAS, "Interrupt", F4,NULL },

{ &helpline, LEFTRELEAS, "F5", F5,NULL },
{ &helpline, LEFTRELEAS, "Notes", F5,NULL },

{ &helpline, LEFTRELEAS, "F6", F6,NULL },
{ &helpline, LEFTRELEAS, "Flip", F6,NULL },


{ &helpline, LEFTRELEAS, "F7", F7,NULL },
{ &helpline, LEFTRELEAS, "Pos", F7,NULL },

{ &helpline, LEFTRELEAS, "F10", F10,NULL },
{ &helpline, LEFTRELEAS, "Menu", F10,NULL },

{ &helpline, LEFTRELEAS, "Alt-X", ALT_X,NULL },
{ &helpline, LEFTRELEAS, "Exit", ALT_X,NULL },

{ &helpline, LEFTRELEAS, "Esc", ESCAPE,NULL },
{ &helpline, LEFTRELEAS, "End", ESCAPE,NULL },
{ &helpline, LEFTRELEAS, "Cancel", ESCAPE,NULL },

{ &helpline, LEFTRELEAS, "Enter", RETURN,NULL },
{ &helpline, LEFTRELEAS, "Change", RETURN,NULL },
{ &helpline, LEFTRELEAS, "Position", RETURN,NULL },
{ &helpline, LEFTRELEAS, "Set/Remove", RETURN,NULL },

{ &helpline, LEFTRELEAS, "'+'", '+',NULL },
{ &helpline, LEFTRELEAS, "Forward", '+',NULL },

{ &helpline, LEFTRELEAS, "'-'", '-',NULL },
{ &helpline, LEFTRELEAS, "Back", '-',NULL },

{ &helpline, LEFTRELEAS, "TAB", TAB,NULL },
{ &helpline, LEFTRELEAS, "Play", TAB,NULL },
{ &helpline, LEFTRELEAS, "Name", TAB,NULL },
{ &helpline, LEFTRELEAS, "Game", TAB,NULL },
{ &helpline, LEFTRELEAS, "list", TAB,NULL },

{ &helpline, LEFTRELEAS, "Shift-TAB", SHIFT_TAB,NULL },
{ &helpline, LEFTRELEAS, "Color", SHIFT_TAB,NULL },

{ &colors,LEFTRELEAS,NULL,0,posmouswindow},
{ &pieces,LEFTRELEAS,NULL,0,posmouswindow},
/*{ NULL,RIGHTRELEAS,NULL,ESCAPE},*/
{ NULL,0 }
};

extern NODE mainmenu;

int findmouse( int key, int x, int y )
{
  char str[40];
  int i;
  WINP wp;
  HOTMOUSE *hmp;
  int (*userfun)( int x, int y );

    wp=getmousetext( y, x, str );
    if( !wp ) return(key);
    i=strlen(str);
    if(i>0) if(str[i-1]==';' || str[i-1]=='|') str[i-1]='\0';
    hmp=hmouse;
    for(; hmp->wpp||hmp->key;hmp++ ) {  /* for all entries in the table */
      if( *(hmp->wpp)==wp || !hmp->wpp){ /* this window or any window */
	if( hmp->str )		/* the string is given */
	  if( FARSTRCMP( str, hmp->str ) ) continue;  /* not this string */
	if( key!=hmp->key && hmp->key) continue; /* not this key */
	if(hmp->retkey) i=hmp->retkey;
	else {
	  userfun=hmp->fun;
	  i=userfun( x, y );
	}
	if(i) return( i );
      }
    }
    return( key );
}
/*
int rightmouseenter( int x, int y )
{
  WINP wp;
    if(cur_infc_ptr->name!=BOARD_ST) return(0);
    wp=whatusrwindow( &y, &x );
    if( wp!=enter ) return( ERROR );
    posstate( enter, (TNROW-CURY)+y, (TNSYM-CURX)+(x-1)/TCOLLTH +1);
    playprotocol();
    refresh(enter);
    return(NULLKEY);
}
*/
int mouseboard(int key, int x, int y)
{
    if(key==RIGHTRELEAS) {
      key=ESCAPE;
      return(key);
    }
    if( !onboard( &x, &y ) ) {
      if(key==LEFTRELEAS) {
	key=ESCAPE;
	return(key);
      }
      return( NULLKEY );
    }
    switch( key ){
      case LEFTPRESS:
	cursquare=GETOFFSET(x,y);
	setcursquare( cursquare );
	if(redsquare!=DUMMY) entermove();
	showsquare();
	key=NULLKEY;
	break;
      case LEFTRELEAS:
	cursquare=GETOFFSET(x,y);
	setcursquare( cursquare );
	key=SPACE;
	break;
      case LEFTBUTTMOVE:
	if( redsquare==DUMMY ) {
	  if(cur_infc_ptr->name==BOARD_ST ||
	    cur_infc_ptr->name==BOARDBREAK_ST)
	  entermove();
	 }
	 cursquare=GETOFFSET(x,y);
	 setcursquare( cursquare );
	 if( redsquare!=DUMMY ){
	    drawpiecemove();
	    drawredframe( redsquare );
	 }
	 showsquare();
	 key=NULLKEY;
	 break;
      default:
	 key=NULLKEY;
	 break;
    }
    return(key);
}

int getmousestatus(WINP wp, int x, int y)
{
  NODEPTR far *mp;
  int lev;
  WINP curwp;
  char buff[80];

    if(cur_infc_ptr->name==BOARDBREAK_ST) return(endofsearch());
    curwp=*(infc_info[cur_infc_ptr->name].wpp);
    if( wp==mainmenu.wp && curwp!=mainmenu.wp ) {
      getmouseloc(&x,&y);
      if(!whatusrwindow( &y, &x )) return 0;
      if(infc_info[cur_infc_ptr->name].type&NOMAINMENUKEY_STATUS)
	return 0;
      buff[0]=(TNSYM-CURX)+(x-1)/TCOLLTH+1;
      buff[1]='\0';
      return( /*exec*/goto_menu(buff));
    }
    for(mp=menustack,lev=0; mp<menusp; mp++,lev++) {
      buff[lev]=(*mp)->curitem+1;
      if((*mp)->wp==wp) {
	getmouseloc(&x,&y);
	if(whatusrwindow( &y, &x )) {
	  buff[lev]=(TNROW-CURY)+y;
	}
	buff[lev+1]='\0';
	skipmousuntil( LEFT_PR|RIGHT_PR|LOC_CH );
	return(goto_menu(buff));
      }
    }  
    if(cur_infc_ptr->name==BREAK_ST) return 0 /*end_work()*/;
						/* For mouse in status line */
    if( wp==enter && curwp!=enter ) {
      skipmousuntil( LEFT_PR|RIGHT_PR|LOC_CH );
      goto_stone();
      return(goto_protocol());
    }
    if(wp==board && curwp!=board ) {
      skipmousuntil( LEFT_PR|RIGHT_PR|LOC_CH );
      goto_stone();
      if(*(infc_info[cur_infc_ptr->name].wpp)==board) {
	(*(infc_info[cur_infc_ptr->name].reenter))();
	  return 0;
      }
      return goto_board();
    }
    if(wp==comment && curwp!=comment ) {
      skipmousuntil( LEFT_PR|RIGHT_PR|LOC_CH );
      goto_stone();
      return goto_annotate();
    }
    if(wp==reply && curwp!=reply ) {
      skipmousuntil( LEFT_PR|RIGHT_PR|LOC_CH );
      goto_stone();
      return 0;
    }
    if(wp==timer) {
/*    if( y==2       Enter names of players
      if( y==3       Enter control time and moves
      if( y==4       Change colors */
      skipmousuntil( LEFT_PR|RIGHT_PR|LOC_CH );
      exec_menu("\x6\x4");
    }
/*  if(wp==colors)
    if(wp==pieces)
    if(wp==helpline)
    if(wp==chessinfo)
    if(wp==small)
*/
    return(0);
}

int set_escape(int x, int y)
{
    return(ESCAPE);
}
/******
int mouseinwind(WINP wp, int key, int x, int y)
{
int far clearfirst(WINP wp);

	if( wp==board ) return mouseboard(key, x, y);
	if(!whatusrwindow( &y, &x )) { /* mouse on border */
	  if(key==LEFTBUTTMOVE) return leftmove(wp, x, y);
	  return NULLKEY;
	}
	if(wp==comment) clearfirst(wp);
	switch (key) {
	  case LEFTRELEAS:
		/*resetmousecond();*/
		posstate( wp, (TNROW-CURY)+y, (TNSYM-CURX)+(x-1)/TCOLLTH+1 );
		if(wp!=reply && wp!=comment) return RETURN;
		else return NULLKEY;
	  case LEFTBUTTMOVE:
		/*resetmousecond();*/
		x=(x-1)/TCOLLTH+1;        /* get new column */
		if( CURX!=x || CURY!=y ) /* if position is new */
			posstate(wp, (TNROW-CURY)+y, (TNSYM-CURX)+x );
		return(NULLKEY);
	  case LEFTPRESS:
		/*resetmousecond();*/
		posstate( wp, (TNROW-CURY)+y, (TNSYM-CURX)+(x-1)/TCOLLTH+1 );
		return NULLKEY;
	  case RIGHTPRESS:
		/*resetmousecond();*/
		/*skipmousecond();*/ /* to skip mouse button release */
		return ESCAPE;
	}
	return(key);
}

int leftmove(WINP wp, int x, int y)
{
	/*resetmousecond();*/
	if(wp!= mainmenu.wp) {
	   if( y<UTOP && TNROW>1 ) {
		if(wp!=board)
		   upedit( wp );
		settextloc( x, UTOP );
		} else if( y>UBOTTOM && TCURRENT->next ) {
		if(wp!=board)
		   downedit( wp );
		settextloc( x, UBOTTOM );
	   } else if( x<ULEFT && TNSYM>1 ) {
		if(wp!=board)
		    leftedit( wp );
		settextloc( ULEFT, y );
	   } else if( x>URIGHT && TNSYM*TCOLLTH<MAXLINE ) {
		if(wp!=board)
		    rightedit( wp );
		settextloc( URIGHT, y );
	   }
	   return NULLKEY;
	} else return RETURN;
}
********/

int posmouswindow( int x, int y )
{
  WINP wp;
	if(cur_infc_ptr->name==BOARDBREAK_ST) return(0);
	/*resetmousecond();*/
	wp=whatusrwindow( &y, &x );
	posstate( wp, (TNROW-CURY)+y, (TNSYM-CURX)+(x-1)/TCOLLTH +1);
	refresh(wp);
	return(NULLKEY);
}
