/*
	 ͻ
	              Making windowes for interface                     
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <conio.h>           /* colors */
#include <stdio.h>           /* NULL */
#include <stdlib.h>          /* exit() */

#include "myface.h"
#include "faceproc.h"
#include "myfacpro.h"
#include "facekeys.h"
#include "facerr.h"
#include "facelib.h"
#include "lang.h"
#include "global.h"
#include "ksiwind.h"
#include "ksibdraw.h"
#include "interface.h"
#include "proc.h"

WINP enter, errors;
WINP colors, pieces;
WINP helpline, chessinfo;
WINP reply, timer, small;
WINDOW errorwindow;
WINP errors=&errorwindow;
WINP comment;

int flagmono;

#define FILEWNDLEN 33
static enum winddef{
  ERRORTOP=13, ERRORLEFT=7,  ERRORBOT=15,  ERRORRIGHT=65,
  DIALTOP=10,  DIALLEFT=20,  DIALBOT=16,   DIALRIGHT=60,

  PROTOCOL=0,
  PIECE=1, COLOR=2, HELPLINE=3, INFOLINE=4,
  REPLY=5, SMALL=6, TIMER=7,    BOARD=8,    HELPWND=9,
  NOTES=10, MENUS=11
};

char far *wndname[]={ /* list of window names */
/*  0 */"cprotocol",
/*  1 */"cpiece",
/*  2 */"ccolor",
/*  3 */"chelpline",
/*  4 */"cinfoline",
/*  5 */"creply",
/*  6 */"csmall",
/*  7 */"ctimer",
/*  8 */"cboard",
/*  9 */"chelp",
/* 10 */"cnotes",
/* 11 */"cmenu",
NULL};

	/* attributes for monochrome adapter */
#define NORMATTR     ( GREEN ON BLACK )
#define INVERSEATTR  ( BLACK ON LIGHTGRAY )
#define HLIGHTATTR   ( WHITE ON BLACK )

int  replyattr=YELLOW ON CYAN,
     replyborder=WHITE ON CYAN,
     proattr=YELLOW ON LIGHTGRAY,
     proborder=BLACK ON LIGHTGRAY,
     helpattr=WHITE ON CYAN,
     helpaltattr=YELLOW ON CYAN,
     curhelpattr=YELLOW ON BLUE,
     helpborder=BLACK ON CYAN,
     commentborder=BLACK ON LIGHTGRAY
;
extern char far configfile[];
int messagehot(WINP wp,int key, int when);

static int near setmonocolors( void )
{
 int i;
	i=0;
	while( wndname[i] ){
		wndname[i++][0]='m'; /* set monochrome status */
	}
	return(0);
}

static int near  makeenter( WINP wp )
{
  int i;
	checkface( readwindow( wp, wndname[PROTOCOL], configfile) );
	getattr(wp,&proattr);
/*	getcurattr(wp, &curproattr );*/
	getborder(wp,&i,&proborder);
	setupwind(wp);		/* goto the window beggining */
	keyfunc(wp,hotkey, BEFORE|AFTER );/* set function for special keys */
	return(checkface(0) );
}

static int near  makepieces(WINP wp)		/* make the menu window */
{
static char far king_str[]="   King";
static char far queen_str[]="   Queen";
static char far rook_str[]="   Rook";
static char far bishop_str[]="   Bishop";
static char far knight_str[]="   kNight";
static char far pawn_str[]="   Pawn";

	checkface( readwindow( wp, wndname[PIECE], configfile) );
			  /*12345678901234567890*/
	newline(wp,king_str);
	newline(wp,queen_str);
	newline(wp,rook_str);
	newline(wp,bishop_str);
	newline(wp,knight_str);
	checkface(
	newline(wp,pawn_str)
	);
	setrolling(wp,VROLL);
	setupwind(wp);		/* goto the window beginning */
	return(checkface(0));
}

static int near  makecolors(WINP wp)		/* make the colors window */
{
static char far mess1[]="    White";
static char far mess2[]="    bLack";

	checkface( readwindow( wp, wndname[COLOR], configfile) );
	newline(wp,mess1);   newline(wp,mess2);
	setrolling(wp,VROLL);
	setupwind(wp);
	return(checkface(0));
}

static int near  makehelpline(WINP wp)		/* make window */
{
	checkface( readwindow( wp, wndname[HELPLINE], configfile) );
	checkface( newline(wp, helpstr));    /*Ecs Interrupt thinking*/
	setupwind(wp);		/* goto the window beginning */
	return(checkface(0));
}

static int near  makeinfo(WINP wp)		/* make window */
{
	checkface( readwindow( wp, wndname[INFOLINE], configfile) );
	newline(wp,version);
	setupwind(wp);		/* goto the window beginning */
	return(checkface(0));
}

static int near  makeerror(WINP wp)		/* make window */
{
static char far mess1[]=" Error. ";

	FARMEMSET(wp,0,sizeof (WINDOW)); /* setting it to zero */
	ATTR=YELLOW ON RED;		/* default attribute - green on black */
	TYPE=PANE;			/* default type - PANE */
	MAXLINE=80;			/* default string size */
	poswindow(wp,ERRORTOP,ERRORLEFT,ERRORBOT,ERRORRIGHT);/* position */
	border(wp, ONELINE, YELLOW ON RED );
	header( wp, mess1);
	keyfunc(errors,messagehot,BEFORE);
	setusemouse(errors);

	if( facerror ) return( ERROR );
	newline( wp," " ); /* to have memory for error messages */
	if( facerror ) return( ERROR );
	setupwind(wp);		/* goto the window beginning */
	return(checkface(0));
}

static int near makereply(WINP wp)		/* make window */
{
  int i;
	checkface( readwindow( wp, wndname[REPLY], configfile) );
	getattr(wp,&replyattr);
	getborder(wp,&i,&replyborder);
	setupwind(wp);		/* goto the window beginning */
	keyfunc( wp, hotkey, BEFORE|AFTER );
	return(checkface(0));
}

static int near makesmall(WINP wp)		/* make window */
{
	checkface( readwindow( wp, wndname[SMALL], configfile) );
	setupwind(wp);		/* goto the window beginning */
	return(checkface(0));
}

static int near  maketimer(WINP wp)		/* make window */
{
static char far form1[]="         Player - Player         ";
static char far form2[]="      00:00:00     00:00:00      ";
static char far form3[]="           White move            ";

	checkface( readwindow( wp, wndname[TIMER], configfile) );
	newline( wp, form1);
	newline( wp, form2);
	newline( wp, form3);
	setupwind(wp);		/* goto the window beginning */
	return(checkface(0));
}

static int near makecomment( WINP wp )
{
  int i;
  checkface( readwindow( wp, wndname[NOTES], configfile) );
/*  getattr(wp,&commentattr);
  getcurattr(wp, &curcommentattr );*/
  getborder(wp,&i,&commentborder);
  setupwind(wp);		/* goto the window beginning */
  keyfunc( wp, hotkey, BEFORE|AFTER );
  return(0);
}

extern int graphmode;

int makewindow()
{
 int i;
static char far mess1[]=" Not enough memory for windows.";
static char far mess2[]=" No memory. Graphics mode not available. ";
static char far mess3[]=" Missing fonts. Graphics mode not available. ";

	detectadapter();
	if( makeerror(errors) ){
		farputs(mess1 );
		exit(1);
	}
	checkface( faceinitialize(MAXWINDOWS) );
	setbackground( '', BLACK ON LIGHTGRAY );
	if( graphmode==1 || videomode==7 || flagmono )
		setmonocolors();
	if( graphmode ){
		i=setfacemode(1);
		if( i==NOMEM )
			message(mess2,0);
		if( i==ERROR )
			message(mess3,0);
	}

	if( (enter=getwindow())==NULL ) checkface(0);
	if( (colors=getwindow())==NULL ) checkface(0);
	if( (pieces=getwindow())==NULL ) checkface(0);
	if( (helpline=getwindow())==NULL ) checkface(0);
	if( (chessinfo=getwindow())==NULL ) checkface(0);
	if( (reply=getwindow())==NULL ) checkface(0);
	if( (timer=getwindow())==NULL ) checkface(0);
	if( (small=getwindow())==NULL ) checkface(0);
	if( (comment=getwindow())==NULL ) checkface(0);

	makeinfo(chessinfo);
	makeenter(enter);
	makepieces(pieces);
	makecolors(colors);
	makehelpline(helpline);
	makereply( reply );
	makesmall( small );
	maketimer( timer );
	makecomment( comment );
	return(checkface(0));
}

int openallwnd( void )
{
	openwindow( chessinfo );
	openwindow( helpline );
	openwindow( small );
	openwindow( timer );
	openwindow( enter );
	openwindow( comment );
	return(0);
}
