/*
	 ͻ
	          Working with debut base                               
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/

#include <io.h>              /* open().. */
#include <fcntl.h>           /* open flags */
#include <conio.h>           /* putch() */
#include <alloc.h>
#include <stdio.h>           /* fopen() (temp) */
#include <stdlib.h>          /* for errors */
#include "chess.h"
#include "ksichess.h"
#include "ks_macro.h"
#include "ksibase.h"
#include "facelib.h"
#include "ksisound.h"

#define OK        0
#define ERROR    -1
#define END_BASE  1
enum dberror {
   OPEN_ERR=1, CLOSE_ERR=2, FILE_ERR=3,
   READ_ERR=4, WRITE_ERR=5, POSF_ERR=6,
   MOVE_ERR=7, SAVE_ERR=9,
   NOMEM_ERR=8
};

typedef struct {	/* Define type of moves in file */
			/* opening book (default file debut.dbe) */
  WORD who:3,	/* who move */
	   capt:1,	/* move is capture */
	   from:6,	/* square from */
	   to:6 ;	/* square to */
  WORD hloffs;	/* horiz link offset ( # of next move on this level ) */
  WORD vloffs;	/* vert link offset ( # of first move on next level ) */
  WORD check:1,	/* move is check */
	   last:1,	/* last move on the level */
	   best:1,	/* best move on the level */
	   first:1,	/* first move on the level (not used yet) */
	   hlseg:2,	/* hor link segment, segment size is 64k */
	   vlseg:2;	/* vert link segment */
} FILEMOVE;
typedef FILEMOVE far * FILEMP;

#define GET_VLINK(x)    (((unsigned long)((x)->vlseg)<<16) \
						 |(unsigned)((x)->vloffs))

#define GET_HLINK(x)    (((unsigned long)((x)->hlseg)<<16) \
						 |(unsigned long)((x)->hloffs))

#define FFROM      fmp->from
#define FTO        fmp->to
#define FWHO       fmp->who
#define FCAPT      fmp->capt
#define FISCHECK   fmp->check
#define FLASTMOVE  fmp->last
#define FBESTMOVE  fmp->best
#define FFIRSTMOVE fmp->first

#define BUFFSIZE   20
typedef struct basemove { /* Define type of moves in memory */
  BYTE who;
  BYTE from, to;
  WORD capt:1, check:1,           /* flags: move is capture, check, */
	   lcastle:1, rcastle:1,      /* move is right or left castle */
	   en_pass:1,                  /* move is en passant */
	   first:1, last:1, best:1,   /* first, last, best on level */
	   flags:8;                   /* editor flags */
  DWRD hlink, vlink, ownlink;   /* horiz, vert links & own index */
} BASEMOVE;

typedef BASEMOVE far * BASEMP; /* may be far ?? */

#define FROM      bmp->from
#define TO        bmp->to
#define WHO       bmp->who
#define CAPT      bmp->capt
#define ISCHECK   bmp->check
#define IS_ENPASS bmp->en_pass
#define LASTMOVE  bmp->last
#define BESTMOVE  bmp->best
#define FIRSTMOVE bmp->first
//#define NEXT      bmp->next
#define LEFT_CASTLE  bmp->lcastle
#define RIGHT_CASTLE bmp->rcastle

#define TITLEMOVE   5
#define TITLESIZE   (sizeof( FILEMOVE )*TITLEMOVE )
static char title[TITLESIZE]=" Kaissa Opening Book v.1 \x1a";

char far basename[80]="filename.ext";
static int basefh=ERROR; /* debut base file handle */
static char endofbase=0; /* set to 1 if enf of base founded */
static PIECE_COLOR basecolor=WHITE_PIECE;/* white color */
static BASEMOVE far *buff=NULL;
static char far playerror[]="t120o5 l24 ms ggg";

/*static int prmove( BASEMOVE *basemp );*/
static int near errorbase( void );
static BASEMOVE far * near findbest( void );
static BASEMOVE far * near findmove( FULLMOVE *movep );
static int near readlevel( long int index, BASEMP far *firstbmpp );

static int near errtrap( enum dberror errcode )
{
    return( errcode );
}
/*
static long int near seekbase( long int index, int fromwhere )
{
  long int l;
    switch( fromwhere ){
      case SEEK_SET: index=index*sizeof( FILEMOVE )+TITLESIZE; break;
      case SEEK_CUR: break;
      case SEEK_END: index=index*sizeof( FILEMOVE ); break;
      default: return( -1L );
    }
    l=MYLSEEK( basefh, index, fromwhere ); /* seek from given position */
    if( l==ERROR )                     /* check new file position */
        return( ERROR );               /* return file position error */
    l=l-TITLESIZE;
    return( l/sizeof( FILEMOVE ) );
}
*/
static int near readfilemove( long int index, FILEMP fmp )
{
  int i;
  long int l;

    l=MYLSEEK( basefh,                   /* use base file hendler */
        index*sizeof( FILEMOVE )+TITLESIZE, /* index from ? */
	SEEK_SET );                    /* seek from begin */
    if( l==ERROR )                     /* check new file position */
	return( errtrap(POSF_ERR) );            /* return file position error */
    i=MYREAD( basefh, fmp, sizeof( FILEMOVE ) ); /* read move from file */
    if( i!=sizeof( FILEMOVE ) )        /* check number of byte read */
	return( errtrap(READ_ERR) );            /* return error code */
    return( OK );
}

static int near readmove( long int index, BASEMP bmp )
{
  int i;
  FILEMOVE filemove, *fmp=&filemove;

    if( (i=readfilemove( index, fmp ))!=OK ) /* read move from file */
        return( i );                   /* error */
    WHO=FWHO; FROM=FFROM; TO=FTO;      /* make fields of BASE MOVE */
    if( index!=0                       /* check move is correct */
        &&( WHO<KING || WHO>PAWN || FROM<a1 || FROM>h8 || TO<a1 || TO>h8) )
            return( errtrap(MOVE_ERR) );        /* this isn't move */
    CAPT=FCAPT; ISCHECK=FISCHECK;
    LASTMOVE=FLASTMOVE; BESTMOVE=FBESTMOVE;
    FIRSTMOVE=FFIRSTMOVE;
    bmp->hlink=GET_HLINK( fmp );
    bmp->vlink=GET_VLINK( fmp );
    bmp->ownlink=index;
//    NEXT=NULL;
//    EDITFLAG=0;
    return(0);
}

int initbase( void )
{
  char tstr[TITLESIZE+1], *cp1, *cp2;
  int i;
  BASEMOVE null;
    if( basefh==ERROR ){
        basefh=MYOPEN( basename, O_RDONLY | O_BINARY ,0);
	if( basefh==ERROR ){ music( playerror ); return( errorbase() ); }
	if( buff==NULL ){
            buff=(BASEMOVE far *)MYCALLOC( BUFFSIZE, sizeof( BASEMOVE ));
	    if( !buff ){ music( playerror ); return( errorbase() ); }
	}
        cp1=tstr; cp2=title;               /* check title of file */
        i=MYREAD( basefh, cp1, TITLESIZE ); /* read title */
        if( i!=TITLESIZE )                 /* check read error */
	    return( errtrap(READ_ERR) );   /* error code */
        tstr[TITLESIZE+1]='\0';            /* null terminated */
        while( *cp1 )                      /* while not '\0' */
	    if( *cp1++ != *cp2++ ){        /* compare titles */
	        closebase();
	        return( errtrap(FILE_ERR) ); /* file isn't Kaissa debut */
	    }
    }
    readmove( 0, &null );
    if( !null.vlink ) return( errtrap(FILE_ERR) );
    readlevel( null.vlink, &buff );
    endofbase=0;
    basecolor=WHITE_PIECE;
    return( OK );
}

int closebase( void )
{
    if( buff ){
        MYFREE( (char far *)buff ); /* free memory */
	buff=NULL;
    }
    if( basefh!=ERROR )                /* if base opened, close it */
	if( MYCLOSE( basefh ) ){
	    music( playerror ); basefh=ERROR; return(ERROR);
	}
    basefh=ERROR;
    return(OK);
}

static int near errorbase( void )
{
    closebase();
    return( ERROR );
}

static BASEMP near findbest( void )
{
  BASEMP bmp=buff;

    while(1){
        if( BESTMOVE ) return( bmp );
	if( LASTMOVE  ) break;
	bmp++;
    }
    return(NULL);
}

static BASEMP near findmove( FULLMOVE *movep )
{
  BASEMP bmp=buff;

    while(1){
	if( WHO==movep->who
	    && FROM==movep->from
	    && TO==movep->to )
		return( bmp );
	if( LASTMOVE ) break;
	bmp++;
    }
    return( NULL );
}

static int near readlevel( long int index, BASEMP far *firstmpp/*, BASEMP *lastmpp*/ )
{
  BASEMP bmp, bmpbuff;
  int i, j;
    bmpbuff=(BASEMOVE far *)MYCALLOC( BUFFSIZE, sizeof( BASEMOVE ));
    bmp=bmpbuff; i=0;
    while( i<BUFFSIZE ){
	if( (j=readmove( index, bmp ))!=OK ) /* read one move */
	    return(j);            /* return error code */
	i++;                      /* increment move counter */
	if( LASTMOVE ) break;     /* move is last on level, break */
	index=bmp->hlink;         /* else get index of next move */
	bmp++;                    /* get next position */
    }
        /* allocate memory for level */
    bmp=(BASEMOVE far *)MYCALLOC( i, sizeof( BASEMOVE ));
    if( !bmp )                    /* check memory presence */
        return( errtrap(NOMEM_ERR) );      /* no more mem */
        /* copy level to new place */
    FARMEMCPY( bmp, bmpbuff, sizeof( BASEMOVE )*i );
    MYFREE (bmpbuff);
    FIRSTMOVE=1;                  /* mark move as first on level */
    *firstmpp=bmp;                /* save pointer to level start */
/*  *lastmpp =bmp+i;              /* save pointer to level end */*/
    return(OK);
}

int getbasemove( FULLMOVE *movep )
{
  BASEMOVE far *basemp;
  int done;

    if( endofbase ) return(END_BASE);
    if( basefh==ERROR ) if( initbase() ) return( errorbase() );
    basemp=findbest();
    if( basemp ){
	movep->flags=0;
	movep->who=basemp->who;
	movep->from=basemp->from;
	movep->to=basemp->to;
	basecolor=REVCOLOR( basecolor );
	if( basemp->vlink==0 ){ closebase(); endofbase=1; }
	else {
	    if (buff) MYFREE(buff);
	    done=readlevel( basemp->vlink, &buff );
	    if( done==ERROR ) endofbase=1;
	}
    } else {
        closebase();
        return(END_BASE);
    }
    return(OK);
}

int putbasemove( FULLMOVE *movep )
{
  BASEMOVE far *basemp;
  int done;

    if( endofbase ) return( END_BASE );
    if( basefh==ERROR ) if( initbase() ) return(errorbase());
    basemp=findmove( movep );
    if( basemp ){
	if( basemp->vlink ){
	    basecolor=REVCOLOR(basecolor);
	    if (buff) MYFREE(buff);
	    done=readlevel( basemp->vlink, &buff );
	    if( done==ERROR ) endofbase=1;
	    return(OK);
	}
    }
    closebase();
    return(END_BASE);
}
/*
main()
{
	int i;
	MOVE move;
	BASEMOVE basemp;
	BITMOVE bitmp;
/*
	initbase();
	for( i=0; i<100; i++ ){
		readbasemove( &bitmp );
		decodemove( &bitmp, &basemp );
		prmove( &basemp );
/*		getch();*/
	}
*/

	move.who=W_KNIGHT; move.from=6; move.to=21;
/*	putbasemove( &move );
*/
	i=0;
	while(!i){
		i=getbasemove( &move );
	}
	closebase();
}
*/