
		/**\
		 	Program file "killer.c"		
		 					
		 	      Public			
		 	       functions: killer()	
		 		      killer_heuristic()
		\**/

#include <mem.h>			/* memcpy() , NULL */
#include <stdlib.h>			/* qsort()  , NULL */

#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "proc.h"
#include "gener.h"
#include "ks_macro.h"
#include "hashpos.h"

/*--------------  killer heuristic algorithm  -----------------------*/

#define NBEST   10	       /* Move number in common best move table */
#define NKEY    5              /* Key move number in best answer table */
#define NANSWER 2              /* Answer move number in best answer table */

int Nmove;  /* Current table size. NBEST or NANSWER */ 

#define MAXFREQ 100
#define MINFREQ 0
#define BONUS 10
#define PENALTY 1
#define KILLERTABLESIZE 10   /* MAXSLOWLEVEL */
/*
typedef struct {			/* Define type KILLER_INFO */
  SQUARE_NUM from;			/* move from square */
  SQUARE_NUM to;			/* move  to  square */
  PIECE_NAME name;		        /* piece */
  WORD who_mask;                        /* piece */
  BYTE flags;                           /* move flag */
  int freq;                             /* Frequancy */
}		KILL_INFO;
*/
static struct {
  int freq;
  MOVE key;
  KILL_INFO kill[NANSWER+1];
} f_killer[NCOLOR][NKEY],*f_kill;

/*
static struct {
  int freq;
  MOVE key;
  KILL_INFO kill[NANSWER+1];
} n_killer[NCOLOR][NKEY],*n_kill;
*/

static KILL_INFO killers[KILLERTABLESIZE][NBEST+1];    /* killer information */

/*
static KILL_INFO forced_killers[KILLERTABLESIZE][NBEST+1];    /* killer information */
*/

GEN_FUNCTION gen_best_answer;
int NEAR put_best_answer(void);
int NEAR moveislegal(MOVE *move);
int NEAR legalcastle(BYTE flags);

static int near local_heuristic( KILL_INFO *killp );
static int near local_killer(void);
static int near local_killer1(MOVE *first, MOVE *last);


int killfreqcmp(const void *killp1,const void *killp2);
/*static void near make_kill_info(KILL_INFO *killp,MOVE *movep);*/
static BOOLEAN near kill_equal(KILL_INFO *killp1,KILL_INFO *killp2);
/*static BOOLEAN near legal_kill(KILL_INFO *killp);*/
static void near insertkill(KILL_INFO *killp);
static void near replacekill(int num);
static void near put_killer(MOVE *movep,int level,int place);  /* Put move into killers table */
#define NKILL 3
static KILL_INFO *table;

typedef struct{
  signed char from;
  signed char to;
  BYTE flags;  
}  SHORTMOVE;        

typedef struct{
  SHORTMOVE answ;
  BYTE freq;
} ANSWER;

typedef ANSWER ANSWER_INFO[2];

ANSWER_INFO far move_answ_table[NSQUARE][NSQUARE]={0};

static int deb_val;
GEN_FUNCTION gen_best_answer
{ 
MOVE move;
ANSWER far *infop;
ANSWER far *currp;

  infop=(ANSWER far *)&move_answ_table[PREVIOUS->from][PREVIOUS->to];

  if(max(infop->freq,(infop+1)->freq) > 2){
    currp=(infop->freq>(infop+1)->freq)? infop : infop+1;
    move.from=currp->answ.from;
    move.to=currp->answ.to;
    move.flags=currp->answ.flags;
    if(move_exist(&move) && moveislegal(&move)){
      STORE_MOVES(SQUAREP(move.to),SQUAREP(move.from)->who_mask.word[MOVE_COLOR]);
      move.flags|=M_KILLER;
      WRITE_MOVE(movep,move.from,move.to,move.flags,KILLER_PROFIT);
    }
  }
}

int NEAR put_best_answer(void)
{ 
ANSWER far *infop;
ANSWER far *currp;
int i,found;

  infop=(ANSWER far *)&move_answ_table[PREVIOUS->from][PREVIOUS->to];

  found=0;
  for(i=0;i<2;i++){
    if(!found && BEST.from==(infop+i)->answ.from &&
       BEST.to==(infop+i)->answ.to ){
      if((infop+i)->freq<MAXFREQ) (infop+i)->freq+=2;
      found=1;
    } else if((infop+i)->freq>MINFREQ) (infop+i)->freq--;
  }
  if(!found){
    currp=(infop->freq<(infop+1)->freq)? infop : infop+1;
    currp->answ.from=BEST.from;
    currp->answ.to=BEST.to;
    currp->answ.flags=BEST.flags;
    currp->freq=2;
  } 
  return 0;
}

GEN_FUNCTION gen_normal_killer		/* Generate normal killer move */
{
  if(level<deb_val) gen_best_answer();
  if(level>=KILLERTABLESIZE) return;
  table=killers[level];   
  Nmove=NBEST;
  local_killer();
}

void forced_killer(MOVE *first, MOVE *last)	/* Set new profit to best moves */
{
int i;
/*			  /* Gen forced move from common forced table */
    if(level>=KILLERTABLESIZE) return;
    table=forced_killers[level];
    Nmove=NBEST;
    local_killer();
*/			  /* Gen forced move from best answer table */
    f_kill=f_killer[MOVE_COLOR];
    for(i=0;i<NKEY;i++) {
      if(movecmp(PREVIOUS,&f_kill[i].key)) {
	table=f_kill[i].kill;
	break;
      }
    }
    if(i==NKEY) {
      return;
    }
    Nmove=NANSWER;
    local_killer1(first,last);
}

static int near local_killer(void)
{
  KILL_INFO *killp;
  int i;
  int ngenerated;
  SQUARE_INFO *top;		/* Pointer to current square information */
  WORD pm;			/* Current our piece mask */
  BYTE flags=0;

  for(i=0,ngenerated=0,killp=table;i<Nmove; i++,killp++){
    pm=killp->who_mask;
    if(!pm) break;           	     /* No more best moves. */
    top=SQUAREP(killp->to);
    if(pm&top->moves) continue;      /* Take into account writtern moves */
    if(!legal_kill(killp)) continue;           /* No such move in position. */
    STORE_MOVES(top,pm);                 /* Store written moves */
    flags=killp->flags;
    flags &= (M_CASTLE_LEFT | M_CASTLE_RIGHT );
    if(top->wood.name)  flags=M_CAPTURE; /* M.D. */
    else if (killp->to==EN_PASS && killp->name==PAWN)
		flags=M_CAPTURE|M_EN_PASSANT;	/* M.D. */
    flags|=M_KILLER;
    WRITE_MOVE(movep,killp->from,killp->to,flags,KILLER_PROFIT-ngenerated);
    ngenerated++;
    if(ngenerated==NKILL) break;
  } /*for NKILL killer moves*/
  return 0;
}

static int near local_killer1(MOVE *first, MOVE *last)
{
  KILL_INFO *killp;
  int i;
  int ngenerated;
  MOVE *mp;

  for(i=0,ngenerated=0,killp=table;i<Nmove; i++,killp++){
	for(mp=first;mp<last;mp++){
	  if( killp->to==mp->to && killp->from==mp->from &&
	      mp->profit < KILLER_PROFIT /* Profit can't be decreased */){
		mp->profit=KILLER_PROFIT-ngenerated;
		mp->flags|=M_KILLER;
		ngenerated++;
		break;
	  }
	}
    if(ngenerated==NKILL) break;
  }
  return 0;
}

void NEAR killer_heuristic(GEN_STATUS status)  /* Fill reference table */
{
 int i;
 BOOLEAN found;
/* int foundnum; */
 MOVE move;                 /* Better move, meeted in search. */
 KILL_INFO kill;            /* Bufer for killer move. */
 KILL_INFO *killp;          /* Killer move pointer. */
 KILL_INFO *currkillp;

  if( BEST.profit > KILLER_PROFIT ) return;

  if(level<deb_val) put_best_answer();
  movecpy(&move,&BEST);
  killp=&kill;

  if(!status&&!CHECK) {                   /* Is status NORMAL ? */
    if(level>=KILLERTABLESIZE) return;
    table=killers[level];  
    Nmove=NBEST;
    make_kill_info(killp,&move);
    local_heuristic(killp);
/*
			/* Put move into normal best answer table */
    found=0;
    n_kill=n_killer[MOVE_COLOR];
    for(i=0;i<NKEY;i++) {
      if(!found && movecmp(PREVIOUS,&n_kill[i].key)) {
	if(n_kill[i].freq<MAXFREQ) n_kill[i].freq+=BONUS;
	table=n_kill[i].kill;
	found=1;
      }
      else {
	if(n_kill[i].freq>MINFREQ) n_kill[i].freq-=PENALTY;
      }
    }
    if(!found) {
      int mfreq,im;
      for(i=im=0,mfreq=MAXFREQ;i<NKEY;i++) {
	if(n_kill[i].key.from==DUMMY) {
	  im=i;
	  break;
	}
	if(n_kill[i].freq<mfreq) {
	  mfreq=n_kill[i].freq;
	  im=i;
	}
      }
      table=n_kill[im].kill;
      n_kill[im].freq=BONUS;
      movecpy(&n_kill[im].key,PREVIOUS);
      for(i=0,currkillp=table;i<NANSWER;i++,currkillp++) {
	 currkillp->freq=0;
	 currkillp->who_mask=0;
	 currkillp->name=NOPIECE;
	 currkillp->who_mask=0;
	 currkillp->from=DUMMY;
	 currkillp->to=DUMMY;
      }
    }
    Nmove=NANSWER;
    make_kill_info(killp,&move);
    local_heuristic(killp);
			/* End put move into normal best answer table */
*/
  } /* End status - Normal */
  else {  /* Status - FORCED */  
			/* Put move into best answer table */
    found=0;
    f_kill=f_killer[MOVE_COLOR];
    for(i=0;i<NKEY;i++) {
      if(!found && movecmp(PREVIOUS,&f_kill[i].key)) {
	if(f_kill[i].freq<MAXFREQ) f_kill[i].freq+=BONUS;
	table=f_kill[i].kill;
	found=1;
      }
      else {
	if(f_kill[i].freq>MINFREQ) f_kill[i].freq-=PENALTY;
      }
    }
    if(!found) {
      int mfreq,im;
      for(i=im=0,mfreq=MAXFREQ;i<NKEY;i++) {
	if(f_kill[i].key.from==DUMMY) {
	  im=i;
	  break;
	}
	if(f_kill[i].freq<mfreq) {
	  mfreq=f_kill[i].freq;
	  im=i;
	}
      }
      table=f_kill[im].kill;
      f_kill[im].freq=BONUS;
      movecpy(&f_kill[im].key,PREVIOUS);
      for(i=0,currkillp=table;i<NANSWER;i++,currkillp++) {
	 currkillp->freq=0;
	 currkillp->who_mask=0;
	 currkillp->name=NOPIECE;
	 currkillp->who_mask=0;
	 currkillp->from=DUMMY;
	 currkillp->to=DUMMY;
      }
    }
    Nmove=NANSWER;
    make_kill_info(killp,&move);
    local_heuristic(killp);
			/* End put move into best answer table */
/*
			/* Put move into forced move table */
    if(level>=KILLERTABLESIZE) return;
    table=forced_killers[level];
    Nmove=NBEST;
    make_kill_info(killp,&move);
    local_heuristic(killp);
			/* End put move into forced move table */
*/
  } /* end status - FORCED */    
}

static int near local_heuristic( KILL_INFO *killp )
{
 int i;
 BOOLEAN found;
 int foundnum;
 KILL_INFO *currkillp;

  found=0;
  for(i=0,currkillp=table;i<Nmove;i++,currkillp++){
    if(!currkillp->who_mask) break;
    if(!found && kill_equal(killp,currkillp)){
      if(currkillp->freq<MAXFREQ) currkillp->freq+=BONUS;
      found=1;foundnum=i;
    } else if(currkillp->freq>MINFREQ) currkillp->freq=(currkillp->freq*8)/10;
  }
  if(found) replacekill(foundnum);
  else insertkill(killp);
  return 0;
}

#define NKILLMOVES 5
void NEAR set_killer0(void)
{
int j,l;
  for(j=0,movep=FIRST;j<NKILLMOVES;j++,movep++)
	for(l=0;l<KILLERTABLESIZE;l+=2) put_killer(movep,l,j);
}

void NEAR set_killer1(void)
{
int j,l;

  for(j=0,movep=FIRST;j<NKILLMOVES;j++,movep++)
	for(l=1;l<KILLERTABLESIZE;l+=2) put_killer(movep,l,j);
}

static void near put_killer(MOVE *movep,int level,int place)  /* Put move into killers table */
{
 KILL_INFO kill;            /* Bufer for killer move. */

  if(level>=KILLERTABLESIZE) return;
  if(place>=NBEST) return;
/*  if(movep->profit>NKILL) return;         /* Profitable captures and */
  if(movep->flags&M_PROMOTION) return;	    /* promotions are generated earlier */
*/										/* than bettermoves. */

  make_kill_info(&kill,movep);
  MEMCPY(killers[level]+place,&kill,sizeof(KILL_INFO));
}                

static void near insertkill(KILL_INFO *killp)
{
int i;
KILL_INFO *currkillp;
KILL_INFO buf[NBEST];         /* Must be NBEST > Nmove */
  for(i=0,currkillp=table;killp->freq<currkillp->freq && i<Nmove;
							   i++,currkillp++);
  if(i<Nmove){
	MEMCPY(buf,currkillp,sizeof(KILL_INFO)*(Nmove-i));
	MEMCPY(currkillp+1,buf,sizeof(KILL_INFO)*(Nmove-i));
	MEMCPY(currkillp,killp,sizeof(KILL_INFO));
  }
}

static void near replacekill(int num)
{
int i;
KILL_INFO *currkillp;
KILL_INFO buf[NBEST],killbuf;  /* Must be NBEST > Nmove */
  if(num==0) return;
  MEMCPY(&killbuf,table+num,sizeof(KILL_INFO));
  for(i=0,currkillp=table;killbuf.freq<currkillp->freq && i<Nmove;
							     i++,currkillp++);
  MEMCPY(buf,currkillp,sizeof(KILL_INFO)*(num-i));
  MEMCPY(currkillp+1,buf,sizeof(KILL_INFO)*(num-i));
  MEMCPY(currkillp,&killbuf,sizeof(KILL_INFO));
}

int killfreqcmp(const void *killp1,const void *killp2)
{
  return(((KILL_INFO *)killp2)->freq-((KILL_INFO *)killp1)->freq);
}

void NEAR make_kill_info(KILL_INFO far *killp,MOVE *movep)
{
  killp->from=movep->from;
  killp->to=movep->to;
  killp->name=WHOONSQUARE(movep->from)->name;
  killp->who_mask=SQUAREP(movep->from)->who_mask.word[Our_color];
  killp->flags=movep->flags;
  killp->freq=BONUS;
}

static BOOLEAN near kill_equal(KILL_INFO *killp1,KILL_INFO *killp2)
{
  if(killp1->from!=killp2->from) return(0);
  if(killp1->to!=killp2->to) return(0);
  if(killp1->who_mask!=killp2->who_mask) return(0);
  return(1);
}

void NEAR init_killer(void)		/* Initialise table for killer */
{                                       /* must be called by "beginsearch" */
  int j;
  PIECE_COLOR color;
  setmem(f_killer,sizeof(f_killer),'\0');
  setmem(killers,sizeof(killers),'\0');
  for(j=0;j<NKEY;j++)
    for(color=0; color<NCOLOR; color++)
      f_killer[color][j].freq=-1;
}

void NEAR clear_killer(int level)
{
int j;
KILL_INFO *currkillp;
  if(level>=KILLERTABLESIZE) return;
  currkillp=killers[level];
  for(j=0;j<NKEY;j++,currkillp++) currkillp->freq=0;

}

void NEAR clear_all_killer(void)
{
int i,j;
KILL_INFO *currkillp;
PIECE_COLOR color;
  for(j=0;j<KILLERTABLESIZE;j++){
    currkillp=killers[j];
    for(i=0;i<NBEST;i++,currkillp++) currkillp->freq=0;
  }
  for(j=0;j<NKEY;j++)
    for(color=0; color<NCOLOR; color++)
      f_killer[color][j].freq=-1;
}

void NEAR start_killer(void)
{ /*
  MEMCPY(killers,killers[2],sizeof(KILL_INFO)*NBEST*(KILLERTABLESIZE-2));
*/ }

BOOLEAN NEAR legal_kill(KILL_INFO far *killp)
{
int step,absstep;
/*  if(killp->name!=WHOONSQUARE(killp->from)->name) return(0); /* No such piece at square 'from'. */
  if(Our_color!=WHOONSQUARE(killp->from)->color) return(0); /* No such piece at square 'from'. */
*/
  if(killp->who_mask!=SQUAREP(killp->from)->who_mask.word[Our_color]) return(0);
  if(SQUAREP(killp->to)->who_mask.word[Our_color]) return(0); /* Our piece is at square 'to'. */
  if(killp->name!=PAWN)	{	/* W.K. */
     if(killp->flags&(M_CASTLE_LEFT|M_CASTLE_RIGHT))
       return(legalcastle(killp->flags));
     if(SQUAREP(killp->to)->attackedby.word[Our_color] &  killp->who_mask)
       return(1);
     else return(0);
  }
  else {       /* killp->name==PAWN */
    step=killp->to-killp->from;
    absstep=abs(step);
    if(absstep==8) {              /* Pawn's vertical move. */
      if(!WHOONSQUARE(killp->to)->name) return(1);
      else return(0);
    } else if(absstep==16)  {       /* Pawn's jump. */
      if(!WHOONSQUARE(killp->to)->name &&
	 !WHOONSQUARE(killp->from+HALF(step))->name) return(1);
      else return(0);
    } else {                        /* Pawn's attack. */
      if(SQUAREP(killp->to)->who_mask.word[Enemy_color]) return(1);
      else if (EN_PASS==killp->to) return(1);	/* M.D. */
      else return(0);
    }
  } /* case of pawn */
}

GEN_FUNCTION selective_killer			/* Generate killer move */
{
/*  KILL_INFO *killp;
  int i;
  int ngenerated;
  SQUARE_INFO *top;		/* Pointer to current square information */
  WORD pm;			/* Current our piece mask */
  BYTE flags;

  table=killers[level-2];   
  Nmove=NBEST;
  for(i=0,ngenerated=0,killp=table;i<Nmove; i++,killp++){
    pm=killp->who_mask;
    if(!pm) break;           	     /* No more best moves. */
    top=SQUAREP(killp->to);
    if(pm&top->moves) continue;      /* Take into account writtern moves */
    if(!(G_STATUS & FORCED)) { /* Is status not NORMAL or SELECTIVE ? */
      if(top->wood.cost<mat_deficit) continue;
      if(!CHECK) if(top->wood.cost<=0&&(!(killp->flags&CHECK))) continue;
    }
    if(!legal_kill(killp)) continue;           /* No such move in position. */
    top->moves|=pm;                 /* Store writtern moves */
    flags=killp->flags;
    flags &= (M_CASTLE_LEFT | M_CASTLE_RIGHT );
    if(top->wood.name)  flags=CAPTURE; /* M.D. */
    else if (killp->to==EN_PASS && killp->name==PAWN)
		flags=CAPTURE|EN_PASSANT;	/* M.D. */
    WRITE_MOVE(movep,killp->from,killp->to,flags,NKILL-ngenerated+KILLER_PROFIT);
    ngenerated++;
    if(ngenerated==NKILL) break;
  } /*for NKILL killer moves*/ */
}

int NEAR moveislegal(MOVE *move)
{
int step,absstep;
WORD who_mask;
PIECE_COLOR color;

  color=MOVE_COLOR;
  who_mask=SQUAREP(move->from)->who_mask.word[color];
  if(!who_mask) return(0); /* No our piece */
  if(SQUAREP(move->to)->who_mask.word[color]) return(0); /* Our piece is at square 'to'. */
  if(SQUAREP(move->to)->attackedby.word[color] & who_mask){  /* We attack 'to' */
    move->flags=M_CAPTURE;
    if(SQUAREP(move->from)->wood.name!=PAWN) return 1;  /* Not pawn */
    else{ /* Pawn */
      if(SQUAREP(move->to)->who_mask.word[reverse_color(color)]) return(1);
      else if (EN_PASS==move->to){	/* En passant */
	move->flags|=M_EN_PASSANT;
	return(1);
      }
      else return(0);
    }
  }
  else{  /* We don't attack 'to' */
    if(move->flags&(M_CASTLE_LEFT|M_CASTLE_RIGHT))
      return(legalcastle(move->flags));
    if(SQUAREP(move->from)->wood.name==PAWN)	{	
      step=move->to-move->from;
      absstep=abs(step);
      if(absstep==8) {              /* Pawn's vertical move. */
	if(!WHOONSQUARE(move->to)->name) return(1);
	else return(0);
      } else if(absstep==16)  {       /* Pawn's jump. */
	if(!WHOONSQUARE(move->to)->name &&
	   !WHOONSQUARE(move->from+HALF(step))->name) return(1);
	else return(0);
      } else return(0);
    } /* case of pawn */
  }
  return 0;
}

int NEAR legalcastle(BYTE flags) /* Check legality of castles */
{
  SQUARE_NUM line;		/* Begin of first/last line coordinate */
  SQUARE_INFO *linep;		/* Pointer to square information */

    if(CHECK) return(0);		/* No castles on check state */
    line=(MOVE_COLOR)? a8: a1;	/* Take begin of line */
    linep=SQUAREP(line);		/* Take pointer to square informtion */
    if(flags&M_CASTLE_RIGHT) {
      if(CASTLE[Our_color] & CASTLERIGHT) {  /* Consider right castle */
	if(!(linep[f1].attackedby.word[Enemy_color]|/* Check attaked squares */
	     linep[g1].attackedby.word[Enemy_color]))
	  if(!(linep[f1].wood.cost|	/* Check occupated squares */
	       linep[g1].wood.cost))
	    return(1);
      }
    }
    else {/*flags&M_CASTLE_RIGHT */
      if(CASTLE[Our_color] & CASTLELEFT ) {	/* Consider left castle */
	if(!(linep[c1].attackedby.word[Enemy_color]|/* Check attaked squares */
	     linep[d1].attackedby.word[Enemy_color]))
	  if(!(linep[b1].wood.cost|	/* Check occupated squares */
	       linep[c1].wood.cost|
	       linep[d1].wood.cost))
	    return(1);
      }
    }
    return(0);
}
