#ifndef  _INTERFAC_H
#define  _INTERFAC_H

#ifndef  _HELPIND_H
#include "helpind.h"
#endif

#ifndef  _FACE_H
#include "face.h"
#endif


typedef enum {
  CURRENT_ST,
  MENU_ST,
  BOARD_ST,
  BOARDSET_ST,
  ENDSET_ST,
  BOARDBREAK_ST,
  PROT_ST,
  REPLY_ST,
  BREAK_ST,
  LOCALMENU_ST,
  ANNOTATE_ST,
  FIND_ST
} INFC_STATUS;

typedef enum {
  USER_STATUS=0,
  MENU_STATUS=1,
  STONE_STATUS=2,
  NOMAINMENUKEY_STATUS=4
} INFC_STATUS_TYPE;

typedef struct {
  int key;
  int (*fun)(void);
} far HOTKEY_INFO;

typedef struct {
  int key;
  int (*fun)(void);
} far HOTSTATE_INFO;

typedef struct {
  INFC_STATUS_TYPE type;
  int (*set)(void);
  int (*reset)(void);
  int (*reenter)(void);
  HOTKEY_INFO *hotkey_info;
  HOTSTATE_INFO *hotstate_info;
  HELPIND helpind;
  WINP *wpp;
  char far * helpline;
} far INFC_INFO;

typedef struct {
  INFC_STATUS name;
  int open;
} far INFC_STK;

typedef enum {
  DELETE_ST = 1,
  CLOSE_ST  = 2,
  GOTOSTONE_ST = 4,
} RET_STATUS;

extern INFC_INFO infc_info[];
extern int global_keys[];

int far hotkey( WINP wp, int key, int why );

int ret_status(int ret);
int delete_status(void);
int findmouse(int key,int x,int y);
int mouseboard(int key, int x, int y);

int proceed_user_action(INFC_STATUS beg_infc_status);
int proceedmenukey( int key );

extern int current_infc_key;
extern INFC_STK *cur_infc_ptr;

int iskeyglobal(int key);
int (* hotkeytable(INFC_STATUS infc_status, int key) )(void);
int (* hotstatetable(INFC_STATUS infc_status, int key) )(void);

int goto_menu(char far *path);
int exec_menu(char far *path);
int goto_stone(void);
INFC_STATUS stone_name(void);
INFC_STATUS_TYPE stone_type(void);
INFC_STK *find_stone(void);

#endif