#include <stdio.h> /* NULL */
#include <conio.h> /* getch() */
#include <mem.h>   /* memcpy() */

#include "myface.h"
#include "faceproc.h"
#include "facekeys.h"
#include "facemous.h"
#include "myfacpro.h"
#include "facelib.h"

#include "helpind.h"
#include "menu.h"
#include "menu_fun.h"
#include "interfac.h"
#include "infc_fun.h"
#include "ksiwind.h"
#include "ks_game.h"
#include "ksibdraw.h"

/* Internal FACE functions */
int leftedit ( WINP wp );
int rightedit( WINP wp );

extern WINP menuground;
int getmousestatus(WINP wp, int x, int y);
int mouseinwind(WINP wp, int key, int x, int y);
int leftmove(WINP wp, int x, int y);

int current_infc_key=0;

static int close_status(void);
static int open_status(void);
static int replace_status(INFC_STATUS infc_status);
static int create_status(INFC_STATUS infc_status);

INFC_STK infc_stk[30];
INFC_STK *cur_infc_ptr;
extern NODE mainmenu;

static int close_status(void)
{
    if(cur_infc_ptr==NULL) return(-1);
    if(cur_infc_ptr->open==0) return 0;
    cur_infc_ptr->open=0;
    return (*(infc_info[cur_infc_ptr->name].reset))();
}
static int open_status(void)
{
    if(cur_infc_ptr==NULL) return(-1);
    if(cur_infc_ptr->open==1) {
      replacehelpline(infc_info[cur_infc_ptr->name].helpline);
      return (*(infc_info[cur_infc_ptr->name].reenter))();
    }
    else {
      cur_infc_ptr->open=1;
      replacehelpline(infc_info[cur_infc_ptr->name].helpline);
      return (*(infc_info[cur_infc_ptr->name].set))();
    }
}
static int replace_status(INFC_STATUS infc_status)
{
  int ret;
    if(infc_status==CURRENT_ST) return 0;
    if(cur_infc_ptr->name==infc_status) return open_status();
    if(cur_infc_ptr==NULL) return create_status(infc_status);
    ret=close_status();
    if(ret>=0) {
      if(cur_infc_ptr==infc_stk) cur_infc_ptr=NULL;
      else {
	cur_infc_ptr--;
      }
      return create_status(infc_status);
    }
    else return(ret);
}
int delete_status(void)
{
  int ret;
  int stone;
    if(cur_infc_ptr==NULL) return(-1);
    stone=(infc_info[cur_infc_ptr->name].type&STONE_STATUS);
    ret=close_status();
    if(ret>=0) {
      if(cur_infc_ptr==infc_stk) cur_infc_ptr=NULL;
      else                       cur_infc_ptr--;
    }
    if(stone) return -1;
    return ret;
}
static int down_status(void)
{
  int ret;
    ret=delete_status();
    if(ret>=0)
      ret=open_status();
    return ret;
}
static int create_status(INFC_STATUS infc_status)
{
  INFC_STK *infc_stk_ptr;
  static INFC_STK swap;
  int find=0;
    if(infc_status==CURRENT_ST) return 0;
    if(cur_infc_ptr==NULL) cur_infc_ptr=infc_stk;
    else {
      for(infc_stk_ptr=cur_infc_ptr; infc_stk_ptr!=infc_stk; infc_stk_ptr--) {
	if(infc_status==infc_stk_ptr->name) {
	  find=1;
	  break;
	}
      }
      if(find) {
	if(infc_info[infc_stk_ptr->name].type|STONE_STATUS) {
	  goto_stone();
	  if(cur_infc_ptr->name==infc_status) return 0;
	}
	else {
	  FARMEMCPY(&swap,infc_stk_ptr,sizeof(INFC_STK));
	  for(; infc_stk_ptr<cur_infc_ptr; infc_stk_ptr++) {
	    FARMEMCPY(infc_stk_ptr,infc_stk_ptr+1,sizeof(INFC_STK));
	  }
	  FARMEMCPY(cur_infc_ptr,&swap,sizeof(INFC_STK));
	  if(cur_infc_ptr->open) {
	    return (*(infc_info[infc_status].reenter))();
	  }
	}
      }
      else {
	cur_infc_ptr++;
      }
    }
    cur_infc_ptr->name=infc_status;
    cur_infc_ptr->open=1;
    if(!(infc_info[cur_infc_ptr->name].type &MENU_STATUS))
      replacehelpline(infc_info[cur_infc_ptr->name].helpline);
    return (*(infc_info[infc_status].set))();
}
int goto_stone(void)
{
  int ret;
    if(cur_infc_ptr==NULL) return(-1);
    ret=0;
    while(!(infc_info[cur_infc_ptr->name].type&STONE_STATUS)) {
      ret=delete_status();
      if(ret<0) return ret;
    }
    if(ret>=0) ret=open_status();
    return ret;
}

INFC_STK *find_stone(void)
{
  INFC_STK  *infc;
    for (infc=cur_infc_ptr; infc!=infc_stk; infc--)
      if(infc_info[infc->name].type & STONE_STATUS) break;
    return(infc);
}

INFC_STATUS_TYPE stone_type(void)
{
  INFC_STK  *infc;
    infc=find_stone();
    return(infc_info[infc->name].type);
}

INFC_STATUS stone_name(void)
{
  INFC_STK  *infc;
    infc=find_stone();
    return(infc->name);
}

int (* hotkeytable(INFC_STATUS infc_status, int key) )(void)
{
  HOTKEY_INFO *hip;
    hip=infc_info[infc_status].hotkey_info;
    if(!hip) return NULL;
    for(; hip->key; hip++) {
      if(hip->key==key) return(hip->fun);
    }
    return NULL;
}
int (* hotstatetable(INFC_STATUS infc_status, int key) )(void)
{
  HOTSTATE_INFO *hip;
    hip=infc_info[infc_status].hotstate_info;
    if(!hip) return NULL;
    for(; hip->key; hip++) {
      if(hip->key==key) return(hip->fun);
    }
    return NULL;
}
int iskeyglobal(int key)
{
  int *keyp;
    for(keyp=global_keys; *keyp; keyp++) {
      if(*keyp==key) return 1;
    }
    return 0;
}

static int special_arrow_enable(void)
{
    if(menulevel>0) {
      if( (CURMENUROLL==VROLL) && ((*(menusp-1))->flag&HROLL) ) {
	return 1;
      }
    }
    return 0;
}
static int arrow_key;

static int special_arrow_key(int key)
{
    if( ((key==LEFTARROW)||(key==RIGHTARROW)) ) {
      if(arrow_key) return 1;
      if(special_arrow_enable()) return 1;
    }
    return 0;
}

static int default_infc_keys(int key)
{
  int helpind;
    switch(key) {
      case F1:
	helpind=infc_info[cur_infc_ptr->name].helpind;
	if(infc_info[cur_infc_ptr->name].type & MENU_ST )
/*	helpind=(*menusp)->helpind;*/
	helpind=((*menusp)->firstitem+(*menusp)->curitem)->helpind;
	gethelp(helpind);
	break;
      case ALT_X: wndexit(); break;
      case ALT_F1 : gethelp(0);
    } 
    return key;
}

int far hotkey( WINP wp, int key, int why )
{
  int item;
  int (*usfun)(void);
  int x,y;
  int x1,y1;
  WINP mywp;

    switch (why){
      case REDRAW:
	if( wp==board ) {
	  w_drawboard();
	  return 0;
	}
	break;
      case BEFORE:
	if( ismousekey(key )) {
	  getmouseloc( &x, &y );
	  x1=x; y1=y;
	  mywp=whatwindow( &y1, &x1 );
	  if( wp==mywp ) {       /* mouse in current window */
	    if( mywp==board ) /* mouse on board */
	      key=mouseboard( key, x, y );
	  }
	  else if( wp==mainmenu.wp && key==LEFTBUTTMOVE ){
	    if(mywp==menuground) key=NULLKEY;
	    else key=RETURN;
	  }
	  else if( mywp==mainmenu.wp && key==LEFTBUTTMOVE ){
	    key=LEFTPRESS;
	  }
	  else {
	    if( wp==board && key==LEFTRELEAS ) {
	      escboard();
	      redraw(board);
	    }
	    key=findmouse(key,x,y);
	  }
	  if( key==0 || key==NULLKEY || key==ESCAPE ) return(key);
	}
	if( (usfun=hotkeytable(cur_infc_ptr->name,key))!=NULL ) {
	  usfun();
	  return NULLKEY;
	}
	default_infc_keys(key);
/*	if(hotstatetable(cur_infc_ptr->name,key))
	  return key;   /* to catch in AFTER ! */*/
	if(wp==board) {
	  key=boardkey(key);
	}
	else if(infc_info[cur_infc_ptr->name].type&MENU_STATUS) {
	  if((item=keytoitem(*menusp,key))!=ERROR) {
	    gotoitem(*menusp,item);
	    return(RETURN);
	  }
	  if(special_arrow_key(key)) return 0;
	}
	return key;
      case AFTER:
	if(infc_info[cur_infc_ptr->name].type&MENU_STATUS) {
	  item=getcurm(CURMENUWP)-1;
	  replacehelpline((CURITEMP)->helpline);
	  CURMENUCURITEM=item;
	}
	if( iskeyglobal(key) ) return key;
	if( mainmenukey(key)!=ERROR ) return key;
	if( hotstatetable(cur_infc_ptr->name,key) ) return key;
	return 0;
      case UNKNOWN:
	return(0);
    } /* end of WHY switch */
    return( key );
}


int proceed_user_action(INFC_STATUS beg_infc_status)
{
  int key;
  int (*usfun)(void);
  int item;
  int ret;
  INFC_STATUS infc_status;
  INFC_STATUS_TYPE type;
  int x,y;
  WINP wp;
    ret=create_status(beg_infc_status);
    while(ret>=0) {
      if(cur_infc_ptr->open==0) {
	cur_infc_ptr->open=1;
	replacehelpline(infc_info[cur_infc_ptr->name].helpline);
	ret=(*(infc_info[cur_infc_ptr->name].set))();
      }
      infc_status=cur_infc_ptr->name;
      type=infc_info[cur_infc_ptr->name].type;

      if(type&MENU_STATUS) wp=CURMENUWP;
      else wp=*(infc_info[infc_status].wpp);
      enablecursor();
      current_infc_key=key=waitkey(wp);

      if(ismousekey(key)) {
	getmouseloc(&x,&y);
	wp=whatwindow(&y,&x);
	ret=getmousestatus(wp,x,y);
	if(ret>=0) ret=ret_status(ret);
      }
      else { 			/* keyboard key */
	type=infc_info[cur_infc_ptr->name].type;
	if((usfun=hotstatetable(cur_infc_ptr->name,key))!=NULL) {
	  ret=usfun();
	  if(ret>=0) ret=ret_status(ret);
	}
	else if(cur_infc_ptr->name==BOARDBREAK_ST) ret=endofsearch();
	else if(iskeyglobal(key)&&(!(type&STONE_STATUS))) {
	  goto_stone();
	  ret=open_status();
	  if(ret<0) continue;
	  if((usfun=hotkeytable(cur_infc_ptr->name,key))!=NULL) {
	    usfun();
	    ret=0;
	  }
	  else if((usfun=hotstatetable(cur_infc_ptr->name,key))!=NULL) {
	    ret=usfun();
	    if(ret>=0) ret=ret_status(ret);
	  }
	  else return (key);
	}
	else if( !(type&NOMAINMENUKEY_STATUS) &&
	  ((item=mainmenukey(key))!=ERROR) ) {
	  char buff[2];
	    buff[0]=item+1; buff[1]=0;
	    ret=exec_menu(buff);
	}
	else if(type&MENU_STATUS) {
	  ret=proceedmenukey(key);
	}
      }
    }
    delete_status();
    return ret;
}

int proceedmenukey( int key )
{
  NODEPTR menup;
  ITEMPTR itemp;
  int item;
  int (*fp)(void);
  int (*special_func)(void);
  int type;
  int ret=0;
  char buff[80];
  int top,left;

    menup=*menusp;
    switch( key ){
      case LEFTARROW: case RIGHTARROW:
	if(!special_arrow_key(key)) break;
	if(!arrow_key) menuup();
	if( key==LEFTARROW ) leftedit( CURMENUWP );
	else                 rightedit( CURMENUWP );
	item=getcurm( CURMENUWP )-1;
	CURMENUCURITEM=item;
	itemp=CURITEMP;
	switch( ITEMTYPE&~SPEC_FLAGS ){
	  case SUBMENU:
	  case LIST:
	    arrow_key=0;
	    *(menusp+1)=(NODEPTR)OBJECT;
	    menudown();
	    break;
	  case FUNCTION:
	    arrow_key=key;
	}
	break;
      case ESCAPE:
	arrow_key=0;
	if(special_arrow_enable()) menuup();
	if(!menuup()) {
	  if(!(infc_info[cur_infc_ptr->name].type&STONE_STATUS))
	    return(down_status());
	  else return(-1);
	}
	break;
      case RETURN:
	arrow_key=0;
	item=getcurm( CURMENUWP )-1;
	CURMENUCURITEM=item;
	itemp=CURITEMP;
	type=ITEMTYPE;
	special_func=SPEC_FUNC;
	switch( type&~SPEC_FLAGS ){
	  case SUBMENU:
	  case LIST:
	    menup=(NODEPTR)OBJECT;
	    if((type&~SPEC_FLAGS)==LIST) MENUCURITEM=*((int *)INFO);
	    *(menusp+1)=menup;
	    menudown();
	    break;
	  case FUNCTION:
	    fp=OBJECT;
	    if(type&CLOSE_MENU) down_status();
	    ret=(*fp)();
	    if(ret>=0) {
	      ret=ret_status(ret);
	      if(infc_info[cur_infc_ptr->name].type==MENU_STATUS) showmenu();
	    }
	    break;
	  default: /* Variables */
	    menuposition(*menusp,&top,&left);
	    switch( type&~SPEC_FLAGS ){
	      case ON_OFF:
	      case YES_NO:
		if((*((int*)OBJECT))&((int)INFO))
		  *((int*)OBJECT)&=~((int)INFO);
		else
		  *((int*)OBJECT)|=((int)INFO);
		break;
	      case INT_NO:
		if(*((int*)OBJECT)) {
		  *((int*)OBJECT)=0;
		  break;
		}
	      case INT: getnumber(top,left,(int *)OBJECT,INFO);
		break;
	      case LONG_NO:
		if(*((long*)OBJECT)) {
		  *((long*)OBJECT)=0L;
		  break;
		}
	      case LONG: getlong(top,left,(long *)OBJECT,INFO);
		break;
	      case TIME: {
		int tmp;
		tmp=(int)(*((long*)OBJECT)*55L+30000L)/60000L;
		getnumber(top,left,&tmp,INFO);
		*((long*)OBJECT)=(tmp*60L*182L+5L)/10L;
		break;
	      }
	      case STR: getstring(top,left,OBJECT,INFO);
		break;
	      case OPTION:
		itemp=(*(menusp-1))->firstitem+((*(menusp-1))->curitem);
		*((int *)INFO)=item;
		menuup();
		break;
		  case SPECSTR:
		break;
	    }
	    fillmenuitem(buff,itemp);
	    setcurmenu(CURMENUWP,buff);
/*	    refresh(CURMENUWP);*/
	    showmenu();
	    if(type&CLOSE_MENU) down_status();
	}          /* end flag switch */
	if(special_func) {
	  ret=special_func();
	  if(ret>=0) ret=ret_status(ret);
	  if(ret==-1) return(ret);
	  if(infc_info[cur_infc_ptr->name].type&MENU_STATUS) {
	    fillmenuitem(buff,CURMENUFIRSTITEM+CURMENUCURITEM);
	    setcurmenu(CURMENUWP,buff);
/*	    refresh(CURMENUWP); */
/*	    showmenu();*/
	  }
	}
      default:;  /* nothing done, ask again */
    }              /* end key switch */
    return(ret);
}

int goto_menu(char far *path)
{
  char far *p;
  NODEPTR far *mp;
  NODEPTR menup;
  int item;
    if(!(infc_info[cur_infc_ptr->name].type&MENU_STATUS)) {
      goto_stone();
      ret_status(goto_mainmenu());
    }
    for(mp=menustack,p=path; mp<menusp && *p && *(p+1); mp++,p++) {
      menup=*mp;
      item=*p-1;
      if(MENUCURITEM!=item) break;
    }
    while(mp<menusp) menuup();

    while(*p) {
      menup=*menusp;
      item=*p-1;
      gotoitem( menup, item );
      if(*(p+1)) {
	*(menusp+1)=(NODEPTR)(CURITEMP->object);
	menudown();
      }
      p++;
    }
    return 0;
}

int exec_menu(char far *path)
{
    goto_menu(path);
    return proceedmenukey(RETURN);
}

int ret_status(int ret)
{
    if(ret>>8) {
      if(!(infc_info[cur_infc_ptr->name].type&STONE_STATUS) &&
	  ret&GOTOSTONE_ST) {
	if(goto_stone()>=0) ret=create_status(ret>>8);
	else ret=-1;
      }
      else if(ret&CLOSE_ST) {
	if(close_status()>=0) ret=create_status(ret>>8);
	else ret=-1;
      }
      else if(ret&DELETE_ST) {
	ret=replace_status(ret>>8);
      }
      else ret=create_status(ret>>8);
    }
    else if(ret&CLOSE_ST) {
      ret=close_status();
    }
    else if(ret&DELETE_ST) {
      ret=down_status();
    }
    return ret;
}
