
		/**\
		 	Program file "infc_def.c"	
		 					
		       Interface state definitions	
		 					
		\**/
#include <stdio.h> /* NULL */
#include <conio.h> /* getch() */
#include <mem.h>   /* memcpy() */

#include "face.h"
#include "faceproc.h"
#include "facekeys.h"
#include "menu.h"
#include "menu_func.h"
#include "interface.h"
#include "infc_func.h"
#include "ksiwind.h"
#include "ks_eval.h"
#include "ksichess.h"
#include "ksiprot.h"
#include "ksitimer.h" 

int kaissaplaywhite(void);
int kaissaplayblack(void); 
int kaissaplayself(void);
int kaissaverifymoves(void);

char far helpstr[]=	" F1 Help  F10 Menu  F6 Flip  Alt-X Exit  F5 Notes  F7 Pos  TAB Game list";
char far helpreply[]=	" F1 Help  F10 Menu  F6 Flip  F2 Save  F3 Load";
char far helpcomment[]=	" F1 Help  Esc Cancel  Enter comment to the move";
char far helpprot[]=	" F1 Help  TAB Play  Enter Change Position  '+' Forward  '-' Back";
char far helpset[]=	" F1 Help  Esc End  Enter Set/Remove  TAB Name  Shift-TAB color";
char far interruptstr[]=" F4 Interrupt  ";

static HOTKEY_INFO menu_hotkey_info[]={ /*MENU_ST*/
  {0,NULL}
};
/*REPLY_ST*/
static HOTKEY_INFO reply_hotkey_info[]={ /*REPLY_ST*/
  {F2,savereply},
  {F3,loadreply},
  {CTRL_F,first_find},
  {CTRL_L,last_find},
  {0,NULL}
};
static HOTKEY_INFO board_hotkey_info[]={ /*BOARD_ST*/
  {F2,saveprotocol},
  {F3,readprotocol},
  {ALT_F2,saveposition},
  {ALT_F3,loadposition},
  {'+',protkeyplus},
  {'-',protkeyminus},
  {CTRL_B,protkeybegin},
  {CTRL_E,protkeyend},
  {ALT_N,newgame},
  {ALT_R,runtests},
  {0,NULL}
};
static HOTKEY_INFO boardset_hotkey_info[]={ /*BOARDSET_ST*/
  {DEL,delboardset},
  {TAB,tabboardset},
  {SHIFT_TAB,shifttabboardset},
  {SPACE,spaceboardset},
  {RETURN,spaceboardset},
  {0,NULL}
};
static HOTKEY_INFO boardbreak_hotkey_info[]={ /*BOARDBREAK_ST*/
  {F2,saveprotocol},
  {0,NULL}
};
static HOTKEY_INFO prot_hotkey_info[]={ /*PROT_ST*/
  {F2,saveprotocol},
  {F3,readprotocol},
  {'+',protkeyplus},
  {'-',protkeyminus},
  {CTRL_B,protkeybegin},
  {CTRL_E,protkeyend},
  {RETURN,playprotocol},
/* CTRL_F,CTRL_L */
  {0,NULL}
};
static HOTKEY_INFO localmenu_hotkey_info[]={ /*LOCALMENU_ST*/
  {0,NULL}
};
static HOTKEY_INFO breakmenu_hotkey_info[]={ /*BREAKMENU_ST*/
  {0,NULL}
};
static HOTKEY_INFO annotate_hotkey_info[]={ /*ANNOTATE_ST*/
  {F5,nothing},
  {0,NULL}
};
	/* ------------- */

static HOTSTATE_INFO menu_hotstate_info[]={ /*MENU_ST*/
  {F7,goto_boardset},
  {F10,escape_status},
  {0,NULL}
};
static HOTSTATE_INFO reply_hotstate_info[]={ /*REPLY_ST*/
  {F6,goto_board},
  {F7,goto_boardset},
  {F9,onemovesearch},
  {F10,goto_mainmenu},
  {ESCAPE,goto_board},
  {0,NULL}
};
static HOTSTATE_INFO board_hotstate_info[]={ /*BOARD_ST*/
  {ALT_W,kaissaplaywhite},
  {ALT_B,kaissaplayblack},
  {ALT_V,kaissaverifymoves},
  {F6,goto_reply},
  {F7,goto_boardset},
  {F8,evaluate},
  {F9,onemovesearch},
  {SPACE,spaceboard},
  {RETURN,spaceboard},
  {F10,goto_mainmenu},
  {TAB,goto_protocol},
  {F5,goto_annotate},
  {ALT_F10,goto_localmenu},
  {ESCAPE,escboard},
  {0,NULL}
};
static HOTSTATE_INFO boardset_hotstate_info[]={ /*BOARDSET_ST*/
  {ALT_W,nothing},
  {ALT_B,nothing},
  {ALT_V,nothing},
  {F6,nothing},
  {F7,nothing},
  {F8,nothing},
  {F9,nothing},
  {SPACE,spaceboard},
  {RETURN,spaceboard},
  {F10,goto_endsetmenu},
  {TAB,nothing},
  {F5,nothing},
  {ALT_F10,nothing},
  {ESCAPE,goto_endsetmenu},
  {F10,goto_endsetmenu},
  {0,NULL}
};
static HOTSTATE_INFO boardbreak_hotstate_info[]={ /*BOARDBREAK_ST*/
  {'+',endofsearch},
  {'-',endofsearch},
  {SPACE,spaceboardbreak},
  {RETURN,spaceboardbreak},
  {0,NULL}
};
static HOTSTATE_INFO prot_hotstate_info[]={ /*PROT_ST*/
  {ESCAPE,escape_status},
  {TAB,goto_board},
  {RETURN,playprotocol},
  {0,NULL}
};
static HOTSTATE_INFO localmenu_hotstate_info[]={ /*LOCALMENU_ST*/
  {F10,escape_status},
  {0,NULL}
};
static HOTSTATE_INFO breakmenu_hotstate_info[]={ /*BREAKMENU_ST*/
  {0,NULL}
};
static HOTSTATE_INFO annotate_hotstate_info[]={ /*ANNOTATE_ST*/
  {RETURN,entercomment},
  {ESCAPE,escape_status},
  {0,NULL}
};
static HOTSTATE_INFO find_hotstate_info[]={ /*FIND_ST*/
  {ESCAPE,end_work},
  {0,NULL}
};

		/* Interface state information for "interface.c" */

INFC_INFO infc_info[]={
  {USER_STATUS, nothing, nothing, nothing, 0, 0, 0,NULL},
  {MENU_STATUS, beginmainmenu, endmenu,    showmenu,
    menu_hotkey_info, menu_hotstate_info, IND_MAINMENU, NULL,NULL},
  {USER_STATUS|STONE_STATUS, beginboard, gooutboard, resetboard,
    board_hotkey_info, board_hotstate_info, IND_BOARD, &board,helpstr},
  {STONE_STATUS|USER_STATUS|NOMAINMENUKEY_STATUS, beginboardset, gooutboardset, resetboardset,
    boardset_hotkey_info, boardset_hotstate_info, IND_SETPIECE, &board,helpset},
  {MENU_STATUS|NOMAINMENUKEY_STATUS, beginendsetmenu, endmenu, showmenu,
    menu_hotkey_info, menu_hotstate_info, IND_SET/*!!!*/, NULL ,NULL/*!!!*/},
  {USER_STATUS|NOMAINMENUKEY_STATUS|STONE_STATUS, beginboardbreak, gooutboard, resetboardbreak,
    boardbreak_hotkey_info, boardbreak_hotstate_info, IND_BOARD, &board,helpstr},
  {USER_STATUS, beginprot,  gooutprot,  beginprot,
    prot_hotkey_info, prot_hotstate_info, IND_GAMELISTKEY, &enter,helpprot},
  {STONE_STATUS, beginreply, gooutreply, beginreply,
    reply_hotkey_info, reply_hotstate_info, IND_REPLY, &reply,helpreply},
  {MENU_STATUS|STONE_STATUS|NOMAINMENUKEY_STATUS, beginbreakmenu, endmenu,    showmenu,
    breakmenu_hotkey_info, breakmenu_hotstate_info, IND_INTERRUPT, NULL,NULL},
  {MENU_STATUS|NOMAINMENUKEY_STATUS, beginlocalmenu, endmenu,    showmenu,
    localmenu_hotkey_info,localmenu_hotstate_info, 0, NULL,NULL},
  {USER_STATUS, beginannotate, gooutannotate, beginannotate,
    annotate_hotkey_info,annotate_hotstate_info, IND_ANNOTATION, &comment,helpcomment},
  {MENU_STATUS|STONE_STATUS|NOMAINMENUKEY_STATUS, beginfindmenu, endmenu,    showmenu,
    NULL, find_hotstate_info, 0, NULL},
};

int global_keys[]={
  F2,F3,F4,F5,F6,F7,F8,F9,F10,
  ALT_F2,ALT_F3,
  ALT_N,
  CTRL_B,CTRL_E,
  0
};

