typedef unsigned long HASH_NUMBER;

typedef struct{
  HASH_NUMBER pieces[NCOLOR][NPIECE+1][NSQUARE];
  HASH_NUMBER castles[NCOLOR][2];
  HASH_NUMBER enpass[NSQUARE];
} RAND_NUM;

extern RAND_NUM far * rand_num;

extern int hash_success;               /*Weren't  moves generated
				  because of occurience position in hash */
extern int gen_hash_success;           /*Were generated moves from hash */
extern int hash_enable;                /*Enable(disable) alloc memory for pos hash,
				  is seting  from the window "Options" */
extern int pos_hash_enable;
extern int gen_hash_enable;
extern int pos_hash_clear_flag;
extern hash_ems;

HASH_NUMBER pos_calc_hash(PIECE_COLOR move_color);
int pos_alloc_hash(void);       /* farmalloc for pos hash */
void pos_free_hash(void);       /* Free memory for pos hash */
				/*United alloc and init hash */
void NEAR pos_init_hash(void);
void NEAR print_deb_pos_hash(void);  /* print pos hash statistics */
int NEAR pos_hash_success(void);
void NEAR pos_hash_eval(void);  /* Put eval of position into Hash. */
				/* Put best move into Hash. */
int readrandom(void);
                                /* Put position into hash with zero eval */
int NEAR zeroevaltohash(HASH_NUMBER hash,int addressanavail);

void NEAR set_print_hash_index( void );

int NEAR hash_att_success( void );
void NEAR hash_att_killer( void );    /* store best move in attack hash */

typedef struct {			/* Define type KILLER_INFO */
  SQUARE_NUM from;			/* move from square */
  SQUARE_NUM to;			/* move  to  square */
  PIECE_NAME name;		        /* piece */
  WORD who_mask;                        /* piece */
  BYTE flags;                           /* move flag */
  int freq;                             /* Frequancy */
}		KILL_INFO;

BOOLEAN NEAR legal_kill(KILL_INFO far *killp);
void NEAR make_kill_info(KILL_INFO far *killp,MOVE *movep);

#define  COLOR_INTO_HASH( hash, move_color ) \
		 ( move_color )? (hash|=0x80000000L) : (hash&=0x7FFFFFFFL)
#define TOUCH_HASH( hash, val )  (hash)^=(val)