#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "proc.h"
#include "ems.h"



typedef struct{
  signed char move_from;
  signed char move_to;
  signed char move_flags;  
  signed char answ_from;
  signed char answ_to;
  signed char answ_flags;  
}  MOVE_HASH_ELEMENT;        

typedef int HASH

define MOVEHASHSIZE 0x2000

MOVE_HASH_ELEMENT *movehashtable;
HASH far random_from[NSQUARE];
HASH far random_to[NSQUARE];

int initmovehash(void)
{
  movehashtable=MYFARMALLOC(MOVEHASHSIZE);
  return(0);
}

int freemovehash(void)
{
  MYFREE(movehashtable);
  movehashtable=0;
  return(0);
}

int NEAR move_to_hash( MOVE *move )
{
  random_from[move->from]^random_to[move]


}

int NEAR putmovehash( MOVE *move, MOVE *answ )
{
  movehash=move_to_hash( move );
  index=MOVEHASHTOINDEX( movehash );
  currp=ind_to_addr( index ); 
  currp->move_from=move->from;
  currp->move_to=move->to;
  currp->answ_from=answ->from;
  currp->answ_to=answ->to;
}

MOVE NEAR * getmovehash(MOVE *dest, MOVE *move)
{
  movehash=move_to_hash( move );
  index=MOVEHASHTOINDEX( movehash );
  currp=ind_to_addr( index ); 
  if(currp->move_from==move->from && currp->move_to==move->to &&
     legalmove(currp->answ_from, currp->answ_to, currp->flags)){
    dest->from=currp->answ_from;
    dest->to=currp->answ_to;
    dest->flags=currp->answ_flags;
    dest++;
  }
  return(dest);
}

