
		/**\
		 	Header file "global.h"		
		 					
		    required :			
		 	"lang.h"			
		       "chess.h"			
		 					
		 		Some global constants, 	
		 		types definitions	
		 		and global variables	
		 			needed for	
		 			everyboby and	
		 			everywhere	
		\**/

#ifndef  _GLOBAL_H
#define  _GLOBAL_H
	    
#ifndef  _LANG_H
#include "lang.h"
#endif
#ifndef  _CHESS_H
#include "chess.h"
#endif
/*#include "hash_def.h"              /*Added by Andrey 18.3.90 */Deleted by W.K.*/
	/* Some global constants */

#define MAXDEPTH    18
	    
		 /* Maximum search depth */
#define	MOVE_STACK_SIZE	/*(MAXDEPTH*20)*/  500
#define EVAL_STACK_SIZE	(MAXDEPTH+2)
#define	POS_STACK_SIZE	(MAXDEPTH)
					/* for generator*/
extern char *version;   /* Version & copyright of Kaissa program (main.c)*/

extern int byteshift[NDIR];			/* direction increments */
extern int increment[NDIR];
extern int knincrement[NDIR];
extern DIR direction[NSQUARE][NSQUARE];	/* direction  between two squares */
extern BYTE numattack[NPIECE+1+1][NDIR]; /* number of squares attacked by */
      /* required piece on req. direction: 0=not, 1=one, 2=all */
extern DIR reverse[NDIR];

extern BYTE square_dirmask[NSQUARE];    /*Available queen dir for square*/
extern BYTE square_kndirmask[NSQUARE];  /*Available knight dir for square*/

extern PIECE_COLOR    Our_color;	/* Color of our pieces */
extern PIECE_COLOR    Enemy_color;	/* Color of enemy pieces */
extern LIST_NUM  our_king;		/* Piece list number of  our  king */
extern LIST_NUM enemy_king;		/* Piece list number of enemy king */
extern SQUARE_NUM  our_king_square;	/* Current  our  king square number */
extern SQUARE_NUM enemy_king_square;	/* Current enemy king square number */

extern int level;			/* Current tree level */
extern int print_level;			/* level for move printing */
extern int depth;			/* Tree depth */

extern EVAL eval_stk[EVAL_STACK_SIZE];	/* Evaluation stack */
extern EVAL beta_stk[EVAL_STACK_SIZE];
extern EVAL realeval[EVAL_STACK_SIZE];
#define EVAL(x)     eval_stk[x+2]
#define BETA(x)     beta_stk[x+2]
#define REALEVAL(x) realeval[x+2]
extern MOVE move_stk[MOVE_STACK_SIZE];	/* Legal moves stack */

extern POSITION *pos_stk;			/* Position stack. */
extern POSITION *pos_sp;			/* Current position pointer. */
extern POSITION pos_stack[POS_STACK_SIZE];

extern MOVE best_move;			/* the best move found on search */

extern PIECE_COLOR turn_move;		/* whoes move is the first */

extern const MAT_EVAL piece_cost[NPIECE+1];	/* Piece prices */
extern PARTY_STATUS party_flag;		/* Party flag (DEBUT and so on) */

extern BYTE bit_quantity[256];		/* Quantity bits in byte */
extern unsigned int sqnum_to_addr_shift[ NSQUARE ];

#define ALINE '\x01'
#define BLINE '\x02'
#define CLINE '\x04'
#define DLINE '\x08'
#define ELINE '\x10'
#define FLINE '\x20'
#define GLINE '\x40'
#define HLINE '\x80'


#endif