
		/**\
		 	Header file "gener.h"		
		 					
		 	      Internal generator	
		 			header file	
		\**/


#ifndef _GENER_H
#define _GENER_H
		   /* A.S. 12.2.91 Store moves */
#define STORE_MOVES(TOP,MASK)    (  TOP )->moves|=( MASK )		\
	,pos_sp->n.square[( TOP )->mynum].moves|=( MASK )
			/* Macro to write move */
#define WRITE_MOVE(MOVEP,FROM,TO,FLAGS,PROFIT)				\
 (MOVEP->from=FROM,			/* Move from square */		\
  MOVEP->to=TO,				/* Move  to  square */		\
  MOVEP->flags=FLAGS,			/* Move flags */		\
  (MOVEP++)->profit=PROFIT)/* Capture profit */

#define LARGENEG (-30000)                 /* Large negative value */
					  /* needed for sorting of moves */

				/* Define type for GENerator FUNCTION */
typedef void NEAR GEN_FUNCTION(void);
typedef GEN_FUNCTION NEAR *GEN_FUNCTION_PTR;

				/* Variables needed in generators functions */
extern MOVE *movep;			/* Current move pointer */
extern MAT_EVAL mat_deficit;		/* Material deficit */


				/* Prototypes of functions */
extern GEN_FUNCTION killer;		 /* Generate killer moves */

int NEAR mask_to_cost(WORD mask);
WORD NEAR cost_to_mask(int cost);

#define PROFITSHIFT 10
#define NEWATTACKSHIFT 5
#define OLDATTACKSHIFT 2
#define PROFIT_LIMIT ((1<<PROFITSHIFT)-1)
#define KILLERSHIFT 5
#define KILLER_PROFIT 1000
#define GIFT_LIMIT -1000
#define EXCHANGE_PROFIT 900

#define HASH_PROFIT 0x7fff
#define HASH_ATTACK_PROFIT (HASH_PROFIT-1)
#define CASTLE_PROFIT QUEEN_COST
#define CHECK_PROFIT  (QUEEN_COST+1)

#endif
/*
 1024 [1<<10] - Max           Profitable capture, exchange, capture just moved 
 996 - 1000                  Killers
 64 [2<<5] - 608 [19<<5]    Escape from new profitable attackes
 8 [2<<2] - 76 [19<<2]      Escape from old profitable attackes

 19 - castles

 -19454 - -1024             Gifts to enemy
*/
void NEAR move_sort(MOVE *first,MOVE *last );
void NEAR go_from_square(SQUARE_NUM from, SQUARE_INFO *fromp, BYTE dir_mask);
				/* Write moves by piece from square in */
				  /* given directions. */
