
		/**\
		 	  Header file "eval.h"		
		 					
		 					
		 	 Functions prototypes		
		 		and variables		
		 		for eval functions	
		\**/

#ifndef _EVAL_H
#define _EVAL_H

#ifndef  _LANG_H
#include "lang.h"
#endif
#ifndef  _CHESS_H
#include "chess.h"
#endif
#ifndef  _GLOBAL_H
#include "global.h"
#endif

extern POSITION *sp;	/* Position stack pointer evaluating position */
extern const BOARD *pawns[NCOLOR];	/* Pointers to boards with pawns */
				/* Pawns attacks after 0-4 forward moves */
extern BYTE double_pawns[NCOLOR];
extern BYTE knights_quantity[NCOLOR];
extern BYTE bishops_quantity[NCOLOR];
extern BYTE rooks_quantity[NCOLOR];
extern BYTE queens_quantity[NCOLOR];

extern BYTE pawns_lines[NCOLOR];	/* Each bit correspond to line */
extern BYTE empty_lines[NCOLOR];
extern BYTE semiopen_lines[NCOLOR];
extern BYTE open_lines;
extern BYTE isolated_pawns_lines;

extern BOARD passage_pawns;
extern BOARD semipassage_pawns;

extern BOARD strong_squares[NCOLOR];	/* BOARD with strong squares */

extern BOARD pawns_on_strong_square;
extern BOARD knights_on_strong_square;
extern BOARD bishops_on_strong_square;

extern PIECE_COLOR our,enemy;

extern BOARD bishop_king_posibility[NCOLOR];
extern BOARD rook_king_posibility[NCOLOR];
extern BOARD queen_king_posibility[NCOLOR];

extern const BOARD *king_posibility[NCOLOR];

void _NEAR pawn_struct(void);
void _NEAR pawn_structure(void);
void _NEAR piece_struct(void);
void _NEAR piece_structure(void);

/* Pawns */

int _NEAR _isolated_pawn(void);
int _NEAR _isolated_pawn_on_semiopen_line(void);
int _NEAR _double_pawn(void);
int _NEAR _phalanga(void);
int _NEAR _centre_pawn(void);
POS_EVAL _NEAR _passage_pawn(void);
int _NEAR _pawn_before_enemy_st_sq(void);
int _NEAR _pawn_on_semiopen_line(void);
int _NEAR _st_sq(void);
int _NEAR _pawn_on_st_sq_without_enemy_pawn_on_line(void);
int _NEAR _pawn_on_st_sq_in_centre(void);
int _NEAR _pawn_blockade_by_enemy_on_cf_lines(void);
int _NEAR _pawn_blockade_by_our_on_cf_lines(void);
POS_EVAL _NEAR _semipassage_pawn(void);

/* Pieces */
int _NEAR _rook_on_last_but_one_file(void);
int _NEAR _profitable_attack_on_bound_piece(void);
int _NEAR _double_profitable_attack(void);
int _NEAR _initial_bishop_knight_state(void);
int _NEAR _knight_on_st_sq(void);
int _NEAR _knight_on_st_sq_in_centre(void);
int _NEAR _bishop_on_st_sq(void);
int _NEAR _bishop_on_st_sq_in_centre(void);
int _NEAR _profitable_attack_on_king_posibility(void);
POS_EVAL _NEAR _change_resistance(void);
int _NEAR _king_opposition(void);
int _NEAR _no_pawn_front_of_castle_king(void);
int _NEAR _two_bishop_existance(void);
int _NEAR _khight_and_queen_existance(void);
int _NEAR _bound_piece(void);
int _NEAR _rook_behind_passage_pawn(void);
int _NEAR _right_castle_right(void);
int _NEAR _left_castle_right(void);
int _NEAR _right_castle(void);
int _NEAR _left_castle(void);
int _NEAR _initial_bishop_state_blocking(void);
int _NEAR _bishop_king_posibility(void);
int _NEAR _rook_king_posibility(void);
int _NEAR _bound_pawn(void);
int _NEAR _initial_queen_state(void);
int _NEAR _pieces_posibility(void);

#endif